<?php
if (! function_exists('bread')) {
    /**
     * Schema.orgに基づいたパンくずを自動作成します。
     * 静的なURLについてはtranslationRulesに記載してください。
     * 動的なURLはControllerから翻訳のルールを$dynamicsとして受け渡すことでパンくずが翻訳されます。
     * $breadをTrueにするとサイトに表示されます。
     * @return string
     */
    function bread($dynamics = null)
    {
        /**
         * "hoge" => "ほげ"
         * の形で記載するとURLに応じてパンくずリストが翻訳されます。
         */
        $translationRules = array(
          "buy" => "購入" ,
          'flow' => array(
              'buy' => '購入の流れ',
              'reform' => '中古＋リフォームの流れ',
              'sell' => '売却の流れ',
            ),
          'mansion' => 'マンション',
          'nhouse' => '新築一戸建て',
          'uhouse' => '中古一戸建て',
          'land' => '土地',
          'shop' => '店舗紹介',
          'staff' => 'スタッフ紹介',
          'reform' => 'リフォーム',
          'example' => 'リフォーム事例',
          'privacy' => 'プライバシーポリシー',
          'merit' => '中古＋リフォームのメリット',
          'company' => '会社情報',
          'topics' => 'トピックス',
          'favorite' => 'お気に入り',
          'save' => '保存した条件',
          'area' => 'エリアガイド',
          'history' => '閲覧した物件',
          'contact' => 'お問い合わせ',
          'sell' => '売却',          
          'cost' => '購入の費用',          
          'type' => '売却の種類',          
          'konan' => '港南区',          
          'sakae' => '栄区',          
          'isogo' => '磯子区',          
          'kanazawa' => '金沢区',          
          'minami' => '南区',          
        );

        $pathToRoot = root("");
        $url =  Request::path();
        $explodedUrls = urlExplode($url);
        $translatedUrls = translate($explodedUrls, $translationRules);
        if (isset($dynamics)) {
            $translatedUrls = dynamicTranslate($dynamics,$translatedUrls);
        }
        $linksToEachPage = makeLinks($explodedUrls, $pathToRoot);
        $translatedUrls = addHomeToTranslatedUrls($translatedUrls);
        $bakedBreadList = bakeBread($linksToEachPage,$translatedUrls);

        return $bakedBreadList;
    }

    function urlExplode($url)
    {
        $explodedUrls = explode("/", $url);
        $tmp = [];
        foreach($explodedUrls as $row) {
            if($row != "detail") {
                array_push($tmp, $row);
            }
        }
        $filteredExplodedUrls = array_filter($tmp, "strlen");
        return $filteredExplodedUrls;
    }

    function translate($explodedUrls, $translationRules)
    {
        $translatedUrls = array();
        foreach ($explodedUrls as $explodedUrl) {
            if (isset($translationRules[$explodedUrl]) && is_array($translationRules[$explodedUrl])) {
                foreach ($translationRules[$explodedUrl] as $englishUrl => $translatedUrl) {
                    if (in_array($englishUrl, $explodedUrls)) {
                        $translatedUrls[] = $translatedUrl;
                    }
                }
            } elseif (isset($translationRules[$explodedUrl]) && !is_array($translationRules[$explodedUrl])) {
                $translatedUrls[] = $translationRules[$explodedUrl];
            } else {
                $translatedUrls[] = $explodedUrl;
            }
        }
        return $translatedUrls;
    }


    function makeLinks($explodedUrls, $pathToRoot)
    {
        $linksToEachPage = array();
        $linksToEachPage[] = $pathToRoot;
        $linkToAPage = $pathToRoot;
        foreach ($explodedUrls as $explodedUrl) {
            $linkToAPage.= $explodedUrl."/";
            $linksToEachPage[] = $linkToAPage;
        }
        return $linksToEachPage;
    }

    function addHomeToTranslatedUrls($translatedUrls){
        array_unshift($translatedUrls, 'ホーム');
        return $translatedUrls;
    }

    function bakeBread($linksToEachPage,$translatedUrls){
        $liTags = array();
        for ($i=0; $i < count($linksToEachPage); $i++) {
            $liTags[] = '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="bread__list"><a itemprop="item" href="'.$linksToEachPage[$i].'" class="bread__link">'.$translatedUrls[$i].'</a></li>';
        }
        $implodedLiTags = implode('>',$liTags);
        $bakedBreadList = '<ol itemscope itemtype="http://schema.org/BreadcrumbList" class="bread">'.$implodedLiTags.'</ol>';
        return $bakedBreadList;
    }

    function dynamicTranslate($dynamics,$translatedUrls){
        foreach ($dynamics as $dynamicKey => $dynamicValue) {
            $translationTargetIndex = array_search($dynamicKey,$translatedUrls);
            $translatedUrls[$translationTargetIndex] = $dynamicValue;
        }
        return $translatedUrls;
    }
}
