<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Article;
use App\Models\RelationArticlePhoto;
use App\Models\UserInfo;
use App\Models\RelationLawrestriction;
use App\Models\MstPrefecture;
use App\Models\MstCity;
use App\Models\MstTown;

class SetArticleToHomes extends Command
{
    private $option;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'batch:test2 {id?} {cid?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        // 登録対象の物件を取得
        $building_id = $this->argument('id');
        $company_id = $this->argument('cid');

        // Homesにアクセス
        $cookie_path = './homes_cookie.txt';
        touch($cookie_path);
        $id = "takara@wills.co.jp";
        $pass = "OaOJ0FGg4E";

        // cURLセッションの共通オプション
        $this->option = [
            // CURLOPT_CUSTOMREQUEST => 'POST',
            // CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:24.0) Gecko/20100101 Firefox/24.0',
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_SSL_VERIFYHOST => FALSE,
            CURLOPT_COOKIEJAR => $cookie_path,
            CURLOPT_COOKIEFILE => $cookie_path,
            // CURLOPT_FOLLOWLOCATION => TRUE,
            CURLOPT_HEADER=> TRUE,
        ];

        // ログイン画面へアクセス
        $url = "https://homes.force.com/pro/UserLogin";
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行
        curl_close($curl);

        // cURLセッション実行結果の解析
        $pattern = '/<form id="(.*?)" name="(.*?)" method="post" action="(.*?)" enctype="application\/x-www-form-urlencoded">/';
        preg_match($pattern, $res, $match1);

        $pattern = '/<input type="hidden"  id="com.salesforce.visualforce.ViewState" name="com.salesforce.visualforce.ViewState" value="(.*?)" \/>/';
        preg_match($pattern, $res, $match2);

        $pattern = '/<input type="hidden"  id="com.salesforce.visualforce.ViewStateVersion" name="com.salesforce.visualforce.ViewStateVersion" value="(.*?)" \/>/';
        preg_match($pattern, $res, $match3);

        $pattern = '/<input type="hidden"  id="com.salesforce.visualforce.ViewStateMAC" name="com.salesforce.visualforce.ViewStateMAC" value="(.*?)" \/>/';
        preg_match($pattern, $res, $match4);

        // ログイン処理
        $url = $match1[3];
        $POST_DATA = [
            $match1[1] => $match1[1],
            'j_id0:j_id13:j_id23' => $id,
            'j_id0:j_id13:j_id25' => $pass,
            'j_id0:j_id13:j_id32' => 'ログイン',
            'com.salesforce.visualforce.ViewState' => $match2[1],
            'com.salesforce.visualforce.ViewStateVersion' => $match3[1],
            'com.salesforce.visualforce.ViewStateMAC' => $match4[1],
        ];
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

// https://homes.force.com/pro/secur/frontdoor.jspのパラメータ付きURLを取得したいが、Cookieに応じて実行結果が変わる
// Cookieが無い状態からバッチを起動すると正常処理になるので、Cookieの削除処理を最後に加える？
        // cURLセッション実行結果の解析
        $pattern = '/window\.location\.href =\'(.*?)\';/';
        preg_match($pattern, $res, $match5);

        $url = $match5[1];
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行
        curl_close($curl);

        // Homesトップ画面にアクセス
        $url = 'https://homes.force.com/pro/top';
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行
        curl_close($curl);

        // cURLセッション実行結果の解析
        $pattern = '/<p class="thumbnail"><a href="(.*?)" target="_blank"><img src="\/pro\/resource\/(.*?)\/homes_manager_/';
        preg_match($pattern, $res, $match6);

        // LIFULL HOME'S Managerにログイン情報を連携
        $url = $match6[1];
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行
        curl_close($curl);

        // cURLセッション実行結果の解析
        $pattern = '/SfdcApp\.projectOneNavigator\.handleRedirect\(\'(.*?)\'\)\; \}  else/';
        preg_match($pattern, $res, $match7);

        $url = $match7[1];
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行
        curl_close($curl);

        // 登録対象の物件を取得
        $article = Article::getDataById($company_id, $building_id);
        if($article->property == 1 || $article->property == 2 || $article->property == 3) {
            // 土地
            $article = $this->moldingDataLand($article);
            $this->saveLand($article);
        } elseif($article->property == 4 || $article->property == 5) {
            // 戸建
            $article = $this->moldingDataHouse($article);
            $this->saveHouse($article);
        } elseif($article->property == null) {
            // マンション
            $mansion = Article::getParentMansion(1, $article->mansion_id);
            $article = $this->moldingDataMansion($article, $mansion);
            $this->saveMansion($article);
        }
    }

    function moldingDataLand($article) {
        // 基本・交通タブ
        // 1.基本情報
        // 物件名
        $article->b_name = mb_substr($article->article_name, 0, 42);

        // 物件担当者
        $user_info = UserInfo::getDataById($article->hp_charge);
        $name_info = '';
        $name_info = $user_info->last_name??'';
        if($name_info != '') {
            $name_info .= ' ';
        }
        $name_info .= $user_info->first_name??'';
        $article->tantou_name = $name_info;

        // 状態
        if($article->status == 1) {
            // 販売中
            $article->status_h = "1";
        } else {
            // 販売中以外
            $article->status_h = "3";
        }

        // LIFULL HOME'S掲載
        if($article->homes == 1) {
            $article->flg_open = "0";
        } elseif($article->homes == 2) {
            $article->flg_open = "1";
        }

        // 2.所在地
        // 郵便番号
        $zip_info = $article->zip;
        $zip_list = explode('-', $zip_info);
        $article->post1 = $zip_list[0]??'';
        $article->post2 = $zip_list[1]??'';

        // 住所
        $article->todofukenCd = $article->address1;
        $article->shikugunCd = $article->address2;
        $article->ooazaCd = $article->address3;

        // 番地など
        $article->addr3_addr4_name = $article->address4;
        if(is_null($article->address4)) {
            // addr3_addr4_nameは必須項目
            $article->flg_addr_hidden = "0";
        } else {
            $article->flg_addr_hidden = "1";
        }
        $article->display_addr_name = $article->address4;

        $pref_info = MstPrefecture::getName($article->address1);
        $city_info = MstCity::getName($article->address1, $article->address2);
        $town_info = MstTown::getName($article->address1, $article->address2, $article->address3);
        $article->todofukenNm = $pref_info->name??'';
        $article->shikugunNm = $city_info->name??'';
        $article->ooazaNm = $town_info->name??'';

        //緯度経度
        $article->nl = $article->lat;
        $article->el = $article->lng;

        // 3.交通

        // 金銭・建物タブ
        // 1.価格



        // 2.担当者情報
        // スタッフコメント
        $article->staffComment = mb_substr($article->comment, 0, 100);
        // 社内メモ1
        $article->kishaComment1 = mb_substr($article->memo1, 0, 20);
        // 社内メモ2
        $article->kishaComment2 = mb_substr($article->memo2, 0, 20);

        // 3.価格
        // 町会費
        if($article->council != 0) {
            $article->chokaihiKbn = $article->council;
            if($article->council_presence == 0) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            } elseif($article->council_presence == 1) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = $article->council_cost;
                if($article->council_cost_unit != 0) {
                    $article->chokaihiRyoTaniKbn = $article->council_cost_unit;
                } else {
                    $article->chokaihiRyoTaniKbn = '';
                }
            } elseif($article->council_presence == 2) {
                $article->chokaihiUmu = '3';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            }
        } elseif($article->council == 0) {
            $article->chokaihiKbn = '0';
            $article->chokaihiUmu = '';
            $article->chokaihiRyo = '';
            $article->chokaihiRyoTaniKbn = '';
        }

        // 温泉
        if($article->spring != 0) {
            $article->onsenKenKbn = $article->council;
            if($article->spring_presence == 0) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            } elseif($article->spring_presence == 1) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = $article->spring_cost;
                if($article->spring_cost_unit != 0) {
                    $article->onsenKenRyoTaniKbn = $article->spring_cost_unit;
                } else {
                    $article->onsenKenRyoTaniKbn = '';
                }
            } elseif($article->spring_presence == 2) {
                $article->onsenKenRyoUmu = '3';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            }
        } elseif($article->spring == 0) {
            $article->onsenKenKbn = '0';
            $article->onsenKenRyoUmu = '';
            $article->onsenKenRyo = '';
            $article->onsenKenRyoTaniKbn = '';
        }
        
        // 4.土地建物情報
        // 土地権利
        if($article->land_right != 0) {
            // ★番号の割り当て方todo
            $article->land_right_h = $article->land_right;
        } else {
            $article->land_right_h = "";
        }
        // 土地面積
        $article->tochiMensekiKbn = $article->land_area;
        $land_area = $article->land_area_val??'0.0';
        $land_area_list = explode('.', $land_area);
        $article->tochiMensekiMinS = $land_area_list[0]??'';
        $article->tochiMensekiMinL = $land_area_list[1]??'';

        if($article->land_condition1 == 1) {
            $land_condition_area1_list = explode('.', $article->land_condition_area1);
            $article->keishaMensekiMinS = $land_condition_area1_list[0]??'';
            $article->keishaMensekiMinL = $land_condition_area1_list[1]??'';
            $article->keishaMensekiMinTaniKbn = $article->land_condition_unit1;
        } else {
            $article->keishaMensekiMinS = '';
            $article->keishaMensekiMinL = '';
            $article->keishaMensekiMinTaniKbn = 0;
        }

        if($article->land_condition2 == 1) {
            $land_condition_area2_list = explode('.', $article->land_condition_area2);
            $article->shikichiEnchoMinS = $land_condition_area2_list[0]??'';
            $article->shikichiEnchoMinL = $land_condition_area2_list[1]??'';
            $article->shikichiEnchoMinTaniKbn = $article->land_condition_unit2;
        } else {
            $article->shikichiEnchoMinS = '';
            $article->shikichiEnchoMinL = '';
            $article->shikichiEnchoMinTaniKbn = 0;           
        }

        if($article->land_condition3 == 1) {
            $land_condition_area3_list = explode('.', $article->land_condition_area3);
            $article->koatsuMensekiMinS = $land_condition_area3_list[0]??'';
            $article->koatsuMensekiMinL = $land_condition_area3_list[1]??'';
        } else {
            $article->koatsuMensekiMinS = '';
            $article->koatsuMensekiMinL = '';          
        }

        // 土地状況
        if($article->current_status == 1 || $article->current_status == 2) {
            $article->tochiJokyoKbn = $article->current_status;
            $article->zoseiKanryoYoteiNen = '';
            $article->zoseiKanryoYoteiTsuki = '';
        } elseif($article->current_status == 3) {
            $article->tochiJokyoKbn = 4;
            $article->zoseiKanryoYoteiNen = $article->comp_year;
            $article->zoseiKanryoYoteiTsuki = $article->comp_month;
        } else {
            $article->tochiJokyoKbn = '';
            $article->zoseiKanryoYoteiNen = '';
            $article->zoseiKanryoYoteiTsuki = '';
        }

        // 引き渡し
        if($article->land_delivery == 1) {
            $article->nyukyoJikiKbn = 1;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiJunKbn = 0;
        } elseif($article->land_delivery == 2) {
            $article->nyukyoJikiKbn = 4;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiJunKbn = 0;
        } elseif($article->land_delivery == 3) {
            $article->nyukyoJikiKbn = 2;
            $article->nyukyoJikiNen = $article->delivery_year;
            $article->nyukyoJikiTsuki = $article->delivery_month;
            $article->nyukyoJikiJunKbn = $article->land_delivery_time;
        } else {
            $article->nyukyoJikiKbn = '';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiJunKbn = 0;
        }

        // 建築条件
        if($article->land_condition == 0) {
            $article->kenchikuJokenUmuKbn = 0;
            $article->tatemonoKakaku = '';
            $article->tatemonoMensekiS = '';
            $article->tatemonoMensekiL = '';
        } elseif($article->land_condition == 1) {
            $article->kenchikuJokenUmuKbn = 1;
            $article->tatemonoKakaku = $article->building_plan_place??'';
            $building_plan_place = $article->building_plan_area;
            $building_plan_place_list = explode('.', $building_plan_place);
            $article->tatemonoMensekiS = $building_plan_place_list[0]??'';
            $article->tatemonoMensekiL = $building_plan_place_list[1]??'';
        } elseif($article->land_condition == 2) {
            $article->kenchikuJokenUmuKbn = '';
            $article->tatemonoKakaku = '';
            $article->tatemonoMensekiS = '';
            $article->tatemonoMensekiL = '';
        }

        // 地目
        if($article->ground != 0 && $article->ground < 7) {
            $article->chimokuKbn = $article->ground;
            $article->chimokuSntComment = '';
        } elseif($article->ground == 7) {
            $article->chimokuKbn = 9;
            $article->chimokuSntComment = $article->ground_text;
        } else {
            $article->chimokuKbn = '';
            $article->chimokuSntComment = '';
        }

        // 建ぺい率
        $article->kenpeiritsu = (int)$article->building_rate;
        // 容積率
        $article->yosekiritsu = (int)$article->volume_rate;

        // 私道負担
        if($article->road_burden == 0) {
            $article->shidoFutanKbn = 1;
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        } elseif($article->road_burden == 1) {
            $article->shidoFutanKbn = 2;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $article->shidoFutanMensekiMinS1 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL1 = $road_burden_area_list[1]??'';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';

        } elseif($article->road_burden == 2) {
            $article->shidoFutanKbn = 3;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $road_numerator = $article->road_numerator;
            $road_numerator_list = explode('.', $road_numerator);
            $road_denominator = $article->road_denominator;
            $road_denominator_list = explode('.', $road_denominator);
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL2 = $road_burden_area_list[1]??'';
            $article->shidoFutanBunshiMinS = $road_numerator_list[0]??'';
            $article->shidoFutanBunshiMinL = $road_numerator_list[1]??'';
            $article->shidoFutanBunboMinS = $road_denominator_list[0]??'';
            $article->shidoFutanBunboMinL = $road_denominator_list[1]??'';
        } else {
            $article->shidoFutanKbn = '';
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        }

        // 地役権
        if($article->easement == 1 || $article->easement == 0) {
            $article->chiekikenKbn = $article->easement;
            $article->chiekikenMensekiS = '';
            $article->chiekikenMensekiL = '';
        } else {
            $article->chiekikenKbn = $article->easement;
            $easement_area = $article->easement_area;
            $easement_area_list = explode('.', $easement_area);
            $article->chiekikenMensekiS = $easement_area_list[0]??'';
            $article->chiekikenMensekiL = $easement_area_list[1]??'';
        }
        // 道路向き
        if($article->land_direction1 == 0) {
            $article->doroMukiKbn1 = 0;
        } else { 
            if($article->land_direction1 == 1) {
                $article->doroMukiKbn1 = 4;
            } elseif($article->land_direction1 == 2) {
                $article->doroMukiKbn1 = 5;
            } elseif($article->land_direction1 == 3) {
                $article->doroMukiKbn1 = 1;
            } elseif($article->land_direction1 == 4) {
                $article->doroMukiKbn1 = 6;
            } elseif($article->land_direction1 == 5) {
                $article->doroMukiKbn1 = 3;
            } elseif($article->land_direction1 == 6) {
                $article->doroMukiKbn1 = 8;
            } elseif($article->land_direction1 == 7) {
                $article->doroMukiKbn1 = 2;
            } elseif($article->land_direction1 == 8) {
                $article->doroMukiKbn1 = 7;
            }
            $road_width1 = $article->road_width1;
            $road_width1_list = explode('.', $road_width1);
            $frontage1 = $article->frontage1;
            $frontage1_list = explode('.', $frontage1);
            $article->doroWidth1S = $road_width1_list[0]??'';
            $article->doroWidth1L = $road_width1_list[1]??'';
            $article->setsudoWidth1S = $frontage1_list[0]??'';
            $article->setsudoWidth1L = $frontage1_list[1]??'';
        }

        if($article->land_direction2 == 0) {
            $article->doroMukiKbn2 = 0;
        } else { 
            if($article->land_direction2 == 1) {
                $article->doroMukiKbn2 = 4;
            } elseif($article->land_direction2 == 2) {
                $article->doroMukiKbn2 = 5;
            } elseif($article->land_direction2 == 3) {
                $article->doroMukiKbn2 = 1;
            } elseif($article->land_direction2 == 4) {
                $article->doroMukiKbn2 = 6;
            } elseif($article->land_direction2 == 5) {
                $article->doroMukiKbn2 = 3;
            } elseif($article->land_direction2 == 6) {
                $article->doroMukiKbn2 = 8;
            } elseif($article->land_direction2 == 7) {
                $article->doroMukiKbn2 = 2;
            } elseif($article->land_direction2 == 8) {
                $article->doroMukiKbn2 = 7;
            }
            $road_width2 = $article->road_width2;
            $road_width2_list = explode('.', $road_width2);
            $frontage2 = $article->frontage2;
            $frontage2_list = explode('.', $frontage2);
            $article->doroWidth2S = $road_width2_list[0]??'';
            $article->doroWidth2L = $road_width2_list[1]??'';
            $article->setsudoWidth2S = $frontage2_list[0]??'';
            $article->setsudoWidth2L = $frontage2_list[1]??'';
        }

        if($article->land_direction3 == 0) {
            $article->doroMukiKbn3 = 0;
        } else { 
            if($article->land_direction3 == 1) {
                $article->doroMukiKbn3 = 4;
            } elseif($article->land_direction3 == 2) {
                $article->doroMukiKbn3 = 5;
            } elseif($article->land_direction3 == 3) {
                $article->doroMukiKbn3 = 1;
            } elseif($article->land_direction3 == 4) {
                $article->doroMukiKbn3 = 6;
            } elseif($article->land_direction3 == 5) {
                $article->doroMukiKbn3 = 3;
            } elseif($article->land_direction3 == 6) {
                $article->doroMukiKbn3 = 8;
            } elseif($article->land_direction3 == 7) {
                $article->doroMukiKbn3 = 2;
            } elseif($article->land_direction3 == 8) {
                $article->doroMukiKbn3 = 7;
            }
            $road_width3 = $article->road_width3;
            $road_width3_list = explode('.', $road_width3);
            $frontage3 = $article->frontage3;
            $frontage3_list = explode('.', $frontage3);
            $article->doroWidth3S = $road_width3_list[0]??'';
            $article->doroWidth3L = $road_width3_list[1]??'';
            $article->setsudoWidth3S = $frontage3_list[0]??'';
            $article->setsudoWidth3L = $frontage3_list[1]??'';
        }

        // 上水道
        $article->setsubiJosuidoKbn = $article->water_supply;

        // 下水道
        $article->setsubiGesuidoKbn = $article->sewerage;

        // ガス
        $article->setsubiGasKbn = $article->gas;

        // 駐車場
        if($article->garage == 1) {
            $article->shakoKbn = 2;
        } elseif($article->garage == 0) {
            $article->shakoKbn = 0;
        }

        // セットパック
        if($article->set == 1) {
            $article->setbackKbn = $article->set;
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        } elseif($article->set == 2 || $article->set == 3) {
            $article->setbackKbn = $article->set;
            $set_area = $article->set_area;
            $set_area_list = explode('.', $set_area);
            $article->setbackMensekiMinS = $set_area_list[0]??'';
            $article->setbackMensekiMinL = $set_area_list[1]??'';
        } else {
            $article->setbackKbn = '';
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        }

        // 用途地域
        if($article->use_area == 1) {
            $article->yotochiikiCd01 = '01';
        } elseif($article->use_area == 2) {
            $article->yotochiikiCd01 = '04';
        } elseif($article->use_area == 3) {
            $article->yotochiikiCd01 = '06';
        } elseif($article->use_area == 4) {
            $article->yotochiikiCd01 = '08';
        } elseif($article->use_area == 5) {
            $article->yotochiikiCd01 = '09';
        } elseif($article->use_area == 6) {
            $article->yotochiikiCd01 = '10';
        } elseif($article->use_area == 7) {
            $article->yotochiikiCd01 = '11';
        } elseif($article->use_area == 8) {
            $article->yotochiikiCd01 = '12';
        } elseif($article->use_area == 10) {
            $article->yotochiikiCd01 = '02';
        } elseif($article->use_area == 11) {
            $article->yotochiikiCd01 = '03';
        } elseif($article->use_area == 12) {
            $article->yotochiikiCd01 = '05';
        } elseif($article->use_area == 13) {
            $article->yotochiikiCd01 = '07';
        } elseif($article->use_area == 14) {
            $article->yotochiikiCd01 = '16';
        } else {
            $article->yotochiikiCd01 = '00';
        }
        
        if($article->land_use == 1) {
            $article->yotochiikiCd02 = '01';
        } elseif($article->land_use == 2) {
            $article->yotochiikiCd02 = '04';
        } elseif($article->land_use == 3) {
            $article->yotochiikiCd02 = '06';
        } elseif($article->land_use == 4) {
            $article->yotochiikiCd02 = '08';
        } elseif($article->land_use == 5) {
            $article->yotochiikiCd02 = '09';
        } elseif($article->land_use == 6) {
            $article->yotochiikiCd02 = '10';
        } elseif($article->land_use == 7) {
            $article->yotochiikiCd02 = '11';
        } elseif($article->land_use == 8) {
            $article->yotochiikiCd02 = '12';
        } elseif($article->land_use == 10) {
            $article->yotochiikiCd02 = '02';
        } elseif($article->land_use == 11) {
            $article->yotochiikiCd02 = '03';
        } elseif($article->land_use == 12) {
            $article->yotochiikiCd02 = '05';
        } elseif($article->land_use == 13) {
            $article->yotochiikiCd02 = '07';
        } elseif($article->land_use == 14) {
            $article->yotochiikiCd02 = '16';
        } else {
            $article->yotochiikiCd02 = '00';
        }

        // 総区画数
        $article->soKosu = $article->section??'';

        // 5.会社情報
        if($article->company_manner == 1) {
            $article->torihikitaiyoKbn01 = '01';
        } elseif($article->company_manner == 2) {
            $article->torihikitaiyoKbn01 = '13';
        } elseif($article->company_manner == 3) {
            $article->torihikitaiyoKbn01 = '09';
        } elseif($article->company_manner == 4) {
            $article->torihikitaiyoKbn01 = '10';
        } elseif($article->company_manner == 5) {
            $article->torihikitaiyoKbn01 = '11';
        } elseif($article->company_manner == 6) {
            $article->torihikitaiyoKbn01 = '07';
        } elseif($article->company_manner == 7) {
            $article->torihikitaiyoKbn01 = '08';
        } elseif($article->company_manner == 8) {
            $article->torihikitaiyoKbn01 = '09';
        } else {
            $article->torihikitaiyoKbn01 = '';
        }

        // 6.制限事項
        $law_check = RelationLawrestriction::getDataByArticleId($article->building_id);
        foreach($law_check as $law) {
            if($law == 1) {
                $article->hriSgnHoBunkazai = 1;
                
            } elseif($law == 2) {
                $article->hriSgnHoKotohogo = 1;
                
            } elseif($law == 3) {
                $article->hriSgnHoKeikan = 1;
                
            } elseif($law == 4) {
                $article->hriSgnHoMisshuSgcSeibi = 1;
                
            } elseif($law == 5) {
                $article->hriSgnHoKoku = 1;
                
            } elseif($law == 6) {
                $article->hriSgnHoKasen = 1;
                
            } elseif($law == 7) {
                $article->hriSgnHoSabo = 1;
                
            } elseif($law == 8) {
                $article->hriSgnHoNochi = 1;
                
            } elseif($law == 9) {
                $article->hriSgnHoAnzenJorei = 1;
                
            } elseif($law == 10) {
                $article->hriSgnChiTakuzokisei = 1;
                
            } elseif($law == 11) {
                $article->hriSgnChiKyukeishachi = 1;
                
            } elseif($law == 12) {
                $article->hriSgnChiKodochiku = 1;
                
            } elseif($law == 13) {
                $article->hriSgnChiKodoriyo = 1;
                
            } elseif($law == 14) {
                $article->hriSgnChiChukosoJutaku = 1;
                
            } elseif($law == 15) {
                $article->hriSgnChiKosojutakuYudo = 1;
                
            } elseif($law == 16) {
                $article->hriSgnChiBoka = 1;
                
            } elseif($law == 17) {
                $article->hriSgnChiJunboka = 1;
                
            } elseif($law == 18) {
                $article->hriSgnChiFuchi = 1;
                
            } elseif($law == 19) {
                $article->hriSgnChiKeikan = 1;
                
            } elseif($law == 20) {
                $article->hriSgnChiJunKeikan = 1;
                
            } elseif($law == 21) {
                $article->hriSgnChiKanko = 1;
                
            } elseif($law == 22) {
                $article->hriSgnChiRekishi = 1;
                
            } elseif($law == 23) {
                $article->hriSgnChiDento = 1;
                
            } elseif($law == 24) {
                $article->hriSgnChiTokuteiGaiku = 1;
                
            } elseif($law == 25) {
                $article->hriSgnChiTokubetsuYoto = 1;
                
            } elseif($law == 26) {
                $article->hriSgnChiBunkyo = 1;
                
            } elseif($law == 27) {
                $article->hriSgnChiToshisaisei = 1;
                
            } elseif($law == 28) {
                $article->hriSgnChiTokubetsuRyokuchi = 1;
                
            } elseif($law == 29) {
                $article->hriSgnTateTakasaMax = 1;
                
            } elseif($law == 30) {
                $article->hriSgnTateTakasaMin = 1;
                
            } elseif($law == 31) {
                $article->hriSgnTateKenpeiMin = 1;
                
            } elseif($law == 32) {
                $article->hriSgnTateYosekiMin = 1;
                
            } elseif($law == 33) {
                $article->hriSgnTateSktMnsMax = 1;
                
            } elseif($law == 34) {
                $article->hriSgnTateSktMnsMin = 1;
                
            } elseif($law == 35) {
                $article->hriSgnTateMnsMax = 1;
                
            } elseif($law == 36) {
                $article->hriSgnTateMnsMin = 1;
            }
        }

        // その他制限事項
        $article->kckKjn43joTadashigakiKbn = $article->other_reason;
        $article->sgnJikoComment = $article->other_comment;

        // 7.投資用・事業用
        if($article->classfication ==1) {
            $article->jigKbn = 0;
            $article->jigComment = '';
        } else {
            $article->jigKbn = 1;
            if($article->use_method == 1) {
                $article->jigYotoKbn = '07';
                $article->jigComment = '';
            } elseif($article->use_method == 2) {
                $article->jigYotoKbn = '08';
                $article->jigComment = '';
            } elseif($article->use_method == 3) {
                $article->jigYotoKbn = '09';
                $article->jigComment = '';
            } elseif($article->use_method == 4) {
                $article->jigYotoKbn = '01';
                $article->jigComment = '';
            } elseif($article->use_method == 5) {
                $article->jigYotoKbn = '02';
                $article->jigComment = '';
            } elseif($article->use_method == 6) {
                $article->jigYotoKbn = '06';
                $article->jigComment = '';
            } elseif($article->use_method == 7) {
                $article->jigYotoKbn = '04';
                $article->jigComment = '';
            } elseif($article->use_method == 8) {
                $article->jigYotoKbn = '03';
                $article->jigComment = '';
            } elseif($article->use_method == 9) {
                $article->jigYotoKbn = '99';
                $article->jigComment = $article->use_method_text;
            }
        }

        // 10.イベント情報
        

        return $article;

    }

    function moldingDataHouse($article) {
        // 基本・交通タブ
        // 1.基本情報
        // 物件名
        $article->b_name = mb_substr($article->article_name, 0, 42);

        // 物件担当者
        $user_info = UserInfo::getDataById($article->hp_charge);
        $name_info = '';
        $name_info = $user_info->last_name??'';
        if($name_info != '') {
            $name_info .= ' ';
        }
        $name_info .= $user_info->first_name??'';
        $article->tantou_name = $name_info;

        // 状態
        if($article->status == 1) {
            // 販売中
            $article->status_h = "1";
        } else {
            // 販売中以外
            $article->status_h = "3";
        }

        // LIFULL HOME'S掲載
        if($article->homes == 1) {
            $article->flg_open = "0";
        } elseif($article->homes == 2) {
            $article->flg_open = "1";
        }

        // 2.所在地
        // 郵便番号
        $zip_info = $article->zip;
        $zip_list = explode('-', $zip_info);
        $article->post1 = $zip_list[0]??'';
        $article->post2 = $zip_list[1]??'';

        // 住所
        $article->todofukenCd = $article->address1;
        $article->shikugunCd = $article->address2;
        $article->ooazaCd = $article->address3;

        // 番地など
        $article->addr3_addr4_name = $article->address4;
        if(is_null($article->address4)) {
            // addr3_addr4_nameは必須項目
            $article->flg_addr_hidden = "0";
        } else {
            $article->flg_addr_hidden = "1";
        }
        $article->display_addr_name = $article->address4;

        $pref_info = MstPrefecture::getName($article->address1);
        $city_info = MstCity::getName($article->address1, $article->address2);
        $town_info = MstTown::getName($article->address1, $article->address2, $article->address3);
        $article->todofukenNm = $pref_info->name??'';
        $article->shikugunNm = $city_info->name??'';
        $article->ooazaNm = $town_info->name??'';

        //緯度経度
        $article->nl = $article->lat;
        $article->el = $article->lng;

        // 3.交通

        // 金銭・建物タブ
        // 1.価格
        if ($article->tax == 1) {
            // 税抜
            $article->money_tax = "3";
        } elseif($article->tax == 2) {
            // 税込
            $article->money_tax = "2";
        }

        // 2.担当者情報
        // スタッフコメント
        $article->staffComment = mb_substr($article->comment, 0, 100);
        // 社内メモ1
        $article->kishaComment1 = mb_substr($article->memo1, 0, 20);
        // 社内メモ2
        $article->kishaComment2 = mb_substr($article->memo2, 0, 20);

        // 3.価格
        // 町会費
        if($article->council != 0) {
            $article->chokaihiKbn = $article->council;
            if($article->council_presence == 0) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            } elseif($article->council_presence == 1) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = $article->council_cost;
                if($article->council_cost_unit != 0) {
                    $article->chokaihiRyoTaniKbn = $article->council_cost_unit;
                } else {
                    $article->chokaihiRyoTaniKbn = '';
                }
            } elseif($article->council_presence == 2) {
                $article->chokaihiUmu = '3';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            }
        } elseif($article->council == 0) {
            $article->chokaihiKbn = '0';
            $article->chokaihiUmu = '';
            $article->chokaihiRyo = '';
            $article->chokaihiRyoTaniKbn = '';
        }

        // 有線
        if($article->broadcasting == 0) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        } elseif($article->broadcasting == 1) {
            $article->yusenHiyoUmu = '1';
            if($article->broadcasting_presence == 0) {
                $article->yusenShokiHiyoUmu = 1;
                $article->yusenShokiHiyo = '';
            } elseif($article->broadcasting_presence == 1) {
                $article->yusenShokiHiyoUmu = 2;
                $article->yusenShokiHiyo = $article->broadcasting_cost;
            } elseif($article->broadcasting_presence == 2) {
                $article->yusenShokiHiyoUmu = 3;
                $article->yusenShokiHiyo = '';
            }

            if($article->broadcasting_fixed_presence == 0) {
                $article->yusenTeigakuRyoUmu = 1;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 1) {
                $article->yusenTeigakuRyoUmu = 2;
                $article->yusenTeigakuRyo = $article->broadcasting_fixed_cost;
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 2) {
                $article->yusenTeigakuRyoUmu = 3;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            }

        } elseif($article->broadcasting == 2) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        }

        // インターネット
        if($article->internet == 0) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        } elseif($article->internet == 1) {
            $article->internetHiyoUmu = '1';
            if($article->internet_presence == 0) {
                $article->internetShokiHiyoUmu = 1;
                $article->internetShokiHiyo = '';
            } elseif($article->internet_presence == 1) {
                $article->internetShokiHiyoUmu = 2;
                $article->internetShokiHiyo = $article->internet_cost;
            } elseif($article->internet_presence == 2) {
                $article->internetShokiHiyoUmu = 3;
                $article->internetShokiHiyo = '';
            }

            if($article->internet_fixed_presence == 0) {
                $article->internetTeigakuRyoUmu = 1;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 1) {
                $article->internetTeigakuRyoUmu = 2;
                $article->internetTeigakuRyo = $article->internet_fixed_cost;
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 2) {
                $article->internetTeigakuRyoUmu = 3;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            }

        } elseif($article->internet == 2) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        }

        // catv
        if($article->catv == 0) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        } elseif($article->catv == 1) {
            $article->catvHiyoUmu = '1';
            if($article->catv_presence == 0) {
                $article->catvShokiHiyoUmu = 1;
                $article->catvShokiHiyo = '';
            } elseif($article->catv_presence == 1) {
                $article->catvShokiHiyoUmu = 2;
                $article->catvShokiHiyo = $article->catv_cost;
            } elseif($article->catv_presence == 2) {
                $article->catvShokiHiyoUmu = 3;
                $article->catvShokiHiyo = '';
            }

            if($article->catv_fixed_presence == 0) {
                $article->catvTeigakuRyoUmu = 1;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 1) {
                $article->catvTeigakuRyoUmu = 2;
                $article->catvTeigakuRyo = $article->catv_fixed_cost;
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 2) {
                $article->catvTeigakuRyoUmu = 3;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            }

        } elseif($article->catv == 2) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        }

        // 温泉
        if($article->spring != 0) {
            $article->onsenKenKbn = $article->council;
            if($article->spring_presence == 0) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            } elseif($article->spring_presence == 1) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = $article->spring_cost;
                if($article->spring_cost_unit != 0) {
                    $article->onsenKenRyoTaniKbn = $article->spring_cost_unit;
                } else {
                    $article->onsenKenRyoTaniKbn = '';
                }
            } elseif($article->spring_presence == 2) {
                $article->onsenKenRyoUmu = '3';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            }
        } elseif($article->spring == 0) {
            $article->onsenKenKbn = '0';
            $article->onsenKenRyoUmu = '';
            $article->onsenKenRyo = '';
            $article->onsenKenRyoTaniKbn = '';
        }
        
        // 4.土地建物情報
        // 土地権利
        if($article->land_right != 0) {
            // ★番号の割り当て方todo
            $article->land_right_h = $article->land_right;
        } else {
            $article->land_right_h = "";
        }
        // 土地面積
        $article->tochiMensekiKbn = $article->land_area;
        $land_area = $article->land_area_val??'0.0';
        $land_area_list = explode('.', $land_area);
        $article->tochiMensekiMinS = $land_area_list[0]??'';
        $article->tochiMensekiMinL = $land_area_list[1]??'';

        if($article->land_condition1 == 1) {
            $land_condition_area1_list = explode('.', $article->land_condition_area1);
            $article->keishaMensekiMinS = $land_condition_area1_list[0]??'';
            $article->keishaMensekiMinL = $land_condition_area1_list[1]??'';
            $article->keishaMensekiMinTaniKbn = $article->land_condition_unit1;
        } else {
            $article->keishaMensekiMinS = '';
            $article->keishaMensekiMinL = '';
            $article->keishaMensekiMinTaniKbn = 0;
        }

        if($article->land_condition2 == 1) {
            $land_condition_area2_list = explode('.', $article->land_condition_area2);
            $article->shikichiEnchoMinS = $land_condition_area2_list[0]??'';
            $article->shikichiEnchoMinL = $land_condition_area2_list[1]??'';
            $article->shikichiEnchoMinTaniKbn = $article->land_condition_unit2;
        } else {
            $article->shikichiEnchoMinS = '';
            $article->shikichiEnchoMinL = '';
            $article->shikichiEnchoMinTaniKbn = 0;           
        }

        if($article->land_condition3 == 1) {
            $land_condition_area3_list = explode('.', $article->land_condition_area3);
            $article->koatsuMensekiMinS = $land_condition_area3_list[0]??'';
            $article->koatsuMensekiMinL = $land_condition_area3_list[1]??'';
        } else {
            $article->koatsuMensekiMinS = '';
            $article->koatsuMensekiMinL = '';          
        }

        // 建ぺい率
        $article->kenpeiritsu = (int)$article->building_rate;
        // 容積率
        $article->yosekiritsu = (int)$article->volume_rate;

        // 私道負担
        if($article->road_burden == 0) {
            $article->shidoFutanKbn = 1;
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        } elseif($article->road_burden == 1) {
            $article->shidoFutanKbn = 2;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $article->shidoFutanMensekiMinS1 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL1 = $road_burden_area_list[1]??'';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';

        } elseif($article->road_burden == 2) {
            $article->shidoFutanKbn = 3;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $road_numerator = $article->road_numerator;
            $road_numerator_list = explode('.', $road_numerator);
            $road_denominator = $article->road_denominator;
            $road_denominator_list = explode('.', $road_denominator);
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL2 = $road_burden_area_list[1]??'';
            $article->shidoFutanBunshiMinS = $road_numerator_list[0]??'';
            $article->shidoFutanBunshiMinL = $road_numerator_list[1]??'';
            $article->shidoFutanBunboMinS = $road_denominator_list[0]??'';
            $article->shidoFutanBunboMinL = $road_denominator_list[1]??'';
        } else {
            $article->shidoFutanKbn = '';
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        }

        // 地役権
        if($article->easement == 1 || $article->easement == 0) {
            $article->chiekikenKbn = $article->easement;
            $article->chiekikenMensekiS = '';
            $article->chiekikenMensekiL = '';
        } else {
            $article->chiekikenKbn = $article->easement;
            $easement_area = $article->easement_area;
            $easement_area_list = explode('.', $easement_area);
            $article->chiekikenMensekiS = $easement_area_list[0]??'';
            $article->chiekikenMensekiL = $easement_area_list[1]??'';
        }
        // 道路向き
        if($article->land_direction1 == 0) {
            $article->doroMukiKbn1 = 0;
        } else { 
            if($article->land_direction1 == 1) {
                $article->doroMukiKbn1 = 4;
            } elseif($article->land_direction1 == 2) {
                $article->doroMukiKbn1 = 5;
            } elseif($article->land_direction1 == 3) {
                $article->doroMukiKbn1 = 1;
            } elseif($article->land_direction1 == 4) {
                $article->doroMukiKbn1 = 6;
            } elseif($article->land_direction1 == 5) {
                $article->doroMukiKbn1 = 3;
            } elseif($article->land_direction1 == 6) {
                $article->doroMukiKbn1 = 8;
            } elseif($article->land_direction1 == 7) {
                $article->doroMukiKbn1 = 2;
            } elseif($article->land_direction1 == 8) {
                $article->doroMukiKbn1 = 7;
            }
            $road_width1 = $article->road_width1;
            $road_width1_list = explode('.', $road_width1);
            $frontage1 = $article->frontage1;
            $frontage1_list = explode('.', $frontage1);
            $article->doroWidth1S = $road_width1_list[0]??'';
            $article->doroWidth1L = $road_width1_list[1]??'';
            $article->setsudoWidth1S = $frontage1_list[0]??'';
            $article->setsudoWidth1L = $frontage1_list[1]??'';
        }

        if($article->land_direction2 == 0) {
            $article->doroMukiKbn2 = 0;
        } else { 
            if($article->land_direction2 == 1) {
                $article->doroMukiKbn2 = 4;
            } elseif($article->land_direction2 == 2) {
                $article->doroMukiKbn2 = 5;
            } elseif($article->land_direction2 == 3) {
                $article->doroMukiKbn2 = 1;
            } elseif($article->land_direction2 == 4) {
                $article->doroMukiKbn2 = 6;
            } elseif($article->land_direction2 == 5) {
                $article->doroMukiKbn2 = 3;
            } elseif($article->land_direction2 == 6) {
                $article->doroMukiKbn2 = 8;
            } elseif($article->land_direction2 == 7) {
                $article->doroMukiKbn2 = 2;
            } elseif($article->land_direction2 == 8) {
                $article->doroMukiKbn2 = 7;
            }
            $road_width2 = $article->road_width2;
            $road_width2_list = explode('.', $road_width2);
            $frontage2 = $article->frontage2;
            $frontage2_list = explode('.', $frontage2);
            $article->doroWidth2S = $road_width2_list[0]??'';
            $article->doroWidth2L = $road_width2_list[1]??'';
            $article->setsudoWidth2S = $frontage2_list[0]??'';
            $article->setsudoWidth2L = $frontage2_list[1]??'';
        }

        if($article->land_direction3 == 0) {
            $article->doroMukiKbn3 = 0;
        } else { 
            if($article->land_direction3 == 1) {
                $article->doroMukiKbn3 = 4;
            } elseif($article->land_direction3 == 2) {
                $article->doroMukiKbn3 = 5;
            } elseif($article->land_direction3 == 3) {
                $article->doroMukiKbn3 = 1;
            } elseif($article->land_direction3 == 4) {
                $article->doroMukiKbn3 = 6;
            } elseif($article->land_direction3 == 5) {
                $article->doroMukiKbn3 = 3;
            } elseif($article->land_direction3 == 6) {
                $article->doroMukiKbn3 = 8;
            } elseif($article->land_direction3 == 7) {
                $article->doroMukiKbn3 = 2;
            } elseif($article->land_direction3 == 8) {
                $article->doroMukiKbn3 = 7;
            }
            $road_width3 = $article->road_width3;
            $road_width3_list = explode('.', $road_width3);
            $frontage3 = $article->frontage3;
            $frontage3_list = explode('.', $frontage3);
            $article->doroWidth3S = $road_width3_list[0]??'';
            $article->doroWidth3L = $road_width3_list[1]??'';
            $article->setsudoWidth3S = $frontage3_list[0]??'';
            $article->setsudoWidth3L = $frontage3_list[1]??'';
        }

        // 上水道
        $article->setsubiJosuidoKbn = $article->water_supply;

        // 下水道
        $article->setsubiGesuidoKbn = $article->sewerage;

        // ガス
        $article->setsubiGasKbn = $article->gas;

        // 駐車場
        if($article->garage == 1) {
            $article->shakoKbn = 2;
        } elseif($article->garage == 0) {
            $article->shakoKbn = 0;
        }

        // セットパック
        if($article->set == 1) {
            $article->setbackKbn = $article->set;
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        } elseif($article->set == 2 || $article->set == 3) {
            $article->setbackKbn = $article->set;
            $set_area = $article->set_area;
            $set_area_list = explode('.', $set_area);
            $article->setbackMensekiMinS = $set_area_list[0]??'';
            $article->setbackMensekiMinL = $set_area_list[1]??'';
        } else {
            $article->setbackKbn = '';
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        }

        // 用途地域
        if($article->use_area == 1) {
            $article->yotochiikiCd01 = '01';
        } elseif($article->use_area == 2) {
            $article->yotochiikiCd01 = '04';
        } elseif($article->use_area == 3) {
            $article->yotochiikiCd01 = '06';
        } elseif($article->use_area == 4) {
            $article->yotochiikiCd01 = '08';
        } elseif($article->use_area == 5) {
            $article->yotochiikiCd01 = '09';
        } elseif($article->use_area == 6) {
            $article->yotochiikiCd01 = '10';
        } elseif($article->use_area == 7) {
            $article->yotochiikiCd01 = '11';
        } elseif($article->use_area == 8) {
            $article->yotochiikiCd01 = '12';
        } elseif($article->use_area == 10) {
            $article->yotochiikiCd01 = '02';
        } elseif($article->use_area == 11) {
            $article->yotochiikiCd01 = '03';
        } elseif($article->use_area == 12) {
            $article->yotochiikiCd01 = '05';
        } elseif($article->use_area == 13) {
            $article->yotochiikiCd01 = '07';
        } elseif($article->use_area == 14) {
            $article->yotochiikiCd01 = '16';
        } else {
            $article->yotochiikiCd01 = '00';
        }
        
        if($article->land_use == 1) {
            $article->yotochiikiCd02 = '01';
        } elseif($article->land_use == 2) {
            $article->yotochiikiCd02 = '04';
        } elseif($article->land_use == 3) {
            $article->yotochiikiCd02 = '06';
        } elseif($article->land_use == 4) {
            $article->yotochiikiCd02 = '08';
        } elseif($article->land_use == 5) {
            $article->yotochiikiCd02 = '09';
        } elseif($article->land_use == 6) {
            $article->yotochiikiCd02 = '10';
        } elseif($article->land_use == 7) {
            $article->yotochiikiCd02 = '11';
        } elseif($article->land_use == 8) {
            $article->yotochiikiCd02 = '12';
        } elseif($article->land_use == 10) {
            $article->yotochiikiCd02 = '02';
        } elseif($article->land_use == 11) {
            $article->yotochiikiCd02 = '03';
        } elseif($article->land_use == 12) {
            $article->yotochiikiCd02 = '05';
        } elseif($article->land_use == 13) {
            $article->yotochiikiCd02 = '07';
        } elseif($article->land_use == 14) {
            $article->yotochiikiCd02 = '16';
        } else {
            $article->yotochiikiCd02 = '00';
        }

        // 建物面積
        $article->tatemonoMnsKbn = $article->total_area;
        $total_area = $article->total_area_val??'0.0';
        $total_area_list = explode('.', $total_area);
        $article->tatemonoMnsMinS = $total_area_list[0]??'';
        $article->tatemonoMnsMinL = $total_area_list[1]??'';

        $building_condition_area1 = $article->building_condition_area1??'0.0';
        $building_condition_area1_list = explode('.', $building_condition_area1);
        $article->uchiChikashitsuMinS = $building_condition_area1_list[0]??'';
        $article->uchiChikashitsuMinL = $building_condition_area1_list[1]??'';

        $building_condition_area2 = $article->building_condition_area2??'0.0';
        $building_condition_area2_list = explode('.', $building_condition_area2);
        $article->uchiShakoMinS = $building_condition_area2_list[0]??'';
        $article->uchiShakoMinL = $building_condition_area2_list[1]??'';

        $building_condition_area3 = $article->building_condition_area3??'0.0';
        $building_condition_area3_list = explode('.', $building_condition_area3);
        $article->uchiChikachuMinS = $building_condition_area3_list[0]??'';
        $article->uchiChikachuMinL = $building_condition_area3_list[1]??'';

        if($article->building_condition4 == 1) {
            if($article->building_condition_select != 9) {
                $article->uchiJigYotoKbn = $article->building_condition_select;
            } else {
                $article->uchiJigYotoKbn = '7';
            }
        } else {
            $article->uchiJigYotoKbn = '0';
        }
        
        $article->madoriMin = $article->floor_plan;
        if($article->floor_plan_type == 1) {
            $article->madoriMinType1Kbn = '03';
        } elseif($article->floor_plan_type == 2) {
            $article->madoriMinType1Kbn = '04';
        } elseif($article->floor_plan_type == 3) {
            $article->madoriMinType1Kbn = '01';
        } elseif($article->floor_plan_type == 4) {
            $article->madoriMinType1Kbn = '02';
        } elseif($article->floor_plan_type == 7) {
            $article->madoriMinType1Kbn = '05';
        } else {
            $article->madoriMinType1Kbn = '00';
        }

        $article->soKosu = $article->total_unit??'0';
        $article->kanseiJikiNen = $article->completed_year;
        $article->kanseiJikiTsuki = $article->completed_month;
        $article->kanseiJikiTsukiSu = $article->completed_contract_month;

        // 建物状況TODO

        // 入居予定
        if($article->move_in == 1) {
            $article->nyukyoJikiKbn = 1;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 2) {
            $article->nyukyoJikiKbn = 4;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 3) {
            $article->nyukyoJikiKbn = 2;
            $article->nyukyoJikiNen = $article->move_in_year;
            $article->nyukyoJikiTsuki = $article->move_in_month;
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 4) {
            $article->nyukyoJikiKbn = 3;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = $article->move_in_contract_month;

        } elseif($article->move_in == 0) {
            $article->nyukyoJikiKbn = 0;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        }
        
        // 構造
        if($article->construction == 1) {
            $article->kozoKbn = '03';
        } elseif($article->construction == 3) {
            $article->kozoKbn = '04';
        } elseif($article->construction == 4) {
            $article->kozoKbn = '01';
        } elseif($article->construction == 5) {
            $article->kozoKbn = '02';
        } elseif($article->construction == 6) {
            $article->kozoKbn = '06';
        } elseif($article->construction == 7) {
            $article->kozoKbn = '07';
        } elseif($article->construction == 8) {
            $article->kozoKbn = '05';
        } elseif($article->construction == 9) {
            $article->kozoKbn = '08';
        } else {
            $article->kozoKbn = '';
        }

        if($article->construction_sub == 1) {
            $article->kozoKbnIchibu = '03';
        } elseif($article->construction_sub == 3) {
            $article->kozoKbnIchibu = '04';
        } elseif($article->construction_sub == 4) {
            $article->kozoKbnIchibu = '01';
        } elseif($article->construction_sub == 5) {
            $article->kozoKbnIchibu = '02';
        } elseif($article->construction_sub == 6) {
            $article->kozoKbnIchibu = '06';
        } elseif($article->construction_sub == 7) {
            $article->kozoKbnIchibu = '07';
        } elseif($article->construction_sub == 8) {
            $article->kozoKbnIchibu = '05';
        } elseif($article->construction_sub == 9) {
            $article->kozoKbnIchibu = '08';
        } else {
            $article->kozoKbnIchibu = '10';
        }
        
        // 建物階建て
        $article->chijokaidate = $article->floor;
        $article->chikakaidate = $article->underground;

        // 駐車場
        if($article->parking == 1) {
            $article->shakoKbn = '5';
        } elseif($article->parking == 9) {
            $article->shakoKbn = '1';
        } elseif($article->parking == 10) {
            $article->shakoKbn = '2';
        } elseif($article->parking == 11) {
            $article->shakoKbn = '3';
        } elseif($article->parking == 12) {
            $article->shakoKbn = '4';
        } else {
            $article->shakoKbn = '0';
        }

        // 建物確認番号
        $article->kenchikuKakuninNo = $article->architecture_no;

        //リフォーム
        if($article->exterior == 1) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = '';
            $article->gaisoTsuki = '';
        } elseif($article->exterior == 2) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        } elseif($article->exterior == 3) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        }

        if($article->interior == 1) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = '';
            $article->naisoTsuki = '';
        } elseif($article->interior == 2) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        } elseif($article->interior == 3) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        }

        // 5.会社情報
        if($article->company_manner == 1) {
            $article->torihikitaiyoKbn01 = '01';
        } elseif($article->company_manner == 2) {
            $article->torihikitaiyoKbn01 = '13';
        } elseif($article->company_manner == 3) {
            $article->torihikitaiyoKbn01 = '09';
        } elseif($article->company_manner == 4) {
            $article->torihikitaiyoKbn01 = '10';
        } elseif($article->company_manner == 5) {
            $article->torihikitaiyoKbn01 = '11';
        } elseif($article->company_manner == 6) {
            $article->torihikitaiyoKbn01 = '07';
        } elseif($article->company_manner == 7) {
            $article->torihikitaiyoKbn01 = '08';
        } elseif($article->company_manner == 8) {
            $article->torihikitaiyoKbn01 = '09';
        } else {
            $article->torihikitaiyoKbn01 = '';
        }

        // 6.制限事項
        $law_check = RelationLawrestriction::getDataByArticleId($article->building_id);
        foreach($law_check as $law) {
            if($law == 1) {
                $article->hriSgnHoBunkazai = 1;
                
            } elseif($law == 2) {
                $article->hriSgnHoKotohogo = 1;
                
            } elseif($law == 3) {
                $article->hriSgnHoKeikan = 1;
                
            } elseif($law == 4) {
                $article->hriSgnHoMisshuSgcSeibi = 1;
                
            } elseif($law == 5) {
                $article->hriSgnHoKoku = 1;
                
            } elseif($law == 6) {
                $article->hriSgnHoKasen = 1;
                
            } elseif($law == 7) {
                $article->hriSgnHoSabo = 1;
                
            } elseif($law == 8) {
                $article->hriSgnHoNochi = 1;
                
            } elseif($law == 9) {
                $article->hriSgnHoAnzenJorei = 1;
                
            } elseif($law == 10) {
                $article->hriSgnChiTakuzokisei = 1;
                
            } elseif($law == 11) {
                $article->hriSgnChiKyukeishachi = 1;
                
            } elseif($law == 12) {
                $article->hriSgnChiKodochiku = 1;
                
            } elseif($law == 13) {
                $article->hriSgnChiKodoriyo = 1;
                
            } elseif($law == 14) {
                $article->hriSgnChiChukosoJutaku = 1;
                
            } elseif($law == 15) {
                $article->hriSgnChiKosojutakuYudo = 1;
                
            } elseif($law == 16) {
                $article->hriSgnChiBoka = 1;
                
            } elseif($law == 17) {
                $article->hriSgnChiJunboka = 1;
                
            } elseif($law == 18) {
                $article->hriSgnChiFuchi = 1;
                
            } elseif($law == 19) {
                $article->hriSgnChiKeikan = 1;
                
            } elseif($law == 20) {
                $article->hriSgnChiJunKeikan = 1;
                
            } elseif($law == 21) {
                $article->hriSgnChiKanko = 1;
                
            } elseif($law == 22) {
                $article->hriSgnChiRekishi = 1;
                
            } elseif($law == 23) {
                $article->hriSgnChiDento = 1;
                
            } elseif($law == 24) {
                $article->hriSgnChiTokuteiGaiku = 1;
                
            } elseif($law == 25) {
                $article->hriSgnChiTokubetsuYoto = 1;
                
            } elseif($law == 26) {
                $article->hriSgnChiBunkyo = 1;
                
            } elseif($law == 27) {
                $article->hriSgnChiToshisaisei = 1;
                
            } elseif($law == 28) {
                $article->hriSgnChiTokubetsuRyokuchi = 1;
                
            } elseif($law == 29) {
                $article->hriSgnTateTakasaMax = 1;
                
            } elseif($law == 30) {
                $article->hriSgnTateTakasaMin = 1;
                
            } elseif($law == 31) {
                $article->hriSgnTateKenpeiMin = 1;
                
            } elseif($law == 32) {
                $article->hriSgnTateYosekiMin = 1;
                
            } elseif($law == 33) {
                $article->hriSgnTateSktMnsMax = 1;
                
            } elseif($law == 34) {
                $article->hriSgnTateSktMnsMin = 1;
                
            } elseif($law == 35) {
                $article->hriSgnTateMnsMax = 1;
                
            } elseif($law == 36) {
                $article->hriSgnTateMnsMin = 1;
            }
        }

        // その他制限事項
        $article->kckKjn43joTadashigakiKbn = $article->other_reason;
        $article->sgnJikoComment = $article->other_comment;

        // 7.投資用・事業用
        if($article->classfication ==1) {
            $article->jigKbn = 0;
            $article->jigComment = '';
        } else {
            $article->jigKbn = 1;
            if($article->use_method == 1) {
                $article->jigYotoKbn = '07';
                $article->jigComment = '';
            } elseif($article->use_method == 2) {
                $article->jigYotoKbn = '08';
                $article->jigComment = '';
            } elseif($article->use_method == 3) {
                $article->jigYotoKbn = '09';
                $article->jigComment = '';
            } elseif($article->use_method == 4) {
                $article->jigYotoKbn = '01';
                $article->jigComment = '';
            } elseif($article->use_method == 5) {
                $article->jigYotoKbn = '02';
                $article->jigComment = '';
            } elseif($article->use_method == 6) {
                $article->jigYotoKbn = '06';
                $article->jigComment = '';
            } elseif($article->use_method == 7) {
                $article->jigYotoKbn = '04';
                $article->jigComment = '';
            } elseif($article->use_method == 8) {
                $article->jigYotoKbn = '03';
                $article->jigComment = '';
            } elseif($article->use_method == 9) {
                $article->jigYotoKbn = '99';
                $article->jigComment = $article->use_method_text;
            }
        }

        // 10.イベント情報
        

        return $article;

    }

    function moldingDataMansion($article, $mansion) {
        // 基本・交通タブ
        // 1.基本情報
        // 物件名
        $article->b_name = mb_substr($article->article_name, 0, 42);

        // 物件担当者
        $user_info = UserInfo::getDataById($article->hp_charge);
        $name_info = '';
        $name_info = $user_info->last_name??'';
        if($name_info != '') {
            $name_info .= ' ';
        }
        $name_info .= $user_info->first_name??'';
        $article->tantou_name = $name_info;

        // 状態
        if($article->status == 1) {
            // 販売中
            $article->status_h = "1";
        } else {
            // 販売中以外
            $article->status_h = "3";
        }

        // LIFULL HOME'S掲載
        if($article->homes == 1) {
            $article->flg_open = "0";
        } elseif($article->homes == 2) {
            $article->flg_open = "1";
        }

        // 2.所在地
        // 郵便番号
        $zip_info = $article->zip;
        $zip_list = explode('-', $zip_info);
        $article->post1 = $zip_list[0]??'';
        $article->post2 = $zip_list[1]??'';

        // 住所
        $article->todofukenCd = $article->address1;
        $article->shikugunCd = $article->address2;
        $article->ooazaCd = $article->address3;

        // 番地など
        $article->addr3_addr4_name = $article->address4;
        if(is_null($article->address4)) {
            // addr3_addr4_nameは必須項目
            $article->addr3_addr4_name = "1"; //★テスト用
            $article->flg_addr_hidden = "0";
        } else {
            $article->flg_addr_hidden = "1";
        }
        $article->display_addr_name = $article->address4;

        $pref_info = MstPrefecture::getName($article->address1);
        $city_info = MstCity::getName($article->address1, $article->address2);
        $town_info = MstTown::getName($article->address1, $article->address2, $article->address3);
        $article->todofukenNm = $pref_info->name??'';
        $article->shikugunNm = $city_info->name??'';
        $article->ooazaNm = $town_info->name??'';

        //緯度経度
        $article->nl = $article->lat;
        $article->el = $article->lng;

        // 3.交通

        // 金銭・建物タブ
        // 1.価格
        if ($article->tax == 1) {
            // 税抜
            $article->money_tax = "3";
        } elseif($article->tax == 2) {
            // 税込
            $article->money_tax = "2";
        }



        // 2.担当者情報
        // スタッフコメント
        $article->staffComment = mb_substr($article->comment, 0, 100);
        // 社内メモ1
        $article->kishaComment1 = mb_substr($article->memo1, 0, 20);
        // 社内メモ2
        $article->kishaComment2 = mb_substr($article->memo2, 0, 20);

        // 3.価格
        // 管理形態TODO
        // 管理費TODO
        // 修繕費TODO
        // 駐車場TODO

        // 町会費
        if($article->council != 0) {
            $article->chokaihiKbn = $article->council;
            if($article->council_presence == 0) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            } elseif($article->council_presence == 1) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = $article->council_cost;
                if($article->council_cost_unit != 0) {
                    $article->chokaihiRyoTaniKbn = $article->council_cost_unit;
                } else {
                    $article->chokaihiRyoTaniKbn = '';
                }
            } elseif($article->council_presence == 2) {
                $article->chokaihiUmu = '3';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            }
        } elseif($article->council == 0) {
            $article->chokaihiKbn = '0';
            $article->chokaihiUmu = '';
            $article->chokaihiRyo = '';
            $article->chokaihiRyoTaniKbn = '';
        }

        // 有線
        if($article->broadcasting == 0) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        } elseif($article->broadcasting == 1) {
            $article->yusenHiyoUmu = '1';
            if($article->broadcasting_presence == 0) {
                $article->yusenShokiHiyoUmu = 1;
                $article->yusenShokiHiyo = '';
            } elseif($article->broadcasting_presence == 1) {
                $article->yusenShokiHiyoUmu = 2;
                $article->yusenShokiHiyo = $article->broadcasting_cost;
            } elseif($article->broadcasting_presence == 2) {
                $article->yusenShokiHiyoUmu = 3;
                $article->yusenShokiHiyo = '';
            }

            if($article->broadcasting_fixed_presence == 0) {
                $article->yusenTeigakuRyoUmu = 1;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 1) {
                $article->yusenTeigakuRyoUmu = 2;
                $article->yusenTeigakuRyo = $article->broadcasting_fixed_cost;
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 2) {
                $article->yusenTeigakuRyoUmu = 3;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            }

        } elseif($article->broadcasting == 2) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        }

        // インターネット
        if($article->internet == 0) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        } elseif($article->internet == 1) {
            $article->internetHiyoUmu = '1';
            if($article->internet_presence == 0) {
                $article->internetShokiHiyoUmu = 1;
                $article->internetShokiHiyo = '';
            } elseif($article->internet_presence == 1) {
                $article->internetShokiHiyoUmu = 2;
                $article->internetShokiHiyo = $article->internet_cost;
            } elseif($article->internet_presence == 2) {
                $article->internetShokiHiyoUmu = 3;
                $article->internetShokiHiyo = '';
            }

            if($article->internet_fixed_presence == 0) {
                $article->internetTeigakuRyoUmu = 1;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 1) {
                $article->internetTeigakuRyoUmu = 2;
                $article->internetTeigakuRyo = $article->internet_fixed_cost;
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 2) {
                $article->internetTeigakuRyoUmu = 3;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            }

        } elseif($article->internet == 2) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        }

        // catv
        if($article->catv == 0) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        } elseif($article->catv == 1) {
            $article->catvHiyoUmu = '1';
            if($article->catv_presence == 0) {
                $article->catvShokiHiyoUmu = 1;
                $article->catvShokiHiyo = '';
            } elseif($article->catv_presence == 1) {
                $article->catvShokiHiyoUmu = 2;
                $article->catvShokiHiyo = $article->catv_cost;
            } elseif($article->catv_presence == 2) {
                $article->catvShokiHiyoUmu = 3;
                $article->catvShokiHiyo = '';
            }

            if($article->catv_fixed_presence == 0) {
                $article->catvTeigakuRyoUmu = 1;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 1) {
                $article->catvTeigakuRyoUmu = 2;
                $article->catvTeigakuRyo = $article->catv_fixed_cost;
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 2) {
                $article->catvTeigakuRyoUmu = 3;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            }

        } elseif($article->catv == 2) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        }

        // 温泉
        if($article->spring != 0) {
            $article->onsenKenKbn = $article->council;
            if($article->spring_presence == 0) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            } elseif($article->spring_presence == 1) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = $article->spring_cost;
                if($article->spring_cost_unit != 0) {
                    $article->onsenKenRyoTaniKbn = $article->spring_cost_unit;
                } else {
                    $article->onsenKenRyoTaniKbn = '';
                }
            } elseif($article->spring_presence == 2) {
                $article->onsenKenRyoUmu = '3';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            }
        } elseif($article->spring == 0) {
            $article->onsenKenKbn = '0';
            $article->onsenKenRyoUmu = '';
            $article->onsenKenRyo = '';
            $article->onsenKenRyoTaniKbn = '';
        }
        
        // 4.土地建物情報
        // 土地権利
        if($mansion->land_right != 0) {
            // ★番号の割り当て方todo
            $article->land_right_h = $mansion->land_right;
        } else {
            $article->land_right_h = "";
        }

        // 用途地域
        if($mansion->use_area == 1) {
            $article->yotochiikiCd01 = '01';
        } elseif($mansion->use_area == 2) {
            $article->yotochiikiCd01 = '04';
        } elseif($mansion->use_area == 3) {
            $article->yotochiikiCd01 = '06';
        } elseif($mansion->use_area == 4) {
            $article->yotochiikiCd01 = '08';
        } elseif($mansion->use_area == 5) {
            $article->yotochiikiCd01 = '09';
        } elseif($mansion->use_area == 6) {
            $article->yotochiikiCd01 = '10';
        } elseif($mansion->use_area == 7) {
            $article->yotochiikiCd01 = '11';
        } elseif($mansion->use_area == 8) {
            $article->yotochiikiCd01 = '12';
        } elseif($mansion->use_area == 10) {
            $article->yotochiikiCd01 = '02';
        } elseif($mansion->use_area == 11) {
            $article->yotochiikiCd01 = '03';
        } elseif($mansion->use_area == 12) {
            $article->yotochiikiCd01 = '05';
        } elseif($mansion->use_area == 13) {
            $article->yotochiikiCd01 = '07';
        } elseif($mansion->use_area == 14) {
            $article->yotochiikiCd01 = '16';
        } else {
            $article->yotochiikiCd01 = '00';
        }
        
        if($mansion->land_use == 1) {
            $article->yotochiikiCd02 = '01';
        } elseif($mansion->land_use == 2) {
            $article->yotochiikiCd02 = '04';
        } elseif($mansion->land_use == 3) {
            $article->yotochiikiCd02 = '06';
        } elseif($mansion->land_use == 4) {
            $article->yotochiikiCd02 = '08';
        } elseif($mansion->land_use == 5) {
            $article->yotochiikiCd02 = '09';
        } elseif($mansion->land_use == 6) {
            $article->yotochiikiCd02 = '10';
        } elseif($mansion->land_use == 7) {
            $article->yotochiikiCd02 = '11';
        } elseif($mansion->land_use == 8) {
            $article->yotochiikiCd02 = '12';
        } elseif($mansion->land_use == 10) {
            $article->yotochiikiCd02 = '02';
        } elseif($mansion->land_use == 11) {
            $article->yotochiikiCd02 = '03';
        } elseif($mansion->land_use == 12) {
            $article->yotochiikiCd02 = '05';
        } elseif($mansion->land_use == 13) {
            $article->yotochiikiCd02 = '07';
        } elseif($mansion->land_use == 14) {
            $article->yotochiikiCd02 = '16';
        } else {
            $article->yotochiikiCd02 = '00';
        }
        
        // 構造
        if($mansion->construction == 1) {
            $article->kozoKbn = '03';
        } elseif($mansion->construction == 3) {
            $article->kozoKbn = '04';
        } elseif($mansion->construction == 4) {
            $article->kozoKbn = '01';
        } elseif($mansion->construction == 5) {
            $article->kozoKbn = '02';
        } elseif($mansion->construction == 6) {
            $article->kozoKbn = '06';
        } elseif($mansion->construction == 7) {
            $article->kozoKbn = '07';
        } elseif($mansion->construction == 8) {
            $article->kozoKbn = '05';
        } elseif($mansion->construction == 9) {
            $article->kozoKbn = '08';
        } else {
            $article->kozoKbn = '';
        }

        if($mansion->construction_sub == 1) {
            $article->kozoKbnIchibu = '03';
        } elseif($mansion->construction_sub == 3) {
            $article->kozoKbnIchibu = '04';
        } elseif($mansion->construction_sub == 4) {
            $article->kozoKbnIchibu = '01';
        } elseif($mansion->construction_sub == 5) {
            $article->kozoKbnIchibu = '02';
        } elseif($mansion->construction_sub == 6) {
            $article->kozoKbnIchibu = '06';
        } elseif($mansion->construction_sub == 7) {
            $article->kozoKbnIchibu = '07';
        } elseif($mansion->construction_sub == 8) {
            $article->kozoKbnIchibu = '05';
        } elseif($article->construction_sub == 9) {
            $article->kozoKbnIchibu = '08';
        } else {
            $article->kozoKbnIchibu = '10';
        }

        // 施工会社
        $article->sekoKaishaNm = $mansion->construction_company;
        
        // 建物階建て
        $article->chijokaidate = $article->floor;
        $article->chikakaidate = $article->underground;

        // 所在階
        $article->shozaiKaiComment = $article->whereabouts;

        // 部屋番号
        $article->empty_contents = $article->room_num;
        if($article->room_num_disp == 0) {
            $article->flg_bukken_name = 2; // 建物名(分譲名)のみを表示
        } elseif($article->room_num_disp == 1) {
            $article->flg_bukken_name = 1; // 建物名(分譲名)と部屋/区画NO.を表示
        }

        // 専有面積
        $article->senyumensekiKbn = $article->total_area;
        $total_area = $article->land_aretotal_area_vala_val??'0.0';
        $total_area_list = explode('.', $total_area);
        $article->senyumensekiMinS = $total_area_list[0]??'';
        $article->senyumensekiMinL = $total_area_list[1]??'';

        // 間取り
        $article->madoriMin = $article->floor_plan;
        if($article->floor_plan_type == 1) {
            $article->madoriMinType1Kbn = '03';
        } elseif($article->floor_plan_type == 2) {
            $article->madoriMinType1Kbn = '04';
        } elseif($article->floor_plan_type == 3) {
            $article->madoriMinType1Kbn = '01';
        } elseif($article->floor_plan_type == 4) {
            $article->madoriMinType1Kbn = '02';
        } elseif($article->floor_plan_type == 7) {
            $article->madoriMinType1Kbn = '05';
        } else {
            $article->madoriMinType1Kbn = '00';
        }

        // バルコニー
        if($article->balcony_area == 0) {
            $article->balcony_umu = "2";
            $article->balcony_area = "";
        } elseif($article->balcony_area == 1) {
            $article->balcony_umu = "1";
            $article->balcony_area = $article->balcony_area_val;
        }
        
        // ルーフバルコニーTODO
        // 専用庭TODO
        // テラスTODO
        // 総戸数TODO
        // 完成時期TODO
        // 建物状況TODO
        // 入居予定TODO

        //リフォーム
        if($article->exterior == 1) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = '';
            $article->gaisoTsuki = '';
        } elseif($article->exterior == 2) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        } elseif($article->exterior == 3) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        }

        if($article->interior == 1) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = '';
            $article->naisoTsuki = '';
        } elseif($article->interior == 2) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        } elseif($article->interior == 3) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        }

        // 5.会社情報
        if($article->company_manner == 1) {
            $article->torihikitaiyoKbn01 = '01';
        } elseif($article->company_manner == 2) {
            $article->torihikitaiyoKbn01 = '13';
        } elseif($article->company_manner == 3) {
            $article->torihikitaiyoKbn01 = '09';
        } elseif($article->company_manner == 4) {
            $article->torihikitaiyoKbn01 = '10';
        } elseif($article->company_manner == 5) {
            $article->torihikitaiyoKbn01 = '11';
        } elseif($article->company_manner == 6) {
            $article->torihikitaiyoKbn01 = '07';
        } elseif($article->company_manner == 7) {
            $article->torihikitaiyoKbn01 = '08';
        } elseif($article->company_manner == 8) {
            $article->torihikitaiyoKbn01 = '09';
        } else {
            $article->torihikitaiyoKbn01 = '';
        }

        // 6.制限事項
        $law_check = RelationLawrestriction::getDataByArticleId($article->building_id);
        foreach($law_check as $law) {
            if($law == 1) {
                $article->hriSgnHoBunkazai = 1;
                
            } elseif($law == 2) {
                $article->hriSgnHoKotohogo = 1;
                
            } elseif($law == 3) {
                $article->hriSgnHoKeikan = 1;
                
            } elseif($law == 4) {
                $article->hriSgnHoMisshuSgcSeibi = 1;
                
            } elseif($law == 5) {
                $article->hriSgnHoKoku = 1;
                
            } elseif($law == 6) {
                $article->hriSgnHoKasen = 1;
                
            } elseif($law == 7) {
                $article->hriSgnHoSabo = 1;
                
            } elseif($law == 8) {
                $article->hriSgnHoNochi = 1;
                
            } elseif($law == 9) {
                $article->hriSgnHoAnzenJorei = 1;
                
            } elseif($law == 10) {
                $article->hriSgnChiTakuzokisei = 1;
                
            } elseif($law == 11) {
                $article->hriSgnChiKyukeishachi = 1;
                
            } elseif($law == 12) {
                $article->hriSgnChiKodochiku = 1;
                
            } elseif($law == 13) {
                $article->hriSgnChiKodoriyo = 1;
                
            } elseif($law == 14) {
                $article->hriSgnChiChukosoJutaku = 1;
                
            } elseif($law == 15) {
                $article->hriSgnChiKosojutakuYudo = 1;
                
            } elseif($law == 16) {
                $article->hriSgnChiBoka = 1;
                
            } elseif($law == 17) {
                $article->hriSgnChiJunboka = 1;
                
            } elseif($law == 18) {
                $article->hriSgnChiFuchi = 1;
                
            } elseif($law == 19) {
                $article->hriSgnChiKeikan = 1;
                
            } elseif($law == 20) {
                $article->hriSgnChiJunKeikan = 1;
                
            } elseif($law == 21) {
                $article->hriSgnChiKanko = 1;
                
            } elseif($law == 22) {
                $article->hriSgnChiRekishi = 1;
                
            } elseif($law == 23) {
                $article->hriSgnChiDento = 1;
                
            } elseif($law == 24) {
                $article->hriSgnChiTokuteiGaiku = 1;
                
            } elseif($law == 25) {
                $article->hriSgnChiTokubetsuYoto = 1;
                
            } elseif($law == 26) {
                $article->hriSgnChiBunkyo = 1;
                
            } elseif($law == 27) {
                $article->hriSgnChiToshisaisei = 1;
                
            } elseif($law == 28) {
                $article->hriSgnChiTokubetsuRyokuchi = 1;
                
            } elseif($law == 29) {
                $article->hriSgnTateTakasaMax = 1;
                
            } elseif($law == 30) {
                $article->hriSgnTateTakasaMin = 1;
                
            } elseif($law == 31) {
                $article->hriSgnTateKenpeiMin = 1;
                
            } elseif($law == 32) {
                $article->hriSgnTateYosekiMin = 1;
                
            } elseif($law == 33) {
                $article->hriSgnTateSktMnsMax = 1;
                
            } elseif($law == 34) {
                $article->hriSgnTateSktMnsMin = 1;
                
            } elseif($law == 35) {
                $article->hriSgnTateMnsMax = 1;
                
            } elseif($law == 36) {
                $article->hriSgnTateMnsMin = 1;
            }
        }

        // その他制限事項
        $article->kckKjn43joTadashigakiKbn = $article->other_reason;
        $article->sgnJikoComment = $article->other_comment;

        // 7.投資用・事業用
        if($article->classfication ==1) {
            $article->jigKbn = 0;
            $article->jigComment = '';
        } else {
            $article->jigKbn = 1;
            if($article->use_method == 1) {
                $article->jigYotoKbn = '07';
                $article->jigComment = '';
            } elseif($article->use_method == 2) {
                $article->jigYotoKbn = '08';
                $article->jigComment = '';
            } elseif($article->use_method == 3) {
                $article->jigYotoKbn = '09';
                $article->jigComment = '';
            } elseif($article->use_method == 4) {
                $article->jigYotoKbn = '01';
                $article->jigComment = '';
            } elseif($article->use_method == 5) {
                $article->jigYotoKbn = '02';
                $article->jigComment = '';
            } elseif($article->use_method == 6) {
                $article->jigYotoKbn = '06';
                $article->jigComment = '';
            } elseif($article->use_method == 7) {
                $article->jigYotoKbn = '04';
                $article->jigComment = '';
            } elseif($article->use_method == 8) {
                $article->jigYotoKbn = '03';
                $article->jigComment = '';
            } elseif($article->use_method == 9) {
                $article->jigYotoKbn = '99';
                $article->jigComment = $article->use_method_text;
            }
        }

        // 10.イベント情報
        

        return $article;

    }

    function saveLand($article) {
        // 物件メンテ画面へアクセス 土地 登録確認
        $url = 'https://manager.homes.co.jp/index.php';

        $POST_DATA = [
            "action" => "sale_reg_confirm",
            "pht_photo_delid" => "",
            "ispost" => "1",
            "b2" => "",
            "b2time" => "",
            "tk" => "1",
            "tab" => "base",
            "photo_order" => "",
            "bt" => "1101",
            "b_name" => $article->b_name,
            "b_ruby" => "",
            "empty_contents" => "",
            "flg_bukken_name" => "1",
            "status" => $article->status_h,
            "flg_open" => $article->flg_open,
            "jss_alert" => "false",
            "invest" => "0",
            "timelimit_date_y" => "2019",
            "timelimit_date_m" => "11",
            "timelimit_date_d" => "19",
            "tantou_name" => $article->tantou_name,
            "local_id" => "",
            "flg_toushi_keisai" => "0",
            "recommend" => "0",
            "post1" => $article->post1,
            "post2" => $article->post2,
            "addr1" => "0hNR5oDOggnXi-RBdHFC_A",
            "temporary_addr1" => "28",
            "addr2" => "AzvADTPTmAfXi-RBdHFC_A",
            "addr3" => "JS4Gwj8SoxjXi-RBdHFC_A",
            "addr4" => "JS4Gwj8SoxjXi-RBdHFC_A",
            "og_addr11" => "",
            "og_addr12" => "",
            "og_addr2" => "",
            "og_addr2_name" => "",
            "og_post1" => "",
            "og_post2" => "",
            "addr3_addr4_name" => $article->addr3_addr4_name,
            "flg_addr_hidden" => $article->flg_addr_hidden,
            "display_addr_name" => $article->display_addr_name,
            "nl" => $article->nl,
            "el" => $article->el,
            "fullmatch" => "1",
            "flg_adjust" => "1",
            "rosen_etc1" => "1",
            "rosen1" => "779",
            "eki1" => "7300",
            "bus_stop1" => "",
            "bus_time1" => "",
            "walk_distance1" => "4",
            "walk_distance_type1" => "2",
            "rosen_etc2" => "3",
            "rosen2" => "",
            "eki2" => "",
            "bus_stop2" => "",
            "bus_time2" => "",
            "walk_distance2" => "",
            "walk_distance_type2" => "2",
            "traffic_other" => "",
            "money_room" => $article->price,
            "money_tax" => "3",
            "money_kyoueki" => "",
            "money_kyoueki_tax" => "2",
            "commision" => "",
            "commisionunit" => "percent_money",
            "money_sonota1" => "",
            "money_sonota_str1" => "",
            "money_sonota2" => "",
            "money_sonota_str2" => "",
            "money_sonota3" => "",
            "money_sonota_str3" => "",
            "usable_status" => "1",
            "usable_etc" => "",
            "usable_date_y" => "",
            "usable_date_m" => "",
            "usable_shun" => "",
            "genkyo_code" => "1",
            "ft112" => "",
            "ft200" => "",
            "ft201" => "",
            "ft202" => "",
            "school_ele_name" => "",
            "school_ele_distance" => "",
            "school_jun_name" => "",
            "school_jun_distance" => "",
            "convenience_distance" => "",
            "super_distance" => "",
            "shopping_street_distance" => "",
            "drugstore_distance" => "",
            "hospital_distance" => "",
            "park_distance" => "",
            "bank_distance" => "",
            "est_other_name" => "",
            "est_other_distance" => "",
            "tokuchou" => "",
            "etc" => "",
            "url_kind" => "0",
            "url" => "",
            "memo" => "",
            "or_open_y" => "",
            "or_open_m" => "",
            "or_open_d" => "",
            "or_end_y" => "",
            "or_end_m" => "",
            "or_end_d" => "",
            "or_time" => "",
            "or_notes" => "",
            "taiyou" => "1",
            "kyakuzuke_simple" => "1",
            "kyakuzuke" => "2",
            "bunpai_a" => "",
            "kyakuzuke_msg" => "",
            "flg_own" => "1",
            "baikai_keiyaku_date_y" => "",
            "baikai_keiyaku_date_m" => "",
            "baikai_keiyaku_date_d" => "",
            "owner_name" => "",
            "owner_tel1" => "",
            "owner_tel2" => "",
            "owner_tel3" => "",
            "owner_fax1" => "",
            "owner_fax2" => "",
            "owner_fax3" => "",
            "owner_etc" => "",
            "owner_post1" => "",
            "owner_post2" => "",
            "owner_addr1" => "",
            "owner_addr2" => "",
            "owner_addr3" => "",
            "owner_addr4" => "",
            "og_owner_addr11" => "",
            "og_owner_addr12" => "",
            "og_owner_addr2" => "",
            "og_owner_addr2_name" => "",
            "og_owner_post1" => "",
            "og_owner_post2" => "",
            "owner_addr3_name" => "",
            "moto_name" => "",
            "moto_tel1" => "",
            "moto_tel2" => "",
            "moto_tel3" => "",
            "moto_fax1" => "",
            "moto_fax2" => "",
            "moto_fax3" => "",
            "moto_tantou_name" => "",
            "confirm_date_y" => "",
            "confirm_date_m" => "",
            "confirm_date_d" => "",
            "moto_etc" => "",
            "moto_post1" => "",
            "moto_post2" => "",
            "moto_addr1" => "",
            "moto_addr2" => "",
            "moto_addr3" => "",
            "moto_addr4" => "",
            "og_moto_addr11" => "",
            "og_moto_addr12" => "",
            "og_moto_addr2" => "",
            "og_moto_addr2_name" => "",
            "og_moto_post1" => "",
            "og_moto_post2" => "",
            "moto_addr3_name" => "",
            "photo_dl_permission" => "1",
            "land_area" => "99",
            "land_area_kind" => "",
            "land_mochibun_b" => "2",
            "land_mochibun_a" => "3",
            "all_number" => "",
            "empty_number" => "",
            "land_chimoku" => "1",
            "land_chisei" => "",
            "land_toshi" => "2",
            "land_youto" => "3",
            "land_kenpei" => "",
            "land_youseki" => "",
            "land_youseki_etc" => "",
            "land_right" => $article->land_right_h,
            "ft110" => "",
            "land_kenchikujoken_etc" => "",
            "keiyaku_year" => "2024",
            "keiyaku_month" => "5",
            "keiyaku_period_kind" => "1",
            "money_shakuchi" => "23633",
            "land_kokudohou" => "1",
            "land_seigen" => "",
            "land_shidou_flg" => "",
            "land_shidou" => "",
            "land_shidou_b" => "",
            "land_shidou_a" => "",
            "land_setback_flg" => "",
            "land_setback" => "",
            "land_road_cond" => "",
            "std_angle1" => "",
            "std_width1" => "",
            "std_kind1" => "",
            "std_maguchi1" => "",
            "std_angle2" => "",
            "std_width2" => "",
            "std_kind2" => "",
            "std_maguchi2" => "",
            "std_angle3" => "",
            "std_width3" => "",
            "std_kind3" => "",
            "std_maguchi3" => "",
            "std_angle4" => "",
            "std_width4" => "",
            "std_kind4" => "",
            "std_maguchi4" => "",
            "pht_photo[]" => "(binary)",
            "pht_photo[]" => "(binary)",
            "photo_type1" => "2",
            "photo_comment1" => "",
            "pht_photo[]" => "(binary)",
            "photo_type2" => "1",
            "photo_comment2" => "",
            "pht_photo[]" => "(binary)",
            "photo_type3" => "11",
            "photo_comment3" => "",
            "pht_photo[]" => "(binary)",
            "photo_type4" => "5",
            "photo_comment4" => "",
            "pht_photo[]" => "(binary)",
            "photo_type5" => "12",
            "photo_comment5" => "",
            "pht_photo[]" => "(binary)",
            "photo_type6" => "15",
            "photo_comment6" => "",
            "pht_photo[]" => "(binary)",
            "photo_type7" => "16",
            "photo_comment7" => "",
            "pht_photo[]" => "(binary)",
            "photo_type8" => "17",
            "photo_comment8" => "",
            "pht_photo[]" => "(binary)",
            "photo_type9" => "13",
            "photo_comment9" => "",
            "pht_photo[]" => "(binary)",
            "photo_type10" => "14",
            "photo_comment10" => "",
            "pht_photo[]" => "(binary)",
            "photo_type11" => "9",
            "photo_comment11" => "",
            "pht_photo[]" => "(binary)",
            "photo_type12" => "9",
            "photo_comment12" => "",
            "pht_photo[]" => "(binary)",
            "photo_type13" => "9",
            "photo_comment13" => "",
            "pht_photo[]" => "(binary)",
            "photo_type14" => "9",
            "photo_comment14" => "",
            "pht_photo[]" => "(binary)",
            "photo_type15" => "9",
            "photo_comment15" => "",
            "pht_photo[]" => "(binary)",
            "photo_type16" => "9",
            "photo_comment16" => "",
            "pht_photo[]" => "(binary)",
            "photo_type17" => "9",
            "photo_comment17" => "",
            "pht_photo[]" => "(binary)",
            "photo_type18" => "9",
            "photo_comment18" => "",
            "pht_photo[]" => "(binary)",
            "photo_type19" => "9",
            "photo_comment19" => "",
            "pht_photo[]" => "(binary)",
            "photo_type20" => "9",
            "photo_comment20" => "",
            "pht_photo[]" => "(binary)",
            "photo_type21" => "9",
            "photo_comment21" => "",
            "pht_photo[]" => "(binary)",
            "photo_type22" => "9",
            "photo_comment22" => "",
            "pht_photo[]" => "(binary)",
            "photo_type23" => "9",
            "photo_comment23" => "",
            "pht_photo[]" => "(binary)",
            "photo_type24" => "9",
            "photo_comment24" => "",
            "pht_photo[]" => "(binary)",
            "photo_type25" => "9",
            "photo_comment25" => "",
            "pht_photo[]" => "(binary)",
            "photo_type26" => "9",
            "photo_comment26" => "",
            "pht_photo[]" => "(binary)",
            "photo_type27" => "9",
            "photo_comment27" => "",
            "pht_photo[]" => "(binary)",
            "photo_type28" => "9",
            "photo_comment28" => "",
            "pht_photo[]" => "(binary)",
            "photo_type29" => "9",
            "photo_comment29" => "",
            "pht_photo[]" => "(binary)",
            "photo_type30" => "9",
            "photo_comment30" => "",
            "MAX_FILE_SIZE" => "5242880",
            "panorama_uid" => "",
        ];

        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // cURLセッション実行結果の解析
        $pattern = '/<input type="hidden" name="(.*?)" value="(.*?)">/';
        preg_match_all($pattern, $res, $match8);

        // 土地 登録完了
        $POST_DATA = [];
        for($i = 0; $i < count($match8[0]); $i++) {
            $POST_DATA[$match8[1][$i]] = $match8[2][$i];
        }

        $url = 'https://manager.homes.co.jp/index.php';
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res= curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        if( $res === FALSE ) {
            // エラー文字列を出力する
            echo curl_error($curl);
        }

//        $pattern = '/<span class="tar b">物件CD：(.*?)<\/span>/s';
//        preg_match($pattern, $res, $match1);
//        $save_data = ['suumo_no' => $match1[1]];
//        Article::where('building_id', $article->building_id)->update($save_data);
    }

    function saveHouse($article) {
        // 物件メンテ画面へアクセス 一戸建て 登録確認
        $url = 'https://manager.homes.co.jp/index.php';

        $POST_DATA = [
            "action" => "sale_reg_confirm",
            "pht_photo_delid" => "",
            "ispost" => "1",
            "b2" => "",
            "b2time" => "",
            "tk" => "1",
            "tab" => "base",
            "photo_order" => "",
            "bt" => "1201",
            "b_name" => $article->b_name,
            "b_ruby" => "",
            "empty_contents" => "",
            "flg_bukken_name" => "1",
            "status" => $article->status_h,
            "flg_open" => $article->flg_open,
            "jss_alert" => "false",
            "timelimit_date_y" => "2019",
            "timelimit_date_m" => "11",
            "timelimit_date_d" => "21",
            "tantou_name" => $article->tantou_name,
            "local_id" => "",
            "recommend" => "0",
            "post1" => $article->post1,
            "post2" => $article->post2,
            "addr1" => "0hNR5oDOggnXi-RBdHFC_A",
            "temporary_addr1" => "28",
            "addr2" => "Pt3NvVx1WoPXi-RBdHFC_A",
            "addr3" => "3x_YL8att4DXi-RBdHFC_A",
            "addr4" => "3x_YL8att4AeRx5hMK78cA",
            "og_addr11" => "",
            "og_addr12" => "",
            "og_addr2" => "",
            "og_addr2_name" => "",
            "og_post1" => "",
            "og_post2" => "",
            "addr3_addr4_name" => $article->addr3_addr4_name,
            "flg_addr_hidden" => $article->flg_addr_hidden,
            "display_addr_name" => $article->display_addr_name,
            "nl" => $article->nl,
            "el" => $article->el,
            "fullmatch" => "1",
            "flg_adjust" => "1",
            "rosen_etc1" => "1",
            "rosen1" => "680",
            "eki1" => "7314",
            "bus_stop1" => "",
            "bus_time1" => "",
            "walk_distance1" => "9",
            "walk_distance_type1" => "2",
            "rosen_etc2" => "3",
            "rosen2" => "",
            "eki2" => "",
            "bus_stop2" => "",
            "bus_time2" => "",
            "walk_distance2" => "",
            "walk_distance_type2" => "2",
            "traffic_other" => "",
            "money_room" => $article->price,
            "money_tax" => $article->money_tax,
            "money_kyoueki" => "",
            "money_kyoueki_tax" => "2",
            "money_shikikin" => "",
            "shikiunit" => "month",
            "money_hoshoukin" => "",
            "hoshouunit" => "month",
            "commision" => "",
            "commisionunit" => "percent_money",
            "money_sonota1" => "",
            "money_sonota_str1" => "",
            "money_sonota2" => "",
            "money_sonota_str2" => "",
            "money_sonota3" => "",
            "money_sonota_str3" => "",
            "house_kaisuu" => "",
            "house_kaisuu_chika" => "",
            "empty_number" => "",
            "all_number" => "",
            "kenchiku_year" => "2019",
            "kenchiku_month" => "8",
            "flg_new" => "1",
            "house_kouzou" => "",
            "house_kouzou_other" => "",
            "house_area" => "567",
            "house_area_kind" => "",
            "kenchiku_num" => "",
            "sekou_company_name" => "",
            "madori_number_all" => "7",
            "reform_wet_area_other" => "",
            "reform_wet_area_year" => "",
            "reform_wet_area_month" => "",
            "reform_interior_other" => "",
            "reform_interior_year" => "",
            "reform_interior_month" => "",
            "reform_exterior_other" => "",
            "reform_exterior_year" => "",
            "reform_exterior_month" => "",
            "reform_note" => "",
            "madori_number_all" => "2",
            "madori_kind_all" => "10",
            "flg_chijyo" => "1",
            "room_kaisuu" => "",
            "window_angle" => "",
            "balcony_area" => "",
            "mdr_kind1" => "",
            "mdr_tatami1" => "",
            "mdr_floor1" => "",
            "mdr_numberof1" => "",
            "mdr_kind2" => "",
            "mdr_tatami2" => "",
            "mdr_floor2" => "",
            "mdr_numberof2" => "",
            "mdr_kind3" => "",
            "mdr_tatami3" => "",
            "mdr_floor3" => "",
            "mdr_numberof3" => "",
            "mdr_kind4" => "",
            "mdr_tatami4" => "",
            "mdr_floor4" => "",
            "mdr_numberof4" => "",
            "mdr_kind5" => "",
            "mdr_tatami5" => "",
            "mdr_floor5" => "",
            "mdr_numberof5" => "",
            "mdr_kind6" => "",
            "mdr_tatami6" => "",
            "mdr_floor6" => "",
            "mdr_numberof6" => "",
            "mdr_kind7" => "",
            "mdr_tatami7" => "",
            "mdr_floor7" => "",
            "mdr_numberof7" => "",
            "mdr_kind8" => "",
            "mdr_tatami8" => "",
            "mdr_floor8" => "",
            "mdr_numberof8" => "",
            "mdr_kind9" => "",
            "mdr_tatami9" => "",
            "mdr_floor9" => "",
            "mdr_numberof9" => "",
            "mdr_kind10" => "",
            "mdr_tatami10" => "",
            "mdr_floor10" => "",
            "mdr_numberof10" => "",
            "madori_etc" => "",
            "usable_status" => "1",
            "usable_etc" => "",
            "usable_date_y" => "",
            "usable_date_m" => "",
            "usable_shun" => "",
            "genkyo_code" => "",
            "ft112" => "",
            "ft200" => "",
            "ft201" => "",
            "ft202" => "",
            "ft289" => "",
            "ft290" => "",
            "ft218" => "",
            "ft213" => "",
            "ft203" => "",
            "ft204" => "",
            "ft207" => "",
            "ft208" => "",
            "ft234" => "",
            "parking_kubun" => "",
            "parking_keiyaku" => "0",
            "parking_money" => "",
            "parking_money_tax" => "2",
            "parking_number" => "",
            "parking_distance" => "",
            "parking_memo" => "",
            "school_ele_name" => "",
            "school_ele_distance" => "",
            "school_jun_name" => "",
            "school_jun_distance" => "",
            "convenience_distance" => "",
            "super_distance" => "",
            "shopping_street_distance" => "",
            "drugstore_distance" => "",
            "hospital_distance" => "",
            "park_distance" => "",
            "bank_distance" => "",
            "est_other_name" => "",
            "est_other_distance" => "",
            "tokuchou" => "",
            "etc" => "",
            "url_kind" => "0",
            "url" => "",
            "memo" => "",
            "or_open_y" => "",
            "or_open_m" => "",
            "or_open_d" => "",
            "or_end_y" => "",
            "or_end_m" => "",
            "or_end_d" => "",
            "or_time" => "",
            "or_notes" => "",
            "taiyou" => "1",
            "kyakuzuke_simple" => "1",
            "kyakuzuke" => "2",
            "bunpai_a" => "",
            "kyakuzuke_msg" => "",
            "flg_own" => "1",
            "baikai_keiyaku_date_y" => "",
            "baikai_keiyaku_date_m" => "",
            "baikai_keiyaku_date_d" => "",
            "owner_name" => "",
            "owner_tel1" => "",
            "owner_tel2" => "",
            "owner_tel3" => "",
            "owner_fax1" => "",
            "owner_fax2" => "",
            "owner_fax3" => "",
            "owner_etc" => "",
            "owner_post1" => "",
            "owner_post2" => "",
            "owner_addr1" => "",
            "owner_addr2" => "",
            "owner_addr3" => "",
            "owner_addr4" => "",
            "og_owner_addr11" => "",
            "og_owner_addr12" => "",
            "og_owner_addr2" => "",
            "og_owner_addr2_name" => "",
            "og_owner_post1" => "",
            "og_owner_post2" => "",
            "owner_addr3_name" => "",
            "moto_name" => "",
            "moto_tel1" => "",
            "moto_tel2" => "",
            "moto_tel3" => "",
            "moto_fax1" => "",
            "moto_fax2" => "",
            "moto_fax3" => "",
            "moto_tantou_name" => "",
            "confirm_date_y" => "",
            "confirm_date_m" => "",
            "confirm_date_d" => "",
            "moto_etc" => "",
            "moto_post1" => "",
            "moto_post2" => "",
            "moto_addr1" => "",
            "moto_addr2" => "",
            "moto_addr3" => "",
            "moto_addr4" => "",
            "og_moto_addr11" => "",
            "og_moto_addr12" => "",
            "og_moto_addr2" => "",
            "og_moto_addr2_name" => "",
            "og_moto_post1" => "",
            "og_moto_post2" => "",
            "moto_addr3_name" => "",
            "photo_dl_permission" => "1",
            "land_area" => "887",
            "land_area_kind" => "",
            "land_mochibun_b" => "3",
            "land_mochibun_a" => "4",
            "land_chimoku" => "",
            "land_chisei" => "",
            "land_toshi" => "",
            "land_youto" => "",
            "land_kenpei" => "",
            "land_youseki" => "",
            "land_youseki_etc" => "",
            "land_right" => $article->land_right_h,
            "keiyaku_year" => "2031",
            "keiyaku_month" => "5",
            "keiyaku_period_kind" => "1",
            "money_shakuchi" => "235",
            "land_kokudohou" => "1",
            "land_seigen" => "",
            "land_shidou_flg" => "",
            "land_shidou" => "",
            "land_shidou_b" => "",
            "land_shidou_a" => "",
            "land_setback_flg" => "",
            "land_setback" => "",
            "land_road_cond" => "",
            "std_angle1" => "",
            "std_width1" => "",
            "std_kind1" => "",
            "std_maguchi1" => "",
            "std_angle2" => "",
            "std_width2" => "",
            "std_kind2" => "",
            "std_maguchi2" => "",
            "std_angle3" => "",
            "std_width3" => "",
            "std_kind3" => "",
            "std_maguchi3" => "",
            "std_angle4" => "",
            "std_width4" => "",
            "std_kind4" => "",
            "std_maguchi4" => "",
            "pht_photo[]" => "(binary)",
            "pht_photo[]" => "(binary)",
            "photo_type1" => "2",
            "photo_comment1" => "",
            "pht_photo[]" => "(binary)",
            "photo_type2" => "1",
            "photo_comment2" => "",
            "pht_photo[]" => "(binary)",
            "photo_type3" => "11",
            "photo_comment3" => "",
            "pht_photo[]" => "(binary)",
            "photo_type4" => "5",
            "photo_comment4" => "",
            "pht_photo[]" => "(binary)",
            "photo_type5" => "12",
            "photo_comment5" => "",
            "pht_photo[]" => "(binary)",
            "photo_type6" => "15",
            "photo_comment6" => "",
            "pht_photo[]" => "(binary)",
            "photo_type7" => "16",
            "photo_comment7" => "",
            "pht_photo[]" => "(binary)",
            "photo_type8" => "17",
            "photo_comment8" => "",
            "pht_photo[]" => "(binary)",
            "photo_type9" => "13",
            "photo_comment9" => "",
            "pht_photo[]" => "(binary)",
            "photo_type10" => "14",
            "photo_comment10" => "",
            "pht_photo[]" => "(binary)",
            "photo_type11" => "9",
            "photo_comment11" => "",
            "pht_photo[]" => "(binary)",
            "photo_type12" => "9",
            "photo_comment12" => "",
            "pht_photo[]" => "(binary)",
            "photo_type13" => "9",
            "photo_comment13" => "",
            "pht_photo[]" => "(binary)",
            "photo_type14" => "9",
            "photo_comment14" => "",
            "pht_photo[]" => "(binary)",
            "photo_type15" => "9",
            "photo_comment15" => "",
            "pht_photo[]" => "(binary)",
            "photo_type16" => "9",
            "photo_comment16" => "",
            "pht_photo[]" => "(binary)",
            "photo_type17" => "9",
            "photo_comment17" => "",
            "pht_photo[]" => "(binary)",
            "photo_type18" => "9",
            "photo_comment18" => "",
            "pht_photo[]" => "(binary)",
            "photo_type19" => "9",
            "photo_comment19" => "",
            "pht_photo[]" => "(binary)",
            "photo_type20" => "9",
            "photo_comment20" => "",
            "pht_photo[]" => "(binary)",
            "photo_type21" => "9",
            "photo_comment21" => "",
            "pht_photo[]" => "(binary)",
            "photo_type22" => "9",
            "photo_comment22" => "",
            "pht_photo[]" => "(binary)",
            "photo_type23" => "9",
            "photo_comment23" => "",
            "pht_photo[]" => "(binary)",
            "photo_type24" => "9",
            "photo_comment24" => "",
            "pht_photo[]" => "(binary)",
            "photo_type25" => "9",
            "photo_comment25" => "",
            "pht_photo[]" => "(binary)",
            "photo_type26" => "9",
            "photo_comment26" => "",
            "pht_photo[]" => "(binary)",
            "photo_type27" => "9",
            "photo_comment27" => "",
            "pht_photo[]" => "(binary)",
            "photo_type28" => "9",
            "photo_comment28" => "",
            "pht_photo[]" => "(binary)",
            "photo_type29" => "9",
            "photo_comment29" => "",
            "pht_photo[]" => "(binary)",
            "photo_type30" => "9",
            "photo_comment30" => "",
            "MAX_FILE_SIZE" => "5242880",
            "panorama_uid" => "",
        ];

        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // cURLセッション実行結果の解析
        $pattern = '/<input type="hidden" name="(.*?)" value="(.*?)">/';
        preg_match_all($pattern, $res, $match9);

        // 一戸建て 登録完了
        $POST_DATA = [];
        for($i = 0; $i < count($match9[0]); $i++) {
            $POST_DATA[$match9[1][$i]] = $match9[2][$i];
        }

        $url = 'https://manager.homes.co.jp/index.php';
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res= curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        if( $res === FALSE ) {
            // エラー文字列を出力する
            echo curl_error($curl);
        }

//        $pattern = '/<span class="tar b">物件CD：(.*?)<\/span>/s';
//        preg_match($pattern, $res, $match1);
//        $save_data = ['suumo_no' => $match1[1]];
//        Article::where('building_id', $article->building_id)->update($save_data);
    }

    function saveMansion($article) {
        // 物件メンテ画面へアクセス マンション 登録確認
        $POST_DATA = [
            "action" => "sale_reg_confirm",
            "pht_photo_delid" => "",
            "ispost" => "1",
            "b2" => "",
            "b2time" => "",
            "tk" => "1",
            "tab" => "base",
            "photo_order" => "",
            "bt" => "1301",
            "b_name" => $article->b_name,
            "b_ruby" => "",
            "empty_contents" => $article->empty_contents,
            "flg_bukken_name" => $article->flg_bukken_name,
            "status" => $article->status_h,
            "flg_open" => $article->flg_open,
            "jss_alert" => "false",
            "timelimit_date_y" => "2019",
            "timelimit_date_m" => "12",
            "timelimit_date_d" => "30",
            "tantou_name" => $article->tantou_name,
            "local_id" => "",
            "recommend" => "0",
            "post1" => $article->post1,
            "post2" => $article->post2,
            "addr1" => "0hNR5oDOggnXi-RBdHFC_A",
            "temporary_addr1" => "28",
            "addr2" => "Pt3NvVx1WoPXi-RBdHFC_A",
            "addr3" => "ei8jaiklneLXi-RBdHFC_A",
            "addr4" => "ei8jaiklneLUhIkWR5rXGQ",
            "og_addr11" => "",
            "og_addr12" => "",
            "og_addr2" => "",
            "og_addr2_name" => "",
            "og_post1" => "",
            "og_post2" => "",
            "addr3_addr4_name" => $article->addr3_addr4_name,
            "flg_addr_hidden" => $article->flg_addr_hidden,
            "display_addr_name" => $article->display_addr_name,
            "nl" => $article->nl,
            "el" => $article->el,
            "fullmatch" => "1",
            "flg_adjust" => "1",
            "rosen_etc1" => "1",
            "rosen1" => "680",
            "eki1" => "7311",
            "bus_stop1" => "",
            "bus_time1" => "",
            "walk_distance1" => "1",
            "walk_distance_type1" => "2",
            "rosen_etc2" => "3",
            "rosen2" => "",
            "eki2" => "",
            "bus_stop2" => "",
            "bus_time2" => "",
            "walk_distance2" => "",
            "walk_distance_type2" => "2",
            "traffic_other" => "",
            "money_room" => $article->price,
            "money_tax" => $article->money_tax,
            "money_kyoueki_ck" => "1",
            "money_kyoueki" => "99",
            "money_kyoueki_tax" => "2",
            "money_shuuzen_ck" => "1",
            "money_shuuzen" => "99",
            "money_shuuzenkikin" => "",
            "money_shikikin" => "",
            "shikiunit" => "month",
            "money_hoshoukin" => "",
            "hoshouunit" => "month",
            "commision" => "",
            "commisionunit" => "percent_money",
            "money_sonota1" => "",
            "money_sonota_str1" => "",
            "money_sonota2" => "",
            "money_sonota_str2" => "",
            "money_sonota3" => "",
            "money_sonota_str3" => "",
            "house_kaisuu" => "6",
            "house_kaisuu_chika" => "",
            "empty_number" => "",
            "all_number" => "",
            "kenchiku_year" => "2019",
            "kenchiku_month" => "9",
            "flg_new" => "1",
            "house_kouzou" => "2",
            "house_kouzou_other" => "",
            "house_area" => "234",
            "house_area_kind" => "",
            "house_kenchiku_area" => "",
            "land_area_all" => "",
            "kenchiku_num" => "",
            "sekou_company_name" => "",
            "reform_wet_area_other" => "",
            "reform_wet_area_year" => "",
            "reform_wet_area_month" => "",
            "reform_interior_other" => "",
            "reform_interior_year" => "",
            "reform_interior_month" => "",
            "reform_common_area" => "",
            "reform_common_area_year" => "",
            "reform_common_area_month" => "",
            "reform_note" => "",
            "house_kanrinin" => "1",
            "house_kanri_kaisha" => "",
            "house_kanri_keitai" => "1",
            "house_kanri_kumiai" => "",
            "madori_number_all" => "3",
            "madori_kind_all" => "10",
            "flg_chijyo" => "1",
            "room_kaisuu" => "3",
            "window_angle" => "",
            "balcony_umu" => $article->balcony_umu,
            "balcony_area" => $article->balcony_area,
            "mdr_kind1" => "",
            "mdr_tatami1" => "",
            "mdr_floor1" => "",
            "mdr_numberof1" => "",
            "mdr_kind2" => "",
            "mdr_tatami2" => "",
            "mdr_floor2" => "",
            "mdr_numberof2" => "",
            "mdr_kind3" => "",
            "mdr_tatami3" => "",
            "mdr_floor3" => "",
            "mdr_numberof3" => "",
            "mdr_kind4" => "",
            "mdr_tatami4" => "",
            "mdr_floor4" => "",
            "mdr_numberof4" => "",
            "mdr_kind5" => "",
            "mdr_tatami5" => "",
            "mdr_floor5" => "",
            "mdr_numberof5" => "",
            "mdr_kind6" => "",
            "mdr_tatami6" => "",
            "mdr_floor6" => "",
            "mdr_numberof6" => "",
            "mdr_kind7" => "",
            "mdr_tatami7" => "",
            "mdr_floor7" => "",
            "mdr_numberof7" => "",
            "mdr_kind8" => "",
            "mdr_tatami8" => "",
            "mdr_floor8" => "",
            "mdr_numberof8" => "",
            "mdr_kind9" => "",
            "mdr_tatami9" => "",
            "mdr_floor9" => "",
            "mdr_numberof9" => "",
            "mdr_kind10" => "",
            "mdr_tatami10" => "",
            "mdr_floor10" => "",
            "mdr_numberof10" => "",
            "madori_etc" => "",
            "usable_status" => "1",
            "usable_etc" => "",
            "usable_date_y" => "",
            "usable_date_m" => "",
            "usable_shun" => "",
            "genkyo_code" => "",
            "ft101" => "",
            "ft112" => "",
            "ft109" => "",
            "ft200" => "",
            "ft201" => "",
            "ft202" => "",
            "ft289" => "",
            "ft290" => "",
            "ft218" => "",
            "ft213" => "",
            "ft203" => "",
            "ft204" => "",
            "ft207" => "",
            "ft208" => "",
            "ft234" => "",
            "parking_kubun" => "",
            "parking_keiyaku" => "0",
            "parking_money" => "",
            "parking_money_tax" => "2",
            "parking_number" => "",
            "parking_distance" => "",
            "parking_memo" => "",
            "school_ele_name" => "",
            "school_ele_distance" => "",
            "school_jun_name" => "",
            "school_jun_distance" => "",
            "convenience_distance" => "",
            "super_distance" => "",
            "shopping_street_distance" => "",
            "drugstore_distance" => "",
            "hospital_distance" => "",
            "park_distance" => "",
            "bank_distance" => "",
            "est_other_name" => "",
            "est_other_distance" => "",
            "tokuchou" => "",
            "etc" => "",
            "url_kind" => "0",
            "url" => "",
            "memo" => "",
            "or_open_y" => "",
            "or_open_m" => "",
            "or_open_d" => "",
            "or_end_y" => "",
            "or_end_m" => "",
            "or_end_d" => "",
            "or_time" => "",
            "or_notes" => "",
            "seller_interview_q1" => "",
            "seller_interview_q2" => "",
            "taiyou" => "1",
            "kyakuzuke_simple" => "1",
            "kyakuzuke" => "2",
            "bunpai_a" => "",
            "kyakuzuke_msg" => "",
            "flg_own" => "1",
            "baikai_keiyaku_date_y" => "",
            "baikai_keiyaku_date_m" => "",
            "baikai_keiyaku_date_d" => "",
            "owner_name" => "",
            "owner_tel1" => "",
            "owner_tel2" => "",
            "owner_tel3" => "",
            "owner_fax1" => "",
            "owner_fax2" => "",
            "owner_fax3" => "",
            "owner_etc" => "",
            "owner_post1" => "",
            "owner_post2" => "",
            "owner_addr1" => "",
            "owner_addr2" => "",
            "owner_addr3" => "",
            "owner_addr4" => "",
            "og_owner_addr11" => "",
            "og_owner_addr12" => "",
            "og_owner_addr2" => "",
            "og_owner_addr2_name" => "",
            "og_owner_post1" => "",
            "og_owner_post2" => "",
            "owner_addr3_name" => "",
            "moto_name" => "",
            "moto_tel1" => "",
            "moto_tel2" => "",
            "moto_tel3" => "",
            "moto_fax1" => "",
            "moto_fax2" => "",
            "moto_fax3" => "",
            "moto_tantou_name" => "",
            "confirm_date_y" => "",
            "confirm_date_m" => "",
            "confirm_date_d" => "",
            "moto_etc" => "",
            "moto_post1" => "",
            "moto_post2" => "",
            "moto_addr1" => "",
            "moto_addr2" => "",
            "moto_addr3" => "",
            "moto_addr4" => "",
            "og_moto_addr11" => "",
            "og_moto_addr12" => "",
            "og_moto_addr2" => "",
            "og_moto_addr2_name" => "",
            "og_moto_post1" => "",
            "og_moto_post2" => "",
            "moto_addr3_name" => "",
            "photo_dl_permission" => "1",
            "land_chisei" => "",
            "land_youto" => "",
            "land_right" => $article->land_right_h,
            "keiyaku_year" => "",
            "keiyaku_month" => "",
            "keiyaku_period_kind" => "1",
            "money_shakuchi" => "",
            "land_kokudohou" => "1",
            "land_seigen" => "",
            "pht_photo[]" => "(binary)",
            "pht_photo[]" => "(binary)",
            "photo_type1" => "2",
            "photo_comment1" => "",
            "pht_photo[]" => "(binary)",
            "photo_type2" => "1",
            "photo_comment2" => "",
            "pht_photo[]" => "(binary)",
            "photo_type3" => "11",
            "photo_comment3" => "",
            "pht_photo[]" => "(binary)",
            "photo_type4" => "5",
            "photo_comment4" => "",
            "pht_photo[]" => "(binary)",
            "photo_type5" => "12",
            "photo_comment5" => "",
            "pht_photo[]" => "(binary)",
            "photo_type6" => "15",
            "photo_comment6" => "",
            "pht_photo[]" => "(binary)",
            "photo_type7" => "16",
            "photo_comment7" => "",
            "pht_photo[]" => "(binary)",
            "photo_type8" => "17",
            "photo_comment8" => "",
            "pht_photo[]" => "(binary)",
            "photo_type9" => "13",
            "photo_comment9" => "",
            "pht_photo[]" => "(binary)",
            "photo_type10" => "14",
            "photo_comment10" => "",
            "pht_photo[]" => "(binary)",
            "photo_type11" => "9",
            "photo_comment11" => "",
            "pht_photo[]" => "(binary)",
            "photo_type12" => "9",
            "photo_comment12" => "",
            "pht_photo[]" => "(binary)",
            "photo_type13" => "9",
            "photo_comment13" => "",
            "pht_photo[]" => "(binary)",
            "photo_type14" => "9",
            "photo_comment14" => "",
            "pht_photo[]" => "(binary)",
            "photo_type15" => "9",
            "photo_comment15" => "",
            "pht_photo[]" => "(binary)",
            "photo_type16" => "9",
            "photo_comment16" => "",
            "pht_photo[]" => "(binary)",
            "photo_type17" => "9",
            "photo_comment17" => "",
            "pht_photo[]" => "(binary)",
            "photo_type18" => "9",
            "photo_comment18" => "",
            "pht_photo[]" => "(binary)",
            "photo_type19" => "9",
            "photo_comment19" => "",
            "pht_photo[]" => "(binary)",
            "photo_type20" => "9",
            "photo_comment20" => "",
            "pht_photo[]" => "(binary)",
            "photo_type21" => "9",
            "photo_comment21" => "",
            "pht_photo[]" => "(binary)",
            "photo_type22" => "9",
            "photo_comment22" => "",
            "pht_photo[]" => "(binary)",
            "photo_type23" => "9",
            "photo_comment23" => "",
            "pht_photo[]" => "(binary)",
            "photo_type24" => "9",
            "photo_comment24" => "",
            "pht_photo[]" => "(binary)",
            "photo_type25" => "9",
            "photo_comment25" => "",
            "pht_photo[]" => "(binary)",
            "photo_type26" => "9",
            "photo_comment26" => "",
            "pht_photo[]" => "(binary)",
            "photo_type27" => "9",
            "photo_comment27" => "",
            "pht_photo[]" => "(binary)",
            "photo_type28" => "9",
            "photo_comment28" => "",
            "pht_photo[]" => "(binary)",
            "photo_type29" => "9",
            "photo_comment29" => "",
            "pht_photo[]" => "(binary)",
            "photo_type30" => "9",
            "photo_comment30" => "",
            "MAX_FILE_SIZE" => "5242880",
            "panorama_uid" => "",
        ];

        $url = 'https://manager.homes.co.jp/index.php';
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        //curl_setopt($curl, CURLOPT_REFERER,        "REFERER");
        //curl_setopt($curl, CURLOPT_USERAGENT,      "USER_AGENT"); 
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        $pattern = '/<input type="hidden" name="(.*?)" value="(.*?)">/';
        preg_match_all($pattern, $res, $match11);

        // マンション 登録完了
        $POST_DATA = [];
        for($i = 0; $i < count($match11[0]); $i++) {
            $POST_DATA[$match11[1][$i]] = $match11[2][$i];
        }

        $url = 'https://manager.homes.co.jp/index.php';
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE); // Locationヘッダを追跡
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        if( $res === FALSE ) {
            // エラー文字列を出力する
            echo curl_error($curl);
        }

//        $pattern = '/<span class="tar b">物件CD：(.*?)<\/span>/s';
//        preg_match($pattern, $res, $match1);
//        $save_data = ['suumo_no' => $match1[1]];
//        Article::where('building_id', $article->building_id)->update($save_data);
    }
}
