<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Article;
use App\Models\RelationArticlePhoto;
use App\Models\UserInfo;
use App\Models\RelationLawrestriction;
use App\Models\MstPrefecture;
use App\Models\MstCity;
use App\Models\MstTown;

class SetArticleToSuumo extends Command
{
    private $option;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'batch:test {id?} {cid?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        // 登録対象の物件を取得
        $building_id = $this->argument('id');
        $company_id = $this->argument('cid');

        // Suumoにアクセス
        $cookie_path = './suumo_cookie.txt';
        touch($cookie_path);    
        $id = "t06889200001";
        $pass = "zuka-32412019";

        // cURLセッションの共通オプション
        $this->option = [
            // CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:24.0) Gecko/20100101 Firefox/24.0',
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_SSL_VERIFYHOST => FALSE,
            CURLOPT_COOKIEJAR => $cookie_path,
            CURLOPT_COOKIEFILE => $cookie_path,
            // CURLOPT_FOLLOWLOCATION => TRUE,
            CURLOPT_HEADER=> TRUE,
        ];

        // ログイン画面へアクセス
        $url = "https://manager.suumo.jp/chukai/login/?path=7d8e4a47d1397db34dccf7ceb4ad7f8d";
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // cURLセッション実行結果の解析
        $pattern = '/<input type="hidden" name="path" value="(.*?)">/';
        preg_match($pattern, $res, $match);

        // ログイン処理
        $url = "https://manager.suumo.jp/chukai/login/login";
        $POST_DATA = array(
            'j_username' => $id,
            'j_password' => $pass,
            'path' => $match[1],
            'old_id' => '',
            'id' => $id,
            'pass' => $pass,
        );
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // 登録対象の物件を取得
        $article = Article::getDataById($company_id, $building_id);
        if($article->property == 1 || $article->property == 2 || $article->property == 3) {
            // 土地
            $article = $this->moldingDataLand($article);
            $this->saveLand($article);
        } elseif($article->property == 4 || $article->property == 5) {
            // 戸建
            $article = $this->moldingDataHouse($article);
            $this->saveHouse($article);
        } elseif($article->property == null) {
            // マンション
            $mansion = Article::getParentMansion(1, $article->mansion_id);
            $article = $this->moldingDataMansion($article, $mansion);
            $this->saveMansion($article);
        }
    }

    function moldingDataLand($article) {
        // 1.基本情報
        // 物件名
        $article->bukkenNm1 = mb_substr($article->article_name, 0, 42);
        // 郵便番号
        $zip_info = $article->zip;
        $zip_list = explode('-', $zip_info);
        $article->yubinbango01 = $zip_list[0]??'';
        $article->yubinbango02 = $zip_list[1]??'';

        // 住所
        $article->todofukenCd = $article->address1;
        $article->shikugunCd = $article->address2;
        $article->ooazaCd = $article->address3;

        $pref_info = MstPrefecture::getName($article->address1);
        $city_info = MstCity::getName($article->address1, $article->address2);
        $town_info = MstTown::getName($article->address1, $article->address2, $article->address3);
        $article->todofukenNm = $pref_info->name??'';
        $article->shikugunNm = $city_info->name??'';
        $article->ooazaNm = $town_info->name??'';

        // 交通

        // 2.担当者情報
        // 担当者名
        $user_info = UserInfo::getDataById($article->hp_charge);
        $name_info = '';
        $name_info = $user_info->last_name??'';
        if($name_info != '') {
            $name_info .= ' ';
        }
        $name_info .= $user_info->first_name??'';
        $article->kishaEigyoMei = $name_info;
        // スタッフコメント
        $article->staffComment = mb_substr($article->comment, 0, 100);
        // 社内メモ1
        $article->kishaComment1 = mb_substr($article->memo1, 0, 20);
        // 社内メモ2
        $article->kishaComment2 = mb_substr($article->memo2, 0, 20);

        // 3.価格
        // 町会費
        if($article->council != 0) {
            $article->chokaihiKbn = $article->council;
            if($article->council_presence == 0) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            } elseif($article->council_presence == 1) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = $article->council_cost;
                if($article->council_cost_unit != 0) {
                    $article->chokaihiRyoTaniKbn = $article->council_cost_unit;
                } else {
                    $article->chokaihiRyoTaniKbn = '';
                }
            } elseif($article->council_presence == 2) {
                $article->chokaihiUmu = '3';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            }
        } elseif($article->council == 0) {
            $article->chokaihiKbn = '0';
            $article->chokaihiUmu = '';
            $article->chokaihiRyo = '';
            $article->chokaihiRyoTaniKbn = '';
        }

        // 温泉
        if($article->spring != 0) {
            $article->onsenKenKbn = $article->council;
            if($article->spring_presence == 0) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            } elseif($article->spring_presence == 1) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = $article->spring_cost;
                if($article->spring_cost_unit != 0) {
                    $article->onsenKenRyoTaniKbn = $article->spring_cost_unit;
                } else {
                    $article->onsenKenRyoTaniKbn = '';
                }
            } elseif($article->spring_presence == 2) {
                $article->onsenKenRyoUmu = '3';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            }
        } elseif($article->spring == 0) {
            $article->onsenKenKbn = '0';
            $article->onsenKenRyoUmu = '';
            $article->onsenKenRyo = '';
            $article->onsenKenRyoTaniKbn = '';
        }
        
        // 4.土地建物情報
        // 土地権利
        if($article->land_right != 0) {
            $article->shikichiKenri = $article->land_right;
        } else {
            $article->shikichiKenri = '1';
        }
        // 土地面積
        $article->tochiMensekiKbn = $article->land_area;
        $land_area = $article->land_area_val??'0.0';
        $land_area_list = explode('.', $land_area);
        $article->tochiMensekiMinS = $land_area_list[0]??'';
        $article->tochiMensekiMinL = $land_area_list[1]??'';

        if($article->land_condition1 == 1) {
            $land_condition_area1_list = explode('.', $article->land_condition_area1);
            $article->keishaMensekiMinS = $land_condition_area1_list[0]??'';
            $article->keishaMensekiMinL = $land_condition_area1_list[1]??'';
            $article->keishaMensekiMinTaniKbn = $article->land_condition_unit1;
        } else {
            $article->keishaMensekiMinS = '';
            $article->keishaMensekiMinL = '';
            $article->keishaMensekiMinTaniKbn = 0;
        }

        if($article->land_condition2 == 1) {
            $land_condition_area2_list = explode('.', $article->land_condition_area2);
            $article->shikichiEnchoMinS = $land_condition_area2_list[0]??'';
            $article->shikichiEnchoMinL = $land_condition_area2_list[1]??'';
            $article->shikichiEnchoMinTaniKbn = $article->land_condition_unit2;
        } else {
            $article->shikichiEnchoMinS = '';
            $article->shikichiEnchoMinL = '';
            $article->shikichiEnchoMinTaniKbn = 0;           
        }

        if($article->land_condition3 == 1) {
            $land_condition_area3_list = explode('.', $article->land_condition_area3);
            $article->koatsuMensekiMinS = $land_condition_area3_list[0]??'';
            $article->koatsuMensekiMinL = $land_condition_area3_list[1]??'';
        } else {
            $article->koatsuMensekiMinS = '';
            $article->koatsuMensekiMinL = '';          
        }

        // 土地状況
        if($article->current_status == 1 || $article->current_status == 2) {
            $article->tochiJokyoKbn = $article->current_status;
            $article->zoseiKanryoYoteiNen = '';
            $article->zoseiKanryoYoteiTsuki = '';
        } elseif($article->current_status == 3) {
            $article->tochiJokyoKbn = 4;
            $article->zoseiKanryoYoteiNen = $article->comp_year;
            $article->zoseiKanryoYoteiTsuki = $article->comp_month;
        } else {
            $article->tochiJokyoKbn = '';
            $article->zoseiKanryoYoteiNen = '';
            $article->zoseiKanryoYoteiTsuki = '';
        }

        // 引き渡し
        if($article->land_delivery == 1) {
            $article->nyukyoJikiKbn = '1';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiJunKbn = '0';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->land_delivery == 2) {
            $article->nyukyoJikiKbn = '4';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiJunKbn = '0';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->land_delivery == 3) {
            $article->nyukyoJikiKbn = '2';
            $article->nyukyoJikiNen = $article->delivery_year;
            $article->nyukyoJikiTsuki = $article->delivery_month;
            $article->nyukyoJikiJunKbn = $article->land_delivery_time;
            $article->nyukyoJikiTsukiSu = '';
        } else {
            $article->nyukyoJikiKbn = '';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiJunKbn = '0';
            $article->nyukyoJikiTsukiSu = '';
        }

        // 建築条件
        if($article->land_condition == 0) {
            $article->kenchikuJokenUmuKbn = 0;
            $article->tatemonoKakaku = '';
            $article->tatemonoMensekiS = '';
            $article->tatemonoMensekiL = '';
        } elseif($article->land_condition == 1) {
            $article->kenchikuJokenUmuKbn = 1;
            $article->tatemonoKakaku = $article->building_plan_place??'';
            $building_plan_place = $article->building_plan_area;
            $building_plan_place_list = explode('.', $building_plan_place);
            $article->tatemonoMensekiS = $building_plan_place_list[0]??'';
            $article->tatemonoMensekiL = $building_plan_place_list[1]??'';
        } elseif($article->land_condition == 2) {
            $article->kenchikuJokenUmuKbn = '';
            $article->tatemonoKakaku = '';
            $article->tatemonoMensekiS = '';
            $article->tatemonoMensekiL = '';
        }

        // 地目
        if($article->ground != 0 && $article->ground < 7) {
            $article->chimokuKbn = $article->ground;
            $article->chimokuSntComment = '';
        } elseif($article->ground == 7) {
            $article->chimokuKbn = 9;
            $article->chimokuSntComment = $article->ground_text;
        } else {
            $article->chimokuKbn = '';
            $article->chimokuSntComment = '';
        }

        // 建ぺい率
        $article->kenpeiritsu = (int)$article->building_rate;
        // 容積率
        $article->yosekiritsu = (int)$article->volume_rate;

        // 私道負担
        if($article->road_burden == 0) {
            $article->shidoFutanKbn = 1;
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        } elseif($article->road_burden == 1) {
            $article->shidoFutanKbn = 2;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $article->shidoFutanMensekiMinS1 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL1 = $road_burden_area_list[1]??'';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';

        } elseif($article->road_burden == 2) {
            $article->shidoFutanKbn = 3;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $road_numerator = $article->road_numerator;
            $road_numerator_list = explode('.', $road_numerator);
            $road_denominator = $article->road_denominator;
            $road_denominator_list = explode('.', $road_denominator);
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL2 = $road_burden_area_list[1]??'';
            $article->shidoFutanBunshiMinS = $road_numerator_list[0]??'';
            $article->shidoFutanBunshiMinL = $road_numerator_list[1]??'';
            $article->shidoFutanBunboMinS = $road_denominator_list[0]??'';
            $article->shidoFutanBunboMinL = $road_denominator_list[1]??'';
        } else {
            $article->shidoFutanKbn = '';
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        }

        // 地役権
        if($article->easement == 1 || $article->easement == 0) {
            $article->chiekikenKbn = $article->easement;
            $article->chiekikenMensekiS = '';
            $article->chiekikenMensekiL = '';
        } else {
            $article->chiekikenKbn = $article->easement;
            $easement_area = $article->easement_area;
            $easement_area_list = explode('.', $easement_area);
            $article->chiekikenMensekiS = $easement_area_list[0]??'';
            $article->chiekikenMensekiL = $easement_area_list[1]??'';
        }
        // 道路向き
        if($article->land_direction1 == 0) {
            $article->doroMukiKbn1 = 0;
        } else { 
            if($article->land_direction1 == 1) {
                $article->doroMukiKbn1 = 4;
            } elseif($article->land_direction1 == 2) {
                $article->doroMukiKbn1 = 5;
            } elseif($article->land_direction1 == 3) {
                $article->doroMukiKbn1 = 1;
            } elseif($article->land_direction1 == 4) {
                $article->doroMukiKbn1 = 6;
            } elseif($article->land_direction1 == 5) {
                $article->doroMukiKbn1 = 3;
            } elseif($article->land_direction1 == 6) {
                $article->doroMukiKbn1 = 8;
            } elseif($article->land_direction1 == 7) {
                $article->doroMukiKbn1 = 2;
            } elseif($article->land_direction1 == 8) {
                $article->doroMukiKbn1 = 7;
            }
            $road_width1 = $article->road_width1;
            $road_width1_list = explode('.', $road_width1);
            $frontage1 = $article->frontage1;
            $frontage1_list = explode('.', $frontage1);
            $article->doroWidth1S = $road_width1_list[0]??'';
            $article->doroWidth1L = $road_width1_list[1]??'';
            $article->setsudoWidth1S = $frontage1_list[0]??'';
            $article->setsudoWidth1L = $frontage1_list[1]??'';
        }

        if($article->land_direction2 == 0) {
            $article->doroMukiKbn2 = 0;
        } else { 
            if($article->land_direction2 == 1) {
                $article->doroMukiKbn2 = 4;
            } elseif($article->land_direction2 == 2) {
                $article->doroMukiKbn2 = 5;
            } elseif($article->land_direction2 == 3) {
                $article->doroMukiKbn2 = 1;
            } elseif($article->land_direction2 == 4) {
                $article->doroMukiKbn2 = 6;
            } elseif($article->land_direction2 == 5) {
                $article->doroMukiKbn2 = 3;
            } elseif($article->land_direction2 == 6) {
                $article->doroMukiKbn2 = 8;
            } elseif($article->land_direction2 == 7) {
                $article->doroMukiKbn2 = 2;
            } elseif($article->land_direction2 == 8) {
                $article->doroMukiKbn2 = 7;
            }
            $road_width2 = $article->road_width2;
            $road_width2_list = explode('.', $road_width2);
            $frontage2 = $article->frontage2;
            $frontage2_list = explode('.', $frontage2);
            $article->doroWidth2S = $road_width2_list[0]??'';
            $article->doroWidth2L = $road_width2_list[1]??'';
            $article->setsudoWidth2S = $frontage2_list[0]??'';
            $article->setsudoWidth2L = $frontage2_list[1]??'';
        }

        if($article->land_direction3 == 0) {
            $article->doroMukiKbn3 = 0;
        } else { 
            if($article->land_direction3 == 1) {
                $article->doroMukiKbn3 = 4;
            } elseif($article->land_direction3 == 2) {
                $article->doroMukiKbn3 = 5;
            } elseif($article->land_direction3 == 3) {
                $article->doroMukiKbn3 = 1;
            } elseif($article->land_direction3 == 4) {
                $article->doroMukiKbn3 = 6;
            } elseif($article->land_direction3 == 5) {
                $article->doroMukiKbn3 = 3;
            } elseif($article->land_direction3 == 6) {
                $article->doroMukiKbn3 = 8;
            } elseif($article->land_direction3 == 7) {
                $article->doroMukiKbn3 = 2;
            } elseif($article->land_direction3 == 8) {
                $article->doroMukiKbn3 = 7;
            }
            $road_width3 = $article->road_width3;
            $road_width3_list = explode('.', $road_width3);
            $frontage3 = $article->frontage3;
            $frontage3_list = explode('.', $frontage3);
            $article->doroWidth3S = $road_width3_list[0]??'';
            $article->doroWidth3L = $road_width3_list[1]??'';
            $article->setsudoWidth3S = $frontage3_list[0]??'';
            $article->setsudoWidth3L = $frontage3_list[1]??'';
        }

        // 上水道
        $article->setsubiJosuidoKbn = $article->water_supply;

        // 下水道
        $article->setsubiGesuidoKbn = $article->sewerage;

        // ガス
        $article->setsubiGasKbn = $article->gas;

        // 駐車場
        if($article->garage == 1) {
            $article->shakoKbn = 2;
        } elseif($article->garage == 0) {
            $article->shakoKbn = 0;
        }

        // セットパック
        if($article->set == 1) {
            $article->setbackKbn = $article->set;
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        } elseif($article->set == 2 || $article->set == 3) {
            $article->setbackKbn = $article->set;
            $set_area = $article->set_area;
            $set_area_list = explode('.', $set_area);
            $article->setbackMensekiMinS = $set_area_list[0]??'';
            $article->setbackMensekiMinL = $set_area_list[1]??'';
        } else {
            $article->setbackKbn = '';
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        }

        // 用途地域
        if($article->use_area == 1) {
            $article->yotochiikiCd01 = '01';
        } elseif($article->use_area == 2) {
            $article->yotochiikiCd01 = '04';
        } elseif($article->use_area == 3) {
            $article->yotochiikiCd01 = '06';
        } elseif($article->use_area == 4) {
            $article->yotochiikiCd01 = '08';
        } elseif($article->use_area == 5) {
            $article->yotochiikiCd01 = '09';
        } elseif($article->use_area == 6) {
            $article->yotochiikiCd01 = '10';
        } elseif($article->use_area == 7) {
            $article->yotochiikiCd01 = '11';
        } elseif($article->use_area == 8) {
            $article->yotochiikiCd01 = '12';
        } elseif($article->use_area == 10) {
            $article->yotochiikiCd01 = '02';
        } elseif($article->use_area == 11) {
            $article->yotochiikiCd01 = '03';
        } elseif($article->use_area == 12) {
            $article->yotochiikiCd01 = '05';
        } elseif($article->use_area == 13) {
            $article->yotochiikiCd01 = '07';
        } elseif($article->use_area == 14) {
            $article->yotochiikiCd01 = '16';
        } else {
            $article->yotochiikiCd01 = '00';
        }
        
        if($article->land_use == 1) {
            $article->yotochiikiCd02 = '01';
        } elseif($article->land_use == 2) {
            $article->yotochiikiCd02 = '04';
        } elseif($article->land_use == 3) {
            $article->yotochiikiCd02 = '06';
        } elseif($article->land_use == 4) {
            $article->yotochiikiCd02 = '08';
        } elseif($article->land_use == 5) {
            $article->yotochiikiCd02 = '09';
        } elseif($article->land_use == 6) {
            $article->yotochiikiCd02 = '10';
        } elseif($article->land_use == 7) {
            $article->yotochiikiCd02 = '11';
        } elseif($article->land_use == 8) {
            $article->yotochiikiCd02 = '12';
        } elseif($article->land_use == 10) {
            $article->yotochiikiCd02 = '02';
        } elseif($article->land_use == 11) {
            $article->yotochiikiCd02 = '03';
        } elseif($article->land_use == 12) {
            $article->yotochiikiCd02 = '05';
        } elseif($article->land_use == 13) {
            $article->yotochiikiCd02 = '07';
        } elseif($article->land_use == 14) {
            $article->yotochiikiCd02 = '16';
        } else {
            $article->yotochiikiCd02 = '00';
        }

        // 総区画数
        $article->soKosu = $article->section??'';

        // 5.会社情報
        if($article->company_manner == 1) {
            $article->torihikitaiyoKbn01 = '01';
        } elseif($article->company_manner == 2) {
            $article->torihikitaiyoKbn01 = '13';
        } elseif($article->company_manner == 3) {
            $article->torihikitaiyoKbn01 = '09';
        } elseif($article->company_manner == 4) {
            $article->torihikitaiyoKbn01 = '10';
        } elseif($article->company_manner == 5) {
            $article->torihikitaiyoKbn01 = '11';
        } elseif($article->company_manner == 6) {
            $article->torihikitaiyoKbn01 = '07';
        } elseif($article->company_manner == 7) {
            $article->torihikitaiyoKbn01 = '08';
        } elseif($article->company_manner == 8) {
            $article->torihikitaiyoKbn01 = '09';
        } else {
            $article->torihikitaiyoKbn01 = '';
        }

        // 6.制限事項
        $law_check = RelationLawrestriction::getDataByArticleId($article->building_id);
        foreach($law_check as $law) {
            if($law == 1) {
                $article->hriSgnHoBunkazai = 1;
                
            } elseif($law == 2) {
                $article->hriSgnHoKotohogo = 1;
                
            } elseif($law == 3) {
                $article->hriSgnHoKeikan = 1;
                
            } elseif($law == 4) {
                $article->hriSgnHoMisshuSgcSeibi = 1;
                
            } elseif($law == 5) {
                $article->hriSgnHoKoku = 1;
                
            } elseif($law == 6) {
                $article->hriSgnHoKasen = 1;
                
            } elseif($law == 7) {
                $article->hriSgnHoSabo = 1;
                
            } elseif($law == 8) {
                $article->hriSgnHoNochi = 1;
                
            } elseif($law == 9) {
                $article->hriSgnHoAnzenJorei = 1;
                
            } elseif($law == 10) {
                $article->hriSgnChiTakuzokisei = 1;
                
            } elseif($law == 11) {
                $article->hriSgnChiKyukeishachi = 1;
                
            } elseif($law == 12) {
                $article->hriSgnChiKodochiku = 1;
                
            } elseif($law == 13) {
                $article->hriSgnChiKodoriyo = 1;
                
            } elseif($law == 14) {
                $article->hriSgnChiChukosoJutaku = 1;
                
            } elseif($law == 15) {
                $article->hriSgnChiKosojutakuYudo = 1;
                
            } elseif($law == 16) {
                $article->hriSgnChiBoka = 1;
                
            } elseif($law == 17) {
                $article->hriSgnChiJunboka = 1;
                
            } elseif($law == 18) {
                $article->hriSgnChiFuchi = 1;
                
            } elseif($law == 19) {
                $article->hriSgnChiKeikan = 1;
                
            } elseif($law == 20) {
                $article->hriSgnChiJunKeikan = 1;
                
            } elseif($law == 21) {
                $article->hriSgnChiKanko = 1;
                
            } elseif($law == 22) {
                $article->hriSgnChiRekishi = 1;
                
            } elseif($law == 23) {
                $article->hriSgnChiDento = 1;
                
            } elseif($law == 24) {
                $article->hriSgnChiTokuteiGaiku = 1;
                
            } elseif($law == 25) {
                $article->hriSgnChiTokubetsuYoto = 1;
                
            } elseif($law == 26) {
                $article->hriSgnChiBunkyo = 1;
                
            } elseif($law == 27) {
                $article->hriSgnChiToshisaisei = 1;
                
            } elseif($law == 28) {
                $article->hriSgnChiTokubetsuRyokuchi = 1;
                
            } elseif($law == 29) {
                $article->hriSgnTateTakasaMax = 1;
                
            } elseif($law == 30) {
                $article->hriSgnTateTakasaMin = 1;
                
            } elseif($law == 31) {
                $article->hriSgnTateKenpeiMin = 1;
                
            } elseif($law == 32) {
                $article->hriSgnTateYosekiMin = 1;
                
            } elseif($law == 33) {
                $article->hriSgnTateSktMnsMax = 1;
                
            } elseif($law == 34) {
                $article->hriSgnTateSktMnsMin = 1;
                
            } elseif($law == 35) {
                $article->hriSgnTateMnsMax = 1;
                
            } elseif($law == 36) {
                $article->hriSgnTateMnsMin = 1;
            }
        }

        // その他制限事項
        $article->kckKjn43joTadashigakiKbn = $article->other_reason;
        $article->sgnJikoComment = $article->other_comment;

        // 7.投資用・事業用
        if($article->classfication ==1) {
            $article->jigKbn = 0;
            $article->jigComment = '';
        } else {
            $article->jigKbn = 1;
            if($article->use_method == 1) {
                $article->jigYotoKbn = '07';
                $article->jigComment = '';
            } elseif($article->use_method == 2) {
                $article->jigYotoKbn = '08';
                $article->jigComment = '';
            } elseif($article->use_method == 3) {
                $article->jigYotoKbn = '09';
                $article->jigComment = '';
            } elseif($article->use_method == 4) {
                $article->jigYotoKbn = '01';
                $article->jigComment = '';
            } elseif($article->use_method == 5) {
                $article->jigYotoKbn = '02';
                $article->jigComment = '';
            } elseif($article->use_method == 6) {
                $article->jigYotoKbn = '06';
                $article->jigComment = '';
            } elseif($article->use_method == 7) {
                $article->jigYotoKbn = '04';
                $article->jigComment = '';
            } elseif($article->use_method == 8) {
                $article->jigYotoKbn = '03';
                $article->jigComment = '';
            } elseif($article->use_method == 9) {
                $article->jigYotoKbn = '99';
                $article->jigComment = $article->use_method_text;
            }
        }

        // 10.イベント情報
        

        return $article;

    }

    function moldingDataHouse($article) {
        // 1.基本情報
        // 物件名
        $article->bukkenNm1 = mb_substr($article->article_name, 0, 42);
        // 郵便番号
        $zip_info = $article->zip;
        $zip_list = explode('-', $zip_info);
        $article->yubinbango01 = $zip_list[0]??'';
        $article->yubinbango02 = $zip_list[1]??'';

        // 住所
        $article->todofukenCd = $article->address1;
        $article->shikugunCd = $article->address2;
        $article->ooazaCd = $article->address3;

        $pref_info = MstPrefecture::getName($article->address1);
        $city_info = MstCity::getName($article->address1, $article->address2);
        $town_info = MstTown::getName($article->address1, $article->address2, $article->address3);
        $article->todofukenNm = $pref_info->name??'';
        $article->shikugunNm = $city_info->name??'';
        $article->ooazaNm = $town_info->name??'';

        // 交通

        // 2.担当者情報
        // 担当者名
        $user_info = UserInfo::getDataById($article->hp_charge);
        $name_info = '';
        $name_info = $user_info->last_name??'';
        if($name_info != '') {
            $name_info .= ' ';
        }
        $name_info .= $user_info->first_name??'';
        $article->kishaEigyoMei = $name_info;
        // スタッフコメント
        $article->staffComment = mb_substr($article->comment, 0, 100);
        // 社内メモ1
        $article->kishaComment1 = mb_substr($article->memo1, 0, 20);
        // 社内メモ2
        $article->kishaComment2 = mb_substr($article->memo2, 0, 20);

        // 3.価格
        // 町会費
        if($article->council != 0) {
            $article->chokaihiKbn = $article->council;
            if($article->council_presence == 0) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            } elseif($article->council_presence == 1) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = $article->council_cost;
                if($article->council_cost_unit != 0) {
                    $article->chokaihiRyoTaniKbn = $article->council_cost_unit;
                } else {
                    $article->chokaihiRyoTaniKbn = '';
                }
            } elseif($article->council_presence == 2) {
                $article->chokaihiUmu = '3';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            }
        } elseif($article->council == 0) {
            $article->chokaihiKbn = '0';
            $article->chokaihiUmu = '';
            $article->chokaihiRyo = '';
            $article->chokaihiRyoTaniKbn = '';
        }

        // 有線
        if($article->broadcasting == 0) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        } elseif($article->broadcasting == 1) {
            $article->yusenHiyoUmu = '1';
            if($article->broadcasting_presence == 0) {
                $article->yusenShokiHiyoUmu = 1;
                $article->yusenShokiHiyo = '';
            } elseif($article->broadcasting_presence == 1) {
                $article->yusenShokiHiyoUmu = 2;
                $article->yusenShokiHiyo = $article->broadcasting_cost;
            } elseif($article->broadcasting_presence == 2) {
                $article->yusenShokiHiyoUmu = 3;
                $article->yusenShokiHiyo = '';
            }

            if($article->broadcasting_fixed_presence == 0) {
                $article->yusenTeigakuRyoUmu = 1;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 1) {
                $article->yusenTeigakuRyoUmu = 2;
                $article->yusenTeigakuRyo = $article->broadcasting_fixed_cost;
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 2) {
                $article->yusenTeigakuRyoUmu = 3;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            }

        } elseif($article->broadcasting == 2) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        }

        // インターネット
        if($article->internet == 0) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        } elseif($article->internet == 1) {
            $article->internetHiyoUmu = '1';
            if($article->internet_presence == 0) {
                $article->internetShokiHiyoUmu = 1;
                $article->internetShokiHiyo = '';
            } elseif($article->internet_presence == 1) {
                $article->internetShokiHiyoUmu = 2;
                $article->internetShokiHiyo = $article->internet_cost;
            } elseif($article->internet_presence == 2) {
                $article->internetShokiHiyoUmu = 3;
                $article->internetShokiHiyo = '';
            }

            if($article->internet_fixed_presence == 0) {
                $article->internetTeigakuRyoUmu = 1;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 1) {
                $article->internetTeigakuRyoUmu = 2;
                $article->internetTeigakuRyo = $article->internet_fixed_cost;
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 2) {
                $article->internetTeigakuRyoUmu = 3;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            }

        } elseif($article->internet == 2) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        }

        // catv
        if($article->catv == 0) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        } elseif($article->catv == 1) {
            $article->catvHiyoUmu = '1';
            if($article->catv_presence == 0) {
                $article->catvShokiHiyoUmu = 1;
                $article->catvShokiHiyo = '';
            } elseif($article->catv_presence == 1) {
                $article->catvShokiHiyoUmu = 2;
                $article->catvShokiHiyo = $article->catv_cost;
            } elseif($article->catv_presence == 2) {
                $article->catvShokiHiyoUmu = 3;
                $article->catvShokiHiyo = '';
            }

            if($article->catv_fixed_presence == 0) {
                $article->catvTeigakuRyoUmu = 1;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 1) {
                $article->catvTeigakuRyoUmu = 2;
                $article->catvTeigakuRyo = $article->catv_fixed_cost;
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 2) {
                $article->catvTeigakuRyoUmu = 3;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            }

        } elseif($article->catv == 2) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        }

        // 温泉
        if($article->spring != 0) {
            $article->onsenKenKbn = $article->council;
            if($article->spring_presence == 0) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            } elseif($article->spring_presence == 1) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = $article->spring_cost;
                if($article->spring_cost_unit != 0) {
                    $article->onsenKenRyoTaniKbn = $article->spring_cost_unit;
                } else {
                    $article->onsenKenRyoTaniKbn = '';
                }
            } elseif($article->spring_presence == 2) {
                $article->onsenKenRyoUmu = '3';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            }
        } elseif($article->spring == 0) {
            $article->onsenKenKbn = '0';
            $article->onsenKenRyoUmu = '';
            $article->onsenKenRyo = '';
            $article->onsenKenRyoTaniKbn = '';
        }
        
        // 4.土地建物情報
        // 土地権利
        if($article->land_right != 0) {
            $article->shikichiKenri = $article->land_right;
        } else {
            $article->shikichiKenri = '1';
        }
        // 土地面積
        $article->tochiMensekiKbn = $article->land_area;
        $land_area = $article->land_area_val??'0.0';
        $land_area_list = explode('.', $land_area);
        $article->tochiMensekiMinS = $land_area_list[0]??'';
        $article->tochiMensekiMinL = $land_area_list[1]??'';

        if($article->land_condition1 == 1) {
            $land_condition_area1_list = explode('.', $article->land_condition_area1);
            $article->keishaMensekiMinS = $land_condition_area1_list[0]??'';
            $article->keishaMensekiMinL = $land_condition_area1_list[1]??'';
            $article->keishaMensekiMinTaniKbn = $article->land_condition_unit1;
        } else {
            $article->keishaMensekiMinS = '';
            $article->keishaMensekiMinL = '';
            $article->keishaMensekiMinTaniKbn = 0;
        }

        if($article->land_condition2 == 1) {
            $land_condition_area2_list = explode('.', $article->land_condition_area2);
            $article->shikichiEnchoMinS = $land_condition_area2_list[0]??'';
            $article->shikichiEnchoMinL = $land_condition_area2_list[1]??'';
            $article->shikichiEnchoMinTaniKbn = $article->land_condition_unit2;
        } else {
            $article->shikichiEnchoMinS = '';
            $article->shikichiEnchoMinL = '';
            $article->shikichiEnchoMinTaniKbn = 0;           
        }

        if($article->land_condition3 == 1) {
            $land_condition_area3_list = explode('.', $article->land_condition_area3);
            $article->koatsuMensekiMinS = $land_condition_area3_list[0]??'';
            $article->koatsuMensekiMinL = $land_condition_area3_list[1]??'';
        } else {
            $article->koatsuMensekiMinS = '';
            $article->koatsuMensekiMinL = '';          
        }

        // 建ぺい率
        $article->kenpeiritsu = (int)$article->building_rate;
        // 容積率
        $article->yosekiritsu = (int)$article->volume_rate;

        // 私道負担
        if($article->road_burden == 0) {
            $article->shidoFutanKbn = 1;
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        } elseif($article->road_burden == 1) {
            $article->shidoFutanKbn = 2;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $article->shidoFutanMensekiMinS1 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL1 = $road_burden_area_list[1]??'';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';

        } elseif($article->road_burden == 2) {
            $article->shidoFutanKbn = 3;
            $road_burden_area = $article->road_burden_area;
            $road_burden_area_list = explode('.', $road_burden_area);
            $road_numerator = $article->road_numerator;
            $road_numerator_list = explode('.', $road_numerator);
            $road_denominator = $article->road_denominator;
            $road_denominator_list = explode('.', $road_denominator);
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = $road_burden_area_list[0]??'';
            $article->shidoFutanMensekiMinL2 = $road_burden_area_list[1]??'';
            $article->shidoFutanBunshiMinS = $road_numerator_list[0]??'';
            $article->shidoFutanBunshiMinL = $road_numerator_list[1]??'';
            $article->shidoFutanBunboMinS = $road_denominator_list[0]??'';
            $article->shidoFutanBunboMinL = $road_denominator_list[1]??'';
        } else {
            $article->shidoFutanKbn = '';
            $article->shidoFutanMensekiMinS1 = '';
            $article->shidoFutanMensekiMinL1 = '';
            $article->shidoFutanMensekiMinS2 = '';
            $article->shidoFutanMensekiMinL2 = '';
            $article->shidoFutanBunshiMinS = '';
            $article->shidoFutanBunshiMinL = '';
            $article->shidoFutanBunboMinS = '';
            $article->shidoFutanBunboMinL = '';
        }

        // 地役権
        if($article->easement == 1 || $article->easement == 0) {
            $article->chiekikenKbn = $article->easement;
            $article->chiekikenMensekiS = '';
            $article->chiekikenMensekiL = '';
        } else {
            $article->chiekikenKbn = $article->easement;
            $easement_area = $article->easement_area;
            $easement_area_list = explode('.', $easement_area);
            $article->chiekikenMensekiS = $easement_area_list[0]??'';
            $article->chiekikenMensekiL = $easement_area_list[1]??'';
        }
        // 道路向き
        if($article->land_direction1 == 0) {
            $article->doroMukiKbn1 = 0;
        } else { 
            if($article->land_direction1 == 1) {
                $article->doroMukiKbn1 = 4;
            } elseif($article->land_direction1 == 2) {
                $article->doroMukiKbn1 = 5;
            } elseif($article->land_direction1 == 3) {
                $article->doroMukiKbn1 = 1;
            } elseif($article->land_direction1 == 4) {
                $article->doroMukiKbn1 = 6;
            } elseif($article->land_direction1 == 5) {
                $article->doroMukiKbn1 = 3;
            } elseif($article->land_direction1 == 6) {
                $article->doroMukiKbn1 = 8;
            } elseif($article->land_direction1 == 7) {
                $article->doroMukiKbn1 = 2;
            } elseif($article->land_direction1 == 8) {
                $article->doroMukiKbn1 = 7;
            }
            $road_width1 = $article->road_width1;
            $road_width1_list = explode('.', $road_width1);
            $frontage1 = $article->frontage1;
            $frontage1_list = explode('.', $frontage1);
            $article->doroWidth1S = $road_width1_list[0]??'';
            $article->doroWidth1L = $road_width1_list[1]??'';
            $article->setsudoWidth1S = $frontage1_list[0]??'';
            $article->setsudoWidth1L = $frontage1_list[1]??'';
        }

        if($article->land_direction2 == 0) {
            $article->doroMukiKbn2 = 0;
        } else { 
            if($article->land_direction2 == 1) {
                $article->doroMukiKbn2 = 4;
            } elseif($article->land_direction2 == 2) {
                $article->doroMukiKbn2 = 5;
            } elseif($article->land_direction2 == 3) {
                $article->doroMukiKbn2 = 1;
            } elseif($article->land_direction2 == 4) {
                $article->doroMukiKbn2 = 6;
            } elseif($article->land_direction2 == 5) {
                $article->doroMukiKbn2 = 3;
            } elseif($article->land_direction2 == 6) {
                $article->doroMukiKbn2 = 8;
            } elseif($article->land_direction2 == 7) {
                $article->doroMukiKbn2 = 2;
            } elseif($article->land_direction2 == 8) {
                $article->doroMukiKbn2 = 7;
            }
            $road_width2 = $article->road_width2;
            $road_width2_list = explode('.', $road_width2);
            $frontage2 = $article->frontage2;
            $frontage2_list = explode('.', $frontage2);
            $article->doroWidth2S = $road_width2_list[0]??'';
            $article->doroWidth2L = $road_width2_list[1]??'';
            $article->setsudoWidth2S = $frontage2_list[0]??'';
            $article->setsudoWidth2L = $frontage2_list[1]??'';
        }

        if($article->land_direction3 == 0) {
            $article->doroMukiKbn3 = 0;
        } else { 
            if($article->land_direction3 == 1) {
                $article->doroMukiKbn3 = 4;
            } elseif($article->land_direction3 == 2) {
                $article->doroMukiKbn3 = 5;
            } elseif($article->land_direction3 == 3) {
                $article->doroMukiKbn3 = 1;
            } elseif($article->land_direction3 == 4) {
                $article->doroMukiKbn3 = 6;
            } elseif($article->land_direction3 == 5) {
                $article->doroMukiKbn3 = 3;
            } elseif($article->land_direction3 == 6) {
                $article->doroMukiKbn3 = 8;
            } elseif($article->land_direction3 == 7) {
                $article->doroMukiKbn3 = 2;
            } elseif($article->land_direction3 == 8) {
                $article->doroMukiKbn3 = 7;
            }
            $road_width3 = $article->road_width3;
            $road_width3_list = explode('.', $road_width3);
            $frontage3 = $article->frontage3;
            $frontage3_list = explode('.', $frontage3);
            $article->doroWidth3S = $road_width3_list[0]??'';
            $article->doroWidth3L = $road_width3_list[1]??'';
            $article->setsudoWidth3S = $frontage3_list[0]??'';
            $article->setsudoWidth3L = $frontage3_list[1]??'';
        }

        // 上水道
        $article->setsubiJosuidoKbn = $article->water_supply;

        // 下水道
        $article->setsubiGesuidoKbn = $article->sewerage;

        // ガス
        $article->setsubiGasKbn = $article->gas;

        // 駐車場
        if($article->garage == 1) {
            $article->shakoKbn = 2;
        } elseif($article->garage == 0) {
            $article->shakoKbn = 0;
        }

        // セットパック
        if($article->set == 1) {
            $article->setbackKbn = $article->set;
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        } elseif($article->set == 2 || $article->set == 3) {
            $article->setbackKbn = $article->set;
            $set_area = $article->set_area;
            $set_area_list = explode('.', $set_area);
            $article->setbackMensekiMinS = $set_area_list[0]??'';
            $article->setbackMensekiMinL = $set_area_list[1]??'';
        } else {
            $article->setbackKbn = '';
            $article->setbackMensekiMinS = '';
            $article->setbackMensekiMinL = '';
        }

        // 用途地域
        if($article->use_area == 1) {
            $article->yotochiikiCd01 = '01';
        } elseif($article->use_area == 2) {
            $article->yotochiikiCd01 = '04';
        } elseif($article->use_area == 3) {
            $article->yotochiikiCd01 = '06';
        } elseif($article->use_area == 4) {
            $article->yotochiikiCd01 = '08';
        } elseif($article->use_area == 5) {
            $article->yotochiikiCd01 = '09';
        } elseif($article->use_area == 6) {
            $article->yotochiikiCd01 = '10';
        } elseif($article->use_area == 7) {
            $article->yotochiikiCd01 = '11';
        } elseif($article->use_area == 8) {
            $article->yotochiikiCd01 = '12';
        } elseif($article->use_area == 10) {
            $article->yotochiikiCd01 = '02';
        } elseif($article->use_area == 11) {
            $article->yotochiikiCd01 = '03';
        } elseif($article->use_area == 12) {
            $article->yotochiikiCd01 = '05';
        } elseif($article->use_area == 13) {
            $article->yotochiikiCd01 = '07';
        } elseif($article->use_area == 14) {
            $article->yotochiikiCd01 = '16';
        } else {
            $article->yotochiikiCd01 = '00';
        }
        
        if($article->land_use == 1) {
            $article->yotochiikiCd02 = '01';
        } elseif($article->land_use == 2) {
            $article->yotochiikiCd02 = '04';
        } elseif($article->land_use == 3) {
            $article->yotochiikiCd02 = '06';
        } elseif($article->land_use == 4) {
            $article->yotochiikiCd02 = '08';
        } elseif($article->land_use == 5) {
            $article->yotochiikiCd02 = '09';
        } elseif($article->land_use == 6) {
            $article->yotochiikiCd02 = '10';
        } elseif($article->land_use == 7) {
            $article->yotochiikiCd02 = '11';
        } elseif($article->land_use == 8) {
            $article->yotochiikiCd02 = '12';
        } elseif($article->land_use == 10) {
            $article->yotochiikiCd02 = '02';
        } elseif($article->land_use == 11) {
            $article->yotochiikiCd02 = '03';
        } elseif($article->land_use == 12) {
            $article->yotochiikiCd02 = '05';
        } elseif($article->land_use == 13) {
            $article->yotochiikiCd02 = '07';
        } elseif($article->land_use == 14) {
            $article->yotochiikiCd02 = '16';
        } else {
            $article->yotochiikiCd02 = '00';
        }

        // 建物面積
        $article->tatemonoMnsKbn = $article->total_area;
        $total_area = $article->total_area_val??'0.0';
        $total_area_list = explode('.', $total_area);
        $article->tatemonoMnsMinS = $total_area_list[0]??'';
        $article->tatemonoMnsMinL = $total_area_list[1]??'';

        $building_condition_area1 = $article->building_condition_area1??'0.0';
        $building_condition_area1_list = explode('.', $building_condition_area1);
        $article->uchiChikashitsuMinS = $building_condition_area1_list[0]??'';
        $article->uchiChikashitsuMinL = $building_condition_area1_list[1]??'';

        $building_condition_area2 = $article->building_condition_area2??'0.0';
        $building_condition_area2_list = explode('.', $building_condition_area2);
        $article->uchiShakoMinS = $building_condition_area2_list[0]??'';
        $article->uchiShakoMinL = $building_condition_area2_list[1]??'';

        $building_condition_area3 = $article->building_condition_area3??'0.0';
        $building_condition_area3_list = explode('.', $building_condition_area3);
        $article->uchiChikachuMinS = $building_condition_area3_list[0]??'';
        $article->uchiChikachuMinL = $building_condition_area3_list[1]??'';

        if($article->building_condition4 == 1) {
            if($article->building_condition_select != 9) {
                $article->uchiJigYotoKbn = $article->building_condition_select;
            } else {
                $article->uchiJigYotoKbn = '7';
            }
        } else {
            $article->uchiJigYotoKbn = '0';
        }
        
        $article->madoriMin = $article->floor_plan;
        if($article->floor_plan_type == 1) {
            $article->madoriMinType1Kbn = '03';
        } elseif($article->floor_plan_type == 2) {
            $article->madoriMinType1Kbn = '04';
        } elseif($article->floor_plan_type == 3) {
            $article->madoriMinType1Kbn = '01';
        } elseif($article->floor_plan_type == 4) {
            $article->madoriMinType1Kbn = '02';
        } elseif($article->floor_plan_type == 7) {
            $article->madoriMinType1Kbn = '05';
        } else {
            $article->madoriMinType1Kbn = '00';
        }

        $article->soKosu = $article->total_unit??'0';
        $article->kanseiJikiNen = $article->completed_year;
        $article->kanseiJikiTsuki = $article->completed_month;
        $article->kanseiJikiTsukiSu = $article->completed_contract_month;

        // 入居予定
        if($article->move_in == 1) {
            $article->nyukyoJikiKbn = 1;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 2) {
            $article->nyukyoJikiKbn = 4;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 3) {
            $article->nyukyoJikiKbn = 2;
            $article->nyukyoJikiNen = $article->move_in_year;
            $article->nyukyoJikiTsuki = $article->move_in_month;
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 4) {
            $article->nyukyoJikiKbn = 3;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = $article->move_in_contract_month;

        } elseif($article->move_in == 0) {
            $article->nyukyoJikiKbn = 0;
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        }
        
        // 構造
        if($article->construction == 1) {
            $article->kozoKbn = '03';
        } elseif($article->construction == 3) {
            $article->kozoKbn = '04';
        } elseif($article->construction == 4) {
            $article->kozoKbn = '01';
        } elseif($article->construction == 5) {
            $article->kozoKbn = '02';
        } elseif($article->construction == 6) {
            $article->kozoKbn = '06';
        } elseif($article->construction == 7) {
            $article->kozoKbn = '07';
        } elseif($article->construction == 8) {
            $article->kozoKbn = '05';
        } elseif($article->construction == 9) {
            $article->kozoKbn = '08';
        } else {
            $article->kozoKbn = '';
        }

        if($article->construction_sub == 1) {
            $article->kozoKbnIchibu = '03';
        } elseif($article->construction_sub == 3) {
            $article->kozoKbnIchibu = '04';
        } elseif($article->construction_sub == 4) {
            $article->kozoKbnIchibu = '01';
        } elseif($article->construction_sub == 5) {
            $article->kozoKbnIchibu = '02';
        } elseif($article->construction_sub == 6) {
            $article->kozoKbnIchibu = '06';
        } elseif($article->construction_sub == 7) {
            $article->kozoKbnIchibu = '07';
        } elseif($article->construction_sub == 8) {
            $article->kozoKbnIchibu = '05';
        } elseif($article->construction_sub == 9) {
            $article->kozoKbnIchibu = '08';
        } else {
            $article->kozoKbnIchibu = '10';
        }
        
        // 建物階建て
        $article->chijokaidate = $article->floor;
        $article->chikakaidate = $article->underground;

        // 駐車場
        if($article->parking == 1) {
            $article->shakoKbn = '5';
        } elseif($article->parking == 9) {
            $article->shakoKbn = '1';
        } elseif($article->parking == 10) {
            $article->shakoKbn = '2';
        } elseif($article->parking == 11) {
            $article->shakoKbn = '3';
        } elseif($article->parking == 12) {
            $article->shakoKbn = '4';
        } else {
            $article->shakoKbn = '0';
        }

        // 建物確認番号
        $article->kenchikuKakuninNo = $article->architecture_no;

        //リフォーム
        if($article->exterior == 1) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = '';
            $article->gaisoTsuki = '';
        } elseif($article->exterior == 2) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        } elseif($article->exterior == 3) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        }

        if($article->interior == 1) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = '';
            $article->naisoTsuki = '';
        } elseif($article->interior == 2) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        } elseif($article->interior == 3) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        }

        // 5.会社情報
        if($article->company_manner == 1) {
            $article->torihikitaiyoKbn01 = '01';
        } elseif($article->company_manner == 2) {
            $article->torihikitaiyoKbn01 = '13';
        } elseif($article->company_manner == 3) {
            $article->torihikitaiyoKbn01 = '09';
        } elseif($article->company_manner == 4) {
            $article->torihikitaiyoKbn01 = '10';
        } elseif($article->company_manner == 5) {
            $article->torihikitaiyoKbn01 = '11';
        } elseif($article->company_manner == 6) {
            $article->torihikitaiyoKbn01 = '07';
        } elseif($article->company_manner == 7) {
            $article->torihikitaiyoKbn01 = '08';
        } elseif($article->company_manner == 8) {
            $article->torihikitaiyoKbn01 = '09';
        } else {
            $article->torihikitaiyoKbn01 = '';
        }

        // 6.制限事項
        $law_check = RelationLawrestriction::getDataByArticleId($article->building_id);
        foreach($law_check as $law) {
            if($law == 1) {
                $article->hriSgnHoBunkazai = 1;
                
            } elseif($law == 2) {
                $article->hriSgnHoKotohogo = 1;
                
            } elseif($law == 3) {
                $article->hriSgnHoKeikan = 1;
                
            } elseif($law == 4) {
                $article->hriSgnHoMisshuSgcSeibi = 1;
                
            } elseif($law == 5) {
                $article->hriSgnHoKoku = 1;
                
            } elseif($law == 6) {
                $article->hriSgnHoKasen = 1;
                
            } elseif($law == 7) {
                $article->hriSgnHoSabo = 1;
                
            } elseif($law == 8) {
                $article->hriSgnHoNochi = 1;
                
            } elseif($law == 9) {
                $article->hriSgnHoAnzenJorei = 1;
                
            } elseif($law == 10) {
                $article->hriSgnChiTakuzokisei = 1;
                
            } elseif($law == 11) {
                $article->hriSgnChiKyukeishachi = 1;
                
            } elseif($law == 12) {
                $article->hriSgnChiKodochiku = 1;
                
            } elseif($law == 13) {
                $article->hriSgnChiKodoriyo = 1;
                
            } elseif($law == 14) {
                $article->hriSgnChiChukosoJutaku = 1;
                
            } elseif($law == 15) {
                $article->hriSgnChiKosojutakuYudo = 1;
                
            } elseif($law == 16) {
                $article->hriSgnChiBoka = 1;
                
            } elseif($law == 17) {
                $article->hriSgnChiJunboka = 1;
                
            } elseif($law == 18) {
                $article->hriSgnChiFuchi = 1;
                
            } elseif($law == 19) {
                $article->hriSgnChiKeikan = 1;
                
            } elseif($law == 20) {
                $article->hriSgnChiJunKeikan = 1;
                
            } elseif($law == 21) {
                $article->hriSgnChiKanko = 1;
                
            } elseif($law == 22) {
                $article->hriSgnChiRekishi = 1;
                
            } elseif($law == 23) {
                $article->hriSgnChiDento = 1;
                
            } elseif($law == 24) {
                $article->hriSgnChiTokuteiGaiku = 1;
                
            } elseif($law == 25) {
                $article->hriSgnChiTokubetsuYoto = 1;
                
            } elseif($law == 26) {
                $article->hriSgnChiBunkyo = 1;
                
            } elseif($law == 27) {
                $article->hriSgnChiToshisaisei = 1;
                
            } elseif($law == 28) {
                $article->hriSgnChiTokubetsuRyokuchi = 1;
                
            } elseif($law == 29) {
                $article->hriSgnTateTakasaMax = 1;
                
            } elseif($law == 30) {
                $article->hriSgnTateTakasaMin = 1;
                
            } elseif($law == 31) {
                $article->hriSgnTateKenpeiMin = 1;
                
            } elseif($law == 32) {
                $article->hriSgnTateYosekiMin = 1;
                
            } elseif($law == 33) {
                $article->hriSgnTateSktMnsMax = 1;
                
            } elseif($law == 34) {
                $article->hriSgnTateSktMnsMin = 1;
                
            } elseif($law == 35) {
                $article->hriSgnTateMnsMax = 1;
                
            } elseif($law == 36) {
                $article->hriSgnTateMnsMin = 1;
            }
        }

        // その他制限事項
        $article->kckKjn43joTadashigakiKbn = $article->other_reason;
        $article->sgnJikoComment = $article->other_comment;

        // 7.投資用・事業用
        if($article->classfication ==1) {
            $article->jigKbn = 0;
            $article->jigComment = '';
        } else {
            $article->jigKbn = 1;
            if($article->use_method == 1) {
                $article->jigYotoKbn = '07';
                $article->jigComment = '';
            } elseif($article->use_method == 2) {
                $article->jigYotoKbn = '08';
                $article->jigComment = '';
            } elseif($article->use_method == 3) {
                $article->jigYotoKbn = '09';
                $article->jigComment = '';
            } elseif($article->use_method == 4) {
                $article->jigYotoKbn = '01';
                $article->jigComment = '';
            } elseif($article->use_method == 5) {
                $article->jigYotoKbn = '02';
                $article->jigComment = '';
            } elseif($article->use_method == 6) {
                $article->jigYotoKbn = '06';
                $article->jigComment = '';
            } elseif($article->use_method == 7) {
                $article->jigYotoKbn = '04';
                $article->jigComment = '';
            } elseif($article->use_method == 8) {
                $article->jigYotoKbn = '03';
                $article->jigComment = '';
            } elseif($article->use_method == 9) {
                $article->jigYotoKbn = '99';
                $article->jigComment = $article->use_method_text;
            }
        }

        // 10.イベント情報
        

        return $article;

    }

    function moldingDataMansion($article, $mansion) {
        // 1.基本情報
        // 物件名
        $article->bukkenNm1 = mb_substr($article->article_name, 0, 42);
        // 郵便番号
        $zip_info = $article->zip;
        $zip_list = explode('-', $zip_info);
        $article->yubinbango01 = $zip_list[0]??'';
        $article->yubinbango02 = $zip_list[1]??'';

        // 住所
        $article->todofukenCd = $article->address1;
        $article->shikugunCd = $article->address2;
        $article->ooazaCd = $article->address3;

        $pref_info = MstPrefecture::getName($article->address1);
        $city_info = MstCity::getName($article->address1, $article->address2);
        $town_info = MstTown::getName($article->address1, $article->address2, $article->address3);
        $article->todofukenNm = $pref_info->name??'';
        $article->shikugunNm = $city_info->name??'';
        $article->ooazaNm = $town_info->name??'';

        // 交通

        // 2.担当者情報
        // 担当者名
        $user_info = UserInfo::getDataById($article->hp_charge);
        $name_info = '';
        $name_info = $user_info->last_name??'';
        if($name_info != '') {
            $name_info .= ' ';
        }
        $name_info .= $user_info->first_name??'';
        $article->kishaEigyoMei = $name_info;
        // スタッフコメント
        $article->staffComment = mb_substr($article->comment, 0, 100);
        // 社内メモ1
        $article->kishaComment1 = mb_substr($article->memo1, 0, 20);
        // 社内メモ2
        $article->kishaComment2 = mb_substr($article->memo2, 0, 20);

        // 3.価格
        // 管理形態
        if($mansion->management_form != 0) {
            $article->kanriKeitai = $mansion->management_form;
        } else {
            $article->kanriKeitai = 1;
        }

        // 管理費
        if($article->management == 0) {
            $article->kanrihiUmu = $article->management;
            $article->kanrihiMin = '0';
            $article->kanrihiTaniKbn = '1';
        } else {
            $article->kanrihiUmu = $article->management;
            $article->kanrihiMin = $article->management_cost??'0';
            $article->kanrihiTaniKbn = $article->management_cost_unit;

        }
        // 修繕費
        if($article->repair == 0) {
            $article->sznTmtKinKbn = $article->repair;
            $article->sznTmtKinMin = '0';
            $article->sznTmtKinTaniKbn = '1';
        } else {
            $article->sznTmtKinKbn = $article->repair;
            $article->sznTmtKinMin = $article->repair_cost??'0';
            $article->sznTmtKinTaniKbn = $article->repair_cost_unit;

        }

        // 駐車場
        if($article->parking == 1) {
            $article->chushajoKbn = '5';
            $article->chushajoUmu = '';
            $article->bnjCsjKakakuMin1 = '';
            $article->bnjCsjKakakuMin2 = '';
            $article->bnjCsjKakakuMax = '';
            $article->bnjCsjKakakuHaniKbn = '0';
            $article->bnjCsjKanrihiUmu = '';
            $article->bnjCsjKanrihi = '';
            $article->bnjCsjKanrihiTaniKbn = '1';
            $article->bnjCsjSznTmtKinUmu = '';
            $article->bnjCsjSznTmtKin = '';
            $article->bnjCsjSznTmtKinTaniKbn = '1';
            $article->chushajoRyoKbn2 = '';
        } elseif($article->parking == 2) {
            $article->chushajoKbn = '1';
            $article->chushajoUmu = '1';
            $article->bnjCsjKakakuMin1 = '';
            $article->bnjCsjKakakuMin2 = '';
            $article->bnjCsjKakakuMax = '';
            $article->bnjCsjKakakuHaniKbn = '0';
            $article->bnjCsjKanrihiUmu = '';
            $article->bnjCsjKanrihi = '';
            $article->bnjCsjKanrihiTaniKbn = '1';
            $article->bnjCsjSznTmtKinUmu = '';
            $article->bnjCsjSznTmtKin = '';
            $article->bnjCsjSznTmtKinTaniKbn = '1';
            $article->chushajoRyoKbn2 = '';
        } elseif($article->parking == 3) {
            $article->chushajoKbn = '1';
            $article->chushajoUmu = '2';
            $article->bnjCsjKakakuMin1 = '';
            $article->bnjCsjKakakuMin2 = '';
            $article->bnjCsjKakakuMax = '';
            $article->bnjCsjKakakuHaniKbn = '0';
            $article->bnjCsjKanrihiUmu = '';
            $article->bnjCsjKanrihi = '';
            $article->bnjCsjKanrihiTaniKbn = '1';
            $article->bnjCsjSznTmtKinUmu = '';
            $article->bnjCsjSznTmtKin = '';
            $article->bnjCsjSznTmtKinTaniKbn = '1';
            $article->chushajoRyoKbn2 = '';
        } elseif($article->parking == 4) {
            $article->chushajoKbn = '2';
            $article->chushajoUmu= '';
            $article->bnjCsjKakakuMin1 = $article->parking_require_cost;
            $article->bnjCsjKakakuMin2 = '';
            $article->bnjCsjKakakuMax = '';
            $article->bnjCsjKakakuHaniKbn = '0';
            $article->bnjCsjKanrihiUmu = $article->parking_any_management;
            $article->bnjCsjKanrihi = $article->parking_any_management_cost;
            $article->bnjCsjKanrihiTaniKbn = $article->parking_any_management_unit;
            $article->bnjCsjSznTmtKinUmu = $article->parking_any_repair;
            $article->bnjCsjSznTmtKin = $article->parking_any_repair_cost;
            $article->bnjCsjSznTmtKinTaniKbn = $article->parking_any_repair_unit;
            $article->chushajoRyoKbn2 = '';
        } elseif($article->parking == 5) {
            $article->chushajoKbn = '3';
            $article->chushajoUmu= '';
            $article->bnjCsjKakakuMin1 = '';
            $article->bnjCsjKakakuMin2 = $article->parking_any_cost_from;
            if($article->parking_any_cost_range == 1) {
                $article->bnjCsjKakakuHaniKbn = '0';
            } elseif($article->parking_any_cost_range == 2) {
                $article->bnjCsjKakakuHaniKbn = '1';
            } else {
                $article->bnjCsjKakakuHaniKbn = '2';
            }
            $article->bnjCsjKanrihiUmu = $article->parking_any_management;
            $article->bnjCsjKanrihi = $article->parking_any_management_cost;
            $article->bnjCsjKanrihiTaniKbn = $article->parking_any_management_unit;
            $article->bnjCsjSznTmtKinUmu = $article->parking_any_repair;
            $article->bnjCsjSznTmtKin = $article->parking_any_repair_cost;
            $article->bnjCsjSznTmtKinTaniKbn = $article->parking_any_repair_unit;
            $article->bnjCsjKakakuMax = $article->parking_any_cost_to;
            $article->chushajoRyoKbn2 = '';
        } elseif($article->parking == 6) {
            $article->chushajoKbn = '4';
            $article->chushajoUmu= '';
            $article->bnjCsjKakakuMin1 = '';
            $article->bnjCsjKakakuMin2 = '';
            $article->bnjCsjKakakuMax = '';
            $article->bnjCsjKakakuHaniKbn = '0';
            $article->bnjCsjKanrihiUmu = '';
            $article->bnjCsjKanrihi = '';
            $article->bnjCsjKanrihiTaniKbn = '1';
            $article->bnjCsjSznTmtKinUmu = '';
            $article->bnjCsjSznTmtKin = '';
            $article->bnjCsjSznTmtKinTaniKbn = '1';
            $article->chushajoRyoKbn2 = $article->parking_designated;
        } elseif($article->parking == 0) {
            $article->chushajoKbn = '0';
            $article->chushajoUmu= '';
            $article->bnjCsjKakakuMin1 = '';
            $article->bnjCsjKakakuMin2 = '';
            $article->bnjCsjKakakuMax = '';
            $article->bnjCsjKakakuHaniKbn = '0';
            $article->bnjCsjKanrihiUmu = '';
            $article->bnjCsjKanrihi = '';
            $article->bnjCsjKanrihiTaniKbn = '1';
            $article->bnjCsjSznTmtKinUmu = '';
            $article->bnjCsjSznTmtKin = '';
            $article->bnjCsjSznTmtKinTaniKbn = '1';
            $article->chushajoRyoKbn2 = '';
        }

        // 町会費
        if($article->council != 0) {
            $article->chokaihiKbn = $article->council;
            if($article->council_presence == 0) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            } elseif($article->council_presence == 1) {
                $article->chokaihiUmu = '1';
                $article->chokaihiRyo = $article->council_cost;
                if($article->council_cost_unit != 0) {
                    $article->chokaihiRyoTaniKbn = $article->council_cost_unit;
                } else {
                    $article->chokaihiRyoTaniKbn = '';
                }
            } elseif($article->council_presence == 2) {
                $article->chokaihiUmu = '3';
                $article->chokaihiRyo = '';
                $article->chokaihiRyoTaniKbn = '';
            }
        } elseif($article->council == 0) {
            $article->chokaihiKbn = '0';
            $article->chokaihiUmu = '';
            $article->chokaihiRyo = '';
            $article->chokaihiRyoTaniKbn = '';
        }

        // 有線
        if($article->broadcasting == 0) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        } elseif($article->broadcasting == 1) {
            $article->yusenHiyoUmu = '1';
            if($article->broadcasting_presence == 0) {
                $article->yusenShokiHiyoUmu = 1;
                $article->yusenShokiHiyo = '';
            } elseif($article->broadcasting_presence == 1) {
                $article->yusenShokiHiyoUmu = 2;
                $article->yusenShokiHiyo = $article->broadcasting_cost;
            } elseif($article->broadcasting_presence == 2) {
                $article->yusenShokiHiyoUmu = 3;
                $article->yusenShokiHiyo = '';
            }

            if($article->broadcasting_fixed_presence == 0) {
                $article->yusenTeigakuRyoUmu = 1;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 1) {
                $article->yusenTeigakuRyoUmu = 2;
                $article->yusenTeigakuRyo = $article->broadcasting_fixed_cost;
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            } elseif($article->broadcasting_fixed_presence == 2) {
                $article->yusenTeigakuRyoUmu = 3;
                $article->yusenTeigakuRyo = '';
                $article->yusenTeigakuRyoTaniKbn = $article->broadcasting_fixed_cost_unit;
            }

        } elseif($article->broadcasting == 2) {
            $article->yusenHiyoUmu = '0';
            $article->yusenShokiHiyoUmu = '';
            $article->yusenShokiHiyo = '';
        }

        // インターネット
        if($article->internet == 0) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        } elseif($article->internet == 1) {
            $article->internetHiyoUmu = '1';
            if($article->internet_presence == 0) {
                $article->internetShokiHiyoUmu = 1;
                $article->internetShokiHiyo = '';
            } elseif($article->internet_presence == 1) {
                $article->internetShokiHiyoUmu = 2;
                $article->internetShokiHiyo = $article->internet_cost;
            } elseif($article->internet_presence == 2) {
                $article->internetShokiHiyoUmu = 3;
                $article->internetShokiHiyo = '';
            }

            if($article->internet_fixed_presence == 0) {
                $article->internetTeigakuRyoUmu = 1;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 1) {
                $article->internetTeigakuRyoUmu = 2;
                $article->internetTeigakuRyo = $article->internet_fixed_cost;
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            } elseif($article->internet_fixed_presence == 2) {
                $article->internetTeigakuRyoUmu = 3;
                $article->internetTeigakuRyo = '';
                $article->internetTeigakuRyoTaniKbn = $article->internet_fixed_cost_unit;
            }

        } elseif($article->internet == 2) {
            $article->internetHiyoUmu = '0';
            $article->internetShokiHiyoUmu = '';
            $article->internetShokiHiyo = '';
        }

        // catv
        if($article->catv == 0) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        } elseif($article->catv == 1) {
            $article->catvHiyoUmu = '1';
            if($article->catv_presence == 0) {
                $article->catvShokiHiyoUmu = 1;
                $article->catvShokiHiyo = '';
            } elseif($article->catv_presence == 1) {
                $article->catvShokiHiyoUmu = 2;
                $article->catvShokiHiyo = $article->catv_cost;
            } elseif($article->catv_presence == 2) {
                $article->catvShokiHiyoUmu = 3;
                $article->catvShokiHiyo = '';
            }

            if($article->catv_fixed_presence == 0) {
                $article->catvTeigakuRyoUmu = 1;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 1) {
                $article->catvTeigakuRyoUmu = 2;
                $article->catvTeigakuRyo = $article->catv_fixed_cost;
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            } elseif($article->catv_fixed_presence == 2) {
                $article->catvTeigakuRyoUmu = 3;
                $article->catvTeigakuRyo = '';
                $article->catvTeigakuRyoTaniKbn = $article->catv_fixed_cost_unit;
            }

        } elseif($article->catv == 2) {
            $article->catvHiyoUmu = '0';
            $article->catvShokiHiyoUmu = '';
            $article->catvShokiHiyo = '';
        }

        // 温泉
        if($article->spring != 0) {
            $article->onsenKenKbn = $article->council;
            if($article->spring_presence == 0) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            } elseif($article->spring_presence == 1) {
                $article->onsenKenRyoUmu = '1';
                $article->onsenKenRyo = $article->spring_cost;
                if($article->spring_cost_unit != 0) {
                    $article->onsenKenRyoTaniKbn = $article->spring_cost_unit;
                } else {
                    $article->onsenKenRyoTaniKbn = '';
                }
            } elseif($article->spring_presence == 2) {
                $article->onsenKenRyoUmu = '3';
                $article->onsenKenRyo = '';
                $article->onsenKenRyoTaniKbn = '';
            }
        } elseif($article->spring == 0) {
            $article->onsenKenKbn = '0';
            $article->onsenKenRyoUmu = '';
            $article->onsenKenRyo = '';
            $article->onsenKenRyoTaniKbn = '';
        }
        
        // 4.土地建物情報
        // 土地権利
        if($mansion->land_right != 0) {
            $article->shikichiKenri = $mansion->land_right;
        } else {
            $article->shikichiKenri = '1';
        }

        // 用途地域
        if($mansion->use_area == 1) {
            $article->yotochiikiCd01 = '01';
        } elseif($mansion->use_area == 2) {
            $article->yotochiikiCd01 = '04';
        } elseif($mansion->use_area == 3) {
            $article->yotochiikiCd01 = '06';
        } elseif($mansion->use_area == 4) {
            $article->yotochiikiCd01 = '08';
        } elseif($mansion->use_area == 5) {
            $article->yotochiikiCd01 = '09';
        } elseif($mansion->use_area == 6) {
            $article->yotochiikiCd01 = '10';
        } elseif($mansion->use_area == 7) {
            $article->yotochiikiCd01 = '11';
        } elseif($mansion->use_area == 8) {
            $article->yotochiikiCd01 = '12';
        } elseif($mansion->use_area == 10) {
            $article->yotochiikiCd01 = '02';
        } elseif($mansion->use_area == 11) {
            $article->yotochiikiCd01 = '03';
        } elseif($mansion->use_area == 12) {
            $article->yotochiikiCd01 = '05';
        } elseif($mansion->use_area == 13) {
            $article->yotochiikiCd01 = '07';
        } elseif($mansion->use_area == 14) {
            $article->yotochiikiCd01 = '16';
        } else {
            $article->yotochiikiCd01 = '00';
        }
        
        if($mansion->land_use == 1) {
            $article->yotochiikiCd02 = '01';
        } elseif($mansion->land_use == 2) {
            $article->yotochiikiCd02 = '04';
        } elseif($mansion->land_use == 3) {
            $article->yotochiikiCd02 = '06';
        } elseif($mansion->land_use == 4) {
            $article->yotochiikiCd02 = '08';
        } elseif($mansion->land_use == 5) {
            $article->yotochiikiCd02 = '09';
        } elseif($mansion->land_use == 6) {
            $article->yotochiikiCd02 = '10';
        } elseif($mansion->land_use == 7) {
            $article->yotochiikiCd02 = '11';
        } elseif($mansion->land_use == 8) {
            $article->yotochiikiCd02 = '12';
        } elseif($mansion->land_use == 10) {
            $article->yotochiikiCd02 = '02';
        } elseif($mansion->land_use == 11) {
            $article->yotochiikiCd02 = '03';
        } elseif($mansion->land_use == 12) {
            $article->yotochiikiCd02 = '05';
        } elseif($mansion->land_use == 13) {
            $article->yotochiikiCd02 = '07';
        } elseif($mansion->land_use == 14) {
            $article->yotochiikiCd02 = '16';
        } else {
            $article->yotochiikiCd02 = '00';
        }
        
        // 構造
        if($mansion->construction == 1) {
            $article->kozoKbn = '03';
        } elseif($mansion->construction == 3) {
            $article->kozoKbn = '04';
        } elseif($mansion->construction == 4) {
            $article->kozoKbn = '01';
        } elseif($mansion->construction == 5) {
            $article->kozoKbn = '02';
        } elseif($mansion->construction == 6) {
            $article->kozoKbn = '06';
        } elseif($mansion->construction == 7) {
            $article->kozoKbn = '07';
        } elseif($mansion->construction == 8) {
            $article->kozoKbn = '05';
        } elseif($mansion->construction == 9) {
            $article->kozoKbn = '08';
        } else {
            $article->kozoKbn = '';
        }

        if($mansion->construction_sub == 1) {
            $article->kozoKbnIchibu = '03';
        } elseif($mansion->construction_sub == 3) {
            $article->kozoKbnIchibu = '04';
        } elseif($mansion->construction_sub == 4) {
            $article->kozoKbnIchibu = '01';
        } elseif($mansion->construction_sub == 5) {
            $article->kozoKbnIchibu = '02';
        } elseif($mansion->construction_sub == 6) {
            $article->kozoKbnIchibu = '06';
        } elseif($mansion->construction_sub == 7) {
            $article->kozoKbnIchibu = '07';
        } elseif($mansion->construction_sub == 8) {
            $article->kozoKbnIchibu = '05';
        } elseif($article->construction_sub == 9) {
            $article->kozoKbnIchibu = '08';
        } else {
            $article->kozoKbnIchibu = '10';
        }

        // 施工会社
        $article->sekoKaishaNm = $mansion->construction_company;
        
        // 建物階建て
        $article->chijokaidate = $article->floor;
        $article->chikakaidate = $article->underground;

        // 所在階
        $article->shozaiKaiComment = $article->whereabouts;

        // 部屋番号
        $article->heyaNo = $article->room_num;

        // 専有面積
        $article->senyumensekiKbn = $article->total_area;
        $total_area = $article->total_area_val??'0.0';
        $total_area_list = explode('.', $total_area);
        $article->senyumensekiMinS = $total_area_list[0]??'';
        $article->senyumensekiMinL = $total_area_list[1]??'';

        // 間取り
        $article->madoriMin = $article->floor_plan;
        if($article->floor_plan_type == 1) {
            $article->madoriMinType1Kbn = '03';
        } elseif($article->floor_plan_type == 2) {
            $article->madoriMinType1Kbn = '04';
        } elseif($article->floor_plan_type == 3) {
            $article->madoriMinType1Kbn = '01';
        } elseif($article->floor_plan_type == 4) {
            $article->madoriMinType1Kbn = '02';
        } elseif($article->floor_plan_type == 7) {
            $article->madoriMinType1Kbn = '05';
        } else {
            $article->madoriMinType1Kbn = '00';
        }

        // バルコニー
        $article->balUmu = $article->balcony_area;
        $balcony_area = $article->balcony_area_val??'0.0';
        $balcony_area_list = explode('.', $balcony_area);
        $article->balMensekiMinS = $balcony_area_list[0]??'';
        $article->balMensekiMinL = $balcony_area_list[1]??'';

        // ルーフバルコニー
        $loof_balcony_area = $article->loof_balcony_area_val??'0.0';
        $loof_balcony_area_list = explode('.', $loof_balcony_area);
        $article->roofBalMensekiMinS = $loof_balcony_area_list[0]??'';
        $article->roofBalMensekiMinL = $loof_balcony_area_list[1]??'';
        $article->roofBalRyoMin = $article->loof_balcony_area_cost??'';
        $article->roofBalRyoTaniKbn = $article->loof_balcony_area_unit;

        // 専用庭
        $garden_area = $article->garden_area_val??'0.0';
        $garden_area_list = explode('.', $garden_area);
        $article->senyoNiwaMensekiMinS = $garden_area_list[0]??'';
        $article->senyoNiwaMensekiMinL = $garden_area_list[1]??'';
        $article->senyoNiwaRyoMin = $article->garden_area_cost??'';
        $article->senyoNiwaRyoTaniKbn = $article->garden_area_unit;

        // テラス
        $terrace_area = $article->terrace_area_val??'0.0';
        $terrace_area_list = explode('.', $terrace_area);
        $article->terraceMensekiMinS = $terrace_area_list[0]??'';
        $article->terraceMensekiMinL = $terrace_area_list[1]??'';
        $article->terraceRyoMin = $article->terrace_area_cost??'';
        $article->terraceRyoTaniKbn = $article->terrace_area_unit;

        // 総戸数
        $article->soKosu = $mansion->total_unit??'';

        // 入居予定
        if($article->move_in == 1) {
            $article->nyukyoJikiKbn = '1';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 2) {
            $article->nyukyoJikiKbn = '4';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        } elseif($article->move_in == 3) {
            $article->nyukyoJikiKbn = '2';
            $article->nyukyoJikiNen = $article->move_in_year;
            $article->nyukyoJikiTsuki = $article->move_in_month;
            $article->nyukyoJikiTsukiSu = '';
        }  elseif($article->move_in == 4) {
            $article->nyukyoJikiKbn = '3';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = $article->move_in_contract_month;
        } else {
            $article->nyukyoJikiKbn = '';
            $article->nyukyoJikiNen = '';
            $article->nyukyoJikiTsuki = '';
            $article->nyukyoJikiTsukiSu = '';
        }

        //リフォーム
        if($article->exterior == 1) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = '';
            $article->gaisoTsuki = '';
        } elseif($article->exterior == 2) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        } elseif($article->exterior == 3) {
            $article->gaisoUmu = $article->exterior;
            $article->gaisoNen = $article->exterior_year;
            $article->gaisoTsuki = $article->exterior_month;
        }

        if($article->interior == 1) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = '';
            $article->naisoTsuki = '';
        } elseif($article->interior == 2) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        } elseif($article->interior == 3) {
            $article->naisoUmu = $article->interior;
            $article->naisoNen = $article->interior_year;
            $article->naisoTsuki = $article->interior_month;
        }

        // 5.会社情報
        if($article->company_manner == 1) {
            $article->torihikitaiyoKbn01 = '01';
        } elseif($article->company_manner == 2) {
            $article->torihikitaiyoKbn01 = '13';
        } elseif($article->company_manner == 3) {
            $article->torihikitaiyoKbn01 = '09';
        } elseif($article->company_manner == 4) {
            $article->torihikitaiyoKbn01 = '10';
        } elseif($article->company_manner == 5) {
            $article->torihikitaiyoKbn01 = '11';
        } elseif($article->company_manner == 6) {
            $article->torihikitaiyoKbn01 = '07';
        } elseif($article->company_manner == 7) {
            $article->torihikitaiyoKbn01 = '08';
        } elseif($article->company_manner == 8) {
            $article->torihikitaiyoKbn01 = '09';
        } else {
            $article->torihikitaiyoKbn01 = '';
        }

        // 6.制限事項
        $law_check = RelationLawrestriction::getDataByArticleId($article->building_id);
        foreach($law_check as $law) {
            if($law == 1) {
                $article->hriSgnHoBunkazai = 1;
                
            } elseif($law == 2) {
                $article->hriSgnHoKotohogo = 1;
                
            } elseif($law == 3) {
                $article->hriSgnHoKeikan = 1;
                
            } elseif($law == 4) {
                $article->hriSgnHoMisshuSgcSeibi = 1;
                
            } elseif($law == 5) {
                $article->hriSgnHoKoku = 1;
                
            } elseif($law == 6) {
                $article->hriSgnHoKasen = 1;
                
            } elseif($law == 7) {
                $article->hriSgnHoSabo = 1;
                
            } elseif($law == 8) {
                $article->hriSgnHoNochi = 1;
                
            } elseif($law == 9) {
                $article->hriSgnHoAnzenJorei = 1;
                
            } elseif($law == 10) {
                $article->hriSgnChiTakuzokisei = 1;
                
            } elseif($law == 11) {
                $article->hriSgnChiKyukeishachi = 1;
                
            } elseif($law == 12) {
                $article->hriSgnChiKodochiku = 1;
                
            } elseif($law == 13) {
                $article->hriSgnChiKodoriyo = 1;
                
            } elseif($law == 14) {
                $article->hriSgnChiChukosoJutaku = 1;
                
            } elseif($law == 15) {
                $article->hriSgnChiKosojutakuYudo = 1;
                
            } elseif($law == 16) {
                $article->hriSgnChiBoka = 1;
                
            } elseif($law == 17) {
                $article->hriSgnChiJunboka = 1;
                
            } elseif($law == 18) {
                $article->hriSgnChiFuchi = 1;
                
            } elseif($law == 19) {
                $article->hriSgnChiKeikan = 1;
                
            } elseif($law == 20) {
                $article->hriSgnChiJunKeikan = 1;
                
            } elseif($law == 21) {
                $article->hriSgnChiKanko = 1;
                
            } elseif($law == 22) {
                $article->hriSgnChiRekishi = 1;
                
            } elseif($law == 23) {
                $article->hriSgnChiDento = 1;
                
            } elseif($law == 24) {
                $article->hriSgnChiTokuteiGaiku = 1;
                
            } elseif($law == 25) {
                $article->hriSgnChiTokubetsuYoto = 1;
                
            } elseif($law == 26) {
                $article->hriSgnChiBunkyo = 1;
                
            } elseif($law == 27) {
                $article->hriSgnChiToshisaisei = 1;
                
            } elseif($law == 28) {
                $article->hriSgnChiTokubetsuRyokuchi = 1;
                
            } elseif($law == 29) {
                $article->hriSgnTateTakasaMax = 1;
                
            } elseif($law == 30) {
                $article->hriSgnTateTakasaMin = 1;
                
            } elseif($law == 31) {
                $article->hriSgnTateKenpeiMin = 1;
                
            } elseif($law == 32) {
                $article->hriSgnTateYosekiMin = 1;
                
            } elseif($law == 33) {
                $article->hriSgnTateSktMnsMax = 1;
                
            } elseif($law == 34) {
                $article->hriSgnTateSktMnsMin = 1;
                
            } elseif($law == 35) {
                $article->hriSgnTateMnsMax = 1;
                
            } elseif($law == 36) {
                $article->hriSgnTateMnsMin = 1;
            }
        }

        // その他制限事項
        $article->kckKjn43joTadashigakiKbn = $article->other_reason;
        $article->sgnJikoComment = $article->other_comment;

        // 7.投資用・事業用
        if($article->classfication ==1) {
            $article->jigKbn = 0;
            $article->jigComment = '';
        } else {
            $article->jigKbn = 1;
            if($article->use_method == 1) {
                $article->jigYotoKbn = '07';
                $article->jigComment = '';
            } elseif($article->use_method == 2) {
                $article->jigYotoKbn = '08';
                $article->jigComment = '';
            } elseif($article->use_method == 3) {
                $article->jigYotoKbn = '09';
                $article->jigComment = '';
            } elseif($article->use_method == 4) {
                $article->jigYotoKbn = '01';
                $article->jigComment = '';
            } elseif($article->use_method == 5) {
                $article->jigYotoKbn = '02';
                $article->jigComment = '';
            } elseif($article->use_method == 6) {
                $article->jigYotoKbn = '06';
                $article->jigComment = '';
            } elseif($article->use_method == 7) {
                $article->jigYotoKbn = '04';
                $article->jigComment = '';
            } elseif($article->use_method == 8) {
                $article->jigYotoKbn = '03';
                $article->jigComment = '';
            } elseif($article->use_method == 9) {
                $article->jigYotoKbn = '99';
                $article->jigComment = $article->use_method_text;
            }
        }

        // 10.イベント情報
        

        return $article;

    }

    function saveLand($article) {
        // 物件登録画面へアクセス 土地1区画
        $url = "https://manager.suumo.jp/chukai/tn01Xx0104.do";

        // 土地1区画
        $POST_DATA = array(
            'TB' => 12,
            'BKTB' => 10,
            'hanKubun' => '1T',
            
        );
        if($article->suumo_no != null) {
            $POST_DATA['bukkenCd'] = $article->suumo_no;
        }

        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // cURLセッション実行結果の解析
        $pattern = '/<form name="tn01Xx0104ActionForm" id="mainForm" method="post" action="\/chukai\/tn01Xx0104\/" enctype="multipart\/form-data">(.*?) <\/form><form name="bukkenIdoKeidoCache">/s';
        preg_match($pattern, $res, $match1);
        $pattern = '/<input type="hidden" name="(.*?)" value="(.*?)".*?>/';
        preg_match_all($pattern, $match1[1], $match2);

        $POST_DATA = [
            "org.apache.struts.taglib.html.TOKEN" => $match2[2][0],
            "TB" => "12",
            "bukkenCd" => $match2[2][2],
            "hanKubun" => "1T",
            "bukkenShuCtg" => "3",
            "hanbaiKosuHanteiFlg" => "1",
            "gazoBukkenCd" => "",
            "motodukeHanbaijokyoflg" => "0",
            "bnjChuKbn" => "2",
            "kisBknKbn" => "1",
            "krCmR2date" => $match2[2][10],
            "jjt" => "",
            "hatchuGazoId" => "",
            "hatchuGazoCtgKbn" => "",
            "warekiSeireki" => "",
            "warekiHayamiUrl" => "/tn/edit/kaisha/wareki_seireki.html",
            "krNyukoKbn" => "00",
            "btobSakimonoBknFlg" => "0",
            "btobMotodukeBknFlg" => "0",
            "kissSetteiYohiFlg" => "0",
            "kissSetteiStatus" => "0",
            "settingChangeFlg" => "",
            "cmSts" => "0",
            "cmKokaiFlg" => "0",
            "panoramaNyukozumiFlg" => "0",
            "panoramaURL" => "",
            "projectCd" => $match2[2][26],
            "datePicker" => $match2[2][27],
            "roleCd" => "0",
            "singleGazoTotalSize" => "0",
            "gaiyouGamenKbn" => "1",
            "upBkCd" => $match2[2][31],
            "upAreaCd" => "060",
            "upRegId" => "Tn01Xx0104",
            "kotoriBukkenShuCd" => "31",
            "bukkenNm1" => $article->bukkenNm1,
            "toiawaseComment" => "",
            "toiawaseTelShigai" => "",
            "toiawaseTelShinai" => "",
            "toiawaseTelNo" => "",
            "toiawaseHosokuComment" => "",
            "yubinbango01" => "",
            "yubinbango02" => "",
            "comment" => "",
            "todofukenCd" => "28",
            "shikugunCd" => "225",
            "ooazaCd" => "015",
            "azaCd" => "000",
            "todofukenNm" => "兵庫県",
            "shikugunNm" => "朝来市",
            "ooazaNm" => "伊由市場",
            "azaNm" => "　",
            "jushoMatsubi" => "bbbb",
            "gaikuGotoNm" => "",
            "ido" => "",
            "keido" => "",
            "tenpoJusho" => "",
            "copyright" => "",
            "denshaBusKb1" => "1",
            "ensenNm1" => "地下鉄御堂筋線",
            "ensenCd1" => "2000",
            "ekiNm1" => "江坂",
            "ekiCd1" => "04840",
            "kotsuKbn1" => "1",
            "tohoJikan1" => "2",
            "busJikan1" => "",
            "busTei1" => "",
            "teihoJikan1" => "",
            "kurumaKyori1Integer" => "",
            "kurumaKyori1Decimal" => "",
            "denshaBusKb2" => "1",
            "ensenNm2" => "",
            "ensenCd2" => "",
            "ekiNm2" => "",
            "ekiCd2" => "",
            "tohoJikan2" => "",
            "busJikan2" => "",
            "busTei2" => "",
            "teihoJikan2" => "",
            "kurumaKyori2Integer" => "",
            "kurumaKyori2Decimal" => "",
            "denshaBusKb3" => "1",
            "ensenNm3" => "",
            "ensenCd3" => "",
            "ekiNm3" => "",
            "ekiCd3" => "",
            "tohoJikan3" => "",
            "busJikan3" => "",
            "busTei3" => "",
            "teihoJikan3" => "",
            "kurumaKyori3Integer" => "",
            "kurumaKyori3Decimal" => "",
            "staffCd" => "",
            "kisStaffShimeiKnj" => "",
            "senTakuHenSyu" => "2",
            "kishaEigyoMei" => $article->kishaEigyoMei,
            "staffComment" => $article->staffComment,
            "kishaTantoNm" => "",
            "kishaBukkenCd" => "",
            "kishaComment1" => $article->kishaComment1,
            "kishaComment2" => $article->kishaComment2,
            "ikkatsuKishaBknCd" => "",
            "hpLinkNm1" => "",
            "hpLinkUrl1" => "",
            "hpLinkNm2" => "",
            "hpLinkUrl2" => "",
            "hpLinkNm3" => "",
            "hpLinkUrl3" => "",
            "hpLinkNm4" => "",
            "hpLinkUrl4" => "",
            "hpLinkNm5" => "",
            "hpLinkUrl5" => "",
            "kakakuMin" => $article->price,
            "chokaihiKbn" => $article->chokaihiKbn,
            "chokaihiRyo" => $article->chokaihiRyo,
            "chokaihiRyoTaniKbn" => $article->chokaihiRyoTaniKbn,
            "onsenKenKbn" => $article->onsenKenKbn,
            "onsenKenRyoUmu" => $article->onsenKenRyoUmu,
            "onsenKenRyo" => $article->onsenKenRyo,
            "onsenKenRyoTaniKbn" => $article->onsenKenRyoTaniKbn,
            "sonota01Nm" => $article->another_cost_name1??'',
            "sonotaRyo01Min" => $article->another_cost1??'',
            "sonotaRyo01TaniKbn" => $article->another_cost_unit1??'0',
            "sonota02Nm" => $article->another_cost_name2??'',
            "sonotaRyo02Min" => $article->another_cost2??'',
            "sonotaRyo02TaniKbn" => $article->another_cost_unit2??'0',
            "shikichiKenri" => $article->shikichiKenri,
            "chidaiMin" => "",
            "chidaiTaniKbn" => "1",
            "shakuchiKikanNen" => "",
            "shakuchiKikanTsuki" => "",
            "shakuchikenWariaiMin" => "",
            "kenrikinMin" => "",
            "hoshokinShikikinMin" => "",
            "shikikinMin" => "",
            "tisSonotaKeiyakuJoko" => "",
            "tisSetteiToki" => "0",
            "tisChinryoKaiteijikiKbn" => "0",
            "tisChinryoKaiteijiki" => "",
            "tisChinryoKaiteigakuKbn" => "0",
            "tisJttKahiKbn" => "0",
            "tisJttShodakuYohiKbn" => "0",
            "tisJttShodakuryoKbn" => "0",
            "tisJttShodakunushiKbn" => "0",
            "tochiMensekiKbn" => $article->tochiMensekiKbn??'0',
            "tochiMensekiMinS" => $article->tochiMensekiMinS??null,
            "tochiMensekiMinL" => $article->tochiMensekiMinL??null,
            "keishaMensekiMinS" => $article->keishaMensekiMinS??'',
            "keishaMensekiMinL" => $article->keishaMensekiMinL??'',
            "keishaMensekiMinTaniKbn" => $article->keishaMensekiMinTaniKbn??'0',
            "shikichiEnchoMinS" => $article->shikichiEnchoMinS??'',
            "shikichiEnchoMinL" => $article->shikichiEnchoMinL??'',
            "shikichiEnchoMinTaniKbn" => $article->shikichiEnchoMinTaniKbn??'0',
            "koatsuMensekiMinS" => $article->koatsuMensekiMinS??'',
            "koatsuMensekiMinL" => $article->koatsuMensekiMinL??'',
            "tochiJokyoKbn" => $article->tochiJokyoKbn??'0',
            "zoseiKanryoYoteiNen" => $article->zoseiKanryoYoteiNen??'',
            "zoseiKanryoYoteiTsuki" => $article->zoseiKanryoYoteiTsuki??'',
            "nyukyoJikiKbn" => $article->nyukyoJikiKbn??'',
            "nyukyoJikiNen" => $article->nyukyoJikiNen??'',
            "nyukyoJikiTsuki" => $article->nyukyoJikiTsuki??'',
            "nyukyoJikiJunKbn" => $article->nyukyoJikiJunKbn??'0',
            "kenchikuJokenUmuKbn" => $article->kenchikuJokenUmuKbn,
            "tatemonoKakaku" => $article->tatemonoKakaku,
            "tatemonoMensekiS" => $article->tatemonoMensekiS,
            "tatemonoMensekiL" => $article->tatemonoMensekiL,
            "chimokuKbn" => $article->chimokuKbn,
            "chimokuSntComment" => $article->chimokuSntComment,
            "kenpeiritsu" => $article->kenpeiritsu,
            "yosekiritsu" => $article->yosekiritsu,
            "shidoFutanKbn" => $article->shidoFutanKbn,
            "shidoFutanMensekiMinS1" => $article->shidoFutanMensekiMinS1,
            "shidoFutanMensekiMinL1" => $article->shidoFutanMensekiMinL1,
            "shidoFutanMensekiMinS2" => $article->shidoFutanMensekiMinS2,
            "shidoFutanMensekiMinL2" => $article->shidoFutanMensekiMinL2,
            "shidoFutanBunshiMinS" => $article->shidoFutanBunshiMinS,
            "shidoFutanBunshiMinL" => $article->shidoFutanBunshiMinL,
            "shidoFutanBunboMinS" => $article->shidoFutanBunboMinS,
            "shidoFutanBunboMinL" => $article->shidoFutanBunboMinL,
            "chiekikenKbn" => $article->chiekikenKbn,
            "chiekikenMensekiS" => $article->chiekikenMensekiS,
            "chiekikenMensekiL" => $article->chiekikenMensekiL,
            "doroMukiKbn1" => $article->doroMukiKbn1,
            "doroWidth1S" => $article->doroWidth1S,
            "doroWidth1L" => $article->doroWidth1L,
            "setsudoWidth1S" => $article->setsudoWidth1S,
            "setsudoWidth1L" => $article->setsudoWidth1L,
            "doroMukiKbn2" => $article->doroMukiKbn2,
            "doroWidth2S" => $article->doroWidth2S,
            "doroWidth2L" => $article->doroWidth2L,
            "setsudoWidth2S" => $article->setsudoWidth2S,
            "setsudoWidth2L" => $article->setsudoWidth2L,
            "doroMukiKbn3" => $article->doroMukiKbn3,
            "doroWidth3S" => $article->doroWidth3S,
            "doroWidth3L" => $article->doroWidth3L,
            "setsudoWidth3S" => $article->setsudoWidth3S,
            "setsudoWidth3L" => $article->setsudoWidth3L,
            "setsubiJosuidoKbn" => $article->setsubiJosuidoKbn,
            "setsubiGesuidoKbn" => $article->setsubiGesuidoKbn,
            "setsubiGasKbn" => $article->setsubiGasKbn,
            "shakoKbn" => $article->shakoKbn,
            "setbackKbn" => $article->setbackKbn,
            "setbackMensekiMinS" => $article->setbackMensekiMinS,
            "setbackMensekiMinL" => $article->setbackMensekiMinL,
            "yotochiikiCd01" => $article->yotochiikiCd01,
            "yotochiikiCd02" => $article->yotochiikiCd02,
            "soKosu" => $article->soKosu,
            "kenchikuKyokaKbn" => "0",
            "kaishaDispSeq01" => "",
            "torihikitaiyoKbn01" => "01",
            "torihikitaiyoComment01" => "",
            "hoshiMarkKbn" => "0",
            "motoGyoshaNm" => "",
            "motoGyoshaTelShigai" => "",
            "motoGyoshaTelShinai" => "",
            "motoGyoshaTelNo" => "",
            "motoGyoshaTantoNm" => "",
            "kissFreeKbn01" => "0",
            "dispKaishaNm01" => "ウィル不動産販売 宝塚本店(株)ウィル",
            "kaishaCd01" => "068892",
            "mdgCd01" => "000",
            "kaishaYubinbango01" => "6650035",
            "kaishaJusho01" => "兵庫県宝塚市逆瀬川1-14-6",
            "shozokuDantai101" => "",
            "menkyoBangoComment01" => "国土交通大臣(4)第006447号",
            "kaishaNm01" => "ウィル不動産販売 宝塚本店(株)ウィル",
            "kaishaDispSeq02" => "",
            "kissFreeKbn02" => "0",
            "dispKaishaNm02" => "",
            "kaishaCd02" => "",
            "mdgCd02" => "",
            "kaishaDispSeq03" => "",
            "kissFreeKbn03" => "0",
            "dispKaishaNm03" => "",
            "kaishaCd03" => "",
            "mdgCd03" => "",
            "kaishaDispSeq04" => "",
            "kissFreeKbn04" => "0",
            "dispKaishaNm04" => "",
            "kaishaCd04" => "",
            "mdgCd04" => "",
            "kaishaDispSeq05" => "",
            "kissFreeKbn05" => "0",
            "dispKaishaNm05" => "",
            "kaishaCd05" => "",
            "mdgCd05" => "",
            "kaishaDispSeq06" => "",
            "kissFreeKbn06" => "0",
            "dispKaishaNm06" => "",
            "kaishaCd06" => "",
            "mdgCd06" => "",
            "kaishaDispSeq07" => "",
            "kissFreeKbn07" => "0",
            "dispKaishaNm07" => "",
            "kaishaCd07" => "",
            "mdgCd07" => "",
            "kaishaDispSeq08" => "",
            "kissFreeKbn08" => "0",
            "dispKaishaNm08" => "",
            "kaishaCd08" => "",
            "mdgCd08" => "",
            "kaishaDispSeq09" => "",
            "kissFreeKbn09" => "0",
            "dispKaishaNm09" => "",
            "kaishaCd09" => "",
            "mdgCd09" => "",
            "kaishaDispSeq10" => "",
            "kissFreeKbn10" => "0",
            "dispKaishaNm10" => "",
            "kaishaCd10" => "",
            "mdgCd10" => "",
            "kaishaDispSeq11" => "",
            "kissFreeKbn11" => "0",
            "dispKaishaNm11" => "",
            "kaishaCd11" => "",
            "mdgCd11" => "",
            "kaishaDispSeq12" => "",
            "kissFreeKbn12" => "0",
            "dispKaishaNm12" => "",
            "kaishaCd12" => "",
            "mdgCd12" => "",
            "kaishaDispSeq13" => "",
            "kissFreeKbn13" => "0",
            "dispKaishaNm13" => "",
            "kaishaCd13" => "",
            "mdgCd13" => "",
            "kaishaDispSeq14" => "",
            "kissFreeKbn14" => "0",
            "dispKaishaNm14" => "",
            "kaishaCd14" => "",
            "mdgCd14" => "",
            "kaishaDispSeq15" => "",
            "kissFreeKbn15" => "0",
            "dispKaishaNm15" => "",
            "kaishaCd15" => "",
            "mdgCd15" => "",
            "kckKjn43joTadashigakiKbn" => "0",
            "kenchikuKyokaComment" => "",
            "sgnJikoComment" => $article->sgnJikoComment,
            "jigKbn" => $article->jigKbn,
            "jigComment" => $article->jigComment,
            "jigToshiShunyu" => "",
            "jigToshiShunyuTaniKbn" => "1",
            "jigToshiNenRimawariS" => "",
            "jigToshiNenRimawariL" => "",
            "cmMaBknPictList[0].pictCtgCd" => "05",
            "cmMaBknPictList[0].pictNm" => "地盤調査済",
            "cmMaBknPictList[0].chukoFlg" => "",
            "cmMaBknPictList[0].pictCd" => "353",
            "cmMaBknPictList[0].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[0].kskJknFlg" => "1",
            "cmMaBknPictList[0].masterSeq" => "00028",
            "cmMaBknPictList[1].pictCtgCd" => "05",
            "cmMaBknPictList[1].pictNm" => "土地100坪以上",
            "cmMaBknPictList[1].chukoFlg" => "",
            "cmMaBknPictList[1].pictCd" => "399",
            "cmMaBknPictList[1].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[1].kskJknFlg" => "0",
            "cmMaBknPictList[1].masterSeq" => "00039",
            "cmMaBknPictList[2].pictCtgCd" => "05",
            "cmMaBknPictList[2].pictNm" => "土地50坪以上",
            "cmMaBknPictList[2].chukoFlg" => "",
            "cmMaBknPictList[2].pictCd" => "225",
            "cmMaBknPictList[2].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[2].kskJknFlg" => "0",
            "cmMaBknPictList[2].masterSeq" => "00040",
            "cmMaBknPictList[3].pictCtgCd" => "05",
            "cmMaBknPictList[3].pictNm" => "市街地が近い",
            "cmMaBknPictList[3].chukoFlg" => "",
            "cmMaBknPictList[3].pictCd" => "664",
            "cmMaBknPictList[3].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[3].kskJknFlg" => "0",
            "cmMaBknPictList[3].masterSeq" => "00055",
            "cmMaBknPictList[4].pictCtgCd" => "05",
            "cmMaBknPictList[4].pictNm" => "避暑地",
            "cmMaBknPictList[4].chukoFlg" => "",
            "cmMaBknPictList[4].pictCd" => "658",
            "cmMaBknPictList[4].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[4].kskJknFlg" => "0",
            "cmMaBknPictList[4].masterSeq" => "00056",
            "cmMaBknPictList[5].pictCtgCd" => "05",
            "cmMaBknPictList[5].pictNm" => "南側道路面す",
            "cmMaBknPictList[5].chukoFlg" => "",
            "cmMaBknPictList[5].pictCd" => "003",
            "cmMaBknPictList[5].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[5].kskJknFlg" => "1",
            "cmMaBknPictList[5].masterSeq" => "00069",
            "cmMaBknPictList[6].pictCtgCd" => "05",
            "cmMaBknPictList[6].pictNm" => "閑静な住宅地",
            "cmMaBknPictList[6].chukoFlg" => "",
            "cmMaBknPictList[6].pictCd" => "097",
            "cmMaBknPictList[6].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[6].kskJknFlg" => "0",
            "cmMaBknPictList[6].masterSeq" => "00070",
            "cmMaBknPictList[7].pictCtgCd" => "05",
            "cmMaBknPictList[7].pictNm" => "前道６ｍ以上",
            "cmMaBknPictList[7].chukoFlg" => "",
            "cmMaBknPictList[7].pictCd" => "173",
            "cmMaBknPictList[7].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[7].kskJknFlg" => "1",
            "cmMaBknPictList[7].masterSeq" => "00073",
            "cmMaBknPictList[8].pictCtgCd" => "05",
            "cmMaBknPictList[8].pictNm" => "角地",
            "cmMaBknPictList[8].chukoFlg" => "",
            "cmMaBknPictList[8].pictCd" => "210",
            "cmMaBknPictList[8].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[8].kskJknFlg" => "1",
            "cmMaBknPictList[8].masterSeq" => "00074",
            "cmMaBknPictList[9].pictCtgCd" => "05",
            "cmMaBknPictList[9].pictNm" => "整形地",
            "cmMaBknPictList[9].chukoFlg" => "",
            "cmMaBknPictList[9].pictCd" => "095",
            "cmMaBknPictList[9].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[9].kskJknFlg" => "1",
            "cmMaBknPictList[9].masterSeq" => "00077",
            "cmMaBknPictList[10].pictCtgCd" => "05",
            "cmMaBknPictList[10].pictNm" => "緑豊かな住宅地",
            "cmMaBknPictList[10].chukoFlg" => "",
            "cmMaBknPictList[10].pictCd" => "096",
            "cmMaBknPictList[10].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[10].kskJknFlg" => "0",
            "cmMaBknPictList[10].masterSeq" => "00122",
            "cmMaBknPictList[11].pictCtgCd" => "05",
            "cmMaBknPictList[11].pictNm" => "都市近郊",
            "cmMaBknPictList[11].chukoFlg" => "",
            "cmMaBknPictList[11].pictCd" => "659",
            "cmMaBknPictList[11].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[11].kskJknFlg" => "0",
            "cmMaBknPictList[11].masterSeq" => "00123",
            "cmMaBknPictList[12].pictCtgCd" => "05",
            "cmMaBknPictList[12].pictNm" => "前面棟無",
            "cmMaBknPictList[12].chukoFlg" => "",
            "cmMaBknPictList[12].pictCd" => "130",
            "cmMaBknPictList[12].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[12].kskJknFlg" => "1",
            "cmMaBknPictList[12].masterSeq" => "00124",
            "cmMaBknPictList[13].pictCtgCd" => "05",
            "cmMaBknPictList[13].pictNm" => "高台に立地",
            "cmMaBknPictList[13].chukoFlg" => "",
            "cmMaBknPictList[13].pictCd" => "007",
            "cmMaBknPictList[13].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[13].kskJknFlg" => "1",
            "cmMaBknPictList[13].masterSeq" => "00147",
            "cmMaBknPictList[14].pictCtgCd" => "05",
            "cmMaBknPictList[14].pictNm" => "大型タウン内",
            "cmMaBknPictList[14].chukoFlg" => "",
            "cmMaBknPictList[14].pictCd" => "314",
            "cmMaBknPictList[14].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[14].kskJknFlg" => "0",
            "cmMaBknPictList[14].masterSeq" => "00150",
            "cmMaBknPictList[15].pictCtgCd" => "05",
            "cmMaBknPictList[15].pictNm" => "平坦地",
            "cmMaBknPictList[15].chukoFlg" => "",
            "cmMaBknPictList[15].pictCd" => "127",
            "cmMaBknPictList[15].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[15].kskJknFlg" => "1",
            "cmMaBknPictList[15].masterSeq" => "00154",
            "cmMaBknPictList[16].pictCtgCd" => "05",
            "cmMaBknPictList[16].pictNm" => "開発分譲地内",
            "cmMaBknPictList[16].chukoFlg" => "",
            "cmMaBknPictList[16].pictCd" => "662",
            "cmMaBknPictList[16].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[16].kskJknFlg" => "0",
            "cmMaBknPictList[16].masterSeq" => "00160",
            "cmMaBknPictList[17].pictCtgCd" => "05",
            "cmMaBknPictList[17].pictNm" => "区画整理地内",
            "cmMaBknPictList[17].chukoFlg" => "",
            "cmMaBknPictList[17].pictCd" => "091",
            "cmMaBknPictList[17].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[17].kskJknFlg" => "0",
            "cmMaBknPictList[17].masterSeq" => "00164",
            "cmMaBknPictList[18].pictCtgCd" => "06",
            "cmMaBknPictList[18].pictNm" => "２沿線以上利用可",
            "cmMaBknPictList[18].chukoFlg" => "",
            "cmMaBknPictList[18].pictCd" => "692",
            "cmMaBknPictList[18].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[18].kskJknFlg" => "1",
            "cmMaBknPictList[18].masterSeq" => "00037",
            "cmMaBknPictList[19].pictCtgCd" => "06",
            "cmMaBknPictList[19].pictNm" => "駅まで平坦",
            "cmMaBknPictList[19].chukoFlg" => "",
            "cmMaBknPictList[19].pictCd" => "112",
            "cmMaBknPictList[19].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[19].kskJknFlg" => "0",
            "cmMaBknPictList[19].masterSeq" => "00068",
            "cmMaBknPictList[20].pictCtgCd" => "06",
            "cmMaBknPictList[20].pictNm" => "始発駅",
            "cmMaBknPictList[20].chukoFlg" => "",
            "cmMaBknPictList[20].pictCd" => "211",
            "cmMaBknPictList[20].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[20].kskJknFlg" => "1",
            "cmMaBknPictList[20].masterSeq" => "00076",
            "cmMaBknPictList[21].pictCtgCd" => "08",
            "cmMaBknPictList[21].pictNm" => "陽当り良好",
            "cmMaBknPictList[21].chukoFlg" => "",
            "cmMaBknPictList[21].pictCd" => "128",
            "cmMaBknPictList[21].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[21].kskJknFlg" => "0",
            "cmMaBknPictList[21].masterSeq" => "00065",
            "cmMaBknPictList[22].pictCtgCd" => "20",
            "cmMaBknPictList[22].pictNm" => "プール",
            "cmMaBknPictList[22].chukoFlg" => "",
            "cmMaBknPictList[22].pictCd" => "376",
            "cmMaBknPictList[22].pictCtgNm" => "共用部",
            "cmMaBknPictList[22].kskJknFlg" => "0",
            "cmMaBknPictList[22].masterSeq" => "00089",
            "cmMaBknPictList[23].pictCtgCd" => "20",
            "cmMaBknPictList[23].pictNm" => "共用露天風呂",
            "cmMaBknPictList[23].chukoFlg" => "",
            "cmMaBknPictList[23].pictCd" => "655",
            "cmMaBknPictList[23].pictCtgNm" => "共用部",
            "cmMaBknPictList[23].kskJknFlg" => "0",
            "cmMaBknPictList[23].masterSeq" => "00179",
            "cmMaBknPictList[24].pictCtgCd" => "21",
            "cmMaBknPictList[24].pictNm" => "セキュリティ充実",
            "cmMaBknPictList[24].chukoFlg" => "",
            "cmMaBknPictList[24].pictCd" => "691",
            "cmMaBknPictList[24].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[24].kskJknFlg" => "0",
            "cmMaBknPictList[24].masterSeq" => "00090",
            "cmMaBknPictList[25].pictCtgCd" => "21",
            "cmMaBknPictList[25].pictNm" => "２４時間有人管理",
            "cmMaBknPictList[25].chukoFlg" => "",
            "cmMaBknPictList[25].pictCd" => "087",
            "cmMaBknPictList[25].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[25].kskJknFlg" => "0",
            "cmMaBknPictList[25].masterSeq" => "00157",
            "cmMaBknPictList[26].pictCtgCd" => "23",
            "cmMaBknPictList[26].pictNm" => "スキー場が近い",
            "cmMaBknPictList[26].chukoFlg" => "",
            "cmMaBknPictList[26].pictCd" => "671",
            "cmMaBknPictList[26].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[26].kskJknFlg" => "0",
            "cmMaBknPictList[26].masterSeq" => "00051",
            "cmMaBknPictList[27].pictCtgCd" => "23",
            "cmMaBknPictList[27].pictNm" => "ゴルフ場が近い",
            "cmMaBknPictList[27].chukoFlg" => "",
            "cmMaBknPictList[27].pictCd" => "670",
            "cmMaBknPictList[27].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[27].kskJknFlg" => "0",
            "cmMaBknPictList[27].masterSeq" => "00052",
            "cmMaBknPictList[28].pictCtgCd" => "23",
            "cmMaBknPictList[28].pictNm" => "テニスコートが近い",
            "cmMaBknPictList[28].chukoFlg" => "",
            "cmMaBknPictList[28].pictCd" => "669",
            "cmMaBknPictList[28].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[28].kskJknFlg" => "0",
            "cmMaBknPictList[28].masterSeq" => "00053",
            "cmMaBknPictList[29].pictCtgCd" => "23",
            "cmMaBknPictList[29].pictNm" => "スーパー 徒歩10分以内",
            "cmMaBknPictList[29].chukoFlg" => "",
            "cmMaBknPictList[29].pictCd" => "668",
            "cmMaBknPictList[29].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[29].kskJknFlg" => "1",
            "cmMaBknPictList[29].masterSeq" => "00054",
            "cmMaBknPictList[30].pictCtgCd" => "23",
            "cmMaBknPictList[30].pictNm" => "総合病院 徒歩10分以内",
            "cmMaBknPictList[30].chukoFlg" => "",
            "cmMaBknPictList[30].pictCd" => "712",
            "cmMaBknPictList[30].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[30].kskJknFlg" => "1",
            "cmMaBknPictList[30].masterSeq" => "00072",
            "cmMaBknPictList[31].pictCtgCd" => "23",
            "cmMaBknPictList[31].pictNm" => "小学校 徒歩10分以内",
            "cmMaBknPictList[31].chukoFlg" => "",
            "cmMaBknPictList[31].pictCd" => "713",
            "cmMaBknPictList[31].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[31].kskJknFlg" => "1",
            "cmMaBknPictList[31].masterSeq" => "00149",
            "cmMaBknPictList[32].pictCtgCd" => "23",
            "cmMaBknPictList[32].pictNm" => "周辺交通量少なめ",
            "cmMaBknPictList[32].chukoFlg" => "",
            "cmMaBknPictList[32].pictCd" => "667",
            "cmMaBknPictList[32].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[32].kskJknFlg" => "0",
            "cmMaBknPictList[32].masterSeq" => "00183",
            "cmMaBknPictList[33].pictCtgCd" => "23",
            "cmMaBknPictList[33].pictNm" => "整備された歩道",
            "cmMaBknPictList[33].chukoFlg" => "",
            "cmMaBknPictList[33].pictCd" => "673",
            "cmMaBknPictList[33].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[33].kskJknFlg" => "0",
            "cmMaBknPictList[33].masterSeq" => "00185",
            "cmMaBknPictList[34].pictCtgCd" => "24",
            "cmMaBknPictList[34].pictNm" => "リバーサイド",
            "cmMaBknPictList[34].chukoFlg" => "",
            "cmMaBknPictList[34].pictCd" => "311",
            "cmMaBknPictList[34].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[34].kskJknFlg" => "0",
            "cmMaBknPictList[34].masterSeq" => "00045",
            "cmMaBknPictList[35].pictCtgCd" => "24",
            "cmMaBknPictList[35].pictNm" => "オーシャンビュー",
            "cmMaBknPictList[35].chukoFlg" => "",
            "cmMaBknPictList[35].pictCd" => "113",
            "cmMaBknPictList[35].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[35].kskJknFlg" => "0",
            "cmMaBknPictList[35].masterSeq" => "00046",
            "cmMaBknPictList[36].pictCtgCd" => "24",
            "cmMaBknPictList[36].pictNm" => "湖・池が見える",
            "cmMaBknPictList[36].chukoFlg" => "",
            "cmMaBknPictList[36].pictCd" => "674",
            "cmMaBknPictList[36].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[36].kskJknFlg" => "0",
            "cmMaBknPictList[36].masterSeq" => "00049",
            "cmMaBknPictList[37].pictCtgCd" => "24",
            "cmMaBknPictList[37].pictNm" => "山が見える",
            "cmMaBknPictList[37].chukoFlg" => "",
            "cmMaBknPictList[37].pictCd" => "675",
            "cmMaBknPictList[37].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[37].kskJknFlg" => "0",
            "cmMaBknPictList[37].masterSeq" => "00050",
            "cmMaBknPictList[38].pictCtgCd" => "24",
            "cmMaBknPictList[38].pictNm" => "海まで2km以内",
            "cmMaBknPictList[38].chukoFlg" => "",
            "cmMaBknPictList[38].pictCd" => "224",
            "cmMaBknPictList[38].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[38].kskJknFlg" => "0",
            "cmMaBknPictList[38].masterSeq" => "00060",
            "cmMaBknPictList[39].pictCtgCd" => "24",
            "cmMaBknPictList[39].pictNm" => "田園風景",
            "cmMaBknPictList[39].chukoFlg" => "",
            "cmMaBknPictList[39].pictCd" => "312",
            "cmMaBknPictList[39].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[39].kskJknFlg" => "0",
            "cmMaBknPictList[39].masterSeq" => "00083",
            "cmMaBknPictList[40].pictCtgCd" => "24",
            "cmMaBknPictList[40].pictNm" => "眺望良好",
            "cmMaBknPictList[40].chukoFlg" => "",
            "cmMaBknPictList[40].pictCd" => "129",
            "cmMaBknPictList[40].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[40].kskJknFlg" => "0",
            "cmMaBknPictList[40].masterSeq" => "00128",
            "cmMaBknPictList[41].pictCtgCd" => "24",
            "cmMaBknPictList[41].pictNm" => "花火大会鑑賞",
            "cmMaBknPictList[41].chukoFlg" => "",
            "cmMaBknPictList[41].pictCd" => "313",
            "cmMaBknPictList[41].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[41].kskJknFlg" => "0",
            "cmMaBknPictList[41].masterSeq" => "00151",
            "cmMaBknPictList[42].pictCtgCd" => "25",
            "cmMaBknPictList[42].pictNm" => "更地渡し",
            "cmMaBknPictList[42].chukoFlg" => "",
            "cmMaBknPictList[42].pictCd" => "172",
            "cmMaBknPictList[42].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[42].kskJknFlg" => "0",
            "cmMaBknPictList[42].masterSeq" => "00043",
            "cmMaBknPictList[43].pictCtgCd" => "25",
            "cmMaBknPictList[43].pictNm" => "即引渡し可",
            "cmMaBknPictList[43].chukoFlg" => "",
            "cmMaBknPictList[43].pictCd" => "099",
            "cmMaBknPictList[43].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[43].kskJknFlg" => "1",
            "cmMaBknPictList[43].masterSeq" => "00044",
            "cmMaBknPictList[44].pictCtgCd" => "25",
            "cmMaBknPictList[44].pictNm" => "建築条件なし",
            "cmMaBknPictList[44].chukoFlg" => "",
            "cmMaBknPictList[44].pictCd" => "171",
            "cmMaBknPictList[44].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[44].kskJknFlg" => "0",
            "cmMaBknPictList[44].masterSeq" => "00078",
            "cmMaBknPictList[45].pictCtgCd" => "25",
            "cmMaBknPictList[45].pictNm" => "建物プラン例有り",
            "cmMaBknPictList[45].chukoFlg" => "",
            "cmMaBknPictList[45].pictCd" => "598",
            "cmMaBknPictList[45].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[45].kskJknFlg" => "0",
            "cmMaBknPictList[45].masterSeq" => "00161",
            "cmMaBknPictList[46].pictCtgCd" => "26",
            "cmMaBknPictList[46].pictNm" => "温泉付",
            "cmMaBknPictList[46].chukoFlg" => "",
            "cmMaBknPictList[46].pictCd" => "350",
            "cmMaBknPictList[46].pictCtgNm" => "その他",
            "cmMaBknPictList[46].kskJknFlg" => "0",
            "cmMaBknPictList[46].masterSeq" => "00048",
            "cmMaBknPictList[47].pictCtgCd" => "26",
            "cmMaBknPictList[47].pictNm" => "家庭菜園",
            "cmMaBknPictList[47].chukoFlg" => "",
            "cmMaBknPictList[47].pictCd" => "649",
            "cmMaBknPictList[47].pictCtgNm" => "その他",
            "cmMaBknPictList[47].kskJknFlg" => "0",
            "cmMaBknPictList[47].masterSeq" => "00086",
            "cmMaBknPictList[48].pictCtgCd" => "26",
            "cmMaBknPictList[48].pictNm" => "都市ガス",
            "cmMaBknPictList[48].chukoFlg" => "",
            "cmMaBknPictList[48].pictCd" => "677",
            "cmMaBknPictList[48].pictCtgNm" => "その他",
            "cmMaBknPictList[48].kskJknFlg" => "1",
            "cmMaBknPictList[48].masterSeq" => "00141",
            "cmMaBknPictList[49].pictCtgCd" => "26",
            "cmMaBknPictList[49].pictNm" => "温泉引き込み可",
            "cmMaBknPictList[49].chukoFlg" => "",
            "cmMaBknPictList[49].pictCd" => "653",
            "cmMaBknPictList[49].pictCtgNm" => "その他",
            "cmMaBknPictList[49].kskJknFlg" => "0",
            "cmMaBknPictList[49].masterSeq" => "00169",
            "cmMaBknPictList[50].pictCtgCd" => "26",
            "cmMaBknPictList[50].pictNm" => "温泉権利付き",
            "cmMaBknPictList[50].chukoFlg" => "",
            "cmMaBknPictList[50].pictCd" => "657",
            "cmMaBknPictList[50].pictCtgNm" => "その他",
            "cmMaBknPictList[50].kskJknFlg" => "0",
            "cmMaBknPictList[50].masterSeq" => "00171",
            "cmMaBknPictList[51].pictCtgCd" => "26",
            "cmMaBknPictList[51].pictNm" => "集合住宅用地",
            "cmMaBknPictList[51].chukoFlg" => "",
            "cmMaBknPictList[51].pictCd" => "644",
            "cmMaBknPictList[51].pictCtgNm" => "その他",
            "cmMaBknPictList[51].kskJknFlg" => "0",
            "cmMaBknPictList[51].masterSeq" => "00177",
            "netCatch" => "",
            "netComment" => "",
            "eventInfoKbn" => "0",
            "eventScheduleKbn" => "0",
            "kikanEventKaishiDate1" => "",
            "kikanEventShuryoDate1" => "",
            "eventDate11" => "",
            "eventDate12" => "",
            "eventDate13" => "",
            "eventDate14" => "",
            "eventDate15" => "",
            "eventDate16" => "",
            "eventDate17" => "",
            "eventDate18" => "",
            "eventDate19" => "",
            "eventDate110" => "",
            "eventDate111" => "",
            "eventDate112" => "",
            "netEventKaishiTimeH" => "",
            "netEventKaishiTimeM" => "",
            "netEventShuryoTimeH" => "",
            "netEventShuryoTimeM" => "",
            "eventActionKbn" => "0",
            "eventInfo" => "",
            "kkbPicComment" => "",
            "btobHoushukeitai" => "0",
            "btobKokokuhitou" => "0",
            "btobGazoId" => "",
            "btobGazoPtn" => "0",
            "btobMainCatch" => "",
            "btobSubCatch1" => "",
            "btobSubCatch2" => "",
            "btobSubCatch3" => "",
            "btobSubCatch4" => "",
            "btobSubCatch5" => "",
            "btobComment" => "",
            "netRenzokuKeisaiKikan" => "8",
            "maemaegaiHatubaigo" => "11/6号",
            "zengaiHatubaigo" => "11/13号",
            "zenzenKeisaiJyouhouList[0]" => "",
            "zenKeisaiJyouhouList[0]" => "",
        ];

        $url = "https://manager.suumo.jp/chukai/tn01Xx0104/update1T";
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_REFERER, 'https://manager.suumo.jp/chukai/tn01Xx0104.do');
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3', 'Accept-Language: ja,en-US;q=0.9,en;q=0.8', 'Cache-Control: max-age=0', 'Connection: keep-alive', 'Host: manager.suumo.jp', 'Origin: https://manager.suumo.jp', 'Sec-Fetch-Mode: navigate', 'Sec-Fetch-Site: same-origin', 'Sec-Fetch-User: ?1', 'Upgrade-Insecure-Requests: 1']);
        curl_setopt($curl, CURLINFO_HEADER_OUT, TRUE);
        curl_setopt($curl, CURLOPT_MAXREDIRS,10);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_AUTOREFERER,TRUE);//リダイレクトの際にヘッダのRefererを自動的に追加させる
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        if( $res === FALSE ) {
            // エラー文字列を出力する
            echo curl_error($curl);
        }

        $pattern = '/<span class="tar b">物件CD：(.*?)<\/span>/s';
        preg_match($pattern, $res, $match1);
        $save_data = ['suumo_no' => $match1[1]];
        Article::where('building_id', $article->building_id)->update($save_data);
    }

    function saveHouse($article) {
        // 物件登録画面へアクセス 戸建1戸
        $url = "https://manager.suumo.jp/chukai/tn01Xx0104.do";

        // 戸建1戸
        $POST_DATA = array(
            'TB' => 11,
            'BKTB' => 10,
            'hanKubun' => '1K',
        );

        if($article->suumo_no != null) {
            $POST_DATA['bukkenCd'] = $article->suumo_no;
        }

        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // cURLセッション実行結果の解析
        $pattern = '/<form name="tn01Xx0104ActionForm" id="mainForm" method="post" action="\/chukai\/tn01Xx0104\/" enctype="multipart\/form-data">(.*?) <\/form><form name="bukkenIdoKeidoCache">/s';
        preg_match($pattern, $res, $match1);
        $pattern = '/<input type="hidden" name="(.*?)" value="(.*?)".*?>/';
        preg_match_all($pattern, $match1[1], $match2);

        $POST_DATA = [
            "org.apache.struts.taglib.html.TOKEN" => $match2[2][0],
            "TB" => "11",
            "bukkenCd" => $match2[2][2],
            "hanKubun" => "1K",
            "bukkenShuCtg" => "2",
            "hanbaiKosuHanteiFlg" => "1",
            "gazoBukkenCd" => "",
            "motodukeHanbaijokyoflg" => "0",
            "bnjChuKbn" => "2",
            "kisBknKbn" => "1",
            "krCmR2date" => $match2[2][10],
            "jjt" => "",
            "hatchuGazoId" => "",
            "hatchuGazoCtgKbn" => "",
            "warekiSeireki" => "",
            "warekiHayamiUrl" => "/tn/edit/kaisha/wareki_seireki.html",
            "krNyukoKbn" => "00",
            "btobSakimonoBknFlg" => "0",
            "btobMotodukeBknFlg" => "0",
            "kissSetteiYohiFlg" => "0",
            "kissSetteiStatus" => "0",
            "settingChangeFlg" => "",
            "cmSts" => "0",
            "cmKokaiFlg" => "0",
            "panoramaNyukozumiFlg" => "0",
            "panoramaURL" => "",
            "projectCd" => $match2[2][26],
            "datePicker" => $match2[2][27],
            "roleCd" => "0",
            "singleGazoTotalSize" => "0",
            "gaiyouGamenKbn" => "1",
            "upBkCd" => $match2[2][31],
            "upAreaCd" => "060",
            "upRegId" => "Tn01Xx0104",
            "kotoriBukkenShuCd" => "21",
            "bukkenNm1" => $article->bukkenNm1,
            "toiawaseComment" => "",
            "toiawaseTelShigai" => "",
            "toiawaseTelShinai" => "",
            "toiawaseTelNo" => "",
            "toiawaseHosokuComment" => "",
            "yubinbango01" => "",
            "yubinbango02" => "",
            "comment" => "",
            "todofukenCd" => "28",
            "shikugunCd" => "110",
            "ooazaCd" => "001",
            "azaCd" => "001",
            "todofukenNm" => "兵庫県",
            "shikugunNm" => "神戸市中央区",
            "ooazaNm" => "相生町",
            "azaNm" => "１",
            "jushoMatsubi" => "テスト２",
            "gaikuGotoNm" => "",
            "ido" => "",
            "keido" => "",
            "tenpoJusho" => "",
            "copyright" => "",
            "denshaBusKb1" => "1",
            "ensenNm1" => "地下鉄御堂筋線",
            "ensenCd1" => "2000",
            "ekiNm1" => "梅田",
            "ekiCd1" => "04640",
            "kotsuKbn1" => "1",
            "tohoJikan1" => "3",
            "busJikan1" => "",
            "busTei1" => "",
            "teihoJikan1" => "",
            "kurumaKyori1Integer" => "",
            "kurumaKyori1Decimal" => "",
            "denshaBusKb2" => "1",
            "ensenNm2" => "",
            "ensenCd2" => "",
            "ekiNm2" => "",
            "ekiCd2" => "",
            "tohoJikan2" => "",
            "busJikan2" => "",
            "busTei2" => "",
            "teihoJikan2" => "",
            "kurumaKyori2Integer" => "",
            "kurumaKyori2Decimal" => "",
            "denshaBusKb3" => "1",
            "ensenNm3" => "",
            "ensenCd3" => "",
            "ekiNm3" => "",
            "ekiCd3" => "",
            "tohoJikan3" => "",
            "busJikan3" => "",
            "busTei3" => "",
            "teihoJikan3" => "",
            "kurumaKyori3Integer" => "",
            "kurumaKyori3Decimal" => "",
            "staffCd" => "",
            "kisStaffShimeiKnj" => "",
            "senTakuHenSyu" => "2",
            "kishaEigyoMei" => $article->kishaEigyoMei,
            "staffComment" => $article->staffComment,
            "kishaTantoNm" => "",
            "kishaBukkenCd" => "",
            "kishaComment1" => $article->kishaComment1,
            "kishaComment2" => $article->kishaComment2,
            "ikkatsuKishaBknCd" => "",
            "hpLinkNm1" => "",
            "hpLinkUrl1" => "",
            "hpLinkNm2" => "",
            "hpLinkUrl2" => "",
            "hpLinkNm3" => "",
            "hpLinkUrl3" => "",
            "hpLinkNm4" => "",
            "hpLinkUrl4" => "",
            "hpLinkNm5" => "",
            "hpLinkUrl5" => "",
            "kakakuMin" => $article->price,
            "chokaihiKbn" => $article->chokaihiKbn,
            "chokaihiRyo" => $article->chokaihiRyo,
            "chokaihiRyoTaniKbn" => $article->chokaihiRyoTaniKbn,
            "yusenHiyoUmu" => $article->yusenHiyoUmu,
            "yusenShokiHiyo" => $article->yusenShokiHiyo,
            "yusenTeigakuRyo" => $article->yusenTeigakuRyo,
            "yusenTeigakuRyoTaniKbn" => $article->yusenTeigakuRyoTaniKbn,
            "internetHiyoUmu" => $article->internetHiyoUmu,
            "internetShokiHiyo" => $article->internetShokiHiyo,
            "internetTeigakuRyo" => $article->internetTeigakuRyo,
            "internetTeigakuRyoTaniKbn" => $article->internetTeigakuRyoTaniKbn,
            "catvHiyoUmu" => $article->catvHiyoUmu,
            "catvShokiHiyo" => $article->catvShokiHiyo,
            "catvTeigakuRyo" => $article->catvTeigakuRyo,
            "catvTeigakuRyoTaniKbn" => $article->catvTeigakuRyoTaniKbn,
            "onsenKenKbn" => $article->onsenKenKbn,
            "onsenKenRyoUmu" => $article->onsenKenRyoUmu,
            "onsenKenRyo" => $article->onsenKenRyo,
            "onsenKenRyoTaniKbn" => $article->onsenKenRyoTaniKbn,
            "sonota01Nm" => $article->another_cost_name1??'',
            "sonotaRyo01Min" => $article->another_cost1??'',
            "sonotaRyo01TaniKbn" => $article->another_cost_unit1??'0',
            "sonota02Nm" => $article->another_cost_name2??'',
            "sonotaRyo02Min" => $article->another_cost2??'',
            "sonotaRyo02TaniKbn" => $article->another_cost_unit2??'0',
            "shikichiKenri" => $article->shikichiKenri,
            "chidaiMin" => "",
            "chidaiTaniKbn" => "1",
            "shakuchiKikanNen" => "",
            "shakuchiKikanTsuki" => "",
            "shakuchikenWariaiMin" => "",
            "kenrikinMin" => "",
            "hoshokinShikikinMin" => "",
            "shikikinMin" => "",
            "tisSonotaKeiyakuJoko" => "",
            "tisSetteiToki" => "0",
            "tisChinryoKaiteijikiKbn" => "0",
            "tisChinryoKaiteijiki" => "",
            "tisChinryoKaiteigakuKbn" => "0",
            "tisJttKahiKbn" => "0",
            "tisJttShodakuYohiKbn" => "0",
            "tisJttShodakuryoKbn" => "0",
            "tisJttShodakunushiKbn" => "0",
            "tochiMensekiKbn" => $article->tochiMensekiKbn??'0',
            "tochiMensekiMinS" => $article->tochiMensekiMinS??null,
            "tochiMensekiMinL" => $article->tochiMensekiMinL??null,
            "keishaMensekiMinS" => $article->keishaMensekiMinS??'',
            "keishaMensekiMinL" => $article->keishaMensekiMinL??'',
            "keishaMensekiMinTaniKbn" => $article->keishaMensekiMinTaniKbn??'0',
            "shikichiEnchoMinS" => $article->shikichiEnchoMinS??'',
            "shikichiEnchoMinL" => $article->shikichiEnchoMinL??'',
            "shikichiEnchoMinTaniKbn" => $article->shikichiEnchoMinTaniKbn??'0',
            "koatsuMensekiMinS" => $article->koatsuMensekiMinS??'',
            "koatsuMensekiMinL" => $article->koatsuMensekiMinL??'',
            "kenpeiritsu" => $article->kenpeiritsu,
            "yosekiritsu" => $article->yosekiritsu,
            "shidoFutanKbn" => $article->shidoFutanKbn,
            "shidoFutanMensekiMinS1" => $article->shidoFutanMensekiMinS1,
            "shidoFutanMensekiMinL1" => $article->shidoFutanMensekiMinL1,
            "shidoFutanMensekiMinS2" => $article->shidoFutanMensekiMinS2,
            "shidoFutanMensekiMinL2" => $article->shidoFutanMensekiMinL2,
            "shidoFutanBunshiMinS" => $article->shidoFutanBunshiMinS,
            "shidoFutanBunshiMinL" => $article->shidoFutanBunshiMinL,
            "shidoFutanBunboMinS" => $article->shidoFutanBunboMinS,
            "shidoFutanBunboMinL" => $article->shidoFutanBunboMinL,
            "chiekikenKbn" => $article->chiekikenKbn,
            "chiekikenMensekiS" => $article->chiekikenMensekiS,
            "chiekikenMensekiL" => $article->chiekikenMensekiL,
            "doroMukiKbn1" => $article->doroMukiKbn1,
            "doroWidth1S" => $article->doroWidth1S,
            "doroWidth1L" => $article->doroWidth1L,
            "setsudoWidth1S" => $article->setsudoWidth1S,
            "setsudoWidth1L" => $article->setsudoWidth1L,
            "doroMukiKbn2" => $article->doroMukiKbn2,
            "doroWidth2S" => $article->doroWidth2S,
            "doroWidth2L" => $article->doroWidth2L,
            "setsudoWidth2S" => $article->setsudoWidth2S,
            "setsudoWidth2L" => $article->setsudoWidth2L,
            "doroMukiKbn3" => $article->doroMukiKbn3,
            "doroWidth3S" => $article->doroWidth3S,
            "doroWidth3L" => $article->doroWidth3L,
            "setsudoWidth3S" => $article->setsudoWidth3S,
            "setsudoWidth3L" => $article->setsudoWidth3L,
            "setsubiJosuidoKbn" => $article->setsubiJosuidoKbn,
            "setsubiGesuidoKbn" => $article->setsubiGesuidoKbn,
            "setsubiGasKbn" => $article->setsubiGasKbn,
            "setbackKbn" => $article->setbackKbn,
            "setbackMensekiMinS" => $article->setbackMensekiMinS,
            "setbackMensekiMinL" => $article->setbackMensekiMinL,
            "yotochiikiCd01" => $article->yotochiikiCd01,
            "yotochiikiCd02" => $article->yotochiikiCd02,
            "kenchikuKyokaKbn" => "0",
            "tatemonoMnsKbn" => $article->tatemonoMnsKbn,
            "tatemonoMnsMinS" => $article->tatemonoMnsMinS,
            "tatemonoMnsMinL" => $article->tatemonoMnsMinL,
            "uchiChikashitsuMinS" => $article->uchiChikashitsuMinS,
            "uchiChikashitsuMinL" => $article->uchiChikashitsuMinL,
            "uchiShakoMinS" => $article->uchiShakoMinS,
            "uchiShakoMinL" => $article->uchiShakoMinL,
            "uchiChikachuMinS" => $article->uchiChikachuMinS,
            "uchiChikachuMinL" => $article->uchiChikachuMinL,
            "uchiJigYotoKbn" => $article->uchiJigYotoKbn,
            "uchiJigYotoSonota" => "",
            "uchiJigYotoMensekiS" => "",
            "uchiJigYotoMensekiL" => "",
            "madoriMin" => $article->madoriMin,
            "madoriMinType1Kbn" => $article->madoriMinType1Kbn,
            "madoriMinType2Kbn" => "0",
            "soKosu" => $article->soKosu,
            "kanseiJikiNen" => $article->kanseiJikiNen,
            "kanseiJikiTsuki" => $article->kanseiJikiTsuki,
            "kanseiJikiTsukiSu" => $article->kanseiJikiTsukiSu,
            "tatemonoJokyoKbn" => "1",
            "nyukyoJikiNen" => $article->nyukyoJikiNen,
            "nyukyoJikiTsuki" => $article->nyukyoJikiTsuki,
            "nyukyoJikiTsukiSu" => $article->nyukyoJikiTsukiSu,
            "nyukyoJikiKbn" => $article->nyukyoJikiKbn??'',
            "kozoKbn" => $article->kozoKbn,
            "kozoSonotaComment" => "",
            "kozoSonotaCommentIchibu" => "",
            "kozoKbnIchibu" => $article->kozoKbnIchibu,
            "kohoKbn" => "00",
            "kohoSonotaComment" => "",
            "chijokaidate" => $article->chijokaidate,
            "chikakaidate" => $article->chikakaidate,
            "shakoKbn" => $article->shakoKbn,
            "sekoKaishaKbn1" => "0",
            "sekoKaishaNm" => "",
            "sekoKaishaKbn2" => "0",
            "kenchikuKakuninNo" => $article->kenchikuKakuninNo,
            "gaisoUmu" => $article->gaisoUmu,
            "gaisoNen" => $article->gaisoNen,
            "gaisoTsuki" => $article->gaisoTsuki,
            "gaisoComment" => "",
            "naisoUmu" => $article->naisoUmu,
            "naisoNen" => $article->naisoNen,
            "naisoTsuki" => $article->naisoTsuki,
            "naisoComment" => "",
            "kaishaDispSeq01" => "",
            "torihikitaiyoKbn01" => "01",
            "torihikitaiyoComment01" => "",
            "hoshiMarkKbn" => "0",
            "motoGyoshaNm" => "",
            "motoGyoshaTelShigai" => "",
            "motoGyoshaTelShinai" => "",
            "motoGyoshaTelNo" => "",
            "motoGyoshaTantoNm" => "",
            "kissFreeKbn01" => "0",
            "dispKaishaNm01" => "ウィル不動産販売 宝塚本店(株)ウィル",
            "kaishaCd01" => "068892",
            "mdgCd01" => "000",
            "kaishaYubinbango01" => "6650035",
            "kaishaJusho01" => "兵庫県宝塚市逆瀬川1-14-6",
            "shozokuDantai101" => "",
            "menkyoBangoComment01" => "国土交通大臣(4)第006447号",
            "kaishaNm01" => "ウィル不動産販売 宝塚本店(株)ウィル",
            "kaishaDispSeq02" => "",
            "kissFreeKbn02" => "0",
            "dispKaishaNm02" => "",
            "kaishaCd02" => "",
            "mdgCd02" => "",
            "kaishaDispSeq03" => "",
            "kissFreeKbn03" => "0",
            "dispKaishaNm03" => "",
            "kaishaCd03" => "",
            "mdgCd03" => "",
            "kaishaDispSeq04" => "",
            "kissFreeKbn04" => "0",
            "dispKaishaNm04" => "",
            "kaishaCd04" => "",
            "mdgCd04" => "",
            "kaishaDispSeq05" => "",
            "kissFreeKbn05" => "0",
            "dispKaishaNm05" => "",
            "kaishaCd05" => "",
            "mdgCd05" => "",
            "kaishaDispSeq06" => "",
            "kissFreeKbn06" => "0",
            "dispKaishaNm06" => "",
            "kaishaCd06" => "",
            "mdgCd06" => "",
            "kaishaDispSeq07" => "",
            "kissFreeKbn07" => "0",
            "dispKaishaNm07" => "",
            "kaishaCd07" => "",
            "mdgCd07" => "",
            "kaishaDispSeq08" => "",
            "kissFreeKbn08" => "0",
            "dispKaishaNm08" => "",
            "kaishaCd08" => "",
            "mdgCd08" => "",
            "kaishaDispSeq09" => "",
            "kissFreeKbn09" => "0",
            "dispKaishaNm09" => "",
            "kaishaCd09" => "",
            "mdgCd09" => "",
            "kaishaDispSeq10" => "",
            "kissFreeKbn10" => "0",
            "dispKaishaNm10" => "",
            "kaishaCd10" => "",
            "mdgCd10" => "",
            "kaishaDispSeq11" => "",
            "kissFreeKbn11" => "0",
            "dispKaishaNm11" => "",
            "kaishaCd11" => "",
            "mdgCd11" => "",
            "kaishaDispSeq12" => "",
            "kissFreeKbn12" => "0",
            "dispKaishaNm12" => "",
            "kaishaCd12" => "",
            "mdgCd12" => "",
            "kaishaDispSeq13" => "",
            "kissFreeKbn13" => "0",
            "dispKaishaNm13" => "",
            "kaishaCd13" => "",
            "mdgCd13" => "",
            "kaishaDispSeq14" => "",
            "kissFreeKbn14" => "0",
            "dispKaishaNm14" => "",
            "kaishaCd14" => "",
            "mdgCd14" => "",
            "kaishaDispSeq15" => "",
            "kissFreeKbn15" => "0",
            "dispKaishaNm15" => "",
            "kaishaCd15" => "",
            "mdgCd15" => "",
            "kckKjn43joTadashigakiKbn" => "0",
            "kenchikuKyokaComment" => "",
            "sgnJikoComment" => $article->sgnJikoComment,
            "jigKbn" => $article->jigKbn,
            "jigComment" => $article->jigComment,
            "jigToshiShunyu" => "",
            "jigToshiShunyuTaniKbn" => "1",
            "jigToshiNenRimawariS" => "",
            "jigToshiNenRimawariL" => "",
            "cmMaBknPictList[0].pictCtgCd" => "01",
            "cmMaBknPictList[0].pictNm" => "耐震基準適合証明書",
            "cmMaBknPictList[0].chukoFlg" => "1",
            "cmMaBknPictList[0].pictCd" => "687",
            "cmMaBknPictList[0].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[0].kskJknFlg" => "1",
            "cmMaBknPictList[0].masterSeq" => "00001",
            "cmMaBknPictList[1].pictCtgCd" => "01",
            "cmMaBknPictList[1].pictNm" => "長期優良住宅認定通知書",
            "cmMaBknPictList[1].chukoFlg" => "",
            "cmMaBknPictList[1].pictCd" => "319",
            "cmMaBknPictList[1].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[1].kskJknFlg" => "1",
            "cmMaBknPictList[1].masterSeq" => "00002",
            "cmMaBknPictList[2].pictCtgCd" => "01",
            "cmMaBknPictList[2].pictNm" => "設計住宅性能評価書",
            "cmMaBknPictList[2].chukoFlg" => "",
            "cmMaBknPictList[2].pictCd" => "142",
            "cmMaBknPictList[2].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[2].kskJknFlg" => "1",
            "cmMaBknPictList[2].masterSeq" => "00003",
            "cmMaBknPictList[3].pictCtgCd" => "01",
            "cmMaBknPictList[3].pictNm" => "建設住宅性能評価書（新築時）",
            "cmMaBknPictList[3].chukoFlg" => "",
            "cmMaBknPictList[3].pictCd" => "695",
            "cmMaBknPictList[3].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[3].kskJknFlg" => "1",
            "cmMaBknPictList[3].masterSeq" => "00004",
            "cmMaBknPictList[4].pictCtgCd" => "01",
            "cmMaBknPictList[4].pictNm" => "建設住宅性能評価書（既存住宅）",
            "cmMaBknPictList[4].chukoFlg" => "1",
            "cmMaBknPictList[4].pictCd" => "696",
            "cmMaBknPictList[4].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[4].kskJknFlg" => "1",
            "cmMaBknPictList[4].masterSeq" => "00005",
            "cmMaBknPictList[5].pictCtgCd" => "01",
            "cmMaBknPictList[5].pictNm" => "建築確認完了検査済証",
            "cmMaBknPictList[5].chukoFlg" => "1",
            "cmMaBknPictList[5].pictCd" => "697",
            "cmMaBknPictList[5].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[5].kskJknFlg" => "1",
            "cmMaBknPictList[5].masterSeq" => "00006",
            "cmMaBknPictList[6].pictCtgCd" => "01",
            "cmMaBknPictList[6].pictNm" => "法適合状況調査報告書",
            "cmMaBknPictList[6].chukoFlg" => "1",
            "cmMaBknPictList[6].pictCd" => "698",
            "cmMaBknPictList[6].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[6].kskJknFlg" => "1",
            "cmMaBknPictList[6].masterSeq" => "00007",
            "cmMaBknPictList[7].pictCtgCd" => "01",
            "cmMaBknPictList[7].pictNm" => "低炭素住宅",
            "cmMaBknPictList[7].chukoFlg" => "",
            "cmMaBknPictList[7].pictCd" => "699",
            "cmMaBknPictList[7].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[7].kskJknFlg" => "1",
            "cmMaBknPictList[7].masterSeq" => "00008",
            "cmMaBknPictList[8].pictCtgCd" => "01",
            "cmMaBknPictList[8].pictNm" => "BELS/省エネ基準適合認定書あり",
            "cmMaBknPictList[8].chukoFlg" => "",
            "cmMaBknPictList[8].pictCd" => "700",
            "cmMaBknPictList[8].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[8].kskJknFlg" => "0",
            "cmMaBknPictList[8].masterSeq" => "00009",
            "cmMaBknPictList[9].pictCtgCd" => "01",
            "cmMaBknPictList[9].pictNm" => "制震・免震・耐震",
            "cmMaBknPictList[9].chukoFlg" => "",
            "cmMaBknPictList[9].pictCd" => "689",
            "cmMaBknPictList[9].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[9].kskJknFlg" => "1",
            "cmMaBknPictList[9].masterSeq" => "00010",
            "cmMaBknPictList[10].pictCtgCd" => "02",
            "cmMaBknPictList[10].pictNm" => "瑕疵保険（国交省指定）保証利用可",
            "cmMaBknPictList[10].chukoFlg" => "1",
            "cmMaBknPictList[10].pictCd" => "701",
            "cmMaBknPictList[10].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[10].kskJknFlg" => "1",
            "cmMaBknPictList[10].masterSeq" => "00011",
            "cmMaBknPictList[11].pictCtgCd" => "02",
            "cmMaBknPictList[11].pictNm" => "瑕疵保険（国交省指定）保証付",
            "cmMaBknPictList[11].chukoFlg" => "1",
            "cmMaBknPictList[11].pictCd" => "702",
            "cmMaBknPictList[11].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[11].kskJknFlg" => "1",
            "cmMaBknPictList[11].masterSeq" => "00012",
            "cmMaBknPictList[12].pictCtgCd" => "02",
            "cmMaBknPictList[12].pictNm" => "瑕疵保証付（不動産会社独自）",
            "cmMaBknPictList[12].chukoFlg" => "1",
            "cmMaBknPictList[12].pictCd" => "703",
            "cmMaBknPictList[12].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[12].kskJknFlg" => "1",
            "cmMaBknPictList[12].masterSeq" => "00013",
            "cmMaBknPictList[13].pictCtgCd" => "02",
            "cmMaBknPictList[13].pictNm" => "フラット３５・S適合証明書",
            "cmMaBknPictList[13].chukoFlg" => "",
            "cmMaBknPictList[13].pictCd" => "704",
            "cmMaBknPictList[13].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[13].kskJknFlg" => "1",
            "cmMaBknPictList[13].masterSeq" => "00014",
            "cmMaBknPictList[14].pictCtgCd" => "02",
            "cmMaBknPictList[14].pictNm" => "建築士等の建物検査報告書",
            "cmMaBknPictList[14].chukoFlg" => "1",
            "cmMaBknPictList[14].pictCd" => "705",
            "cmMaBknPictList[14].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[14].kskJknFlg" => "1",
            "cmMaBknPictList[14].masterSeq" => "00015",
            "cmMaBknPictList[15].pictCtgCd" => "03",
            "cmMaBknPictList[15].pictNm" => "新築時・増改築時の設計図",
            "cmMaBknPictList[15].chukoFlg" => "1",
            "cmMaBknPictList[15].pictCd" => "706",
            "cmMaBknPictList[15].pictCtgNm" => "住宅履歴",
            "cmMaBknPictList[15].kskJknFlg" => "1",
            "cmMaBknPictList[15].masterSeq" => "00016",
            "cmMaBknPictList[16].pictCtgCd" => "03",
            "cmMaBknPictList[16].pictNm" => "修繕・点検の記録",
            "cmMaBknPictList[16].chukoFlg" => "1",
            "cmMaBknPictList[16].pictCd" => "707",
            "cmMaBknPictList[16].pictCtgNm" => "住宅履歴",
            "cmMaBknPictList[16].kskJknFlg" => "1",
            "cmMaBknPictList[16].masterSeq" => "00017",
            "cmMaBknPictList[17].pictCtgCd" => "04",
            "cmMaBknPictList[17].pictNm" => "空き家バンク登録物件",
            "cmMaBknPictList[17].chukoFlg" => "",
            "cmMaBknPictList[17].pictCd" => "708",
            "cmMaBknPictList[17].pictCtgNm" => "空き家バンク",
            "cmMaBknPictList[17].kskJknFlg" => "0",
            "cmMaBknPictList[17].masterSeq" => "00018",
            "cmMaBknPictList[18].pictCtgCd" => "05",
            "cmMaBknPictList[18].pictNm" => "地盤調査済",
            "cmMaBknPictList[18].chukoFlg" => "",
            "cmMaBknPictList[18].pictCd" => "353",
            "cmMaBknPictList[18].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[18].kskJknFlg" => "0",
            "cmMaBknPictList[18].masterSeq" => "00028",
            "cmMaBknPictList[19].pictCtgCd" => "05",
            "cmMaBknPictList[19].pictNm" => "土地100坪以上",
            "cmMaBknPictList[19].chukoFlg" => "",
            "cmMaBknPictList[19].pictCd" => "399",
            "cmMaBknPictList[19].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[19].kskJknFlg" => "0",
            "cmMaBknPictList[19].masterSeq" => "00039",
            "cmMaBknPictList[20].pictCtgCd" => "05",
            "cmMaBknPictList[20].pictNm" => "土地50坪以上",
            "cmMaBknPictList[20].chukoFlg" => "",
            "cmMaBknPictList[20].pictCd" => "225",
            "cmMaBknPictList[20].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[20].kskJknFlg" => "0",
            "cmMaBknPictList[20].masterSeq" => "00040",
            "cmMaBknPictList[21].pictCtgCd" => "05",
            "cmMaBknPictList[21].pictNm" => "市街地が近い",
            "cmMaBknPictList[21].chukoFlg" => "",
            "cmMaBknPictList[21].pictCd" => "664",
            "cmMaBknPictList[21].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[21].kskJknFlg" => "0",
            "cmMaBknPictList[21].masterSeq" => "00055",
            "cmMaBknPictList[22].pictCtgCd" => "05",
            "cmMaBknPictList[22].pictNm" => "避暑地",
            "cmMaBknPictList[22].chukoFlg" => "",
            "cmMaBknPictList[22].pictCd" => "658",
            "cmMaBknPictList[22].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[22].kskJknFlg" => "0",
            "cmMaBknPictList[22].masterSeq" => "00056",
            "cmMaBknPictList[23].pictCtgCd" => "05",
            "cmMaBknPictList[23].pictNm" => "南側道路面す",
            "cmMaBknPictList[23].chukoFlg" => "",
            "cmMaBknPictList[23].pictCd" => "003",
            "cmMaBknPictList[23].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[23].kskJknFlg" => "0",
            "cmMaBknPictList[23].masterSeq" => "00069",
            "cmMaBknPictList[24].pictCtgCd" => "05",
            "cmMaBknPictList[24].pictNm" => "閑静な住宅地",
            "cmMaBknPictList[24].chukoFlg" => "",
            "cmMaBknPictList[24].pictCd" => "097",
            "cmMaBknPictList[24].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[24].kskJknFlg" => "0",
            "cmMaBknPictList[24].masterSeq" => "00070",
            "cmMaBknPictList[25].pictCtgCd" => "05",
            "cmMaBknPictList[25].pictNm" => "前道６ｍ以上",
            "cmMaBknPictList[25].chukoFlg" => "",
            "cmMaBknPictList[25].pictCd" => "173",
            "cmMaBknPictList[25].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[25].kskJknFlg" => "0",
            "cmMaBknPictList[25].masterSeq" => "00073",
            "cmMaBknPictList[26].pictCtgCd" => "05",
            "cmMaBknPictList[26].pictNm" => "角地",
            "cmMaBknPictList[26].chukoFlg" => "",
            "cmMaBknPictList[26].pictCd" => "210",
            "cmMaBknPictList[26].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[26].kskJknFlg" => "1",
            "cmMaBknPictList[26].masterSeq" => "00074",
            "cmMaBknPictList[27].pictCtgCd" => "05",
            "cmMaBknPictList[27].pictNm" => "整形地",
            "cmMaBknPictList[27].chukoFlg" => "",
            "cmMaBknPictList[27].pictCd" => "095",
            "cmMaBknPictList[27].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[27].kskJknFlg" => "1",
            "cmMaBknPictList[27].masterSeq" => "00077",
            "cmMaBknPictList[28].pictCtgCd" => "05",
            "cmMaBknPictList[28].pictNm" => "緑豊かな住宅地",
            "cmMaBknPictList[28].chukoFlg" => "",
            "cmMaBknPictList[28].pictCd" => "096",
            "cmMaBknPictList[28].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[28].kskJknFlg" => "0",
            "cmMaBknPictList[28].masterSeq" => "00122",
            "cmMaBknPictList[29].pictCtgCd" => "05",
            "cmMaBknPictList[29].pictNm" => "都市近郊",
            "cmMaBknPictList[29].chukoFlg" => "",
            "cmMaBknPictList[29].pictCd" => "659",
            "cmMaBknPictList[29].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[29].kskJknFlg" => "0",
            "cmMaBknPictList[29].masterSeq" => "00123",
            "cmMaBknPictList[30].pictCtgCd" => "05",
            "cmMaBknPictList[30].pictNm" => "前面棟無",
            "cmMaBknPictList[30].chukoFlg" => "",
            "cmMaBknPictList[30].pictCd" => "130",
            "cmMaBknPictList[30].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[30].kskJknFlg" => "0",
            "cmMaBknPictList[30].masterSeq" => "00124",
            "cmMaBknPictList[31].pictCtgCd" => "05",
            "cmMaBknPictList[31].pictNm" => "高台に立地",
            "cmMaBknPictList[31].chukoFlg" => "",
            "cmMaBknPictList[31].pictCd" => "007",
            "cmMaBknPictList[31].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[31].kskJknFlg" => "1",
            "cmMaBknPictList[31].masterSeq" => "00147",
            "cmMaBknPictList[32].pictCtgCd" => "05",
            "cmMaBknPictList[32].pictNm" => "大型タウン内",
            "cmMaBknPictList[32].chukoFlg" => "",
            "cmMaBknPictList[32].pictCd" => "314",
            "cmMaBknPictList[32].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[32].kskJknFlg" => "0",
            "cmMaBknPictList[32].masterSeq" => "00150",
            "cmMaBknPictList[33].pictCtgCd" => "05",
            "cmMaBknPictList[33].pictNm" => "平坦地",
            "cmMaBknPictList[33].chukoFlg" => "",
            "cmMaBknPictList[33].pictCd" => "127",
            "cmMaBknPictList[33].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[33].kskJknFlg" => "0",
            "cmMaBknPictList[33].masterSeq" => "00154",
            "cmMaBknPictList[34].pictCtgCd" => "05",
            "cmMaBknPictList[34].pictNm" => "開発分譲地内",
            "cmMaBknPictList[34].chukoFlg" => "",
            "cmMaBknPictList[34].pictCd" => "662",
            "cmMaBknPictList[34].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[34].kskJknFlg" => "0",
            "cmMaBknPictList[34].masterSeq" => "00160",
            "cmMaBknPictList[35].pictCtgCd" => "05",
            "cmMaBknPictList[35].pictNm" => "区画整理地内",
            "cmMaBknPictList[35].chukoFlg" => "",
            "cmMaBknPictList[35].pictCd" => "091",
            "cmMaBknPictList[35].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[35].kskJknFlg" => "0",
            "cmMaBknPictList[35].masterSeq" => "00164",
            "cmMaBknPictList[36].pictCtgCd" => "06",
            "cmMaBknPictList[36].pictNm" => "２沿線以上利用可",
            "cmMaBknPictList[36].chukoFlg" => "",
            "cmMaBknPictList[36].pictCd" => "692",
            "cmMaBknPictList[36].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[36].kskJknFlg" => "1",
            "cmMaBknPictList[36].masterSeq" => "00037",
            "cmMaBknPictList[37].pictCtgCd" => "06",
            "cmMaBknPictList[37].pictNm" => "駅まで平坦",
            "cmMaBknPictList[37].chukoFlg" => "",
            "cmMaBknPictList[37].pictCd" => "112",
            "cmMaBknPictList[37].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[37].kskJknFlg" => "0",
            "cmMaBknPictList[37].masterSeq" => "00068",
            "cmMaBknPictList[38].pictCtgCd" => "06",
            "cmMaBknPictList[38].pictNm" => "始発駅",
            "cmMaBknPictList[38].chukoFlg" => "",
            "cmMaBknPictList[38].pictCd" => "211",
            "cmMaBknPictList[38].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[38].kskJknFlg" => "1",
            "cmMaBknPictList[38].masterSeq" => "00076",
            "cmMaBknPictList[39].pictCtgCd" => "07",
            "cmMaBknPictList[39].pictNm" => "２階建",
            "cmMaBknPictList[39].chukoFlg" => "",
            "cmMaBknPictList[39].pictCd" => "665",
            "cmMaBknPictList[39].pictCtgNm" => "住戸・階数",
            "cmMaBknPictList[39].kskJknFlg" => "1",
            "cmMaBknPictList[39].masterSeq" => "00101",
            "cmMaBknPictList[40].pictCtgCd" => "07",
            "cmMaBknPictList[40].pictNm" => "３階建以上",
            "cmMaBknPictList[40].chukoFlg" => "",
            "cmMaBknPictList[40].pictCd" => "666",
            "cmMaBknPictList[40].pictCtgNm" => "住戸・階数",
            "cmMaBknPictList[40].kskJknFlg" => "1",
            "cmMaBknPictList[40].masterSeq" => "00137",
            "cmMaBknPictList[41].pictCtgCd" => "08",
            "cmMaBknPictList[41].pictNm" => "南向き",
            "cmMaBknPictList[41].chukoFlg" => "",
            "cmMaBknPictList[41].pictCd" => "032",
            "cmMaBknPictList[41].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[41].kskJknFlg" => "1",
            "cmMaBknPictList[41].masterSeq" => "00061",
            "cmMaBknPictList[42].pictCtgCd" => "08",
            "cmMaBknPictList[42].pictNm" => "陽当り良好",
            "cmMaBknPictList[42].chukoFlg" => "",
            "cmMaBknPictList[42].pictCd" => "128",
            "cmMaBknPictList[42].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[42].kskJknFlg" => "0",
            "cmMaBknPictList[42].masterSeq" => "00065",
            "cmMaBknPictList[43].pictCtgCd" => "08",
            "cmMaBknPictList[43].pictNm" => "３面採光",
            "cmMaBknPictList[43].chukoFlg" => "",
            "cmMaBknPictList[43].pictCd" => "183",
            "cmMaBknPictList[43].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[43].kskJknFlg" => "0",
            "cmMaBknPictList[43].masterSeq" => "00094",
            "cmMaBknPictList[44].pictCtgCd" => "08",
            "cmMaBknPictList[44].pictNm" => "東南向き",
            "cmMaBknPictList[44].chukoFlg" => "",
            "cmMaBknPictList[44].pictCd" => "420",
            "cmMaBknPictList[44].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[44].kskJknFlg" => "0",
            "cmMaBknPictList[44].masterSeq" => "00103",
            "cmMaBknPictList[45].pictCtgCd" => "08",
            "cmMaBknPictList[45].pictNm" => "全室南向き",
            "cmMaBknPictList[45].chukoFlg" => "",
            "cmMaBknPictList[45].pictCd" => "034",
            "cmMaBknPictList[45].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[45].kskJknFlg" => "1",
            "cmMaBknPictList[45].masterSeq" => "00108",
            "cmMaBknPictList[46].pictCtgCd" => "08",
            "cmMaBknPictList[46].pictNm" => "通風良好",
            "cmMaBknPictList[46].chukoFlg" => "",
            "cmMaBknPictList[46].pictCd" => "641",
            "cmMaBknPictList[46].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[46].kskJknFlg" => "0",
            "cmMaBknPictList[46].masterSeq" => "00125",
            "cmMaBknPictList[47].pictCtgCd" => "08",
            "cmMaBknPictList[47].pictNm" => "南西向き",
            "cmMaBknPictList[47].chukoFlg" => "",
            "cmMaBknPictList[47].pictCd" => "421",
            "cmMaBknPictList[47].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[47].kskJknFlg" => "0",
            "cmMaBknPictList[47].masterSeq" => "00131",
            "cmMaBknPictList[48].pictCtgCd" => "08",
            "cmMaBknPictList[48].pictNm" => "全室２面採光",
            "cmMaBknPictList[48].chukoFlg" => "",
            "cmMaBknPictList[48].pictCd" => "121",
            "cmMaBknPictList[48].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[48].kskJknFlg" => "0",
            "cmMaBknPictList[48].masterSeq" => "00144",
            "cmMaBknPictList[49].pictCtgCd" => "08",
            "cmMaBknPictList[49].pictNm" => "全室南西向き",
            "cmMaBknPictList[49].chukoFlg" => "",
            "cmMaBknPictList[49].pictCd" => "423",
            "cmMaBknPictList[49].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[49].kskJknFlg" => "0",
            "cmMaBknPictList[49].masterSeq" => "00152",
            "cmMaBknPictList[50].pictCtgCd" => "08",
            "cmMaBknPictList[50].pictNm" => "全室東南向き",
            "cmMaBknPictList[50].chukoFlg" => "",
            "cmMaBknPictList[50].pictCd" => "422",
            "cmMaBknPictList[50].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[50].kskJknFlg" => "0",
            "cmMaBknPictList[50].masterSeq" => "00167",
            "cmMaBknPictList[51].pictCtgCd" => "09",
            "cmMaBknPictList[51].pictNm" => "ＬＤＫ２０畳以上",
            "cmMaBknPictList[51].chukoFlg" => "",
            "cmMaBknPictList[51].pictCd" => "445",
            "cmMaBknPictList[51].pictCtgNm" => "間取り",
            "cmMaBknPictList[51].kskJknFlg" => "1",
            "cmMaBknPictList[51].masterSeq" => "00038",
            "cmMaBknPictList[52].pictCtgCd" => "09",
            "cmMaBknPictList[52].pictNm" => "ＬＤＫ１８畳以上",
            "cmMaBknPictList[52].chukoFlg" => "",
            "cmMaBknPictList[52].pictCd" => "216",
            "cmMaBknPictList[52].pictCtgNm" => "間取り",
            "cmMaBknPictList[52].kskJknFlg" => "1",
            "cmMaBknPictList[52].masterSeq" => "00041",
            "cmMaBknPictList[53].pictCtgCd" => "09",
            "cmMaBknPictList[53].pictNm" => "ＬＤＫ１５畳以上",
            "cmMaBknPictList[53].chukoFlg" => "",
            "cmMaBknPictList[53].pictCd" => "166",
            "cmMaBknPictList[53].pictCtgNm" => "間取り",
            "cmMaBknPictList[53].kskJknFlg" => "1",
            "cmMaBknPictList[53].masterSeq" => "00071",
            "cmMaBknPictList[54].pictCtgCd" => "09",
            "cmMaBknPictList[54].pictNm" => "和室",
            "cmMaBknPictList[54].chukoFlg" => "",
            "cmMaBknPictList[54].pictCd" => "452",
            "cmMaBknPictList[54].pictCtgNm" => "間取り",
            "cmMaBknPictList[54].kskJknFlg" => "0",
            "cmMaBknPictList[54].masterSeq" => "00075",
            "cmMaBknPictList[55].pictCtgCd" => "09",
            "cmMaBknPictList[55].pictNm" => "ロフト",
            "cmMaBknPictList[55].chukoFlg" => "",
            "cmMaBknPictList[55].pictCd" => "072",
            "cmMaBknPictList[55].pictCtgNm" => "間取り",
            "cmMaBknPictList[55].kskJknFlg" => "0",
            "cmMaBknPictList[55].masterSeq" => "00113",
            "cmMaBknPictList[56].pictCtgCd" => "09",
            "cmMaBknPictList[56].pictNm" => "吹抜け",
            "cmMaBknPictList[56].chukoFlg" => "",
            "cmMaBknPictList[56].pictCd" => "120",
            "cmMaBknPictList[56].pictCtgNm" => "間取り",
            "cmMaBknPictList[56].kskJknFlg" => "0",
            "cmMaBknPictList[56].masterSeq" => "00118",
            "cmMaBknPictList[57].pictCtgCd" => "09",
            "cmMaBknPictList[57].pictNm" => "全居室６畳以上",
            "cmMaBknPictList[57].chukoFlg" => "",
            "cmMaBknPictList[57].pictCd" => "222",
            "cmMaBknPictList[57].pictCtgNm" => "間取り",
            "cmMaBknPictList[57].kskJknFlg" => "1",
            "cmMaBknPictList[57].masterSeq" => "00135",
            "cmMaBknPictList[58].pictCtgCd" => "09",
            "cmMaBknPictList[58].pictNm" => "２世帯住宅",
            "cmMaBknPictList[58].chukoFlg" => "",
            "cmMaBknPictList[58].pictCd" => "017",
            "cmMaBknPictList[58].pictCtgNm" => "間取り",
            "cmMaBknPictList[58].kskJknFlg" => "1",
            "cmMaBknPictList[58].masterSeq" => "00155",
            "cmMaBknPictList[59].pictCtgCd" => "09",
            "cmMaBknPictList[59].pictNm" => "可動間仕切り",
            "cmMaBknPictList[59].chukoFlg" => "",
            "cmMaBknPictList[59].pictCd" => "336",
            "cmMaBknPictList[59].pictCtgNm" => "間取り",
            "cmMaBknPictList[59].kskJknFlg" => "0",
            "cmMaBknPictList[59].masterSeq" => "00176",
            "cmMaBknPictList[60].pictCtgCd" => "10",
            "cmMaBknPictList[60].pictNm" => "バリアフリー",
            "cmMaBknPictList[60].chukoFlg" => "",
            "cmMaBknPictList[60].pictCd" => "041",
            "cmMaBknPictList[60].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[60].kskJknFlg" => "1",
            "cmMaBknPictList[60].masterSeq" => "00095",
            "cmMaBknPictList[61].pictCtgCd" => "10",
            "cmMaBknPictList[61].pictNm" => "自然素材使用",
            "cmMaBknPictList[61].chukoFlg" => "",
            "cmMaBknPictList[61].pictCd" => "540",
            "cmMaBknPictList[61].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[61].kskJknFlg" => "0",
            "cmMaBknPictList[61].masterSeq" => "00097",
            "cmMaBknPictList[62].pictCtgCd" => "10",
            "cmMaBknPictList[62].pictNm" => "全居室フローリング",
            "cmMaBknPictList[62].chukoFlg" => "",
            "cmMaBknPictList[62].pictCd" => "070",
            "cmMaBknPictList[62].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[62].kskJknFlg" => "0",
            "cmMaBknPictList[62].masterSeq" => "00126",
            "cmMaBknPictList[63].pictCtgCd" => "10",
            "cmMaBknPictList[63].pictNm" => "天井高２．５ｍ以上",
            "cmMaBknPictList[63].chukoFlg" => "",
            "cmMaBknPictList[63].pictCd" => "212",
            "cmMaBknPictList[63].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[63].kskJknFlg" => "0",
            "cmMaBknPictList[63].masterSeq" => "00134",
            "cmMaBknPictList[64].pictCtgCd" => "10",
            "cmMaBknPictList[64].pictNm" => "リビング階段",
            "cmMaBknPictList[64].chukoFlg" => "",
            "cmMaBknPictList[64].pictCd" => "214",
            "cmMaBknPictList[64].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[64].kskJknFlg" => "0",
            "cmMaBknPictList[64].masterSeq" => "00139",
            "cmMaBknPictList[65].pictCtgCd" => "10",
            "cmMaBknPictList[65].pictNm" => "床暖房",
            "cmMaBknPictList[65].chukoFlg" => "",
            "cmMaBknPictList[65].pictCd" => "073",
            "cmMaBknPictList[65].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[65].kskJknFlg" => "1",
            "cmMaBknPictList[65].masterSeq" => "00158",
            "cmMaBknPictList[66].pictCtgCd" => "10",
            "cmMaBknPictList[66].pictNm" => "スマートキー",
            "cmMaBknPictList[66].chukoFlg" => "",
            "cmMaBknPictList[66].pictCd" => "721",
            "cmMaBknPictList[66].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[66].kskJknFlg" => "0",
            "cmMaBknPictList[66].masterSeq" => "00191",
            "cmMaBknPictList[67].pictCtgCd" => "11",
            "cmMaBknPictList[67].pictNm" => "全居室収納",
            "cmMaBknPictList[67].chukoFlg" => "",
            "cmMaBknPictList[67].pictCd" => "067",
            "cmMaBknPictList[67].pictCtgNm" => "収納",
            "cmMaBknPictList[67].kskJknFlg" => "1",
            "cmMaBknPictList[67].masterSeq" => "00067",
            "cmMaBknPictList[68].pictCtgCd" => "11",
            "cmMaBknPictList[68].pictNm" => "床下収納",
            "cmMaBknPictList[68].chukoFlg" => "",
            "cmMaBknPictList[68].pictCd" => "066",
            "cmMaBknPictList[68].pictCtgNm" => "収納",
            "cmMaBknPictList[68].kskJknFlg" => "0",
            "cmMaBknPictList[68].masterSeq" => "00116",
            "cmMaBknPictList[69].pictCtgCd" => "11",
            "cmMaBknPictList[69].pictNm" => "ウォークインクローゼット",
            "cmMaBknPictList[69].chukoFlg" => "",
            "cmMaBknPictList[69].pictCd" => "065",
            "cmMaBknPictList[69].pictCtgNm" => "収納",
            "cmMaBknPictList[69].kskJknFlg" => "1",
            "cmMaBknPictList[69].masterSeq" => "00133",
            "cmMaBknPictList[70].pictCtgCd" => "11",
            "cmMaBknPictList[70].pictNm" => "シューズインクローク",
            "cmMaBknPictList[70].chukoFlg" => "",
            "cmMaBknPictList[70].pictCd" => "709",
            "cmMaBknPictList[70].pictCtgNm" => "収納",
            "cmMaBknPictList[70].kskJknFlg" => "1",
            "cmMaBknPictList[70].masterSeq" => "00142",
            "cmMaBknPictList[71].pictCtgCd" => "11",
            "cmMaBknPictList[71].pictNm" => "屋根裏収納",
            "cmMaBknPictList[71].chukoFlg" => "",
            "cmMaBknPictList[71].pictCd" => "153",
            "cmMaBknPictList[71].pictCtgNm" => "収納",
            "cmMaBknPictList[71].kskJknFlg" => "0",
            "cmMaBknPictList[71].masterSeq" => "00156",
            "cmMaBknPictList[72].pictCtgCd" => "11",
            "cmMaBknPictList[72].pictNm" => "納戸",
            "cmMaBknPictList[72].chukoFlg" => "",
            "cmMaBknPictList[72].pictCd" => "069",
            "cmMaBknPictList[72].pictCtgNm" => "収納",
            "cmMaBknPictList[72].kskJknFlg" => "0",
            "cmMaBknPictList[72].masterSeq" => "00180",
            "cmMaBknPictList[73].pictCtgCd" => "12",
            "cmMaBknPictList[73].pictNm" => "システムキッチン",
            "cmMaBknPictList[73].chukoFlg" => "",
            "cmMaBknPictList[73].pictCd" => "055",
            "cmMaBknPictList[73].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[73].kskJknFlg" => "1",
            "cmMaBknPictList[73].masterSeq" => "00062",
            "cmMaBknPictList[74].pictCtgCd" => "12",
            "cmMaBknPictList[74].pictNm" => "対面式キッチン",
            "cmMaBknPictList[74].chukoFlg" => "",
            "cmMaBknPictList[74].pictCd" => "056",
            "cmMaBknPictList[74].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[74].kskJknFlg" => "1",
            "cmMaBknPictList[74].masterSeq" => "00088",
            "cmMaBknPictList[75].pictCtgCd" => "12",
            "cmMaBknPictList[75].pictNm" => "アイランドキッチン",
            "cmMaBknPictList[75].chukoFlg" => "",
            "cmMaBknPictList[75].pictCd" => "715",
            "cmMaBknPictList[75].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[75].kskJknFlg" => "0",
            "cmMaBknPictList[75].masterSeq" => "00129",
            "cmMaBknPictList[76].pictCtgCd" => "12",
            "cmMaBknPictList[76].pictNm" => "パントリー（食器・食品の収納庫）",
            "cmMaBknPictList[76].chukoFlg" => "",
            "cmMaBknPictList[76].pictCd" => "710",
            "cmMaBknPictList[76].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[76].kskJknFlg" => "1",
            "cmMaBknPictList[76].masterSeq" => "00132",
            "cmMaBknPictList[77].pictCtgCd" => "12",
            "cmMaBknPictList[77].pictNm" => "ＩＨクッキングヒーター",
            "cmMaBknPictList[77].chukoFlg" => "",
            "cmMaBknPictList[77].pictCd" => "219",
            "cmMaBknPictList[77].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[77].kskJknFlg" => "1",
            "cmMaBknPictList[77].masterSeq" => "00136",
            "cmMaBknPictList[78].pictCtgCd" => "12",
            "cmMaBknPictList[78].pictNm" => "食器洗乾燥機",
            "cmMaBknPictList[78].chukoFlg" => "",
            "cmMaBknPictList[78].pictCd" => "076",
            "cmMaBknPictList[78].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[78].kskJknFlg" => "1",
            "cmMaBknPictList[78].masterSeq" => "00181",
            "cmMaBknPictList[79].pictCtgCd" => "12",
            "cmMaBknPictList[79].pictNm" => "ディスポーザー（生ごみ粉砕処理器）",
            "cmMaBknPictList[79].chukoFlg" => "",
            "cmMaBknPictList[79].pictCd" => "716",
            "cmMaBknPictList[79].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[79].kskJknFlg" => "0",
            "cmMaBknPictList[79].masterSeq" => "00187",
            "cmMaBknPictList[80].pictCtgCd" => "12",
            "cmMaBknPictList[80].pictNm" => "浄水器",
            "cmMaBknPictList[80].chukoFlg" => "",
            "cmMaBknPictList[80].pictCd" => "119",
            "cmMaBknPictList[80].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[80].kskJknFlg" => "0",
            "cmMaBknPictList[80].masterSeq" => "00188",
            "cmMaBknPictList[81].pictCtgCd" => "13",
            "cmMaBknPictList[81].pictNm" => "浴室乾燥機",
            "cmMaBknPictList[81].chukoFlg" => "",
            "cmMaBknPictList[81].pictCd" => "063",
            "cmMaBknPictList[81].pictCtgNm" => "浴室",
            "cmMaBknPictList[81].kskJknFlg" => "1",
            "cmMaBknPictList[81].masterSeq" => "00063",
            "cmMaBknPictList[82].pictCtgCd" => "13",
            "cmMaBknPictList[82].pictNm" => "ミストサウナ",
            "cmMaBknPictList[82].chukoFlg" => "",
            "cmMaBknPictList[82].pictCd" => "206",
            "cmMaBknPictList[82].pictCtgNm" => "浴室",
            "cmMaBknPictList[82].kskJknFlg" => "0",
            "cmMaBknPictList[82].masterSeq" => "00082",
            "cmMaBknPictList[83].pictCtgCd" => "13",
            "cmMaBknPictList[83].pictNm" => "浴室１坪以上",
            "cmMaBknPictList[83].chukoFlg" => "",
            "cmMaBknPictList[83].pictCd" => "100",
            "cmMaBknPictList[83].pictCtgNm" => "浴室",
            "cmMaBknPictList[83].kskJknFlg" => "1",
            "cmMaBknPictList[83].masterSeq" => "00099",
            "cmMaBknPictList[84].pictCtgCd" => "13",
            "cmMaBknPictList[84].pictNm" => "オートバス",
            "cmMaBknPictList[84].chukoFlg" => "",
            "cmMaBknPictList[84].pictCd" => "062",
            "cmMaBknPictList[84].pictCtgNm" => "浴室",
            "cmMaBknPictList[84].kskJknFlg" => "0",
            "cmMaBknPictList[84].masterSeq" => "00110",
            "cmMaBknPictList[85].pictCtgCd" => "13",
            "cmMaBknPictList[85].pictNm" => "ＴＶ付浴室",
            "cmMaBknPictList[85].chukoFlg" => "",
            "cmMaBknPictList[85].pictCd" => "060",
            "cmMaBknPictList[85].pictCtgNm" => "浴室",
            "cmMaBknPictList[85].kskJknFlg" => "0",
            "cmMaBknPictList[85].masterSeq" => "00114",
            "cmMaBknPictList[86].pictCtgCd" => "13",
            "cmMaBknPictList[86].pictNm" => "浴室に窓",
            "cmMaBknPictList[86].chukoFlg" => "",
            "cmMaBknPictList[86].pictCd" => "165",
            "cmMaBknPictList[86].pictCtgNm" => "浴室",
            "cmMaBknPictList[86].kskJknFlg" => "0",
            "cmMaBknPictList[86].masterSeq" => "00117",
            "cmMaBknPictList[87].pictCtgCd" => "13",
            "cmMaBknPictList[87].pictNm" => "ジェットバス",
            "cmMaBknPictList[87].chukoFlg" => "",
            "cmMaBknPictList[87].pictCd" => "061",
            "cmMaBknPictList[87].pictCtgNm" => "浴室",
            "cmMaBknPictList[87].kskJknFlg" => "0",
            "cmMaBknPictList[87].masterSeq" => "00143",
            "cmMaBknPictList[88].pictCtgCd" => "13",
            "cmMaBknPictList[88].pictNm" => "露天風呂",
            "cmMaBknPictList[88].chukoFlg" => "",
            "cmMaBknPictList[88].pictCd" => "654",
            "cmMaBknPictList[88].pictCtgNm" => "浴室",
            "cmMaBknPictList[88].kskJknFlg" => "0",
            "cmMaBknPictList[88].masterSeq" => "00170",
            "cmMaBknPictList[89].pictCtgCd" => "13",
            "cmMaBknPictList[89].pictNm" => "オーディオバス",
            "cmMaBknPictList[89].chukoFlg" => "",
            "cmMaBknPictList[89].pictCd" => "497",
            "cmMaBknPictList[89].pictCtgNm" => "浴室",
            "cmMaBknPictList[89].kskJknFlg" => "0",
            "cmMaBknPictList[89].masterSeq" => "00174",
            "cmMaBknPictList[90].pictCtgCd" => "14",
            "cmMaBknPictList[90].pictNm" => "シャワー付洗面化粧台",
            "cmMaBknPictList[90].chukoFlg" => "",
            "cmMaBknPictList[90].pictCd" => "205",
            "cmMaBknPictList[90].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[90].kskJknFlg" => "0",
            "cmMaBknPictList[90].masterSeq" => "00087",
            "cmMaBknPictList[91].pictCtgCd" => "14",
            "cmMaBknPictList[91].pictNm" => "トイレ２ヶ所",
            "cmMaBknPictList[91].chukoFlg" => "",
            "cmMaBknPictList[91].pictCd" => "136",
            "cmMaBknPictList[91].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[91].kskJknFlg" => "0",
            "cmMaBknPictList[91].masterSeq" => "00096",
            "cmMaBknPictList[92].pictCtgCd" => "14",
            "cmMaBknPictList[92].pictNm" => "温水洗浄便座",
            "cmMaBknPictList[92].chukoFlg" => "",
            "cmMaBknPictList[92].pictCd" => "167",
            "cmMaBknPictList[92].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[92].kskJknFlg" => "0",
            "cmMaBknPictList[92].masterSeq" => "00112",
            "cmMaBknPictList[93].pictCtgCd" => "14",
            "cmMaBknPictList[93].pictNm" => "節水型トイレ",
            "cmMaBknPictList[93].chukoFlg" => "",
            "cmMaBknPictList[93].pictCd" => "719",
            "cmMaBknPictList[93].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[93].kskJknFlg" => "0",
            "cmMaBknPictList[93].masterSeq" => "00121",
            "cmMaBknPictList[94].pictCtgCd" => "14",
            "cmMaBknPictList[94].pictNm" => "高機能トイレ",
            "cmMaBknPictList[94].chukoFlg" => "",
            "cmMaBknPictList[94].pictCd" => "694",
            "cmMaBknPictList[94].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[94].kskJknFlg" => "0",
            "cmMaBknPictList[94].masterSeq" => "00192",
            "cmMaBknPictList[95].pictCtgCd" => "15",
            "cmMaBknPictList[95].pictNm" => "ワイドバルコニー",
            "cmMaBknPictList[95].chukoFlg" => "",
            "cmMaBknPictList[95].pictCd" => "203",
            "cmMaBknPictList[95].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[95].kskJknFlg" => "0",
            "cmMaBknPictList[95].masterSeq" => "00093",
            "cmMaBknPictList[96].pictCtgCd" => "15",
            "cmMaBknPictList[96].pictNm" => "２面以上バルコニー",
            "cmMaBknPictList[96].chukoFlg" => "",
            "cmMaBknPictList[96].pictCd" => "678",
            "cmMaBknPictList[96].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[96].kskJknFlg" => "0",
            "cmMaBknPictList[96].masterSeq" => "00102",
            "cmMaBknPictList[97].pictCtgCd" => "15",
            "cmMaBknPictList[97].pictNm" => "南面バルコニー",
            "cmMaBknPictList[97].chukoFlg" => "",
            "cmMaBknPictList[97].pictCd" => "532",
            "cmMaBknPictList[97].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[97].kskJknFlg" => "1",
            "cmMaBknPictList[97].masterSeq" => "00104",
            "cmMaBknPictList[98].pictCtgCd" => "15",
            "cmMaBknPictList[98].pictNm" => "ウッドデッキ",
            "cmMaBknPictList[98].chukoFlg" => "",
            "cmMaBknPictList[98].pictCd" => "047",
            "cmMaBknPictList[98].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[98].kskJknFlg" => "1",
            "cmMaBknPictList[98].masterSeq" => "00127",
            "cmMaBknPictList[99].pictCtgCd" => "15",
            "cmMaBknPictList[99].pictNm" => "ルーフバルコニー",
            "cmMaBknPictList[99].chukoFlg" => "",
            "cmMaBknPictList[99].pictCd" => "029",
            "cmMaBknPictList[99].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[99].kskJknFlg" => "1",
            "cmMaBknPictList[99].masterSeq" => "00153",
            "cmMaBknPictList[100].pictCtgCd" => "15",
            "cmMaBknPictList[100].pictNm" => "テラス",
            "cmMaBknPictList[100].chukoFlg" => "",
            "cmMaBknPictList[100].pictCd" => "106",
            "cmMaBknPictList[100].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[100].kskJknFlg" => "1",
            "cmMaBknPictList[100].masterSeq" => "00162",
            "cmMaBknPictList[101].pictCtgCd" => "15",
            "cmMaBknPictList[101].pictNm" => "バルコニー・屋上に水栓あり",
            "cmMaBknPictList[101].chukoFlg" => "",
            "cmMaBknPictList[101].pictCd" => "718",
            "cmMaBknPictList[101].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[101].kskJknFlg" => "0",
            "cmMaBknPictList[101].masterSeq" => "00190",
            "cmMaBknPictList[102].pictCtgCd" => "16",
            "cmMaBknPictList[102].pictNm" => "庭１０坪以上",
            "cmMaBknPictList[102].chukoFlg" => "",
            "cmMaBknPictList[102].pictCd" => "428",
            "cmMaBknPictList[102].pictCtgNm" => "庭",
            "cmMaBknPictList[102].kskJknFlg" => "1",
            "cmMaBknPictList[102].masterSeq" => "00081",
            "cmMaBknPictList[103].pictCtgCd" => "16",
            "cmMaBknPictList[103].pictNm" => "庭",
            "cmMaBknPictList[103].chukoFlg" => "",
            "cmMaBknPictList[103].pictCd" => "427",
            "cmMaBknPictList[103].pictCtgNm" => "庭",
            "cmMaBknPictList[103].kskJknFlg" => "0",
            "cmMaBknPictList[103].masterSeq" => "00085",
            "cmMaBknPictList[104].pictCtgCd" => "16",
            "cmMaBknPictList[104].pictNm" => "南庭",
            "cmMaBknPictList[104].chukoFlg" => "",
            "cmMaBknPictList[104].pictCd" => "135",
            "cmMaBknPictList[104].pictCtgNm" => "庭",
            "cmMaBknPictList[104].kskJknFlg" => "1",
            "cmMaBknPictList[104].masterSeq" => "00115",
            "cmMaBknPictList[105].pictCtgCd" => "17",
            "cmMaBknPictList[105].pictNm" => "エコポイント対象住宅",
            "cmMaBknPictList[105].chukoFlg" => "",
            "cmMaBknPictList[105].pictCd" => "661",
            "cmMaBknPictList[105].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[105].kskJknFlg" => "0",
            "cmMaBknPictList[105].masterSeq" => "00022",
            "cmMaBknPictList[106].pictCtgCd" => "17",
            "cmMaBknPictList[106].pictNm" => "省エネルギー対策",
            "cmMaBknPictList[106].chukoFlg" => "",
            "cmMaBknPictList[106].pictCd" => "040",
            "cmMaBknPictList[106].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[106].kskJknFlg" => "0",
            "cmMaBknPictList[106].masterSeq" => "00023",
            "cmMaBknPictList[107].pictCtgCd" => "17",
            "cmMaBknPictList[107].pictNm" => "太陽光発電システム",
            "cmMaBknPictList[107].chukoFlg" => "",
            "cmMaBknPictList[107].pictCd" => "207",
            "cmMaBknPictList[107].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[107].kskJknFlg" => "1",
            "cmMaBknPictList[107].masterSeq" => "00026",
            "cmMaBknPictList[108].pictCtgCd" => "17",
            "cmMaBknPictList[108].pictNm" => "高気密高断熱住宅",
            "cmMaBknPictList[108].chukoFlg" => "",
            "cmMaBknPictList[108].pictCd" => "321",
            "cmMaBknPictList[108].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[108].kskJknFlg" => "0",
            "cmMaBknPictList[108].masterSeq" => "00027",
            "cmMaBknPictList[109].pictCtgCd" => "17",
            "cmMaBknPictList[109].pictNm" => "省エネ給湯器",
            "cmMaBknPictList[109].chukoFlg" => "",
            "cmMaBknPictList[109].pictCd" => "679",
            "cmMaBknPictList[109].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[109].kskJknFlg" => "1",
            "cmMaBknPictList[109].masterSeq" => "00047",
            "cmMaBknPictList[110].pictCtgCd" => "17",
            "cmMaBknPictList[110].pictNm" => "複層ガラス",
            "cmMaBknPictList[110].chukoFlg" => "",
            "cmMaBknPictList[110].pictCd" => "109",
            "cmMaBknPictList[110].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[110].kskJknFlg" => "0",
            "cmMaBknPictList[110].masterSeq" => "00106",
            "cmMaBknPictList[111].pictCtgCd" => "17",
            "cmMaBknPictList[111].pictNm" => "全居室複層ガラスか複層サッシ",
            "cmMaBknPictList[111].chukoFlg" => "",
            "cmMaBknPictList[111].pictCd" => "714",
            "cmMaBknPictList[111].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[111].kskJknFlg" => "0",
            "cmMaBknPictList[111].masterSeq" => "00140",
            "cmMaBknPictList[112].pictCtgCd" => "17",
            "cmMaBknPictList[112].pictNm" => "オール電化",
            "cmMaBknPictList[112].chukoFlg" => "",
            "cmMaBknPictList[112].pictCd" => "184",
            "cmMaBknPictList[112].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[112].kskJknFlg" => "1",
            "cmMaBknPictList[112].masterSeq" => "00186",
            "cmMaBknPictList[113].pictCtgCd" => "18",
            "cmMaBknPictList[113].pictNm" => "高速ネット対応",
            "cmMaBknPictList[113].chukoFlg" => "",
            "cmMaBknPictList[113].pictCd" => "583",
            "cmMaBknPictList[113].pictCtgNm" => "テレビ・通信",
            "cmMaBknPictList[113].kskJknFlg" => "0",
            "cmMaBknPictList[113].masterSeq" => "00111",
            "cmMaBknPictList[114].pictCtgCd" => "18",
            "cmMaBknPictList[114].pictNm" => "BS・CS・CATV",
            "cmMaBknPictList[114].chukoFlg" => "",
            "cmMaBknPictList[114].pictCd" => "680",
            "cmMaBknPictList[114].pictCtgNm" => "テレビ・通信",
            "cmMaBknPictList[114].kskJknFlg" => "0",
            "cmMaBknPictList[114].masterSeq" => "00146",
            "cmMaBknPictList[115].pictCtgCd" => "19",
            "cmMaBknPictList[115].pictNm" => "駐車２台可",
            "cmMaBknPictList[115].chukoFlg" => "",
            "cmMaBknPictList[115].pictCd" => "043",
            "cmMaBknPictList[115].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[115].kskJknFlg" => "1",
            "cmMaBknPictList[115].masterSeq" => "00034",
            "cmMaBknPictList[116].pictCtgCd" => "19",
            "cmMaBknPictList[116].pictNm" => "駐車３台以上可",
            "cmMaBknPictList[116].chukoFlg" => "",
            "cmMaBknPictList[116].pictCd" => "681",
            "cmMaBknPictList[116].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[116].kskJknFlg" => "1",
            "cmMaBknPictList[116].masterSeq" => "00035",
            "cmMaBknPictList[117].pictCtgCd" => "19",
            "cmMaBknPictList[117].pictNm" => "ハイルーフ駐車場",
            "cmMaBknPictList[117].chukoFlg" => "",
            "cmMaBknPictList[117].pictCd" => "711",
            "cmMaBknPictList[117].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[117].kskJknFlg" => "1",
            "cmMaBknPictList[117].masterSeq" => "00091",
            "cmMaBknPictList[118].pictCtgCd" => "19",
            "cmMaBknPictList[118].pictNm" => "EV車充電設備",
            "cmMaBknPictList[118].chukoFlg" => "",
            "cmMaBknPictList[118].pictCd" => "720",
            "cmMaBknPictList[118].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[118].kskJknFlg" => "0",
            "cmMaBknPictList[118].masterSeq" => "00092",
            "cmMaBknPictList[119].pictCtgCd" => "19",
            "cmMaBknPictList[119].pictNm" => "シャッター車庫",
            "cmMaBknPictList[119].chukoFlg" => "",
            "cmMaBknPictList[119].pictCd" => "220",
            "cmMaBknPictList[119].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[119].kskJknFlg" => "0",
            "cmMaBknPictList[119].masterSeq" => "00130",
            "cmMaBknPictList[120].pictCtgCd" => "19",
            "cmMaBknPictList[120].pictNm" => "ビルトインガレージ",
            "cmMaBknPictList[120].chukoFlg" => "",
            "cmMaBknPictList[120].pictCd" => "202",
            "cmMaBknPictList[120].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[120].kskJknFlg" => "0",
            "cmMaBknPictList[120].masterSeq" => "00193",
            "cmMaBknPictList[121].pictCtgCd" => "20",
            "cmMaBknPictList[121].pictNm" => "プール",
            "cmMaBknPictList[121].chukoFlg" => "",
            "cmMaBknPictList[121].pictCd" => "376",
            "cmMaBknPictList[121].pictCtgNm" => "共用部",
            "cmMaBknPictList[121].kskJknFlg" => "0",
            "cmMaBknPictList[121].masterSeq" => "00089",
            "cmMaBknPictList[122].pictCtgCd" => "20",
            "cmMaBknPictList[122].pictNm" => "共用露天風呂",
            "cmMaBknPictList[122].chukoFlg" => "",
            "cmMaBknPictList[122].pictCd" => "655",
            "cmMaBknPictList[122].pictCtgNm" => "共用部",
            "cmMaBknPictList[122].kskJknFlg" => "0",
            "cmMaBknPictList[122].masterSeq" => "00179",
            "cmMaBknPictList[123].pictCtgCd" => "21",
            "cmMaBknPictList[123].pictNm" => "セキュリティ充実",
            "cmMaBknPictList[123].chukoFlg" => "",
            "cmMaBknPictList[123].pictCd" => "691",
            "cmMaBknPictList[123].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[123].kskJknFlg" => "1",
            "cmMaBknPictList[123].masterSeq" => "00090",
            "cmMaBknPictList[124].pictCtgCd" => "21",
            "cmMaBknPictList[124].pictNm" => "ＴＶモニタ付インターホン",
            "cmMaBknPictList[124].chukoFlg" => "",
            "cmMaBknPictList[124].pictCd" => "085",
            "cmMaBknPictList[124].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[124].kskJknFlg" => "0",
            "cmMaBknPictList[124].masterSeq" => "00119",
            "cmMaBknPictList[125].pictCtgCd" => "21",
            "cmMaBknPictList[125].pictNm" => "２４時間有人管理",
            "cmMaBknPictList[125].chukoFlg" => "",
            "cmMaBknPictList[125].pictCd" => "087",
            "cmMaBknPictList[125].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[125].kskJknFlg" => "0",
            "cmMaBknPictList[125].masterSeq" => "00157",
            "cmMaBknPictList[126].pictCtgCd" => "22",
            "cmMaBknPictList[126].pictNm" => "適合リノベーション",
            "cmMaBknPictList[126].chukoFlg" => "",
            "cmMaBknPictList[126].pictCd" => "647",
            "cmMaBknPictList[126].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[126].kskJknFlg" => "1",
            "cmMaBknPictList[126].masterSeq" => "00030",
            "cmMaBknPictList[127].pictCtgCd" => "22",
            "cmMaBknPictList[127].pictNm" => "内外装リフォーム",
            "cmMaBknPictList[127].chukoFlg" => "",
            "cmMaBknPictList[127].pictCd" => "685",
            "cmMaBknPictList[127].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[127].kskJknFlg" => "1",
            "cmMaBknPictList[127].masterSeq" => "00058",
            "cmMaBknPictList[128].pictCtgCd" => "22",
            "cmMaBknPictList[128].pictNm" => "内装リフォーム",
            "cmMaBknPictList[128].chukoFlg" => "",
            "cmMaBknPictList[128].pictCd" => "683",
            "cmMaBknPictList[128].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[128].kskJknFlg" => "1",
            "cmMaBknPictList[128].masterSeq" => "00059",
            "cmMaBknPictList[129].pictCtgCd" => "22",
            "cmMaBknPictList[129].pictNm" => "外装リフォーム",
            "cmMaBknPictList[129].chukoFlg" => "",
            "cmMaBknPictList[129].pictCd" => "684",
            "cmMaBknPictList[129].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[129].kskJknFlg" => "1",
            "cmMaBknPictList[129].masterSeq" => "00100",
            "cmMaBknPictList[130].pictCtgCd" => "22",
            "cmMaBknPictList[130].pictNm" => "フローリング張替",
            "cmMaBknPictList[130].chukoFlg" => "",
            "cmMaBknPictList[130].pictCd" => "536",
            "cmMaBknPictList[130].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[130].kskJknFlg" => "0",
            "cmMaBknPictList[130].masterSeq" => "00105",
            "cmMaBknPictList[131].pictCtgCd" => "22",
            "cmMaBknPictList[131].pictNm" => "リノベーション",
            "cmMaBknPictList[131].chukoFlg" => "",
            "cmMaBknPictList[131].pictCd" => "590",
            "cmMaBknPictList[131].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[131].kskJknFlg" => "1",
            "cmMaBknPictList[131].masterSeq" => "00120",
            "cmMaBknPictList[132].pictCtgCd" => "23",
            "cmMaBknPictList[132].pictNm" => "スキー場が近い",
            "cmMaBknPictList[132].chukoFlg" => "",
            "cmMaBknPictList[132].pictCd" => "671",
            "cmMaBknPictList[132].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[132].kskJknFlg" => "0",
            "cmMaBknPictList[132].masterSeq" => "00051",
            "cmMaBknPictList[133].pictCtgCd" => "23",
            "cmMaBknPictList[133].pictNm" => "ゴルフ場が近い",
            "cmMaBknPictList[133].chukoFlg" => "",
            "cmMaBknPictList[133].pictCd" => "670",
            "cmMaBknPictList[133].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[133].kskJknFlg" => "0",
            "cmMaBknPictList[133].masterSeq" => "00052",
            "cmMaBknPictList[134].pictCtgCd" => "23",
            "cmMaBknPictList[134].pictNm" => "テニスコートが近い",
            "cmMaBknPictList[134].chukoFlg" => "",
            "cmMaBknPictList[134].pictCd" => "669",
            "cmMaBknPictList[134].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[134].kskJknFlg" => "0",
            "cmMaBknPictList[134].masterSeq" => "00053",
            "cmMaBknPictList[135].pictCtgCd" => "23",
            "cmMaBknPictList[135].pictNm" => "スーパー 徒歩10分以内",
            "cmMaBknPictList[135].chukoFlg" => "",
            "cmMaBknPictList[135].pictCd" => "668",
            "cmMaBknPictList[135].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[135].kskJknFlg" => "1",
            "cmMaBknPictList[135].masterSeq" => "00054",
            "cmMaBknPictList[136].pictCtgCd" => "23",
            "cmMaBknPictList[136].pictNm" => "総合病院 徒歩10分以内",
            "cmMaBknPictList[136].chukoFlg" => "",
            "cmMaBknPictList[136].pictCd" => "712",
            "cmMaBknPictList[136].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[136].kskJknFlg" => "1",
            "cmMaBknPictList[136].masterSeq" => "00072",
            "cmMaBknPictList[137].pictCtgCd" => "23",
            "cmMaBknPictList[137].pictNm" => "小学校 徒歩10分以内",
            "cmMaBknPictList[137].chukoFlg" => "",
            "cmMaBknPictList[137].pictCd" => "713",
            "cmMaBknPictList[137].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[137].kskJknFlg" => "1",
            "cmMaBknPictList[137].masterSeq" => "00149",
            "cmMaBknPictList[138].pictCtgCd" => "23",
            "cmMaBknPictList[138].pictNm" => "周辺交通量少なめ",
            "cmMaBknPictList[138].chukoFlg" => "",
            "cmMaBknPictList[138].pictCd" => "667",
            "cmMaBknPictList[138].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[138].kskJknFlg" => "0",
            "cmMaBknPictList[138].masterSeq" => "00183",
            "cmMaBknPictList[139].pictCtgCd" => "23",
            "cmMaBknPictList[139].pictNm" => "隣家との間隔が大きい",
            "cmMaBknPictList[139].chukoFlg" => "",
            "cmMaBknPictList[139].pictCd" => "672",
            "cmMaBknPictList[139].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[139].kskJknFlg" => "1",
            "cmMaBknPictList[139].masterSeq" => "00184",
            "cmMaBknPictList[140].pictCtgCd" => "23",
            "cmMaBknPictList[140].pictNm" => "整備された歩道",
            "cmMaBknPictList[140].chukoFlg" => "",
            "cmMaBknPictList[140].pictCd" => "673",
            "cmMaBknPictList[140].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[140].kskJknFlg" => "0",
            "cmMaBknPictList[140].masterSeq" => "00185",
            "cmMaBknPictList[141].pictCtgCd" => "24",
            "cmMaBknPictList[141].pictNm" => "リバーサイド",
            "cmMaBknPictList[141].chukoFlg" => "",
            "cmMaBknPictList[141].pictCd" => "311",
            "cmMaBknPictList[141].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[141].kskJknFlg" => "0",
            "cmMaBknPictList[141].masterSeq" => "00045",
            "cmMaBknPictList[142].pictCtgCd" => "24",
            "cmMaBknPictList[142].pictNm" => "オーシャンビュー",
            "cmMaBknPictList[142].chukoFlg" => "",
            "cmMaBknPictList[142].pictCd" => "113",
            "cmMaBknPictList[142].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[142].kskJknFlg" => "0",
            "cmMaBknPictList[142].masterSeq" => "00046",
            "cmMaBknPictList[143].pictCtgCd" => "24",
            "cmMaBknPictList[143].pictNm" => "湖・池が見える",
            "cmMaBknPictList[143].chukoFlg" => "",
            "cmMaBknPictList[143].pictCd" => "674",
            "cmMaBknPictList[143].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[143].kskJknFlg" => "0",
            "cmMaBknPictList[143].masterSeq" => "00049",
            "cmMaBknPictList[144].pictCtgCd" => "24",
            "cmMaBknPictList[144].pictNm" => "山が見える",
            "cmMaBknPictList[144].chukoFlg" => "",
            "cmMaBknPictList[144].pictCd" => "675",
            "cmMaBknPictList[144].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[144].kskJknFlg" => "0",
            "cmMaBknPictList[144].masterSeq" => "00050",
            "cmMaBknPictList[145].pictCtgCd" => "24",
            "cmMaBknPictList[145].pictNm" => "海まで2km以内",
            "cmMaBknPictList[145].chukoFlg" => "",
            "cmMaBknPictList[145].pictCd" => "224",
            "cmMaBknPictList[145].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[145].kskJknFlg" => "0",
            "cmMaBknPictList[145].masterSeq" => "00060",
            "cmMaBknPictList[146].pictCtgCd" => "24",
            "cmMaBknPictList[146].pictNm" => "田園風景",
            "cmMaBknPictList[146].chukoFlg" => "",
            "cmMaBknPictList[146].pictCd" => "312",
            "cmMaBknPictList[146].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[146].kskJknFlg" => "0",
            "cmMaBknPictList[146].masterSeq" => "00083",
            "cmMaBknPictList[147].pictCtgCd" => "24",
            "cmMaBknPictList[147].pictNm" => "眺望良好",
            "cmMaBknPictList[147].chukoFlg" => "",
            "cmMaBknPictList[147].pictCd" => "129",
            "cmMaBknPictList[147].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[147].kskJknFlg" => "0",
            "cmMaBknPictList[147].masterSeq" => "00128",
            "cmMaBknPictList[148].pictCtgCd" => "24",
            "cmMaBknPictList[148].pictNm" => "花火大会鑑賞",
            "cmMaBknPictList[148].chukoFlg" => "",
            "cmMaBknPictList[148].pictCd" => "313",
            "cmMaBknPictList[148].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[148].kskJknFlg" => "0",
            "cmMaBknPictList[148].masterSeq" => "00151",
            "cmMaBknPictList[149].pictCtgCd" => "25",
            "cmMaBknPictList[149].pictNm" => "フラット３５Sに対応",
            "cmMaBknPictList[149].chukoFlg" => "",
            "cmMaBknPictList[149].pictCd" => "676",
            "cmMaBknPictList[149].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[149].kskJknFlg" => "0",
            "cmMaBknPictList[149].masterSeq" => "00025",
            "cmMaBknPictList[150].pictCtgCd" => "25",
            "cmMaBknPictList[150].pictNm" => "年内入居可",
            "cmMaBknPictList[150].chukoFlg" => "",
            "cmMaBknPictList[150].pictCd" => "628",
            "cmMaBknPictList[150].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[150].kskJknFlg" => "0",
            "cmMaBknPictList[150].masterSeq" => "00033",
            "cmMaBknPictList[151].pictCtgCd" => "25",
            "cmMaBknPictList[151].pictNm" => "即入居可",
            "cmMaBknPictList[151].chukoFlg" => "",
            "cmMaBknPictList[151].pictCd" => "098",
            "cmMaBknPictList[151].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[151].kskJknFlg" => "1",
            "cmMaBknPictList[151].masterSeq" => "00036",
            "cmMaBknPictList[152].pictCtgCd" => "25",
            "cmMaBknPictList[152].pictNm" => "年度内入居可",
            "cmMaBknPictList[152].chukoFlg" => "",
            "cmMaBknPictList[152].pictCd" => "627",
            "cmMaBknPictList[152].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[152].kskJknFlg" => "0",
            "cmMaBknPictList[152].masterSeq" => "00042",
            "cmMaBknPictList[153].pictCtgCd" => "26",
            "cmMaBknPictList[153].pictNm" => "温泉付",
            "cmMaBknPictList[153].chukoFlg" => "",
            "cmMaBknPictList[153].pictCd" => "350",
            "cmMaBknPictList[153].pictCtgNm" => "その他",
            "cmMaBknPictList[153].kskJknFlg" => "0",
            "cmMaBknPictList[153].masterSeq" => "00048",
            "cmMaBknPictList[154].pictCtgCd" => "26",
            "cmMaBknPictList[154].pictNm" => "融雪対策",
            "cmMaBknPictList[154].chukoFlg" => "",
            "cmMaBknPictList[154].pictCd" => "690",
            "cmMaBknPictList[154].pictCtgNm" => "その他",
            "cmMaBknPictList[154].kskJknFlg" => "0",
            "cmMaBknPictList[154].masterSeq" => "00057",
            "cmMaBknPictList[155].pictCtgCd" => "26",
            "cmMaBknPictList[155].pictNm" => "家庭菜園",
            "cmMaBknPictList[155].chukoFlg" => "",
            "cmMaBknPictList[155].pictCd" => "649",
            "cmMaBknPictList[155].pictCtgNm" => "その他",
            "cmMaBknPictList[155].kskJknFlg" => "0",
            "cmMaBknPictList[155].masterSeq" => "00086",
            "cmMaBknPictList[156].pictCtgCd" => "26",
            "cmMaBknPictList[156].pictNm" => "オーナーチェンジ",
            "cmMaBknPictList[156].chukoFlg" => "",
            "cmMaBknPictList[156].pictCd" => "642",
            "cmMaBknPictList[156].pictCtgNm" => "その他",
            "cmMaBknPictList[156].kskJknFlg" => "0",
            "cmMaBknPictList[156].masterSeq" => "00138",
            "cmMaBknPictList[157].pictCtgCd" => "26",
            "cmMaBknPictList[157].pictNm" => "都市ガス",
            "cmMaBknPictList[157].chukoFlg" => "",
            "cmMaBknPictList[157].pictCd" => "677",
            "cmMaBknPictList[157].pictCtgNm" => "その他",
            "cmMaBknPictList[157].kskJknFlg" => "1",
            "cmMaBknPictList[157].masterSeq" => "00141",
            "cmMaBknPictList[158].pictCtgCd" => "26",
            "cmMaBknPictList[158].pictNm" => "屋上",
            "cmMaBknPictList[158].chukoFlg" => "",
            "cmMaBknPictList[158].pictCd" => "138",
            "cmMaBknPictList[158].pictCtgNm" => "その他",
            "cmMaBknPictList[158].kskJknFlg" => "0",
            "cmMaBknPictList[158].masterSeq" => "00168",
            "cmMaBknPictList[159].pictCtgCd" => "26",
            "cmMaBknPictList[159].pictNm" => "温泉引き込み可",
            "cmMaBknPictList[159].chukoFlg" => "",
            "cmMaBknPictList[159].pictCd" => "653",
            "cmMaBknPictList[159].pictCtgNm" => "その他",
            "cmMaBknPictList[159].kskJknFlg" => "0",
            "cmMaBknPictList[159].masterSeq" => "00169",
            "cmMaBknPictList[160].pictCtgCd" => "26",
            "cmMaBknPictList[160].pictNm" => "ログハウス",
            "cmMaBknPictList[160].chukoFlg" => "",
            "cmMaBknPictList[160].pictCd" => "345",
            "cmMaBknPictList[160].pictCtgNm" => "その他",
            "cmMaBknPictList[160].kskJknFlg" => "0",
            "cmMaBknPictList[160].masterSeq" => "00172",
            "cmMaBknPictList[161].pictCtgCd" => "26",
            "cmMaBknPictList[161].pictNm" => "畑",
            "cmMaBknPictList[161].chukoFlg" => "",
            "cmMaBknPictList[161].pictCd" => "365",
            "cmMaBknPictList[161].pictCtgNm" => "その他",
            "cmMaBknPictList[161].kskJknFlg" => "0",
            "cmMaBknPictList[161].masterSeq" => "00173",
            "cmMaBknPictList[162].pictCtgCd" => "26",
            "cmMaBknPictList[162].pictNm" => "古民家風",
            "cmMaBknPictList[162].chukoFlg" => "",
            "cmMaBknPictList[162].pictCd" => "648",
            "cmMaBknPictList[162].pictCtgNm" => "その他",
            "cmMaBknPictList[162].kskJknFlg" => "0",
            "cmMaBknPictList[162].masterSeq" => "00175",
            "netCatch" => "",
            "netComment" => "",
            "eventInfoKbn" => "0",
            "eventScheduleKbn" => "0",
            "kikanEventKaishiDate1" => "",
            "kikanEventShuryoDate1" => "",
            "eventDate11" => "",
            "eventDate12" => "",
            "eventDate13" => "",
            "eventDate14" => "",
            "eventDate15" => "",
            "eventDate16" => "",
            "eventDate17" => "",
            "eventDate18" => "",
            "eventDate19" => "",
            "eventDate110" => "",
            "eventDate111" => "",
            "eventDate112" => "",
            "netEventKaishiTimeH" => "",
            "netEventKaishiTimeM" => "",
            "netEventShuryoTimeH" => "",
            "netEventShuryoTimeM" => "",
            "eventActionKbn" => "0",
            "eventInfo" => "",
            "kkbPicComment" => "",
            "btobHoushukeitai" => "0",
            "btobKokokuhitou" => "0",
            "btobGazoId" => "",
            "btobGazoPtn" => "0",
            "btobMainCatch" => "",
            "btobSubCatch1" => "",
            "btobSubCatch2" => "",
            "btobSubCatch3" => "",
            "btobSubCatch4" => "",
            "btobSubCatch5" => "",
            "btobComment" => "",
            "netRenzokuKeisaiKikan" => "8",
            "maemaegaiHatubaigo" => "10/30号",
            "zengaiHatubaigo" => "11/6号",
            "zenzenKeisaiJyouhouList[0]" => "",
            "zenKeisaiJyouhouList[0]" => "",
        ];

        $url = "https://manager.suumo.jp/chukai/tn01Xx0104/update1K";
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_REFERER, 'https://manager.suumo.jp/chukai/tn01Xx0104.do');
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3', 'Accept-Language: ja,en-US;q=0.9,en;q=0.8', 'Cache-Control: max-age=0', 'Connection: keep-alive', 'Host: manager.suumo.jp', 'Origin: https://manager.suumo.jp', 'Sec-Fetch-Mode: navigate', 'Sec-Fetch-Site: same-origin', 'Sec-Fetch-User: ?1', 'Upgrade-Insecure-Requests: 1']);
        curl_setopt($curl, CURLINFO_HEADER_OUT, TRUE);
        curl_setopt($curl, CURLOPT_MAXREDIRS,10);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_AUTOREFERER,TRUE);//リダイレクトの際にヘッダのRefererを自動的に追加させる
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        if( $res === FALSE ) {
            // エラー文字列を出力する
            echo curl_error($curl);
        }

        $pattern = '/<span class="tar b">物件CD：(.*?)<\/span>/s';
        preg_match($pattern, $res, $match1);
        $save_data = ['suumo_no' => $match1[1]];
        Article::where('building_id', $article->building_id)->update($save_data);
    }

    function saveMansion($article) {
        // 物件登録画面へアクセス マンション1戸
        $url = "https://manager.suumo.jp/chukai/tn01Xx0104.do";

        // マンション
        $POST_DATA = array(
            'TB' => 13,
            'BKTB' => 10,
            'hanKubun' => '1M',
        );

        if($article->suumo_no != null) {
            $POST_DATA['bukkenCd'] = $article->suumo_no;
        }

        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        // cURLセッション実行結果の解析
        $pattern = '/<form name="tn01Xx0104ActionForm" id="mainForm" method="post" action="\/chukai\/tn01Xx0104\/" enctype="multipart\/form-data">(.*?) <\/form><form name="bukkenIdoKeidoCache">/s';
        preg_match($pattern, $res, $match1);
        $pattern = '/<input type="hidden" name="(.*?)" value="(.*?)".*?>/';
        preg_match_all($pattern, $match1[1], $match2);

        $POST_DATA = [
            "org.apache.struts.taglib.html.TOKEN" => $match2[2][0],
            "TB" => "13",
            "bukkenCd" => $match2[2][2],
            "hanKubun" => "1M",
            "bukkenShuCtg" => "1",
            "hanbaiKosuHanteiFlg" => "1",
            "gazoBukkenCd" => "",
            "motodukeHanbaijokyoflg" => "0",
            "bnjChuKbn" => "2",
            "kisBknKbn" => "1",
            "krCmR2date" => $match2[2][10],
            "jjt" => "",
            "hatchuGazoId" => "",
            "hatchuGazoCtgKbn" => "",
            "warekiSeireki" => "",
            "warekiHayamiUrl" => "/tn/edit/kaisha/wareki_seireki.html",
            "krNyukoKbn" => "00",
            "btobSakimonoBknFlg" => "0",
            "btobMotodukeBknFlg" => "0",
            "kissSetteiYohiFlg" => "0",
            "kissSetteiStatus" => "0",
            "settingChangeFlg" => "",
            "cmSts" => "0",
            "cmKokaiFlg" => "0",
            "panoramaNyukozumiFlg" => "0",
            "panoramaURL" => "",
            "projectCd" => $match2[2][26],
            "datePicker" => $match2[2][27],
            "roleCd" => "0",
            "singleGazoTotalSize" => "0",
            "gaiyouGamenKbn" => "1",
            "upBkCd" => $match2[2][31],
            "upAreaCd" => "060",
            "upRegId" => "Tn01Xx0104",
            "kotoriBukkenShuCd" => "11",
            "bukkenNm1" => $article->bukkenNm1,
            "yubinbango01" => "",
            "yubinbango02" => "",
            "comment" => "",
            "todofukenCd" => "28",
            "shikugunCd" => "228",
            "ooazaCd" => "014",
            "azaCd" => "000",
            "todofukenNm" => "兵庫県",
            "shikugunNm" => "加東市",
            "ooazaNm" => "小沢",
            "azaNm" => "　",
            "jushoMatsubi" => "テスト",
            "gaikuGotoNm" => "",
            "ido" => "",
            "keido" => "",
            "tenpoJusho" => "",
            "copyright" => "",
            "denshaBusKb1" => "1",
            "ensenNm1" => "地下鉄御堂筋線",
            "ensenCd1" => "2000",
            "ekiNm1" => "本町",
            "ekiCd1" => "35470",
            "kotsuKbn1" => "1",
            "tohoJikan1" => "6",
            "busJikan1" => "",
            "busTei1" => "",
            "teihoJikan1" => "",
            "kurumaKyori1Integer" => "",
            "kurumaKyori1Decimal" => "",
            "denshaBusKb2" => "1",
            "ensenNm2" => "",
            "ensenCd2" => "",
            "ekiNm2" => "",
            "ekiCd2" => "",
            "tohoJikan2" => "",
            "busJikan2" => "",
            "busTei2" => "",
            "teihoJikan2" => "",
            "kurumaKyori2Integer" => "",
            "kurumaKyori2Decimal" => "",
            "denshaBusKb3" => "1",
            "ensenNm3" => "",
            "ensenCd3" => "",
            "ekiNm3" => "",
            "ekiCd3" => "",
            "tohoJikan3" => "",
            "busJikan3" => "",
            "busTei3" => "",
            "teihoJikan3" => "",
            "kurumaKyori3Integer" => "",
            "kurumaKyori3Decimal" => "",
            "staffCd" => "",
            "kisStaffShimeiKnj" => "",
            "senTakuHenSyu" => "2",
            "kishaEigyoMei" => $article->kishaEigyoMei,
            "staffComment" => $article->staffComment,
            "kishaTantoNm" => "",
            "kishaBukkenCd" => "",
            "kishaComment1" => $article->kishaComment1,
            "kishaComment2" => $article->kishaComment2,
            "ikkatsuKishaBknCd" => "",
            "hpLinkNm1" => "",
            "hpLinkUrl1" => "",
            "hpLinkNm2" => "",
            "hpLinkUrl2" => "",
            "hpLinkNm3" => "",
            "hpLinkUrl3" => "",
            "hpLinkNm4" => "",
            "hpLinkUrl4" => "",
            "hpLinkNm5" => "",
            "hpLinkUrl5" => "",
            "kakakuMin" => $article->price,
            "kanriKeitai" => $article->kanriKeitai,
            "kanrihiUmu" => $article->kanrihiUmu,
            "kanrihiMin" => $article->kanrihiMin,
            "kanrihiTaniKbn" => $article->kanrihiTaniKbn,
            "sznTmtKinKbn" => $article->sznTmtKinKbn,
            "sznTmtKinMin" => $article->sznTmtKinMin,
            "sznTmtKinTaniKbn" => $article->sznTmtKinTaniKbn,
            "chushajoKbn" => $article->chushajoKbn,
            "chushajoRyoMin1" => $article->chushajoRyoMin1,
            "chushajoRyoHaniKbn" => $article->chushajoRyoHaniKbn,
            "chushajoRyoMax" => $article->chushajoRyoMax,
            "chushajoRyoTaniKbn1" => $article->chushajoRyoTaniKbn1,
            "bnjCsjKakakuMin1" => $article->bnjCsjKakakuMin1,
            "bnjCsjKakakuMin2" => $article->bnjCsjKakakuMin2,
            "bnjCsjKakakuHaniKbn" => $article->bnjCsjKakakuHaniKbn,
            "bnjCsjKakakuMax" => $article->bnjCsjKakakuMax,
            "bnjCsjKanrihi" => $article->bnjCsjKanrihi,
            "bnjCsjKanrihiTaniKbn" => $article->bnjCsjKanrihiTaniKbn,
            "bnjCsjSznTmtKin" => $article->bnjCsjSznTmtKin,
            "bnjCsjSznTmtKinTaniKbn" => $article->bnjCsjSznTmtKinTaniKbn,
            "bnjCsjSznTmtKikin" => '',
            "chushajoRyoMin2" => $article->chushajoRyoMin2,
            "chushajoRyoTaniKbn2" => $article->chushajoRyoTaniKbn2,
            "chokaihiKbn" => $article->chokaihiKbn,
            "chokaihiRyo" => $article->chokaihiRyo,
            "chokaihiRyoTaniKbn" => $article->chokaihiRyoTaniKbn,
            "yusenHiyoUmu" => $article->yusenHiyoUmu,
            "yusenShokiHiyo" => $article->yusenShokiHiyo,
            "yusenTeigakuRyo" => $article->yusenTeigakuRyo,
            "yusenTeigakuRyoTaniKbn" => $article->yusenTeigakuRyoTaniKbn,
            "internetHiyoUmu" => $article->internetHiyoUmu,
            "internetShokiHiyo" => $article->internetShokiHiyo,
            "internetTeigakuRyo" => $article->internetTeigakuRyo,
            "internetTeigakuRyoTaniKbn" => $article->internetTeigakuRyoTaniKbn,
            "catvHiyoUmu" => $article->catvHiyoUmu,
            "catvShokiHiyo" => $article->catvShokiHiyo,
            "catvTeigakuRyo" => $article->catvTeigakuRyo,
            "catvTeigakuRyoTaniKbn" => $article->catvTeigakuRyoTaniKbn,
            "onsenKenKbn" => $article->onsenKenKbn,
            "onsenKenRyoUmu" => $article->onsenKenRyoUmu,
            "onsenKenRyo" => $article->onsenKenRyo,
            "onsenKenRyoTaniKbn" => $article->onsenKenRyoTaniKbn,
            "sonota01Nm" => $article->another_cost_name1??'',
            "sonotaRyo01Min" => $article->another_cost1??'',
            "sonotaRyo01TaniKbn" => $article->another_cost_unit1??'0',
            "sonota02Nm" => $article->another_cost_name2??'',
            "sonotaRyo02Min" => $article->another_cost2??'',
            "sonotaRyo02TaniKbn" => $article->another_cost_unit2??'0',
            "shikichiKenri" => $article->shikichiKenri,
            "chidaiMin" => "",
            "chidaiTaniKbn" => "1",
            "shakuchiKikanNen" => "",
            "shakuchiKikanTsuki" => "",
            "shakuchikenWariaiMin" => "",
            "kenrikinMin" => "",
            "hoshokinShikikinMin" => "",
            "shikikinMin" => "",
            "tisSonotaKeiyakuJoko" => "",
            "tisSetteiToki" => "0",
            "tisChinryoKaiteijikiKbn" => "0",
            "tisChinryoKaiteijiki" => "",
            "tisChinryoKaiteigakuKbn" => "0",
            "tisJttKahiKbn" => "0",
            "tisJttShodakuYohiKbn" => "0",
            "tisJttShodakuryoKbn" => "0",
            "tisJttShodakunushiKbn" => "0",
            "yotochiikiCd01" => $article->yotochiikiCd01,
            "yotochiikiCd02" => $article->yotochiikiCd02,
            "sgnJikoComment" => $article->sgnJikoComment,
            "kozoKbn" => $article->kozoKbn,
            "kozoSonotaComment" => "",
            "kozoSonotaCommentIchibu" => "",
            "kozoKbnIchibu" => $article->kozoKbnIchibu,
            "sekoKaishaKbn1" => "0",
            "sekoKaishaNm" => $article->sekoKaishaNm,
            "sekoKaishaKbn2" => "0",
            "chijokaidate" => $article->chijokaidate,
            "chikakaidate" => $article->chikakaidate,
            "shozaiKaiComment" => $article->shozaiKaiComment,
            "heyaNo" => $article->heyaNo,
            "kaikoMuki" => "0",
            "senyumensekiKbn" => $article->senyumensekiKbn,
            "senyumensekiMinS" => $article->senyumensekiMinS,
            "senyumensekiMinL" => $article->senyumensekiMinL,
            "uchiChikashitsuMinS" => "",
            "uchiChikashitsuMinL" => "",
            "uchiShakoMinS" => "",
            "uchiShakoMinL" => "",
            "uchiChikachuMinS" => "",
            "uchiChikachuMinL" => "",
            "madoriMin" => $article->madoriMin,
            "madoriMinType1Kbn" => $article->madoriMinType1Kbn,
            "madoriMinType2Kbn" => "0",
            "balUmu" => $article->balUmu,
            "balMensekiMinS" => $article->balMensekiMinS,
            "balMensekiMinL" => $article->balMensekiMinL,
            "roofBalMensekiMinS" => $article->roofBalMensekiMinS,
            "roofBalMensekiMinL" => $article->roofBalMensekiMinL,
            "roofBalRyoMin" => $article->roofBalRyoMin,
            "roofBalRyoTaniKbn" => $article->roofBalRyoTaniKbn,
            "senyoNiwaMensekiMinS" => $article->senyoNiwaMensekiMinS,
            "senyoNiwaMensekiMinL" => $article->senyoNiwaMensekiMinL,
            "senyoNiwaRyoMin" => $article->senyoNiwaRyoMin,
            "senyoNiwaRyoTaniKbn" => $article->senyoNiwaRyoTaniKbn,
            "terraceMensekiMinS" => $article->terraceMensekiMinS,
            "terraceMensekiMinL" => $article->terraceMensekiMinL,
            "terraceRyoMin" => $article->terraceRyoMin,
            "terraceRyoTaniKbn" => $article->terraceRyoTaniKbn,
            "soKosu" => $article->soKosu,
            "kanseiJikiNen" => "",
            "kanseiJikiTsuki" => "",
            "tatemonoJokyoKbn" => "1",
            "nyukyoJikiKbn" => $article->nyukyoJikiKbn,
            "nyukyoJikiNen" => $article->nyukyoJikiNen,
            "nyukyoJikiTsuki" => $article->nyukyoJikiTsuki,
            "nyukyoJikiTsukiSu" => $article->nyukyoJikiTsukiSu,
            "gaisoUmu" => $article->gaisoUmu,
            "gaisoNen" => $article->gaisoNen,
            "gaisoTsuki" => $article->gaisoTsuki,
            "gaisoComment" => "",
            "naisoUmu" => $article->naisoUmu,
            "naisoNen" => $article->naisoNen,
            "naisoTsuki" => $article->naisoTsuki,
            "naisoComment" => "",
            "kaishaDispSeq01" => "",
            "torihikitaiyoKbn01" => "03",
            "torihikitaiyoComment01" => "",
            "hoshiMarkKbn" => "0",
            "motoGyoshaNm" => "",
            "motoGyoshaTelShigai" => "",
            "motoGyoshaTelShinai" => "",
            "motoGyoshaTelNo" => "",
            "motoGyoshaTantoNm" => "",
            "kissFreeKbn01" => "0",
            "dispKaishaNm01" => "ウィル不動産販売 宝塚本店(株)ウィル",
            "kaishaCd01" => "068892",
            "mdgCd01" => "000",
            "kaishaYubinbango01" => "6650035",
            "kaishaJusho01" => "兵庫県宝塚市逆瀬川1-14-6",
            "shozokuDantai101" => "",
            "menkyoBangoComment01" => "国土交通大臣(4)第006447号",
            "kaishaNm01" => "ウィル不動産販売 宝塚本店(株)ウィル",
            "kaishaDispSeq02" => "",
            "kissFreeKbn02" => "0",
            "dispKaishaNm02" => "",
            "kaishaCd02" => "",
            "mdgCd02" => "",
            "kaishaDispSeq03" => "",
            "kissFreeKbn03" => "0",
            "dispKaishaNm03" => "",
            "kaishaCd03" => "",
            "mdgCd03" => "",
            "kaishaDispSeq04" => "",
            "kissFreeKbn04" => "0",
            "dispKaishaNm04" => "",
            "kaishaCd04" => "",
            "mdgCd04" => "",
            "kaishaDispSeq05" => "",
            "kissFreeKbn05" => "0",
            "dispKaishaNm05" => "",
            "kaishaCd05" => "",
            "mdgCd05" => "",
            "kaishaDispSeq06" => "",
            "kissFreeKbn06" => "0",
            "dispKaishaNm06" => "",
            "kaishaCd06" => "",
            "mdgCd06" => "",
            "kaishaDispSeq07" => "",
            "kissFreeKbn07" => "0",
            "dispKaishaNm07" => "",
            "kaishaCd07" => "",
            "mdgCd07" => "",
            "kaishaDispSeq08" => "",
            "kissFreeKbn08" => "0",
            "dispKaishaNm08" => "",
            "kaishaCd08" => "",
            "mdgCd08" => "",
            "kaishaDispSeq09" => "",
            "kissFreeKbn09" => "0",
            "dispKaishaNm09" => "",
            "kaishaCd09" => "",
            "mdgCd09" => "",
            "kaishaDispSeq10" => "",
            "kissFreeKbn10" => "0",
            "dispKaishaNm10" => "",
            "kaishaCd10" => "",
            "mdgCd10" => "",
            "kaishaDispSeq11" => "",
            "kissFreeKbn11" => "0",
            "dispKaishaNm11" => "",
            "kaishaCd11" => "",
            "mdgCd11" => "",
            "kaishaDispSeq12" => "",
            "kissFreeKbn12" => "0",
            "dispKaishaNm12" => "",
            "kaishaCd12" => "",
            "mdgCd12" => "",
            "kaishaDispSeq13" => "",
            "kissFreeKbn13" => "0",
            "dispKaishaNm13" => "",
            "kaishaCd13" => "",
            "mdgCd13" => "",
            "kaishaDispSeq14" => "",
            "kissFreeKbn14" => "0",
            "dispKaishaNm14" => "",
            "kaishaCd14" => "",
            "mdgCd14" => "",
            "kaishaDispSeq15" => "",
            "kissFreeKbn15" => "0",
            "dispKaishaNm15" => "",
            "kaishaCd15" => "",
            "mdgCd15" => "",
            "jigKbn" => "0",
            "jigComment" => "",
            "jigToshiShunyu" => "",
            "jigToshiShunyuTaniKbn" => "1",
            "jigToshiNenRimawariS" => "",
            "jigToshiNenRimawariL" => "",
            "cmMaBknPictList[0].pictCtgCd" => "01",
            "cmMaBknPictList[0].pictNm" => "耐震基準適合証明書",
            "cmMaBknPictList[0].chukoFlg" => "1",
            "cmMaBknPictList[0].pictCd" => "687",
            "cmMaBknPictList[0].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[0].kskJknFlg" => "1",
            "cmMaBknPictList[0].masterSeq" => "00001",
            "cmMaBknPictList[1].pictCtgCd" => "01",
            "cmMaBknPictList[1].pictNm" => "長期優良住宅認定通知書",
            "cmMaBknPictList[1].chukoFlg" => "",
            "cmMaBknPictList[1].pictCd" => "319",
            "cmMaBknPictList[1].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[1].kskJknFlg" => "1",
            "cmMaBknPictList[1].masterSeq" => "00002",
            "cmMaBknPictList[2].pictCtgCd" => "01",
            "cmMaBknPictList[2].pictNm" => "設計住宅性能評価書",
            "cmMaBknPictList[2].chukoFlg" => "",
            "cmMaBknPictList[2].pictCd" => "142",
            "cmMaBknPictList[2].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[2].kskJknFlg" => "1",
            "cmMaBknPictList[2].masterSeq" => "00003",
            "cmMaBknPictList[3].pictCtgCd" => "01",
            "cmMaBknPictList[3].pictNm" => "建設住宅性能評価書（新築時）",
            "cmMaBknPictList[3].chukoFlg" => "",
            "cmMaBknPictList[3].pictCd" => "695",
            "cmMaBknPictList[3].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[3].kskJknFlg" => "1",
            "cmMaBknPictList[3].masterSeq" => "00004",
            "cmMaBknPictList[4].pictCtgCd" => "01",
            "cmMaBknPictList[4].pictNm" => "建設住宅性能評価書（既存住宅）",
            "cmMaBknPictList[4].chukoFlg" => "1",
            "cmMaBknPictList[4].pictCd" => "696",
            "cmMaBknPictList[4].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[4].kskJknFlg" => "1",
            "cmMaBknPictList[4].masterSeq" => "00005",
            "cmMaBknPictList[5].pictCtgCd" => "01",
            "cmMaBknPictList[5].pictNm" => "建築確認完了検査済証",
            "cmMaBknPictList[5].chukoFlg" => "1",
            "cmMaBknPictList[5].pictCd" => "697",
            "cmMaBknPictList[5].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[5].kskJknFlg" => "1",
            "cmMaBknPictList[5].masterSeq" => "00006",
            "cmMaBknPictList[6].pictCtgCd" => "01",
            "cmMaBknPictList[6].pictNm" => "法適合状況調査報告書",
            "cmMaBknPictList[6].chukoFlg" => "1",
            "cmMaBknPictList[6].pictCd" => "698",
            "cmMaBknPictList[6].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[6].kskJknFlg" => "1",
            "cmMaBknPictList[6].masterSeq" => "00007",
            "cmMaBknPictList[7].pictCtgCd" => "01",
            "cmMaBknPictList[7].pictNm" => "低炭素住宅",
            "cmMaBknPictList[7].chukoFlg" => "",
            "cmMaBknPictList[7].pictCd" => "699",
            "cmMaBknPictList[7].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[7].kskJknFlg" => "1",
            "cmMaBknPictList[7].masterSeq" => "00008",
            "cmMaBknPictList[8].pictCtgCd" => "01",
            "cmMaBknPictList[8].pictNm" => "BELS/省エネ基準適合認定書あり",
            "cmMaBknPictList[8].chukoFlg" => "1",
            "cmMaBknPictList[8].pictCd" => "700",
            "cmMaBknPictList[8].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[8].kskJknFlg" => "0",
            "cmMaBknPictList[8].masterSeq" => "00009",
            "cmMaBknPictList[9].pictCtgCd" => "01",
            "cmMaBknPictList[9].pictNm" => "制震・免震・耐震",
            "cmMaBknPictList[9].chukoFlg" => "",
            "cmMaBknPictList[9].pictCd" => "689",
            "cmMaBknPictList[9].pictCtgNm" => "物件の性能",
            "cmMaBknPictList[9].kskJknFlg" => "1",
            "cmMaBknPictList[9].masterSeq" => "00010",
            "cmMaBknPictList[10].pictCtgCd" => "02",
            "cmMaBknPictList[10].pictNm" => "瑕疵保険（国交省指定）保証利用可",
            "cmMaBknPictList[10].chukoFlg" => "1",
            "cmMaBknPictList[10].pictCd" => "701",
            "cmMaBknPictList[10].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[10].kskJknFlg" => "1",
            "cmMaBknPictList[10].masterSeq" => "00011",
            "cmMaBknPictList[11].pictCtgCd" => "02",
            "cmMaBknPictList[11].pictNm" => "瑕疵保険（国交省指定）保証付",
            "cmMaBknPictList[11].chukoFlg" => "1",
            "cmMaBknPictList[11].pictCd" => "702",
            "cmMaBknPictList[11].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[11].kskJknFlg" => "1",
            "cmMaBknPictList[11].masterSeq" => "00012",
            "cmMaBknPictList[12].pictCtgCd" => "02",
            "cmMaBknPictList[12].pictNm" => "瑕疵保証付（不動産会社独自）",
            "cmMaBknPictList[12].chukoFlg" => "1",
            "cmMaBknPictList[12].pictCd" => "703",
            "cmMaBknPictList[12].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[12].kskJknFlg" => "1",
            "cmMaBknPictList[12].masterSeq" => "00013",
            "cmMaBknPictList[13].pictCtgCd" => "02",
            "cmMaBknPictList[13].pictNm" => "フラット３５・S適合証明書",
            "cmMaBknPictList[13].chukoFlg" => "",
            "cmMaBknPictList[13].pictCd" => "704",
            "cmMaBknPictList[13].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[13].kskJknFlg" => "1",
            "cmMaBknPictList[13].masterSeq" => "00014",
            "cmMaBknPictList[14].pictCtgCd" => "02",
            "cmMaBknPictList[14].pictNm" => "建築士等の建物検査報告書",
            "cmMaBknPictList[14].chukoFlg" => "1",
            "cmMaBknPictList[14].pictCd" => "705",
            "cmMaBknPictList[14].pictCtgNm" => "建物検査（インスペクション）",
            "cmMaBknPictList[14].kskJknFlg" => "1",
            "cmMaBknPictList[14].masterSeq" => "00015",
            "cmMaBknPictList[15].pictCtgCd" => "03",
            "cmMaBknPictList[15].pictNm" => "新築時・増改築時の設計図",
            "cmMaBknPictList[15].chukoFlg" => "1",
            "cmMaBknPictList[15].pictCd" => "706",
            "cmMaBknPictList[15].pictCtgNm" => "住宅履歴",
            "cmMaBknPictList[15].kskJknFlg" => "1",
            "cmMaBknPictList[15].masterSeq" => "00016",
            "cmMaBknPictList[16].pictCtgCd" => "03",
            "cmMaBknPictList[16].pictNm" => "修繕・点検の記録",
            "cmMaBknPictList[16].chukoFlg" => "1",
            "cmMaBknPictList[16].pictCd" => "707",
            "cmMaBknPictList[16].pictCtgNm" => "住宅履歴",
            "cmMaBknPictList[16].kskJknFlg" => "1",
            "cmMaBknPictList[16].masterSeq" => "00017",
            "cmMaBknPictList[17].pictCtgCd" => "04",
            "cmMaBknPictList[17].pictNm" => "空き家バンク登録物件",
            "cmMaBknPictList[17].chukoFlg" => "",
            "cmMaBknPictList[17].pictCd" => "708",
            "cmMaBknPictList[17].pictCtgNm" => "空き家バンク",
            "cmMaBknPictList[17].kskJknFlg" => "0",
            "cmMaBknPictList[17].masterSeq" => "00018",
            "cmMaBknPictList[18].pictCtgCd" => "05",
            "cmMaBknPictList[18].pictNm" => "市街地が近い",
            "cmMaBknPictList[18].chukoFlg" => "",
            "cmMaBknPictList[18].pictCd" => "664",
            "cmMaBknPictList[18].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[18].kskJknFlg" => "0",
            "cmMaBknPictList[18].masterSeq" => "00055",
            "cmMaBknPictList[19].pictCtgCd" => "05",
            "cmMaBknPictList[19].pictNm" => "避暑地",
            "cmMaBknPictList[19].chukoFlg" => "",
            "cmMaBknPictList[19].pictCd" => "658",
            "cmMaBknPictList[19].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[19].kskJknFlg" => "0",
            "cmMaBknPictList[19].masterSeq" => "00056",
            "cmMaBknPictList[20].pictCtgCd" => "05",
            "cmMaBknPictList[20].pictNm" => "閑静な住宅地",
            "cmMaBknPictList[20].chukoFlg" => "",
            "cmMaBknPictList[20].pictCd" => "097",
            "cmMaBknPictList[20].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[20].kskJknFlg" => "0",
            "cmMaBknPictList[20].masterSeq" => "00070",
            "cmMaBknPictList[21].pictCtgCd" => "05",
            "cmMaBknPictList[21].pictNm" => "緑豊かな住宅地",
            "cmMaBknPictList[21].chukoFlg" => "",
            "cmMaBknPictList[21].pictCd" => "096",
            "cmMaBknPictList[21].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[21].kskJknFlg" => "0",
            "cmMaBknPictList[21].masterSeq" => "00122",
            "cmMaBknPictList[22].pictCtgCd" => "05",
            "cmMaBknPictList[22].pictNm" => "都市近郊",
            "cmMaBknPictList[22].chukoFlg" => "",
            "cmMaBknPictList[22].pictCd" => "659",
            "cmMaBknPictList[22].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[22].kskJknFlg" => "0",
            "cmMaBknPictList[22].masterSeq" => "00123",
            "cmMaBknPictList[23].pictCtgCd" => "05",
            "cmMaBknPictList[23].pictNm" => "前面棟無",
            "cmMaBknPictList[23].chukoFlg" => "",
            "cmMaBknPictList[23].pictCd" => "130",
            "cmMaBknPictList[23].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[23].kskJknFlg" => "0",
            "cmMaBknPictList[23].masterSeq" => "00124",
            "cmMaBknPictList[24].pictCtgCd" => "05",
            "cmMaBknPictList[24].pictNm" => "高台に立地",
            "cmMaBknPictList[24].chukoFlg" => "",
            "cmMaBknPictList[24].pictCd" => "007",
            "cmMaBknPictList[24].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[24].kskJknFlg" => "0",
            "cmMaBknPictList[24].masterSeq" => "00147",
            "cmMaBknPictList[25].pictCtgCd" => "05",
            "cmMaBknPictList[25].pictNm" => "大型タウン内",
            "cmMaBknPictList[25].chukoFlg" => "",
            "cmMaBknPictList[25].pictCd" => "314",
            "cmMaBknPictList[25].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[25].kskJknFlg" => "0",
            "cmMaBknPictList[25].masterSeq" => "00150",
            "cmMaBknPictList[26].pictCtgCd" => "05",
            "cmMaBknPictList[26].pictNm" => "平坦地",
            "cmMaBknPictList[26].chukoFlg" => "",
            "cmMaBknPictList[26].pictCd" => "127",
            "cmMaBknPictList[26].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[26].kskJknFlg" => "0",
            "cmMaBknPictList[26].masterSeq" => "00154",
            "cmMaBknPictList[27].pictCtgCd" => "05",
            "cmMaBknPictList[27].pictNm" => "区画整理地内",
            "cmMaBknPictList[27].chukoFlg" => "",
            "cmMaBknPictList[27].pictCd" => "091",
            "cmMaBknPictList[27].pictCtgNm" => "立地・土地特徴",
            "cmMaBknPictList[27].kskJknFlg" => "0",
            "cmMaBknPictList[27].masterSeq" => "00164",
            "cmMaBknPictList[28].pictCtgCd" => "06",
            "cmMaBknPictList[28].pictNm" => "２沿線以上利用可",
            "cmMaBknPictList[28].chukoFlg" => "",
            "cmMaBknPictList[28].pictCd" => "692",
            "cmMaBknPictList[28].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[28].kskJknFlg" => "1",
            "cmMaBknPictList[28].masterSeq" => "00037",
            "cmMaBknPictList[29].pictCtgCd" => "06",
            "cmMaBknPictList[29].pictNm" => "駅まで平坦",
            "cmMaBknPictList[29].chukoFlg" => "",
            "cmMaBknPictList[29].pictCd" => "112",
            "cmMaBknPictList[29].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[29].kskJknFlg" => "0",
            "cmMaBknPictList[29].masterSeq" => "00068",
            "cmMaBknPictList[30].pictCtgCd" => "06",
            "cmMaBknPictList[30].pictNm" => "始発駅",
            "cmMaBknPictList[30].chukoFlg" => "",
            "cmMaBknPictList[30].pictCd" => "211",
            "cmMaBknPictList[30].pictCtgNm" => "駅利便性",
            "cmMaBknPictList[30].kskJknFlg" => "1",
            "cmMaBknPictList[30].masterSeq" => "00076",
            "cmMaBknPictList[31].pictCtgCd" => "07",
            "cmMaBknPictList[31].pictNm" => "角住戸",
            "cmMaBknPictList[31].chukoFlg" => "",
            "cmMaBknPictList[31].pictCd" => "035",
            "cmMaBknPictList[31].pictCtgNm" => "住戸・階数",
            "cmMaBknPictList[31].kskJknFlg" => "1",
            "cmMaBknPictList[31].masterSeq" => "00064",
            "cmMaBknPictList[32].pictCtgCd" => "07",
            "cmMaBknPictList[32].pictNm" => "最上階・上階なし",
            "cmMaBknPictList[32].chukoFlg" => "",
            "cmMaBknPictList[32].pictCd" => "688",
            "cmMaBknPictList[32].pictCtgNm" => "住戸・階数",
            "cmMaBknPictList[32].kskJknFlg" => "1",
            "cmMaBknPictList[32].masterSeq" => "00079",
            "cmMaBknPictList[33].pictCtgCd" => "07",
            "cmMaBknPictList[33].pictNm" => "高層階",
            "cmMaBknPictList[33].chukoFlg" => "",
            "cmMaBknPictList[33].pictCd" => "157",
            "cmMaBknPictList[33].pictCtgNm" => "住戸・階数",
            "cmMaBknPictList[33].kskJknFlg" => "0",
            "cmMaBknPictList[33].masterSeq" => "00080",
            "cmMaBknPictList[34].pictCtgCd" => "08",
            "cmMaBknPictList[34].pictNm" => "南向き",
            "cmMaBknPictList[34].chukoFlg" => "",
            "cmMaBknPictList[34].pictCd" => "032",
            "cmMaBknPictList[34].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[34].kskJknFlg" => "1",
            "cmMaBknPictList[34].masterSeq" => "00061",
            "cmMaBknPictList[35].pictCtgCd" => "08",
            "cmMaBknPictList[35].pictNm" => "陽当り良好",
            "cmMaBknPictList[35].chukoFlg" => "",
            "cmMaBknPictList[35].pictCd" => "128",
            "cmMaBknPictList[35].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[35].kskJknFlg" => "0",
            "cmMaBknPictList[35].masterSeq" => "00065",
            "cmMaBknPictList[36].pictCtgCd" => "08",
            "cmMaBknPictList[36].pictNm" => "３面採光",
            "cmMaBknPictList[36].chukoFlg" => "",
            "cmMaBknPictList[36].pictCd" => "183",
            "cmMaBknPictList[36].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[36].kskJknFlg" => "0",
            "cmMaBknPictList[36].masterSeq" => "00094",
            "cmMaBknPictList[37].pictCtgCd" => "08",
            "cmMaBknPictList[37].pictNm" => "東南向き",
            "cmMaBknPictList[37].chukoFlg" => "",
            "cmMaBknPictList[37].pictCd" => "420",
            "cmMaBknPictList[37].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[37].kskJknFlg" => "0",
            "cmMaBknPictList[37].masterSeq" => "00103",
            "cmMaBknPictList[38].pictCtgCd" => "08",
            "cmMaBknPictList[38].pictNm" => "全室南向き",
            "cmMaBknPictList[38].chukoFlg" => "",
            "cmMaBknPictList[38].pictCd" => "034",
            "cmMaBknPictList[38].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[38].kskJknFlg" => "1",
            "cmMaBknPictList[38].masterSeq" => "00108",
            "cmMaBknPictList[39].pictCtgCd" => "08",
            "cmMaBknPictList[39].pictNm" => "通風良好",
            "cmMaBknPictList[39].chukoFlg" => "",
            "cmMaBknPictList[39].pictCd" => "641",
            "cmMaBknPictList[39].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[39].kskJknFlg" => "0",
            "cmMaBknPictList[39].masterSeq" => "00125",
            "cmMaBknPictList[40].pictCtgCd" => "08",
            "cmMaBknPictList[40].pictNm" => "南西向き",
            "cmMaBknPictList[40].chukoFlg" => "",
            "cmMaBknPictList[40].pictCd" => "421",
            "cmMaBknPictList[40].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[40].kskJknFlg" => "0",
            "cmMaBknPictList[40].masterSeq" => "00131",
            "cmMaBknPictList[41].pictCtgCd" => "08",
            "cmMaBknPictList[41].pictNm" => "全室２面採光",
            "cmMaBknPictList[41].chukoFlg" => "",
            "cmMaBknPictList[41].pictCd" => "121",
            "cmMaBknPictList[41].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[41].kskJknFlg" => "0",
            "cmMaBknPictList[41].masterSeq" => "00144",
            "cmMaBknPictList[42].pictCtgCd" => "08",
            "cmMaBknPictList[42].pictNm" => "全室南西向き",
            "cmMaBknPictList[42].chukoFlg" => "",
            "cmMaBknPictList[42].pictCd" => "423",
            "cmMaBknPictList[42].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[42].kskJknFlg" => "0",
            "cmMaBknPictList[42].masterSeq" => "00152",
            "cmMaBknPictList[43].pictCtgCd" => "08",
            "cmMaBknPictList[43].pictNm" => "全室東南向き",
            "cmMaBknPictList[43].chukoFlg" => "",
            "cmMaBknPictList[43].pictCd" => "422",
            "cmMaBknPictList[43].pictCtgNm" => "陽当り・採光・通風",
            "cmMaBknPictList[43].kskJknFlg" => "0",
            "cmMaBknPictList[43].masterSeq" => "00167",
            "cmMaBknPictList[44].pictCtgCd" => "09",
            "cmMaBknPictList[44].pictNm" => "ＬＤＫ２０畳以上",
            "cmMaBknPictList[44].chukoFlg" => "",
            "cmMaBknPictList[44].pictCd" => "445",
            "cmMaBknPictList[44].pictCtgNm" => "間取り",
            "cmMaBknPictList[44].kskJknFlg" => "1",
            "cmMaBknPictList[44].masterSeq" => "00038",
            "cmMaBknPictList[45].pictCtgCd" => "09",
            "cmMaBknPictList[45].pictNm" => "ＬＤＫ１８畳以上",
            "cmMaBknPictList[45].chukoFlg" => "",
            "cmMaBknPictList[45].pictCd" => "216",
            "cmMaBknPictList[45].pictCtgNm" => "間取り",
            "cmMaBknPictList[45].kskJknFlg" => "1",
            "cmMaBknPictList[45].masterSeq" => "00041",
            "cmMaBknPictList[46].pictCtgCd" => "09",
            "cmMaBknPictList[46].pictNm" => "ＬＤＫ１５畳以上",
            "cmMaBknPictList[46].chukoFlg" => "",
            "cmMaBknPictList[46].pictCd" => "166",
            "cmMaBknPictList[46].pictCtgNm" => "間取り",
            "cmMaBknPictList[46].kskJknFlg" => "1",
            "cmMaBknPictList[46].masterSeq" => "00071",
            "cmMaBknPictList[47].pictCtgCd" => "09",
            "cmMaBknPictList[47].pictNm" => "和室",
            "cmMaBknPictList[47].chukoFlg" => "",
            "cmMaBknPictList[47].pictCd" => "452",
            "cmMaBknPictList[47].pictCtgNm" => "間取り",
            "cmMaBknPictList[47].kskJknFlg" => "1",
            "cmMaBknPictList[47].masterSeq" => "00075",
            "cmMaBknPictList[48].pictCtgCd" => "09",
            "cmMaBknPictList[48].pictNm" => "ロフト",
            "cmMaBknPictList[48].chukoFlg" => "",
            "cmMaBknPictList[48].pictCd" => "072",
            "cmMaBknPictList[48].pictCtgNm" => "間取り",
            "cmMaBknPictList[48].kskJknFlg" => "0",
            "cmMaBknPictList[48].masterSeq" => "00113",
            "cmMaBknPictList[49].pictCtgCd" => "09",
            "cmMaBknPictList[49].pictNm" => "吹抜け",
            "cmMaBknPictList[49].chukoFlg" => "",
            "cmMaBknPictList[49].pictCd" => "120",
            "cmMaBknPictList[49].pictCtgNm" => "間取り",
            "cmMaBknPictList[49].kskJknFlg" => "0",
            "cmMaBknPictList[49].masterSeq" => "00118",
            "cmMaBknPictList[50].pictCtgCd" => "09",
            "cmMaBknPictList[50].pictNm" => "全居室６畳以上",
            "cmMaBknPictList[50].chukoFlg" => "",
            "cmMaBknPictList[50].pictCd" => "222",
            "cmMaBknPictList[50].pictCtgNm" => "間取り",
            "cmMaBknPictList[50].kskJknFlg" => "1",
            "cmMaBknPictList[50].masterSeq" => "00135",
            "cmMaBknPictList[51].pictCtgCd" => "09",
            "cmMaBknPictList[51].pictNm" => "可動間仕切り",
            "cmMaBknPictList[51].chukoFlg" => "",
            "cmMaBknPictList[51].pictCd" => "336",
            "cmMaBknPictList[51].pictCtgNm" => "間取り",
            "cmMaBknPictList[51].kskJknFlg" => "0",
            "cmMaBknPictList[51].masterSeq" => "00176",
            "cmMaBknPictList[52].pictCtgCd" => "10",
            "cmMaBknPictList[52].pictNm" => "バリアフリー",
            "cmMaBknPictList[52].chukoFlg" => "",
            "cmMaBknPictList[52].pictCd" => "041",
            "cmMaBknPictList[52].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[52].kskJknFlg" => "0",
            "cmMaBknPictList[52].masterSeq" => "00095",
            "cmMaBknPictList[53].pictCtgCd" => "10",
            "cmMaBknPictList[53].pictNm" => "自然素材使用",
            "cmMaBknPictList[53].chukoFlg" => "",
            "cmMaBknPictList[53].pictCd" => "540",
            "cmMaBknPictList[53].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[53].kskJknFlg" => "0",
            "cmMaBknPictList[53].masterSeq" => "00097",
            "cmMaBknPictList[54].pictCtgCd" => "10",
            "cmMaBknPictList[54].pictNm" => "全居室フローリング",
            "cmMaBknPictList[54].chukoFlg" => "",
            "cmMaBknPictList[54].pictCd" => "070",
            "cmMaBknPictList[54].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[54].kskJknFlg" => "0",
            "cmMaBknPictList[54].masterSeq" => "00126",
            "cmMaBknPictList[55].pictCtgCd" => "10",
            "cmMaBknPictList[55].pictNm" => "天井高２．５ｍ以上",
            "cmMaBknPictList[55].chukoFlg" => "",
            "cmMaBknPictList[55].pictCd" => "212",
            "cmMaBknPictList[55].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[55].kskJknFlg" => "0",
            "cmMaBknPictList[55].masterSeq" => "00134",
            "cmMaBknPictList[56].pictCtgCd" => "10",
            "cmMaBknPictList[56].pictNm" => "床暖房",
            "cmMaBknPictList[56].chukoFlg" => "",
            "cmMaBknPictList[56].pictCd" => "073",
            "cmMaBknPictList[56].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[56].kskJknFlg" => "1",
            "cmMaBknPictList[56].masterSeq" => "00158",
            "cmMaBknPictList[57].pictCtgCd" => "10",
            "cmMaBknPictList[57].pictNm" => "スマートキー",
            "cmMaBknPictList[57].chukoFlg" => "",
            "cmMaBknPictList[57].pictCd" => "721",
            "cmMaBknPictList[57].pictCtgNm" => "室内設備・仕様",
            "cmMaBknPictList[57].kskJknFlg" => "0",
            "cmMaBknPictList[57].masterSeq" => "00191",
            "cmMaBknPictList[58].pictCtgCd" => "11",
            "cmMaBknPictList[58].pictNm" => "全居室収納",
            "cmMaBknPictList[58].chukoFlg" => "",
            "cmMaBknPictList[58].pictCd" => "067",
            "cmMaBknPictList[58].pictCtgNm" => "収納",
            "cmMaBknPictList[58].kskJknFlg" => "1",
            "cmMaBknPictList[58].masterSeq" => "00067",
            "cmMaBknPictList[59].pictCtgCd" => "11",
            "cmMaBknPictList[59].pictNm" => "床下収納",
            "cmMaBknPictList[59].chukoFlg" => "",
            "cmMaBknPictList[59].pictCd" => "066",
            "cmMaBknPictList[59].pictCtgNm" => "収納",
            "cmMaBknPictList[59].kskJknFlg" => "0",
            "cmMaBknPictList[59].masterSeq" => "00116",
            "cmMaBknPictList[60].pictCtgCd" => "11",
            "cmMaBknPictList[60].pictNm" => "ウォークインクローゼット",
            "cmMaBknPictList[60].chukoFlg" => "",
            "cmMaBknPictList[60].pictCd" => "065",
            "cmMaBknPictList[60].pictCtgNm" => "収納",
            "cmMaBknPictList[60].kskJknFlg" => "1",
            "cmMaBknPictList[60].masterSeq" => "00133",
            "cmMaBknPictList[61].pictCtgCd" => "11",
            "cmMaBknPictList[61].pictNm" => "シューズインクローク",
            "cmMaBknPictList[61].chukoFlg" => "",
            "cmMaBknPictList[61].pictCd" => "709",
            "cmMaBknPictList[61].pictCtgNm" => "収納",
            "cmMaBknPictList[61].kskJknFlg" => "1",
            "cmMaBknPictList[61].masterSeq" => "00142",
            "cmMaBknPictList[62].pictCtgCd" => "11",
            "cmMaBknPictList[62].pictNm" => "納戸",
            "cmMaBknPictList[62].chukoFlg" => "",
            "cmMaBknPictList[62].pictCd" => "069",
            "cmMaBknPictList[62].pictCtgNm" => "収納",
            "cmMaBknPictList[62].kskJknFlg" => "0",
            "cmMaBknPictList[62].masterSeq" => "00180",
            "cmMaBknPictList[63].pictCtgCd" => "12",
            "cmMaBknPictList[63].pictNm" => "システムキッチン",
            "cmMaBknPictList[63].chukoFlg" => "",
            "cmMaBknPictList[63].pictCd" => "055",
            "cmMaBknPictList[63].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[63].kskJknFlg" => "1",
            "cmMaBknPictList[63].masterSeq" => "00062",
            "cmMaBknPictList[64].pictCtgCd" => "12",
            "cmMaBknPictList[64].pictNm" => "対面式キッチン",
            "cmMaBknPictList[64].chukoFlg" => "",
            "cmMaBknPictList[64].pictCd" => "056",
            "cmMaBknPictList[64].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[64].kskJknFlg" => "1",
            "cmMaBknPictList[64].masterSeq" => "00088",
            "cmMaBknPictList[65].pictCtgCd" => "12",
            "cmMaBknPictList[65].pictNm" => "アイランドキッチン",
            "cmMaBknPictList[65].chukoFlg" => "",
            "cmMaBknPictList[65].pictCd" => "715",
            "cmMaBknPictList[65].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[65].kskJknFlg" => "0",
            "cmMaBknPictList[65].masterSeq" => "00129",
            "cmMaBknPictList[66].pictCtgCd" => "12",
            "cmMaBknPictList[66].pictNm" => "パントリー（食器・食品の収納庫）",
            "cmMaBknPictList[66].chukoFlg" => "",
            "cmMaBknPictList[66].pictCd" => "710",
            "cmMaBknPictList[66].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[66].kskJknFlg" => "1",
            "cmMaBknPictList[66].masterSeq" => "00132",
            "cmMaBknPictList[67].pictCtgCd" => "12",
            "cmMaBknPictList[67].pictNm" => "ＩＨクッキングヒーター",
            "cmMaBknPictList[67].chukoFlg" => "",
            "cmMaBknPictList[67].pictCd" => "219",
            "cmMaBknPictList[67].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[67].kskJknFlg" => "1",
            "cmMaBknPictList[67].masterSeq" => "00136",
            "cmMaBknPictList[68].pictCtgCd" => "12",
            "cmMaBknPictList[68].pictNm" => "食器洗乾燥機",
            "cmMaBknPictList[68].chukoFlg" => "",
            "cmMaBknPictList[68].pictCd" => "076",
            "cmMaBknPictList[68].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[68].kskJknFlg" => "1",
            "cmMaBknPictList[68].masterSeq" => "00181",
            "cmMaBknPictList[69].pictCtgCd" => "12",
            "cmMaBknPictList[69].pictNm" => "ディスポーザー（生ごみ粉砕処理器）",
            "cmMaBknPictList[69].chukoFlg" => "",
            "cmMaBknPictList[69].pictCd" => "716",
            "cmMaBknPictList[69].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[69].kskJknFlg" => "0",
            "cmMaBknPictList[69].masterSeq" => "00187",
            "cmMaBknPictList[70].pictCtgCd" => "12",
            "cmMaBknPictList[70].pictNm" => "浄水器",
            "cmMaBknPictList[70].chukoFlg" => "",
            "cmMaBknPictList[70].pictCd" => "119",
            "cmMaBknPictList[70].pictCtgNm" => "キッチン・関連設備",
            "cmMaBknPictList[70].kskJknFlg" => "0",
            "cmMaBknPictList[70].masterSeq" => "00188",
            "cmMaBknPictList[71].pictCtgCd" => "13",
            "cmMaBknPictList[71].pictNm" => "浴室乾燥機",
            "cmMaBknPictList[71].chukoFlg" => "",
            "cmMaBknPictList[71].pictCd" => "063",
            "cmMaBknPictList[71].pictCtgNm" => "浴室",
            "cmMaBknPictList[71].kskJknFlg" => "1",
            "cmMaBknPictList[71].masterSeq" => "00063",
            "cmMaBknPictList[72].pictCtgCd" => "13",
            "cmMaBknPictList[72].pictNm" => "ミストサウナ",
            "cmMaBknPictList[72].chukoFlg" => "",
            "cmMaBknPictList[72].pictCd" => "206",
            "cmMaBknPictList[72].pictCtgNm" => "浴室",
            "cmMaBknPictList[72].kskJknFlg" => "0",
            "cmMaBknPictList[72].masterSeq" => "00082",
            "cmMaBknPictList[73].pictCtgCd" => "13",
            "cmMaBknPictList[73].pictNm" => "浴室１坪以上",
            "cmMaBknPictList[73].chukoFlg" => "",
            "cmMaBknPictList[73].pictCd" => "100",
            "cmMaBknPictList[73].pictCtgNm" => "浴室",
            "cmMaBknPictList[73].kskJknFlg" => "1",
            "cmMaBknPictList[73].masterSeq" => "00099",
            "cmMaBknPictList[74].pictCtgCd" => "13",
            "cmMaBknPictList[74].pictNm" => "オートバス",
            "cmMaBknPictList[74].chukoFlg" => "",
            "cmMaBknPictList[74].pictCd" => "062",
            "cmMaBknPictList[74].pictCtgNm" => "浴室",
            "cmMaBknPictList[74].kskJknFlg" => "0",
            "cmMaBknPictList[74].masterSeq" => "00110",
            "cmMaBknPictList[75].pictCtgCd" => "13",
            "cmMaBknPictList[75].pictNm" => "ＴＶ付浴室",
            "cmMaBknPictList[75].chukoFlg" => "",
            "cmMaBknPictList[75].pictCd" => "060",
            "cmMaBknPictList[75].pictCtgNm" => "浴室",
            "cmMaBknPictList[75].kskJknFlg" => "0",
            "cmMaBknPictList[75].masterSeq" => "00114",
            "cmMaBknPictList[76].pictCtgCd" => "13",
            "cmMaBknPictList[76].pictNm" => "浴室に窓",
            "cmMaBknPictList[76].chukoFlg" => "",
            "cmMaBknPictList[76].pictCd" => "165",
            "cmMaBknPictList[76].pictCtgNm" => "浴室",
            "cmMaBknPictList[76].kskJknFlg" => "1",
            "cmMaBknPictList[76].masterSeq" => "00117",
            "cmMaBknPictList[77].pictCtgCd" => "13",
            "cmMaBknPictList[77].pictNm" => "ジェットバス",
            "cmMaBknPictList[77].chukoFlg" => "",
            "cmMaBknPictList[77].pictCd" => "061",
            "cmMaBknPictList[77].pictCtgNm" => "浴室",
            "cmMaBknPictList[77].kskJknFlg" => "0",
            "cmMaBknPictList[77].masterSeq" => "00143",
            "cmMaBknPictList[78].pictCtgCd" => "13",
            "cmMaBknPictList[78].pictNm" => "露天風呂",
            "cmMaBknPictList[78].chukoFlg" => "",
            "cmMaBknPictList[78].pictCd" => "654",
            "cmMaBknPictList[78].pictCtgNm" => "浴室",
            "cmMaBknPictList[78].kskJknFlg" => "0",
            "cmMaBknPictList[78].masterSeq" => "00170",
            "cmMaBknPictList[79].pictCtgCd" => "13",
            "cmMaBknPictList[79].pictNm" => "オーディオバス",
            "cmMaBknPictList[79].chukoFlg" => "",
            "cmMaBknPictList[79].pictCd" => "497",
            "cmMaBknPictList[79].pictCtgNm" => "浴室",
            "cmMaBknPictList[79].kskJknFlg" => "0",
            "cmMaBknPictList[79].masterSeq" => "00174",
            "cmMaBknPictList[80].pictCtgCd" => "14",
            "cmMaBknPictList[80].pictNm" => "シャワー付洗面化粧台",
            "cmMaBknPictList[80].chukoFlg" => "",
            "cmMaBknPictList[80].pictCd" => "205",
            "cmMaBknPictList[80].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[80].kskJknFlg" => "0",
            "cmMaBknPictList[80].masterSeq" => "00087",
            "cmMaBknPictList[81].pictCtgCd" => "14",
            "cmMaBknPictList[81].pictNm" => "トイレ２ヶ所",
            "cmMaBknPictList[81].chukoFlg" => "",
            "cmMaBknPictList[81].pictCd" => "136",
            "cmMaBknPictList[81].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[81].kskJknFlg" => "0",
            "cmMaBknPictList[81].masterSeq" => "00096",
            "cmMaBknPictList[82].pictCtgCd" => "14",
            "cmMaBknPictList[82].pictNm" => "温水洗浄便座",
            "cmMaBknPictList[82].chukoFlg" => "",
            "cmMaBknPictList[82].pictCd" => "167",
            "cmMaBknPictList[82].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[82].kskJknFlg" => "0",
            "cmMaBknPictList[82].masterSeq" => "00112",
            "cmMaBknPictList[83].pictCtgCd" => "14",
            "cmMaBknPictList[83].pictNm" => "節水型トイレ",
            "cmMaBknPictList[83].chukoFlg" => "",
            "cmMaBknPictList[83].pictCd" => "719",
            "cmMaBknPictList[83].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[83].kskJknFlg" => "0",
            "cmMaBknPictList[83].masterSeq" => "00121",
            "cmMaBknPictList[84].pictCtgCd" => "14",
            "cmMaBknPictList[84].pictNm" => "高機能トイレ",
            "cmMaBknPictList[84].chukoFlg" => "",
            "cmMaBknPictList[84].pictCd" => "694",
            "cmMaBknPictList[84].pictCtgNm" => "トイレ・洗面関連設備",
            "cmMaBknPictList[84].kskJknFlg" => "0",
            "cmMaBknPictList[84].masterSeq" => "00192",
            "cmMaBknPictList[85].pictCtgCd" => "15",
            "cmMaBknPictList[85].pictNm" => "ワイドバルコニー",
            "cmMaBknPictList[85].chukoFlg" => "",
            "cmMaBknPictList[85].pictCd" => "203",
            "cmMaBknPictList[85].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[85].kskJknFlg" => "1",
            "cmMaBknPictList[85].masterSeq" => "00093",
            "cmMaBknPictList[86].pictCtgCd" => "15",
            "cmMaBknPictList[86].pictNm" => "２面以上バルコニー",
            "cmMaBknPictList[86].chukoFlg" => "",
            "cmMaBknPictList[86].pictCd" => "678",
            "cmMaBknPictList[86].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[86].kskJknFlg" => "0",
            "cmMaBknPictList[86].masterSeq" => "00102",
            "cmMaBknPictList[87].pictCtgCd" => "15",
            "cmMaBknPictList[87].pictNm" => "南面バルコニー",
            "cmMaBknPictList[87].chukoFlg" => "",
            "cmMaBknPictList[87].pictCd" => "532",
            "cmMaBknPictList[87].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[87].kskJknFlg" => "1",
            "cmMaBknPictList[87].masterSeq" => "00104",
            "cmMaBknPictList[88].pictCtgCd" => "15",
            "cmMaBknPictList[88].pictNm" => "ウッドデッキ",
            "cmMaBknPictList[88].chukoFlg" => "",
            "cmMaBknPictList[88].pictCd" => "047",
            "cmMaBknPictList[88].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[88].kskJknFlg" => "0",
            "cmMaBknPictList[88].masterSeq" => "00127",
            "cmMaBknPictList[89].pictCtgCd" => "15",
            "cmMaBknPictList[89].pictNm" => "ルーフバルコニー",
            "cmMaBknPictList[89].chukoFlg" => "",
            "cmMaBknPictList[89].pictCd" => "029",
            "cmMaBknPictList[89].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[89].kskJknFlg" => "1",
            "cmMaBknPictList[89].masterSeq" => "00153",
            "cmMaBknPictList[90].pictCtgCd" => "15",
            "cmMaBknPictList[90].pictNm" => "テラス",
            "cmMaBknPictList[90].chukoFlg" => "",
            "cmMaBknPictList[90].pictCd" => "106",
            "cmMaBknPictList[90].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[90].kskJknFlg" => "0",
            "cmMaBknPictList[90].masterSeq" => "00162",
            "cmMaBknPictList[91].pictCtgCd" => "15",
            "cmMaBknPictList[91].pictNm" => "バルコニー・屋上に水栓あり",
            "cmMaBknPictList[91].chukoFlg" => "",
            "cmMaBknPictList[91].pictCd" => "718",
            "cmMaBknPictList[91].pictCtgNm" => "バルコニー・テラス",
            "cmMaBknPictList[91].kskJknFlg" => "0",
            "cmMaBknPictList[91].masterSeq" => "00190",
            "cmMaBknPictList[92].pictCtgCd" => "16",
            "cmMaBknPictList[92].pictNm" => "庭１０坪以上",
            "cmMaBknPictList[92].chukoFlg" => "",
            "cmMaBknPictList[92].pictCd" => "428",
            "cmMaBknPictList[92].pictCtgNm" => "庭",
            "cmMaBknPictList[92].kskJknFlg" => "0",
            "cmMaBknPictList[92].masterSeq" => "00081",
            "cmMaBknPictList[93].pictCtgCd" => "16",
            "cmMaBknPictList[93].pictNm" => "南庭",
            "cmMaBknPictList[93].chukoFlg" => "",
            "cmMaBknPictList[93].pictCd" => "135",
            "cmMaBknPictList[93].pictCtgNm" => "庭",
            "cmMaBknPictList[93].kskJknFlg" => "0",
            "cmMaBknPictList[93].masterSeq" => "00115",
            "cmMaBknPictList[94].pictCtgCd" => "16",
            "cmMaBknPictList[94].pictNm" => "専用庭",
            "cmMaBknPictList[94].chukoFlg" => "",
            "cmMaBknPictList[94].pictCd" => "049",
            "cmMaBknPictList[94].pictCtgNm" => "庭",
            "cmMaBknPictList[94].kskJknFlg" => "1",
            "cmMaBknPictList[94].masterSeq" => "00163",
            "cmMaBknPictList[95].pictCtgCd" => "17",
            "cmMaBknPictList[95].pictNm" => "エコポイント対象住宅",
            "cmMaBknPictList[95].chukoFlg" => "",
            "cmMaBknPictList[95].pictCd" => "661",
            "cmMaBknPictList[95].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[95].kskJknFlg" => "0",
            "cmMaBknPictList[95].masterSeq" => "00022",
            "cmMaBknPictList[96].pictCtgCd" => "17",
            "cmMaBknPictList[96].pictNm" => "省エネルギー対策",
            "cmMaBknPictList[96].chukoFlg" => "",
            "cmMaBknPictList[96].pictCd" => "040",
            "cmMaBknPictList[96].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[96].kskJknFlg" => "0",
            "cmMaBknPictList[96].masterSeq" => "00023",
            "cmMaBknPictList[97].pictCtgCd" => "17",
            "cmMaBknPictList[97].pictNm" => "高気密高断熱住宅",
            "cmMaBknPictList[97].chukoFlg" => "",
            "cmMaBknPictList[97].pictCd" => "321",
            "cmMaBknPictList[97].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[97].kskJknFlg" => "0",
            "cmMaBknPictList[97].masterSeq" => "00027",
            "cmMaBknPictList[98].pictCtgCd" => "17",
            "cmMaBknPictList[98].pictNm" => "省エネ給湯器",
            "cmMaBknPictList[98].chukoFlg" => "",
            "cmMaBknPictList[98].pictCd" => "679",
            "cmMaBknPictList[98].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[98].kskJknFlg" => "1",
            "cmMaBknPictList[98].masterSeq" => "00047",
            "cmMaBknPictList[99].pictCtgCd" => "17",
            "cmMaBknPictList[99].pictNm" => "複層ガラス",
            "cmMaBknPictList[99].chukoFlg" => "",
            "cmMaBknPictList[99].pictCd" => "109",
            "cmMaBknPictList[99].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[99].kskJknFlg" => "0",
            "cmMaBknPictList[99].masterSeq" => "00106",
            "cmMaBknPictList[100].pictCtgCd" => "17",
            "cmMaBknPictList[100].pictNm" => "全居室複層ガラスか複層サッシ",
            "cmMaBknPictList[100].chukoFlg" => "",
            "cmMaBknPictList[100].pictCd" => "714",
            "cmMaBknPictList[100].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[100].kskJknFlg" => "0",
            "cmMaBknPictList[100].masterSeq" => "00140",
            "cmMaBknPictList[101].pictCtgCd" => "17",
            "cmMaBknPictList[101].pictNm" => "オール電化",
            "cmMaBknPictList[101].chukoFlg" => "",
            "cmMaBknPictList[101].pictCd" => "184",
            "cmMaBknPictList[101].pictCtgNm" => "エコ関連",
            "cmMaBknPictList[101].kskJknFlg" => "1",
            "cmMaBknPictList[101].masterSeq" => "00186",
            "cmMaBknPictList[102].pictCtgCd" => "18",
            "cmMaBknPictList[102].pictNm" => "高速ネット対応",
            "cmMaBknPictList[102].chukoFlg" => "",
            "cmMaBknPictList[102].pictCd" => "583",
            "cmMaBknPictList[102].pictCtgNm" => "テレビ・通信",
            "cmMaBknPictList[102].kskJknFlg" => "1",
            "cmMaBknPictList[102].masterSeq" => "00111",
            "cmMaBknPictList[103].pictCtgCd" => "18",
            "cmMaBknPictList[103].pictNm" => "BS・CS・CATV",
            "cmMaBknPictList[103].chukoFlg" => "",
            "cmMaBknPictList[103].pictCd" => "680",
            "cmMaBknPictList[103].pictCtgNm" => "テレビ・通信",
            "cmMaBknPictList[103].kskJknFlg" => "1",
            "cmMaBknPictList[103].masterSeq" => "00146",
            "cmMaBknPictList[104].pictCtgCd" => "19",
            "cmMaBknPictList[104].pictNm" => "駐車２台可",
            "cmMaBknPictList[104].chukoFlg" => "",
            "cmMaBknPictList[104].pictCd" => "043",
            "cmMaBknPictList[104].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[104].kskJknFlg" => "0",
            "cmMaBknPictList[104].masterSeq" => "00034",
            "cmMaBknPictList[105].pictCtgCd" => "19",
            "cmMaBknPictList[105].pictNm" => "ハイルーフ駐車場空きあり",
            "cmMaBknPictList[105].chukoFlg" => "",
            "cmMaBknPictList[105].pictCd" => "711",
            "cmMaBknPictList[105].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[105].kskJknFlg" => "1",
            "cmMaBknPictList[105].masterSeq" => "00091",
            "cmMaBknPictList[106].pictCtgCd" => "19",
            "cmMaBknPictList[106].pictNm" => "EV車充電設備",
            "cmMaBknPictList[106].chukoFlg" => "",
            "cmMaBknPictList[106].pictCd" => "720",
            "cmMaBknPictList[106].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[106].kskJknFlg" => "0",
            "cmMaBknPictList[106].masterSeq" => "00092",
            "cmMaBknPictList[107].pictCtgCd" => "19",
            "cmMaBknPictList[107].pictNm" => "自走式駐車場",
            "cmMaBknPictList[107].chukoFlg" => "",
            "cmMaBknPictList[107].pictCd" => "144",
            "cmMaBknPictList[107].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[107].kskJknFlg" => "1",
            "cmMaBknPictList[107].masterSeq" => "00098",
            "cmMaBknPictList[108].pictCtgCd" => "19",
            "cmMaBknPictList[108].pictNm" => "平面駐車場",
            "cmMaBknPictList[108].chukoFlg" => "",
            "cmMaBknPictList[108].pictCd" => "412",
            "cmMaBknPictList[108].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[108].kskJknFlg" => "1",
            "cmMaBknPictList[108].masterSeq" => "00107",
            "cmMaBknPictList[109].pictCtgCd" => "19",
            "cmMaBknPictList[109].pictNm" => "駐輪場",
            "cmMaBknPictList[109].chukoFlg" => "",
            "cmMaBknPictList[109].pictCd" => "403",
            "cmMaBknPictList[109].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[109].kskJknFlg" => "1",
            "cmMaBknPictList[109].masterSeq" => "00166",
            "cmMaBknPictList[110].pictCtgCd" => "19",
            "cmMaBknPictList[110].pictNm" => "バイク置場",
            "cmMaBknPictList[110].chukoFlg" => "",
            "cmMaBknPictList[110].pictCd" => "414",
            "cmMaBknPictList[110].pictCtgNm" => "駐車・駐輪",
            "cmMaBknPictList[110].kskJknFlg" => "1",
            "cmMaBknPictList[110].masterSeq" => "00182",
            "cmMaBknPictList[111].pictCtgCd" => "20",
            "cmMaBknPictList[111].pictNm" => "共有施設充実",
            "cmMaBknPictList[111].chukoFlg" => "",
            "cmMaBknPictList[111].pictCd" => "682",
            "cmMaBknPictList[111].pictCtgNm" => "共用部",
            "cmMaBknPictList[111].kskJknFlg" => "0",
            "cmMaBknPictList[111].masterSeq" => "00066",
            "cmMaBknPictList[112].pictCtgCd" => "20",
            "cmMaBknPictList[112].pictNm" => "ゲストルーム",
            "cmMaBknPictList[112].chukoFlg" => "",
            "cmMaBknPictList[112].pictCd" => "717",
            "cmMaBknPictList[112].pictCtgNm" => "共用部",
            "cmMaBknPictList[112].kskJknFlg" => "0",
            "cmMaBknPictList[112].masterSeq" => "00084",
            "cmMaBknPictList[113].pictCtgCd" => "20",
            "cmMaBknPictList[113].pictNm" => "２４時間ゴミ出し可",
            "cmMaBknPictList[113].chukoFlg" => "",
            "cmMaBknPictList[113].pictCd" => "388",
            "cmMaBknPictList[113].pictCtgNm" => "共用部",
            "cmMaBknPictList[113].kskJknFlg" => "1",
            "cmMaBknPictList[113].masterSeq" => "00089",
            "cmMaBknPictList[114].pictCtgCd" => "20",
            "cmMaBknPictList[114].pictNm" => "プール",
            "cmMaBknPictList[114].chukoFlg" => "",
            "cmMaBknPictList[114].pictCd" => "376",
            "cmMaBknPictList[114].pictCtgNm" => "共用部",
            "cmMaBknPictList[114].kskJknFlg" => "0",
            "cmMaBknPictList[114].masterSeq" => "00109",
            "cmMaBknPictList[115].pictCtgCd" => "20",
            "cmMaBknPictList[115].pictNm" => "エレベーター",
            "cmMaBknPictList[115].chukoFlg" => "",
            "cmMaBknPictList[115].pictCd" => "367",
            "cmMaBknPictList[115].pictCtgNm" => "共用部",
            "cmMaBknPictList[115].kskJknFlg" => "1",
            "cmMaBknPictList[115].masterSeq" => "00159",
            "cmMaBknPictList[116].pictCtgCd" => "20",
            "cmMaBknPictList[116].pictNm" => "宅配ボックス",
            "cmMaBknPictList[116].chukoFlg" => "",
            "cmMaBknPictList[116].pictCd" => "088",
            "cmMaBknPictList[116].pictCtgNm" => "共用部",
            "cmMaBknPictList[116].kskJknFlg" => "1",
            "cmMaBknPictList[116].masterSeq" => "00165",
            "cmMaBknPictList[117].pictCtgCd" => "20",
            "cmMaBknPictList[117].pictNm" => "キッズルーム・託児所",
            "cmMaBknPictList[117].chukoFlg" => "",
            "cmMaBknPictList[117].pictCd" => "693",
            "cmMaBknPictList[117].pictCtgNm" => "共用部",
            "cmMaBknPictList[117].kskJknFlg" => "1",
            "cmMaBknPictList[117].masterSeq" => "00179",
            "cmMaBknPictList[118].pictCtgCd" => "20",
            "cmMaBknPictList[118].pictNm" => "共用露天風呂",
            "cmMaBknPictList[118].chukoFlg" => "",
            "cmMaBknPictList[118].pictCd" => "655",
            "cmMaBknPictList[118].pictCtgNm" => "共用部",
            "cmMaBknPictList[118].kskJknFlg" => "0",
            "cmMaBknPictList[118].masterSeq" => "00189",
            "cmMaBknPictList[119].pictCtgCd" => "21",
            "cmMaBknPictList[119].pictNm" => "セキュリティ充実",
            "cmMaBknPictList[119].chukoFlg" => "",
            "cmMaBknPictList[119].pictCd" => "691",
            "cmMaBknPictList[119].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[119].kskJknFlg" => "1",
            "cmMaBknPictList[119].masterSeq" => "00090",
            "cmMaBknPictList[120].pictCtgCd" => "21",
            "cmMaBknPictList[120].pictNm" => "ＴＶモニタ付インターホン",
            "cmMaBknPictList[120].chukoFlg" => "",
            "cmMaBknPictList[120].pictCd" => "085",
            "cmMaBknPictList[120].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[120].kskJknFlg" => "1",
            "cmMaBknPictList[120].masterSeq" => "00119",
            "cmMaBknPictList[121].pictCtgCd" => "21",
            "cmMaBknPictList[121].pictNm" => "２４時間有人管理",
            "cmMaBknPictList[121].chukoFlg" => "",
            "cmMaBknPictList[121].pictCd" => "087",
            "cmMaBknPictList[121].pictCtgNm" => "管理・セキュリティ",
            "cmMaBknPictList[121].kskJknFlg" => "1",
            "cmMaBknPictList[121].masterSeq" => "00157",
            "cmMaBknPictList[122].pictCtgCd" => "22",
            "cmMaBknPictList[122].pictNm" => "適合リノベーション",
            "cmMaBknPictList[122].chukoFlg" => "",
            "cmMaBknPictList[122].pictCd" => "647",
            "cmMaBknPictList[122].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[122].kskJknFlg" => "1",
            "cmMaBknPictList[122].masterSeq" => "00030",
            "cmMaBknPictList[123].pictCtgCd" => "22",
            "cmMaBknPictList[123].pictNm" => "内外装リフォーム",
            "cmMaBknPictList[123].chukoFlg" => "",
            "cmMaBknPictList[123].pictCd" => "685",
            "cmMaBknPictList[123].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[123].kskJknFlg" => "1",
            "cmMaBknPictList[123].masterSeq" => "00058",
            "cmMaBknPictList[124].pictCtgCd" => "22",
            "cmMaBknPictList[124].pictNm" => "内装リフォーム",
            "cmMaBknPictList[124].chukoFlg" => "",
            "cmMaBknPictList[124].pictCd" => "683",
            "cmMaBknPictList[124].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[124].kskJknFlg" => "1",
            "cmMaBknPictList[124].masterSeq" => "00059",
            "cmMaBknPictList[125].pictCtgCd" => "22",
            "cmMaBknPictList[125].pictNm" => "外装リフォーム",
            "cmMaBknPictList[125].chukoFlg" => "",
            "cmMaBknPictList[125].pictCd" => "684",
            "cmMaBknPictList[125].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[125].kskJknFlg" => "0",
            "cmMaBknPictList[125].masterSeq" => "00100",
            "cmMaBknPictList[126].pictCtgCd" => "22",
            "cmMaBknPictList[126].pictNm" => "フローリング張替",
            "cmMaBknPictList[126].chukoFlg" => "",
            "cmMaBknPictList[126].pictCd" => "536",
            "cmMaBknPictList[126].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[126].kskJknFlg" => "0",
            "cmMaBknPictList[126].masterSeq" => "00105",
            "cmMaBknPictList[127].pictCtgCd" => "22",
            "cmMaBknPictList[127].pictNm" => "リノベーション",
            "cmMaBknPictList[127].chukoFlg" => "",
            "cmMaBknPictList[127].pictCd" => "590",
            "cmMaBknPictList[127].pictCtgNm" => "ﾘﾌｫｰﾑ・ﾘﾉﾍﾞｰｼｮﾝ",
            "cmMaBknPictList[127].kskJknFlg" => "1",
            "cmMaBknPictList[127].masterSeq" => "00120",
            "cmMaBknPictList[128].pictCtgCd" => "23",
            "cmMaBknPictList[128].pictNm" => "スキー場が近い",
            "cmMaBknPictList[128].chukoFlg" => "",
            "cmMaBknPictList[128].pictCd" => "671",
            "cmMaBknPictList[128].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[128].kskJknFlg" => "0",
            "cmMaBknPictList[128].masterSeq" => "00051",
            "cmMaBknPictList[129].pictCtgCd" => "23",
            "cmMaBknPictList[129].pictNm" => "ゴルフ場が近い",
            "cmMaBknPictList[129].chukoFlg" => "",
            "cmMaBknPictList[129].pictCd" => "670",
            "cmMaBknPictList[129].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[129].kskJknFlg" => "0",
            "cmMaBknPictList[129].masterSeq" => "00052",
            "cmMaBknPictList[130].pictCtgCd" => "23",
            "cmMaBknPictList[130].pictNm" => "テニスコートが近い",
            "cmMaBknPictList[130].chukoFlg" => "",
            "cmMaBknPictList[130].pictCd" => "669",
            "cmMaBknPictList[130].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[130].kskJknFlg" => "0",
            "cmMaBknPictList[130].masterSeq" => "00053",
            "cmMaBknPictList[131].pictCtgCd" => "23",
            "cmMaBknPictList[131].pictNm" => "スーパー 徒歩10分以内",
            "cmMaBknPictList[131].chukoFlg" => "",
            "cmMaBknPictList[131].pictCd" => "668",
            "cmMaBknPictList[131].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[131].kskJknFlg" => "1",
            "cmMaBknPictList[131].masterSeq" => "00054",
            "cmMaBknPictList[132].pictCtgCd" => "23",
            "cmMaBknPictList[132].pictNm" => "総合病院 徒歩10分以内",
            "cmMaBknPictList[132].chukoFlg" => "",
            "cmMaBknPictList[132].pictCd" => "712",
            "cmMaBknPictList[132].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[132].kskJknFlg" => "1",
            "cmMaBknPictList[132].masterSeq" => "00072",
            "cmMaBknPictList[133].pictCtgCd" => "23",
            "cmMaBknPictList[133].pictNm" => "小学校 徒歩10分以内",
            "cmMaBknPictList[133].chukoFlg" => "",
            "cmMaBknPictList[133].pictCd" => "713",
            "cmMaBknPictList[133].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[133].kskJknFlg" => "1",
            "cmMaBknPictList[133].masterSeq" => "00149",
            "cmMaBknPictList[134].pictCtgCd" => "23",
            "cmMaBknPictList[134].pictNm" => "周辺交通量少なめ",
            "cmMaBknPictList[134].chukoFlg" => "",
            "cmMaBknPictList[134].pictCd" => "667",
            "cmMaBknPictList[134].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[134].kskJknFlg" => "0",
            "cmMaBknPictList[134].masterSeq" => "00183",
            "cmMaBknPictList[135].pictCtgCd" => "23",
            "cmMaBknPictList[135].pictNm" => "整備された歩道",
            "cmMaBknPictList[135].chukoFlg" => "",
            "cmMaBknPictList[135].pictCd" => "673",
            "cmMaBknPictList[135].pictCtgNm" => "周辺環境",
            "cmMaBknPictList[135].kskJknFlg" => "0",
            "cmMaBknPictList[135].masterSeq" => "00185",
            "cmMaBknPictList[136].pictCtgCd" => "24",
            "cmMaBknPictList[136].pictNm" => "リバーサイド",
            "cmMaBknPictList[136].chukoFlg" => "",
            "cmMaBknPictList[136].pictCd" => "311",
            "cmMaBknPictList[136].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[136].kskJknFlg" => "0",
            "cmMaBknPictList[136].masterSeq" => "00045",
            "cmMaBknPictList[137].pictCtgCd" => "24",
            "cmMaBknPictList[137].pictNm" => "オーシャンビュー",
            "cmMaBknPictList[137].chukoFlg" => "",
            "cmMaBknPictList[137].pictCd" => "113",
            "cmMaBknPictList[137].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[137].kskJknFlg" => "0",
            "cmMaBknPictList[137].masterSeq" => "00046",
            "cmMaBknPictList[138].pictCtgCd" => "24",
            "cmMaBknPictList[138].pictNm" => "湖・池が見える",
            "cmMaBknPictList[138].chukoFlg" => "",
            "cmMaBknPictList[138].pictCd" => "674",
            "cmMaBknPictList[138].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[138].kskJknFlg" => "0",
            "cmMaBknPictList[138].masterSeq" => "00049",
            "cmMaBknPictList[139].pictCtgCd" => "24",
            "cmMaBknPictList[139].pictNm" => "山が見える",
            "cmMaBknPictList[139].chukoFlg" => "",
            "cmMaBknPictList[139].pictCd" => "675",
            "cmMaBknPictList[139].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[139].kskJknFlg" => "0",
            "cmMaBknPictList[139].masterSeq" => "00050",
            "cmMaBknPictList[140].pictCtgCd" => "24",
            "cmMaBknPictList[140].pictNm" => "海まで2km以内",
            "cmMaBknPictList[140].chukoFlg" => "",
            "cmMaBknPictList[140].pictCd" => "224",
            "cmMaBknPictList[140].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[140].kskJknFlg" => "0",
            "cmMaBknPictList[140].masterSeq" => "00060",
            "cmMaBknPictList[141].pictCtgCd" => "24",
            "cmMaBknPictList[141].pictNm" => "田園風景",
            "cmMaBknPictList[141].chukoFlg" => "",
            "cmMaBknPictList[141].pictCd" => "312",
            "cmMaBknPictList[141].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[141].kskJknFlg" => "0",
            "cmMaBknPictList[141].masterSeq" => "00083",
            "cmMaBknPictList[142].pictCtgCd" => "24",
            "cmMaBknPictList[142].pictNm" => "眺望良好",
            "cmMaBknPictList[142].chukoFlg" => "",
            "cmMaBknPictList[142].pictCd" => "129",
            "cmMaBknPictList[142].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[142].kskJknFlg" => "0",
            "cmMaBknPictList[142].masterSeq" => "00128",
            "cmMaBknPictList[143].pictCtgCd" => "24",
            "cmMaBknPictList[143].pictNm" => "花火大会鑑賞",
            "cmMaBknPictList[143].chukoFlg" => "",
            "cmMaBknPictList[143].pictCd" => "313",
            "cmMaBknPictList[143].pictCtgNm" => "眺望・自然環境",
            "cmMaBknPictList[143].kskJknFlg" => "0",
            "cmMaBknPictList[143].masterSeq" => "00151",
            "cmMaBknPictList[144].pictCtgCd" => "25",
            "cmMaBknPictList[144].pictNm" => "フラット３５Sに対応",
            "cmMaBknPictList[144].chukoFlg" => "",
            "cmMaBknPictList[144].pictCd" => "676",
            "cmMaBknPictList[144].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[144].kskJknFlg" => "0",
            "cmMaBknPictList[144].masterSeq" => "00025",
            "cmMaBknPictList[145].pictCtgCd" => "25",
            "cmMaBknPictList[145].pictNm" => "年内入居可",
            "cmMaBknPictList[145].chukoFlg" => "",
            "cmMaBknPictList[145].pictCd" => "628",
            "cmMaBknPictList[145].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[145].kskJknFlg" => "0",
            "cmMaBknPictList[145].masterSeq" => "00033",
            "cmMaBknPictList[146].pictCtgCd" => "25",
            "cmMaBknPictList[146].pictNm" => "即入居可",
            "cmMaBknPictList[146].chukoFlg" => "",
            "cmMaBknPictList[146].pictCd" => "098",
            "cmMaBknPictList[146].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[146].kskJknFlg" => "1",
            "cmMaBknPictList[146].masterSeq" => "00036",
            "cmMaBknPictList[147].pictCtgCd" => "25",
            "cmMaBknPictList[147].pictNm" => "年度内入居可",
            "cmMaBknPictList[147].chukoFlg" => "",
            "cmMaBknPictList[147].pictCd" => "627",
            "cmMaBknPictList[147].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[147].kskJknFlg" => "0",
            "cmMaBknPictList[147].masterSeq" => "00042",
            "cmMaBknPictList[148].pictCtgCd" => "25",
            "cmMaBknPictList[148].pictNm" => "ペット相談",
            "cmMaBknPictList[148].chukoFlg" => "",
            "cmMaBknPictList[148].pictCd" => "089",
            "cmMaBknPictList[148].pictCtgNm" => "費用・引き渡し・入居・条件",
            "cmMaBknPictList[148].kskJknFlg" => "1",
            "cmMaBknPictList[148].masterSeq" => "00145",
            "cmMaBknPictList[149].pictCtgCd" => "26",
            "cmMaBknPictList[149].pictNm" => "温泉付",
            "cmMaBknPictList[149].chukoFlg" => "",
            "cmMaBknPictList[149].pictCd" => "350",
            "cmMaBknPictList[149].pictCtgNm" => "その他",
            "cmMaBknPictList[149].kskJknFlg" => "0",
            "cmMaBknPictList[149].masterSeq" => "00048",
            "cmMaBknPictList[150].pictCtgCd" => "26",
            "cmMaBknPictList[150].pictNm" => "融雪対策",
            "cmMaBknPictList[150].chukoFlg" => "",
            "cmMaBknPictList[150].pictCd" => "690",
            "cmMaBknPictList[150].pictCtgNm" => "その他",
            "cmMaBknPictList[150].kskJknFlg" => "0",
            "cmMaBknPictList[150].masterSeq" => "00057",
            "cmMaBknPictList[151].pictCtgCd" => "26",
            "cmMaBknPictList[151].pictNm" => "家庭菜園",
            "cmMaBknPictList[151].chukoFlg" => "",
            "cmMaBknPictList[151].pictCd" => "649",
            "cmMaBknPictList[151].pictCtgNm" => "その他",
            "cmMaBknPictList[151].kskJknFlg" => "0",
            "cmMaBknPictList[151].masterSeq" => "00086",
            "cmMaBknPictList[152].pictCtgCd" => "26",
            "cmMaBknPictList[152].pictNm" => "オーナーチェンジ",
            "cmMaBknPictList[152].chukoFlg" => "",
            "cmMaBknPictList[152].pictCd" => "642",
            "cmMaBknPictList[152].pictCtgNm" => "その他",
            "cmMaBknPictList[152].kskJknFlg" => "0",
            "cmMaBknPictList[152].masterSeq" => "00138",
            "cmMaBknPictList[153].pictCtgCd" => "26",
            "cmMaBknPictList[153].pictNm" => "屋上",
            "cmMaBknPictList[153].chukoFlg" => "",
            "cmMaBknPictList[153].pictCd" => "138",
            "cmMaBknPictList[153].pictCtgNm" => "その他",
            "cmMaBknPictList[153].kskJknFlg" => "0",
            "cmMaBknPictList[153].masterSeq" => "00168",
            "cmMaBknPictList[154].pictCtgCd" => "26",
            "cmMaBknPictList[154].pictNm" => "スケルトン渡し",
            "cmMaBknPictList[154].chukoFlg" => "",
            "cmMaBknPictList[154].pictCd" => "599",
            "cmMaBknPictList[154].pictCtgNm" => "その他",
            "cmMaBknPictList[154].kskJknFlg" => "0",
            "cmMaBknPictList[154].masterSeq" => "00178",
            "netCatch" => "",
            "netComment" => "",
            "eventInfoKbn" => "0",
            "eventScheduleKbn" => "0",
            "kikanEventKaishiDate1" => "",
            "kikanEventShuryoDate1" => "",
            "eventDate11" => "",
            "eventDate12" => "",
            "eventDate13" => "",
            "eventDate14" => "",
            "eventDate15" => "",
            "eventDate16" => "",
            "eventDate17" => "",
            "eventDate18" => "",
            "eventDate19" => "",
            "eventDate110" => "",
            "eventDate111" => "",
            "eventDate112" => "",
            "netEventKaishiTimeH" => "",
            "netEventKaishiTimeM" => "",
            "netEventShuryoTimeH" => "",
            "netEventShuryoTimeM" => "",
            "eventActionKbn" => "0",
            "eventInfo" => "",
            "kkbPicComment" => "",
            "btobHoushukeitai" => "0",
            "btobKokokuhitou" => "0",
            "btobGazoId" => "",
            "btobGazoPtn" => "0",
            "btobMainCatch" => "",
            "btobSubCatch1" => "",
            "btobSubCatch2" => "",
            "btobSubCatch3" => "",
            "btobSubCatch4" => "",
            "btobSubCatch5" => "",
            "btobComment" => "",
            "netRenzokuKeisaiKikan" => "8",
            "maemaegaiHatubaigo" => "11/6号",
            "zengaiHatubaigo" => "11/13号",
            "zenzenKeisaiJyouhouList[0]" => "",
            "zenKeisaiJyouhouList[0]" => "",
        ];

        $url = "https://manager.suumo.jp/chukai/tn01Xx0104/update1M";
        $curl = curl_init(); // cURLセッションの初期化
        curl_setopt($curl, CURLOPT_URL, $url); // 取得するURLを指定
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($POST_DATA)); // POST変数をセット
        curl_setopt($curl, CURLOPT_REFERER, 'https://manager.suumo.jp/chukai/tn01Xx0104.do');
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3', 'Accept-Language: ja,en-US;q=0.9,en;q=0.8', 'Cache-Control: max-age=0', 'Connection: keep-alive', 'Host: manager.suumo.jp', 'Origin: https://manager.suumo.jp', 'Sec-Fetch-Mode: navigate', 'Sec-Fetch-Site: same-origin', 'Sec-Fetch-User: ?1', 'Upgrade-Insecure-Requests: 1']);
        curl_setopt($curl, CURLINFO_HEADER_OUT, TRUE);
        curl_setopt($curl, CURLOPT_MAXREDIRS,10);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($curl, CURLOPT_AUTOREFERER,TRUE);//リダイレクトの際にヘッダのRefererを自動的に追加させる
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE); // 実行結果を文字列で返す。
        curl_setopt_array($curl, $this->option); // 共通オプションの設定
        $res = curl_exec($curl) or die('error ' . curl_error($curl)); // cURLセッションの実行

        if( $res === FALSE ) {
            // エラー文字列を出力する
            echo curl_error($curl);
        }

        $pattern = '/<span class="tar b">物件CD：(.*?)<\/span>/s';
        preg_match($pattern, $res, $match1);
        $save_data = ['suumo_no' => $match1[1]];
        Article::where('building_id', $article->building_id)->update($save_data);
    }

    function saveRoom() {

    }
}
