<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Article;
use App\Models\MstSchool;
use App\Models\MstStation;

class SetCountSchoolAndStation extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'batch:setCount';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $cid = 1;
        // 駅に設定されている物件の件数を設定
        $stations = MstStation::getAllId();
        foreach($stations as $row) {
            $count = Article::getCountByStation($row->id, $cid);
            $data = ['count' => $count];
            MstStation::where('id', '=', $row->id)->update($data);
        }

        $primary_schools = MstSchool::getAllId(1);
        foreach($primary_schools as $row) {
            $count = Article::getCountByPrimarySchool($row->code, $cid);
            $data = ['count' => $count];
            MstSchool::where('code', '=', $row->code)->update($data);
        }
        
        $secondary_schools = MstSchool::getAllId(2);
        foreach($secondary_schools as $row) {
            $count = Article::getCountBySecondarySchool($row->code, $cid);
            $data = ['count' => $count];
            MstSchool::where('code', '=', $row->code)->update($data);
        }
    }
}
