<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\News;
use App\Models\MstStore;
use App\Models\MstNewsCategory;

class NewsController extends Controller
{
    /**
     * お知らせ一覧画面の表示
     */
    public function showNews()
    {   
        $data = [];
        $user = Auth::user();
        $info = News::getDataByCompany($user->company_id);
        $category = MstNewsCategory::getDataArray();

        foreach($info as &$row) {
            $row->file_path = str_replace('public', '/storage', $row->file_path);
            $row->category_name = $category[$row->news_category];
        }

        
        $data['active'] = "list";
        $data['category'] = MstNewsCategory::getData();
        $data['news'] = $info;
        return view('admin.pages.hp-news', $data);
    }

    /**
     * お知らせ新規登録画面の表示
     */
    public function registNewsForm()
    {
        $data = [];
        $user = Auth::user();
        
        $data['active'] = "regist";
        $data['category'] = MstNewsCategory::getData();
        $data['today'] = date('Y/m/d');
        return view('admin.pages.hp-regist-news', $data);
    }

    /**
     * お知らせ新規登録処理
     */
    public function registNews(Request $request)
    {
        $user = Auth::user();

        $max = News::getMaxNo($user->company_id);
        $news_id = $max+1;
        // お知らせ登録
        $news = new News;
        $save = [];
        $save['news_id'] = $news_id;
        $save['company_id'] = $user->company_id;
        $save['news_date'] = $request->news_date;
        $save['news_category'] = $request->news_category;
        if($request->news_category == 4) {
            $save['news_category_text'] = $request->news_category_text;
        } else {
            $save['news_category_text'] = '';
        }
        $save['news_title'] = $request->news_title;
        $save['news_link'] = $request->news_link;
        if(isset($request->disp)) {
            $save['disp'] = 1;
        } else {
            $save['disp'] = 0;
        }
        if($request->news_link == 1) {
            if($request->news_link_target == 1) {
                $save['news_link_target'] = $request->news_link_target;
                $save['news_link_target_url'] = $request->news_link_target_1;
            } else {
                $save['news_link_target'] = $request->news_link_target;
                $save['news_link_target_text'] = $request->news_link_target_text;
            }
        } else {
            $save['news_link_target'] = 1;
            $save['news_link_target_url'] = null;
            $save['news_link_target_text'] = null;
        }

        $result = $news->fill($save)->save();


        $update_data = [];
        if($request->news_link == 1) {
            if($request->news_link_target == 2) {
                $update_data['news_link_target_url'] = config('const.NEWS_URL_BASE').$news->news_id;
            }
        }
// dump();
        // 画像の登録
        if(isset($request->file_single_input)) {
            $extension = $request->file_single_input->getClientOriginalExtension();
            $image_url = $request->file_single_input->storeAs('public/news', 'news_image_'.$news->news_id.'.'. $extension);
            $update_data['file_path'] = $image_url;
        }

        if(!empty($update_data)) {
            News::where('news_id', $news->news_id)->where('company_id', $user->company_id)->update($update_data);
        }

        if($result) {
            $URL = url('');
            header('Location: '.$URL.'/admin/editNews/'.$news->news_id);
            die();
        }
    }

    /**
     * お知らせ新規登録画面の表示
     */
    public function editNewsForm(Request $request)
    {
        $data = [];
        $user = Auth::user();
        $old = $request->session()->all();

        // お知らせ情報の取得
        $news = News::where('company_id', '=', $user->company_id)->where('news_id', '=', $request->id)->first();
        $news->file_path = str_replace('public', '/storage', $news->file_path);

        $data['active'] = "regist";
        $data['news'] = $news;
        $data['category'] = MstNewsCategory::getData();

        return view('admin.pages.hp-edit-news', $data);
    }

    /**
     * お知らせ新規登録処理
     */
    public function editNews(Request $request)
    {
        $user = Auth::user();

        // お知らせ登録
        $news = News::where('company_id', '=', $user->company_id)->where('news_id', '=', $request->id)->first();
        $save = [];
        $save['news_date'] = $request->news_date;
        $save['news_category'] = $request->news_category;
        if($request->news_category == 4) {
            $save['news_category_text'] = $request->news_category_text;
        } else {
            $save['news_category_text'] = '';
        }
        $save['news_title'] = $request->news_title;
        $save['news_link'] = $request->news_link;
        if($request->news_link == 1) {
            if($request->news_link_target == 1) {
                $save['news_link_target'] = $request->news_link_target;
                $save['news_link_target_url'] = $request->news_link_target_1;
                $save['news_link_target_text'] = null;
            } else {
                $save['news_link_target'] = $request->news_link_target;
                if($news->news_link_target_url == null) {
                    $save['news_link_target_url'] = config('const.NEWS_URL_BASE').$request->id;
                }
                $save['news_link_target_text'] = $request->news_link_target_text;
            }
        } else {
            $save['news_link_target'] = 1;
            $save['news_link_target_url'] = null;
            $save['news_link_target_text'] = null;
        }

        $result = $news->fill($save)->save();

        if(isset($request->file_single_input)) {
            $extension = $request->file_single_input->getClientOriginalExtension();
            $image_url = $request->file_single_input->storeAs('public/news', 'news_image_'.$news->news_id.'.'. $extension);
            News::where('id', $news->news_id)->update(['file_path' => $image_url]);
        }

        if($result) {
            $URL = url('');
            header('Location: '.$URL.'/admin/editNews/'.$news->news_id);
            die();
        }
    }
}
