<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Article;
use App\Models\Vendor;
use App\Models\MstNewsCategory;
use App\Models\MstPrefecture;   
use App\Models\MstCity;
use App\Models\MstTown;
use App\Models\MstLine;
use App\Models\MstStation;
use App\Models\MstFloorType;
use App\Models\MstGenkyou;
use App\Models\MstUseArea;
use App\Models\MstStore;
use App\Models\MstStructure;
use App\Models\MstSchool;
use App\Models\MstManner;

class RecommendController extends Controller
{
    /**
     * おすすめ一覧画面の表示
     */
    public function showRecommend()
    {
        $data = [];

        // おすすめ物件の取得
        $con = new Request();
        $con->order = 'recommend';
        $info = $this->getRecommendData($con, 1);

        $data['active'] = "list";
        $data['recommend'] = $info;
        return view('admin.pages.hp-recommend', $data);
    }


    /**
     * おすすめ新規登録画面の表示
     */
    public function registRecommendForm(Request $request)
    {
        $data = [];
        $user = Auth::user();

        $data = $this->getMaster();
        $con = $request->all();
        if(!empty($con)) {
            $recommend = $this->getRecommendData($request, 2, 20);
            foreach($recommend as &$row) {
                if($row->property == null) {
                    $floor = Article::getParentMansionFloor($user->company_id, $row->mansion_id);
                    $row->floor = $floor->floor;
                }
            }


            $data['recommend'] = $recommend;
        }
        $max = Article::getRecommendMaxNo($user->company_id);

        $data['remaining'] = 10-$max;
        $data['active'] = "regist";
        unset($con['_token']);
        $data['con'] = $con;


        return view('admin.pages.hp-regist-recommend', $data);
    }

    public function getRecommendData($con, $flag, $pager=null) {
        
        $article = Article::getSearchDataByCondition($con, $pager, $flag);

        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $current_status_list = MstGenkyou:: getData();
        $current_status = [];
        foreach($current_status_list as $row) {
            $current_status[$row['code']] = $row['name'];
        }

        foreach($article as &$row) {
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row['address'] = $address;
            if(isset($row->floor_plan_type)) {
                $row['floor_plan_text'] = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                if($row->current_status != 0) {
                    $row['current_status'] = $current_status[$row->current_status];
                }
            }
            if(isset($row->age_month)) {
                $row['age'] = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row['primary_school_name'] = $primary->name;
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row['secondary_school_name'] = $secondary->name;
                }
            }

            // 業者取得
            $vendor_info = Vendor::getDataByArticleId($row->id);
            $row['vendor_info'] = $vendor_info;
        }

        if($pager != null) {
            // 表示中のページの最初のアイテムのインデックス番号
            $first = $article->firstItem();
                    
            // 表示中のページの最後のアイテムのインデックス番号
            $last = $article->lastItem();

            $article->first = $first;
            $article->last = $last;
        }

        return $article;
    }

    public function getMaster()
    {
        // 取引態様
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;


        $data['property'] = [
            ['code' => 61, 'name' => 'マンション'],
            ['code' => 1, 'name' => '土地'],
            ['code' => 41, 'name' => '新築戸建'],
            ['code' => 42, 'name' => '中古戸建'],
            ['code' => 5, 'name' => 'テラスハウス'],
            ['code' => 7, 'name' => 'タウンハウス'],
        ];

        $data['revenue'] = [
            ['code' => 1, 'name' => '収益'],
        ];


        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData(config('const.DEFAULT_PREF'));
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1);
        $data['secondary_school'] = MstSchool::getSchoolByType(2);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['parking'] = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 2, 'name' => '車庫'],
            ['code' => 3, 'name' => '地下車庫'],
            ['code' => 4, 'name' => 'カースペース'],
            ['code' => 5, 'name' => 'カーポート'],
            ['code' => 6, 'name' => '2台以上'],
        ];

        $data['land_direction'] = [
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];

        return $data;
    }
}
