<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\MstPropertyType;
use App\Models\MstPropertyTypeSub;
use App\Models\Article;
use App\Models\Facility;
use App\Models\Vendor;
use App\Models\MstPrefecture;   
use App\Models\MstCity;
use App\Models\MstTown;
use App\Models\MstLine;
use App\Models\MstStation;
use App\Models\MstFloorType;
use App\Models\MstGenkyou;
use App\Models\MstUseArea;
use App\Models\MstStore;
use App\Models\MstStructure;
use App\Models\MstStructureSub;
use App\Models\MstSchool;
use App\Models\MstManner;
use App\Models\MstParking;
use App\Models\MstStatus;
use App\Models\RelationArticlePhoto;
use App\Models\RelationArticleFacility;
use App\Models\RelationVendorArticle;
use App\Models\RelationPriceHistory;

// use Illuminate\Support\Facades\Auth;
// use Illuminate\Routing\Redirector;

// use Illuminate\Support\Facades\App;

class SearchController extends Controller
{
    /**
     * 売出物件　検索
     */
    public function forSale(Request $request)
    {
        $data = $this->getSearchProperty();

        return view('admin.pages.for-sale', $data);
    }

    /**
     * 成約物件　検索
     */
    public function close(Request $request)
    {
        $data = $this->getSearchProperty();

        return view('admin.pages.close', $data);
    }

    /**
     * マンション建物　検索
     */
    public function mansion(Request $request)
    {
        $data = $this->getSearchPropertyMansion();

        return view('admin.pages.mansion', $data);
    }

    /**
     * 分譲地　検索
     */
    public function lot(Request $request)
    {
        $data = $this->getSearchPropertyLot();

        return view('admin.pages.lot', $data);
    }


    /**
     * 売出物件　一覧
     */
    public function forSaleList(Request $request)
    {
        $user = Auth::user();
        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        
        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        // $current_status_list = MstGenkyou::getData();
        // $current_status = [];
        // foreach($current_status_list as $row) {
        //     $current_status[$row['code']] = $row['name'];
        // }

        $params = $request->all();
        unset($params['page']);
        unset($params['notcondition']);
        unset($params['sort']);
        unset($params['image']);
        unset($params['_token']);

        $request['provisional'] = 0;
        $article_list = Article::getSearchDataByCondition($request, 10, null, 2);
        foreach($article_list as &$row) {
            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row['floor_plan_text'] = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = str_replace('学校', '', $primary->name);
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                }
            }

            // 間取り画像取得
            $count = 0;
            if(isset($row->floor_file_path)) {
                $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
                $count = 1;
            } else {
                $row->floor_file_path = '';
            }

            // 写真
            $top_image = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($top_image->file_path)) {
                $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
            } else {
                $row->top_file_path = '';
            }

            // 写真の枚数
            $count += RelationArticlePhoto::getCountImgByArticleId($row->building_id);
            $row->file_count = $count;

            // 価格履歴の取得
            $history = RelationPriceHistory::getHistoryById($row->building_id);
            $row->history = $history;

            // 物件種別名、業者取得
            if(is_null($row->property)) {
                // マンションの場合
                $mansion = Article::getDataById($user->company_id, $row->mansion_id);
                $row->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($row->building_id);

                // 学校
                if(isset($mansion->primary_school_school)) {
                    $primary = MstSchool::getSchoolByCode($mansion->primary_school_school);
                    if(isset($primary->name)){
                        $row->primary_school_name = str_replace('学校', '', $primary->name);
                    }
                }
                if(isset($mansion->secondary_school_school)) {
                    $secondary = MstSchool::getSchoolByCode($mansion->secondary_school_school);
                    if(isset($secondary->name)){
                        $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                    }
                }

                // 築年月
                $row->age_year = $mansion->age_year;
                $row->age_month = $mansion->age_month;
                $row->age = intval(date('Y')) - intval($mansion->age_year);
            } else {
                // それ以外
                $row->property_name = $this->getPropertyName($row->property, $row->property_sub);

                $vendor_info = Vendor::getDataListByArticleId($row->building_id);
            }
            
            $row['vendor_info'] = $vendor_info;
        }

        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];


        $count = count($article_list);
        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['count'] = $count;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;
        $data['isDel'] = 1;
// dump($article_list);
        return view('admin.pages.for-sale-list', $data);
    }


    /**
     * 成約物件　一覧
     */
    public function closeList(Request $request)
    {
        $user = Auth::user();
        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $current_status_list = MstGenkyou:: getData();
        $current_status = [];
        foreach($current_status_list as $row) {
            $current_status[$row['code']] = $row['name'];
        }


        $params = $request->all();
        unset($params['page']);
        unset($params['notcondition']);
        unset($params['sort']);
        unset($params['image']);
        unset($params['_token']);

        $article_list = Article::getSearchDataByCondition($request, 10, null, 1);

        foreach($article_list as &$row) {
            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            
            if(isset($row->floor_plan_type)) {
                $row->floor_plan_text = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = str_replace('学校', '', $primary->name);
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                }
            }

            // 間取り画像取得
            $count = 0;
            if(isset($row->floor_file_path)) {
                $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
                $count = 1;
            } else {
                $row->floor_file_path = '';
            }

            // 写真
            $top_image = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($top_image->file_path)) {
                $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
            } else {
                $row->top_file_path = '';
            }

            // 写真の枚数
            $count += RelationArticlePhoto::getCountImgByArticleId($row->building_id);
            $row->file_count = $count;

            // 価格履歴の取得
            $history = RelationPriceHistory::getHistoryById($row->building_id);
            $row->history = $history;

            // 物件種別名、業者取得
            if(is_null($row->property)) {
                // マンションの場合
                $mansion = Article::getDataById($user->company_id, $row->mansion_id);
                $row->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($row->building_id);

                // 学校
                if(isset($mansion->primary_school_school)) {
                    $primary = MstSchool::getSchoolByCode($mansion->primary_school_school);
                    if(isset($primary->name)){
                        $row->primary_school_name = str_replace('学校', '', $primary->name);
                    }
                }
                if(isset($mansion->secondary_school_school)) {
                    $secondary = MstSchool::getSchoolByCode($mansion->secondary_school_school);
                    if(isset($secondary->name)){
                        $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                    }
                }

                // 築年月
                $row->age_year = $mansion->age_year;
                $row->age_month = $mansion->age_month;
                $row->age = intval(date('Y')) - intval($mansion->age_year);
            } else {
                // それ以外
                $row->property_name = $this->getPropertyName($row->property, $row->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($row->building_id);
            }
            
            $row['vendor_info'] = $vendor_info;
        }
        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];

        $count = count($article_list);
        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['count'] = $count;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;

        return view('admin.pages.close-list', $data);
    }

    /**
     * 売出物件　一覧
     */
    public function mansionList(Request $request)
    {
        $params = $request->all();
        unset($params['_token']);
        unset($params['sort']);
        unset($params['page']);

        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $current_status_list = MstGenkyou:: getData();
        $current_status = [];
        foreach($current_status_list as $row) {
            $current_status[$row['code']] = $row['name'];
        }
        $article_list = Article::getMansionDataByCondition($request, 10);

        $room_count = 0;
        foreach($article_list as &$row) {
            $room_count++;

            // 部屋取得
            $room_list = Article::getRoomList($row['building_id']);
            foreach($room_list as &$room) {
                $room->floor_plan_name = MstFloorType::find($room->floor_plan_type)->name??'';
                if(isset($room->floor_plan_type)) {
                    $room->floor_plan_text = $room->floor_plan . $floor_type[$room->floor_plan_type];
                    
                }

                // 写真
                $top_image = RelationArticlePhoto::getTopImagePath($room->building_id);
                if(isset($top_image->file_path)) {
                    $count++;
                    $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
                } else {
                    $row->top_file_path = '';
                }

                // 写真の枚数
                $count += RelationArticlePhoto::getCountImgByArticleId($room->building_id);
                $room->file_count = $count;


                
                // 業者の取得
                $vendor = RelationVendorArticle::getVendorDataByRainsNo($room->building_id);
                $room->vendor_info = $vendor;

                // 価格履歴の取得
                $history = RelationPriceHistory::getHistoryById($room->building_id);
                $room->history = $history;
            }
            $row->room_list = $room_list;
            $row->room_count = count($room_list);
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row->floor_plan_text = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = $primary->name;
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = $secondary->name;
                }
            }

            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            // 物件種別
            $row->property_name = $this->getPropertyName($row->property, $row->property_sub);

            // // 業者取得
            // $vendor_info = Vendor::getDataListByArticleId($row->building_id);
            // $row->vendor_info = $vendor_info;
        }

        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();
// dump($article_list);
        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $data['room_count'] = $room_count;

        // 
        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];


        $data['method_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        $data['price_change'] = [
            ['code' => 1, 'name' => '価格変更'],
        ];

        return view('admin.pages.mansion-list', $data);
    }

    /**
     * 売出物件　一覧
     */
    public function lotList(Request $request)
    {
        $params = $request->all();
        unset($params['_token']);
        unset($params['sort']);
        unset($params['page']);

        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $current_status_list = MstGenkyou:: getData();
        $current_status = [];
        foreach($current_status_list as $row) {
            $current_status[$row['code']] = $row['name'];
        }
        $article_list = Article::getSearchDataByCondition($request, 10);

        $propety_list = [];
        $lot_count = 0;
        foreach($article_list as &$row) {
            $row->disp_file = str_replace('public', '/storage', $row->floor_file_path);
            // 部屋取得
            $lot_list = Article::getLotList($row['building_id']);

            $lot_count_tmp = 0;
            foreach($lot_list as &$lot) {
                $lot_count_tmp++;
                $lot->floor_plan_name = MstFloorType::find($lot->floor_plan_type)->name??'';
                if(isset($lot->floor_plan_type)) {
                    $lot->floor_plan_text = $lot->floor_plan . $floor_type[$lot->floor_plan_type];
                    
                }
                // 物件種別
                $property_name = $this->getPropertyName($lot->property, $lot->property_sub);

                $lot->property_name = $property_name;
                if(!in_array($property_name, $propety_list)) {
                    $propety_list[] = $property_name;
                }

                // 写真
                $top_image = RelationArticlePhoto::getTopImagePath($lot->building_id);
                if(isset($top_image->file_path)) {
                    $count++;
                    $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
                } else {
                    $row->top_file_path = '';
                }

                // 写真の枚数
                $count += RelationArticlePhoto::getCountImgByArticleId($lot->building_id);
                $lot->file_count = $count;


                // 業者の取得
                $vendor = RelationVendorArticle::getVendorDataByRainsNo($lot->building_id);
                $lot->vendor_info = $vendor;

                // 価格履歴の取得
                $history = RelationPriceHistory::getHistoryById($lot->building_id);
                $lot->history = $history;
            }
            $lot_count += $lot_count_tmp;
            $row->property_list = $propety_list;

            $row->lot_list = $lot_list;
            $row->lot_count = count($lot_list);
            //dd($row->address1, $row->address2, $row->address3, $row->address4);    
            $address = "";
            if(!empty($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(!empty($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(!empty($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(!empty($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row->floor_plan_text = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = $primary->name;
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = $secondary->name;
                }
            }

            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            // 物件種別
            $row->property_name = $this->getPropertyName($row->property, $row->property_sub);
        }

        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $data['lot_count'] = $lot_count;

        // 
        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['method_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        $data['price_change'] = [
            ['code' => 1, 'name' => '価格変更'],
        ];

        return view('admin.pages.lot-list', $data);
    }

    public function getSearchProperty() {
	$user = Auth::user();

        $data = [];
        $data['property'] = [
            ['code' => 61, 'name' => 'マンション'],
            ['code' => 1, 'name' => '土地'],
            ['code' => 41, 'name' => '新築戸建'],
            ['code' => 42, 'name' => '中古戸建'],
            ['code' => 5, 'name' => 'テラスハウス'],
            ['code' => 7, 'name' => 'タウンハウス'],
        ];

        $data['revenue'] = [
            ['code' => 1, 'name' => '収益'],
        ];


        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
	$defaultPrefCode = array_get(array_first($data['pref']), 'code');
        $data['city'] = MstCity::getData($defaultPrefCode, null, $user->company_id);
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1, $user->company_id);
        $data['secondary_school'] = MstSchool::getSchoolByType(2, $user->company_id);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['parking'] = MstParking::getData();

        $data['land_direction'] = [
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];

        return $data;
    }

    public function getSearchPropertyMansion() {
        $data = [];
        $data['property'] = [
            ['code' => 1, 'name' => '土地'],
            ['code' => 2, 'name' => '戸建'],
            ['code' => 3, 'name' => 'マンション'],
        ];


        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData(config('const.DEFAULT_PREF'));
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1);
        $data['secondary_school'] = MstSchool::getSchoolByType(2);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['parking'] = MstParking::getDataByType(1);

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['shared'] = [
            ['code' => 1, 'name' => 'ゲストルーム'],
            ['code' => 2, 'name' => '24時間ゴミ出し可'],
            ['code' => 3, 'name' => 'プール'],
            ['code' => 4, 'name' => 'エレベーター'],
            ['code' => 5, 'name' => '宅配ボックス'],
            ['code' => 6, 'name' => 'キッズルーム・託児所'],
            ['code' => 7, 'name' => '共用露天風呂'],
            ['code' => 8, 'name' => 'オートロック'],
        ];

        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];

        return $data;
    }

    public function getSearchPropertyLot() {
        $data = [];
        $data['property'] = [
            ['code' => 1, 'name' => '土地'],
            ['code' => 2, 'name' => '戸建'],
            ['code' => 3, 'name' => 'マンション'],
        ];


        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData(config('const.DEFAULT_PREF'));
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1);
        $data['secondary_school'] = MstSchool::getSchoolByType(2);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        return $data;
    }

    public static function getPropertyName($property, $property_sub) {
        $res = '';
        if($property > 3) {
            $res .= MstPropertyTypeSub::find($property_sub)->name??'';
        }

        $res .= MstPropertyType::find($property)->name??'';

        return $res;
    }

    public static function createConditionList($con) {
        // dump($con);
        $user = Auth::user();
        $res = [];
        $property_name = "";
        $add = "";
        $pref = 0;
        $city = 0;
        $town = 0;
        $price = "";
        $years = "";
        $months = "";
        $construction = "";
        $floor_area = "";
        $land = "";
        $floor = "";
        $school = "";
        $parking = "";
        $land_status = "";
        $land_kind = "";
        $shop = "";
        $balcony_direction = "";
        $balcony_area = "";
        $pet = "";
        $pet_num = "";
        $use_area = "";
        $management_company = "";
        $construction_name = "";
        foreach($con as $key => $val) {
            if($key == 'property') {
                $property_name = "";
                foreach($val as $row) {
                    $tmp = "";
                    $tmp_sub = "";
                    if($row == 41) {
                        $property = 4;
                        $property_sub = 1;
                        $tmp_sub = MstPropertyTypeSub::find($property_sub)->name??'';
                    } elseif($row == 42) {
                        $property = 4;
                        $property_sub = 2;
                        $tmp_sub = MstPropertyTypeSub::find($property_sub)->name??'';
                    } else {
                        $property = $row;
                    }
                    $tmp = MstPropertyType::find($property)->name??'';
                    $property_name .= $tmp_sub . $tmp;
                }
                
            }
            if($key == 'address1') {
                foreach($val as $row) {
                    $add .= MstPrefecture::where('code', '=', $row)->first()->name??'';
                    $pref .= $row;
                }
                
            }
            if($key == 'address2') {
                foreach($val as $row) {
                    $add .= MstCity::where('pref_code', '=', $pref)->where('code', '=', $val)->first()->name??'';
                    $city .= $row;
                }
            }
            if($key == 'address3') {
                foreach($val as $row) {
                    $add .= MstTown::where('pref_code', '=', $pref)->where('city_code', '=', $city)->where('code', '=', $val)->first()->name??'';
                    $add .= $row;
                }
            }
            if($key == 'address4') {
                foreach($val as $row) {
                    $add .= $row;
                }
            }
            if($key == 'building_id') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $res['物件ID'] = $row;
                    }
                }
            }
            if($key == 'price_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $price .= $row."万円";
                    }
                }
            }
            if($key == 'price_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($price != "") {
                            $price .= "〜";
                        }
                        $price .= $row."万円";
                    } else {
                        if($price != "") {
                            $price .= "〜";
                        }
                    }
                }
            }
            if($key == 'access1') {
            
            }
            if($key == 'access2') {
            
            }
            if($key == 'access3') {
            
            }
            if($key == 'bus') {
            
            }
            if($key == 'walk') {
            
            }
            if($key == 'primary_school') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $school .= MstSchool::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'secondary_school') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($school != "") {
                            $school .= " ";
                        }
                        $school .= MstSchool::where('code', '=', $row)->first()->name??'';
                    }
                }
            }

            if($key == 'land_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $land .= $row."㎡";
                    }
                }
            }
            if($key == 'land_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($land != "") {
                            $land .= "〜";
                        }
                        $land .= $row."㎡";
                    } else {
                        if($land != "") {
                            $land .= "〜";
                        }
                    }
                }
            }
            if($key == 'floor_area_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $floor_area .= $row."㎡";
                    }
                }
            }
            if($key == 'floor_area_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($floor_area != "") {
                            $floor_area .= "〜";
                        }
                        $floor_area .= $row."㎡";
                    } else {
                        if($floor_area != "") {
                            $floor_area .= "〜";
                        }
                    }
                }
            }
            if($key == 'floor_plan') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 1:
                            $res['間取り'] = '1R - 1SLDK';
                            break;
                            case 2:
                            $res['間取り'] = '2K - 2SLDK';
                            break;
                            case 3:
                            $res['間取り'] = '3K - 3SLDK';
                            break;
                            case 4:
                            $res['間取り'] = '4K - 4SLDK';
                            break;
                            case 5:
                            $res['間取り'] = '5K〜';
                            break;
    
                        }
                    }
                }


            }
            if($key == 'name') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $res['物件名'] = $row;
                    }
                }
            }
            if($key == 'mansion_name') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $res['マンション名'] = $row;
                    }
                }
            }
            if($key == 'years_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $years .= $row."年";
                    }
                }
            }
            if($key == 'years_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($years != "") {
                            $years .= "〜";
                        }
                        $years .= $row."年";
                    } else {
                        if($years != "") {
                            $years .= "〜";
                        }
                    }
                }
            }

            if($key == 'year_month_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $months .= $row;
                    }
                }
            }
            if($key == 'year_month_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($months != "") {
                            $months .= "〜";
                        }
                        $months .= $row;
                    } else {
                        if($months != "") {
                            $months .= "〜";
                        }
                    }
                }
            }
            if($key == 'construction') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $construction .= MstStructure::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'parking') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $parking .= MstParking::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'land_status') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $land_status .= MstGenkyou::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'use_area') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $use_area .= MstUseArea::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'floor_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $floor .= $row."㎡";
                    }
                }
            }
            if($key == 'floor_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($floor != "") {
                            $floor .= "〜";
                        }
                        $floor .= $row."㎡";
                    } else {
                        if($floor != "") {
                            $floor .= "〜";
                        }
                    }
                }
            }
            if($key == 'land_kind') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 1:
                                $land_kind = "北";
                            break;
                            case 2:
                                $land_kind = "北東";
                            break;
                            case 3:
                                $land_kind = "東";
                            break;
                            case 4:
                                $land_kind = "南東";
                            break;
                            case 5:
                                $land_kind = "南";
                            break;
                            case 6:
                                $land_kind = "南西";
                            break;
                            case 7:
                                $land_kind = "西";
                            break;
                            case 8:
                                $land_kind = "北西";
                            break;
                        }
                    }
                }
            }

            if($key == 'search_shop') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $shop .= MstStore::where('company_id', '=', $user->company_id)->where('code', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'balcony_direction') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 1:
                                $balcony_direction = "北";
                            break;
                            case 2:
                                $balcony_direction = "北東";
                            break;
                            case 3:
                                $balcony_direction = "東";
                            break;
                            case 4:
                                $balcony_direction = "南東";
                            break;
                            case 5:
                                $balcony_direction = "南";
                            break;
                            case 6:
                                $balcony_direction = "南西";
                            break;
                            case 7:
                                $balcony_direction = "西";
                            break;
                            case 8:
                                $balcony_direction = "北西";
                            break;
                        }
                    }
                }
            }

            if($key == 'balcony_area') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $balcony_area .= $row."㎡";
                    }
                }
            }
            if($key == 'is_pet') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 2:
                                $pet = "飼育可能（制限有）";
                            break;
                            case 1:
                                $pet = "飼育不可";
                            break;
                        }
                    }
                }
            }
            if($key == 'pet_num') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $pet_num .= $row."匹";
                    }
                }
            }

            if($key == 'management_company') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $management_company .= $row;
                    }
                }
            }

            if($key == 'construction_name') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $construction_name .= $row;
                    }
                }
            }
            if($key == 'owner') {
            
            }
            if($key == 'registed_from') {
            
            }
            if($key == 'registed_to') {
            
            }
            if($key == 'checked_from') {
            
            }
            if($key == 'checked_to') {
            
            }
            if($key == 'changed_price_from') {
            
            }
            if($key == 'changed_price_to') {
            
            }
            if($key == 'ad_checked_from') {
            
            }
            if($key == 'ad_checked_to') {
            
            }
            if($key == 'flyer') {
            
            }
            if($key == 'vender_name') {
            
            }
            if($key == 'vender_kind') {
            
            }
            if($key == 'vender_tel') {
            
            }
        }

        if($property_name != "") {
            $res['物件種別'] = $property_name;
        }

        if($add != "") {
            $res['所在地'] = $add;
        }

        if($price != "") {
            $res['価格'] = $price;
        }
        if($years != "") {
            $res['築年数'] = $years;
        }
        if($months != "") {
            $res['築年月'] = $months;
        }
        if($construction != "") {
            $res['構造'] = $construction;
        }
        if($parking != "") {
            $res['駐車場'] = $parking;
        }
        if($land_status != "") {
            $res['現況'] = $land_status;
        }
        if($use_area != "") {
            $res['用途地域'] = $use_area;
        }
        if($land_kind != "") {
            $res['接道方向'] = $land_kind;
        }
        if($shop != "") {
            $res['取扱店舗'] = $shop;
        }
        if($balcony_direction != "") {
            $res['バルコニー'] = $balcony_direction." ".$balcony_area;
        }

        if($pet != "") {
            $res['ペット'] = $pet." ".$pet_num;
        }
        if($management_company != "") {
            $res['事業主'] = $management_company;
        }
        if($construction_name != "") {
            $res['施工'] = $construction_name;
        }

        if($school != "") {
            $res['学校区'] = $school;
        }

        if($land != "") {
            $res['土地面積'] = $land;
        }

        if($floor_area != "") {
            $res['延床面積'] = $floor_area;
        }

        if($floor != "") {
            $res['階建'] = $floor;
        }

        return $res;
    }
}

