<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Vendor;
use App\Models\RelationVendorArticle;
use App\Models\MstPrefecture;
use App\Models\MstCity;
use App\Models\MstTown;
use App\Models\MstStore;
use App\Models\MstFloorType;
use App\Models\MstSchool;
use App\Models\MstStatus;
use App\Models\MstManner;

class VendorController extends Controller
{
    /**
     * 業者検索条件設定画面の表示
     * @return string
     */
    public function show()
    {
        $data['active'] = 'search';
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);
        $data['status'] = MstStatus::getData();
        // 確認手法
        $data['method_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        return view('admin.pages.vendor', $data);
    }

    /**
     * 業者検索結果画面の表示
     * @return string
     */
    public function list(Request $request)
    {
        $user = Auth::user();

        $data['active'] = 'list';
        $params = $request->all();
        unset($params['_token']);
        $data['params'] = $params;
        $request->company_id = $user->company_id;

        $search_shop = $request->shop??null;
        $data['search_shop'] = $search_shop;
        $result = Vendor::getDataByCondition($request, 20);


        // 表示中のページの最初のアイテムのインデックス番号
        $first = $result->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $result->lastItem();

        // 業者に登録されている物件の取得
        foreach($result as $row) {
            $row->count = RelationVendorArticle::getCountById($row->id, $search_shop);
            $article = RelationVendorArticle::getArticleDataByVendorId($row->id, $search_shop);
            // print_r($article);
            foreach($article as &$info) {
                $info->created_at = date('Y/m/d',  strtotime($info->created_at));

                // 学校取得
                $shool_info = MstSchool::getSchoolByCode($info->primary_school_school);
                if(empty($shool_info)) {
                    $info->primary = '-';
                } else {
                    $info->primary = $shool_info['name'];
                }
                $shool_info = MstSchool::getSchoolByCode($info->secondary_school_school);
                if(empty($shool_info)) {
                    $info->secondary = '-';
                } else {
                    $info->secondary = $shool_info['name'];
                }
                if(!is_null($info->shop)) {
                    $shop = MstStore::getDataByCode($user->company_id, $info->shop);
                    $info->shop_name = $shop->name??'-';
                } else {
                    $info->shop_name = '';
                }
                
            }
            $row->article = $article;
        }

        $data['list'] = $result;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['ad_conf'] = [
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];
        // 確認手法
        $data['method_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];
        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $data['floor_type'] = $floor_type;

        // ステータス
        $data['statuses'] = MstStatus::getData();
        $data['statuses2'] = [
            ['code' => 1, 'name' => '価格変更'],
        ];

        $data['manner'] = MstManner::getData();

        if(isset($request->shop) && $request->shop != null) {
            $data['disp_flag'] = false;
        } else {
            $data['disp_flag'] = true;
        }

        return view('admin.pages.vendor-list', $data);
    }

        /**
     * 業者登録画面の表示
     * @return string
     */
    public function registVendor(Request $request)
    {
        $data['active'] = 'regist';

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData($data['pref'][0]['code']);
        $data['town'] = MstTown::getData($data['pref'][0]['code'], $data['city'][0]['code']);

        $all = $request->all();
        return view('admin.pages.vendor-regist', $data);
    }

    /**
     * 業者検索結果画面の表示
     * @return string
     */
    public function regist(Request $request)
    {
        $user = Auth::user();
        $URL = url('');
        $vendor = new Vendor;
        $all = $request->all();
        $all['company_id'] = $user->company_id;
        unset($all['_token']);
        $result = $vendor->fill($all)->save();

        if($result) {
            header('Location: '.$URL.'/admin/editVendor/'.$vendor->id);
            die();
        }
    }

    /**
     * 業者検索結果画面の表示
     * @return string
     */
    public function editVendor(Request $request)
    {
        $user = Auth::user();
        $data['active'] = 'regist';
        $id = $request->id;

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        $vendor_data = Vendor::getDataByIdCompany($id, $user->company_id);
        if($vendor_data == null) {
            print('不正なアクセスです。');
            exit;   
        }
        $data['vendor_info'] = $vendor_data;

        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData($vendor_data['address1']);
        $data['town'] = MstTown::getData($vendor_data['address1'], $vendor_data['address2']);

        $all = $request->all();
        return view('admin.pages.vendor-edit', $data);
    }

    /**
     * 業者検索結果画面の表示
     * @return string
     */
    public function edit(Request $request)
    {
        $URL = url('');
        
        $all = $request->all();
        unset($all['_token']);
        $result = Vendor::where('id', $request->id)->update($all);

        if($result) {
            header('Location: '.$URL.'/admin/editVendor/'.$request->id);
            die();
        }
    }

    public function showPrint(Request $request) {
        $data = [];
        $data['today'] = date('Y/m/d');
        $target_shop = $request->target_shop;

        if(isset($request->print_id_list)) {
            
            $id_list = explode(',', $request->print_id_list);
            $tmp_list = [];
            foreach($id_list as $row) {
                $vendor = Vendor::getDataById($row);
                $article = RelationVendorArticle::getArticleDataByVendorId($vendor->id, $target_shop);
                $tmp = [
                    'vendor' => $vendor,
                    'article' => $article
                ];
                $tmp_list[] = $tmp;
            }
            $data['print_list'] = $tmp_list;
        }

        if(empty($request->print_id_list)) {
            $URL = url('');
            header('Location: '.$URL.'/admin/vendor'.$request->id);
            die();
        }

        // 返送先の取得
        $user = Auth::user();
        $data['shop'] = MstStore::getDataByCode($user->company_id, $user->store_id);

        return view('admin.pages.vendor-print', $data);
    }
}
