<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Article;
use App\Models\RelationArticlePhoto;
use App\Models\MstArea;
use App\Models\MstStation;
use App\Models\MstCity;

class AreaController extends Controller
{
    public function index()
    {
        $data['css'] = root("css/area/index.css");
        $data['bread' ] = true;
        // 各種別の件数取得
        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null]);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3]);

        return view('home.area.index', $data);
    }

//静的生成のため追記 ここから
    public function konan()
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/area/konan.jpg'),
            'title' => "CITY",
            'jp' => '横浜市港南区の不動産の売却と購入',
            'city' => '横浜市港南区',
            'city_en' => 'konan',
            'comment' => '港南区は横浜市の南部に位置するエリアです。元々は南区の一部でしたが、1969年（昭和44年）に南区から分かれて発足しました。昔は農村地帯でしたが、1950年頃から少しずつ宅地開発が行われ始め、1970年代に野庭団地や港南台団地等の巨大団地が作られ、人口が急増。現在では、20万人以上が暮らしています。それ以前、戦後しばらくの間は大岡川沿いに捺染工場があり、当時横浜の名産品であったスカーフが作られていました。上大岡駅周辺と港南台中央駅周辺が中心的な商業地。公共機関も集中しています。また上大岡駅周辺は、主要生活拠点と横浜市が定めていて、現在も積極的に開発が進んでいるエリアになります。',
        );
        // 各種別の件数取得
        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null], null, 14111);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2, 14111);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1, 14111);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3], null, 14111);

        $article = Article::getNewDataByArea(config('const.COMPANY_ID'), 14111, 6);
        foreach($article as $row) {
            // 画像取得
            $row_photo = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($row_photo->file_path)) {
              $row->file_path = str_replace('public', '/storage', $row_photo->floor_file_path);
            } else {
              $row->file_path = "";
            }
        }
        $data['new'] = $article;
        

        return view('home.area.city', $data);
    }
    public function sakae()
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/area/sakae.jpg'),
            'title' => "CITY",
            'jp' => '横浜市栄区の不動産の売却と購入',
            'city' => '横浜市栄区',
            'city_en' => 'sakae',
            'comment' => '栄区は、横浜市の南部に位置し、18区の中では緑の多いエリアです。そのため、人口は少なく18区中17位。特に東部はより多くの自然が残っていて、横浜市の緑の7大拠点の一つにも選ばれています。商業エリアは本郷台駅と大船駅周辺に集中。特に公共機関は本郷台駅周辺に集まっています。一方、大船駅周辺は栄区と鎌倉市の両方にまたがっていて、栄区においても鎌倉市においても主要な商業エリアです。鎌倉と縁が深い事から、横浜市の中でも古い歴史を持つエリアで、古墳時代の墓が多数残っていたり、古くから製鉄の技術が広まっていた地域です。鎌倉時代には、いたち川流域が食料生産の拠点になる一方で、鎌倉に近いこともあり度々戦場にもなりました。そんな自然と歴史に囲まれた栄区ですが、1960年代から大規模な宅地開発が行われたこともあり、現在では豊かな自然と古い歴史の面影を残しつつも、閑静な住宅都市となっています。',
        );
        // 各種別の件数取得
        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null], null, 14115);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2, 14115);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1, 14115);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3], null, 14115);

        $article = Article::getNewDataByArea(config('const.COMPANY_ID'), 14115, 6);
        foreach($article as $row) {
            // 画像取得
            $row_photo = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($row_photo->file_path)) {
              $row->file_path = str_replace('public', '/storage', $row_photo->floor_file_path);
            } else {
              $row->file_path = "";
            }
        }
        $data['new'] = $article;

        return view('home.area.city', $data);
    }
    public function isogo()
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/area/isogo.jpg'),
            'title' => "CITY",
            'jp' => '横浜市磯子区の不動産の売却と購入',
            'city' => '横浜市磯子区',
            'city_en' => 'isogo',
            'comment' => '磯子区は横浜市の東南部に位置し、根岸湾に面しているエリアです。沿岸沿いには大きな低地が広がっていて、それを囲むように、海から離れた地域は丘陵地となっています。元々は、この丘陵地が根岸湾に海岸沿いに広がっていましたが、1960年頃から、大規模な埋め立てが行われて現在のような低地が誕生しました。埋め立てされた当初は、ライフラインが地下に埋設されたり、全車道に歩道が設置されるなど、当時は近未来的な都市デザインで開発されたエリアでもあります。同時期にJR根岸線が開通されたこともあり、ベッドタウンとして大きく発展。横浜の発展と人口増加を支えました。現在では、JR根岸線だけでなく、首都高速湾岸線や国道16号線、横浜市道環状線など主要な道路交通網が整備されていることもあり、横浜屈指の都市基盤が整えられた、住みやすいエリアとなっており、横浜のベッドタウンエリアの一つとして親しまれる街です。',
        );
        // 各種別の件数取得
        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null], null, 14107);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2, 14107);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1, 14107);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3], null, 14107);

        $article = Article::getNewDataByArea(config('const.COMPANY_ID'), 14107, 6);
        foreach($article as $row) {
            // 画像取得
            $row_photo = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($row_photo->file_path)) {
              $row->file_path = str_replace('public', '/storage', $row_photo->floor_file_path);
            } else {
              $row->file_path = "";
            }
        }
        $data['new'] = $article;

        return view('home.area.city', $data);
    }
    public function kanazawa()
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/area/kanazawa.jpg'),
            'title' => "CITY",
            'jp' => '横浜市金沢区の不動産の売却と購入',
            'city' => '横浜市金沢区',
            'city_en' => 'kanazawa',
            'comment' => '金沢区は、横浜市の最南端で、三浦半島の東部に位置しています。かつては「かねさわ」と呼ばれていましたが、同じ漢字である加賀藩の金沢（石川県の金沢市）が有名になったのをきっかけに、金沢区も「かなざわ」と呼ばれるようになったそうです。鎌倉幕府の影響を強く受け、鎌倉文化が継承されてきた地でもあります。金沢文庫もその一つ。北条氏が作ったとされる武家の図書館で、現在は地名にもなっています。そんな金沢区ですが、江戸時代には金沢八景と呼ばれる程、美しい海岸線が有名な観光地でもありました。また明治時代には富岡海岸を中心に外国人の海水浴場となり、そこから要人の保養地として別荘が建てられ始めたそうです。現在は海岸線の埋め立てにより、当時の景色を拝むことは出来ないものの、造成により作られた砂浜海岸、海の公園や横浜・八景島シーパラダイスなどの、海水浴やマリンスポーツを楽しめる施設がたくさんあります。豊かな自然と鎌倉文化の融合したエリアです。',
        );
        // 各種別の件数取得
        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null], null, 14108);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2, 14108);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1, 14108);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3], null, 14108);

        $article = Article::getNewDataByArea(config('const.COMPANY_ID'), 14108, 6);
        foreach($article as $row) {
            // 画像取得
            $row_photo = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($row_photo->file_path)) {
              $row->file_path = str_replace('public', '/storage', $row_photo->floor_file_path);
            } else {
              $row->file_path = "";
            }
        }
        $data['new'] = $article;

        return view('home.area.city', $data);
    }
    public function minami()
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/area/minami.jpg'),
            'title' => "CITY",
            'jp' => '横浜市南区の不動産の売却と購入',
            'city' => '横浜市南区',
            'city_en' => 'minami',
            'comment' => '南区は横浜市の中南部に位置する、主に住宅街で構成されたエリアです。1943年（昭和18年）に、横浜市の中心である中区から分離して誕生しました。その際、中区の南部に位置していたことから、南区と名付けられたそうです。南北を縦断するように京浜急行、横浜市営地下鉄ブルーライン、鎌倉街道話が通っており、他にも首都高速や横浜横須賀道路も通っているなど、交通の便が良いエリア。そのため中区へのアクセスが良好なこともあり、18区内では一番人口密度の高く、居住エリアとして人気です。区の花としてさくらが選定される程、さくらが有名。鎌倉街道に並行して流れる、大岡川のほとりは、大岡川プロムナードという散歩道が整備されており、500本の桜が咲き乱れる花見の名所となっています。夜にはぼんぼりが桜をライトアップする美しい夜景が見られます。',
        );
        // 各種別の件数取得
        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null], null, 14105);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2, 14105);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1, 14105);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3], null, 14105);

        $article = Article::getNewDataByArea(config('const.COMPANY_ID'), 14105, 6);
        foreach($article as $row) {
            // 画像取得
            $row_photo = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($row_photo->file_path)) {
              $row->file_path = str_replace('public', '/storage', $row_photo->floor_file_path);
            } else {
              $row->file_path = "";
            }
        }
        $data['new'] = $article;

        return view('home.area.city', $data);
    }
//静的生成のため追記 ここまで

    public function city($city_name)
    {
        $area_id = "";
        $area["aoba"] = 14117;
        $area["tsurumi"] = 14101;
        $area["totsuka"] = 14110;
        $area["kouhoku"] = 14109;
        $area["asahi"] = 14112;
        $area["kanagawa"] = 14102;
        $area["hodogaya"] = 14106;
        $area["tuduki"] = 14118;
        $area["midori"] = 14113;
        $area["izumi"] = 14116;
        $area["seya"] = 14114;
        $area["nishi"] = 14103;
        $area["naka"] = 14104;
        $area_id = $area[$city_name];
        if($area_id == "") {
            print("存在しないエリアです。");
            exit;
        }
        $area_info = MstArea::getDataByCode($area_id);

        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/area/other.jpg'),
            'title' => "CITY",
            'jp' => $area_info->name.'の不動産購入と売却',
            'city' => $area_info->name,
            'city_en' => 'other',
            'comment' => $area_info->memo1,
        );
        $dynamics[$city_name] = $area_info->name;
        $data['other'] = true;

        $data['mansion'] = Article::getCountByProperty(config('const.COMPANY_ID'), [null], null, $area_id);
        $data['house_old'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 2, $area_id);
        $data['house_new'] = Article::getCountByProperty(config('const.COMPANY_ID'), [4,5], 1, $area_id);
        $data['land'] = Article::getCountByProperty(config('const.COMPANY_ID'), [1,2,3], null, $area_id);

        return view('home.area.city', $data);
    }
    public function school($city_name,$school_id)
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/history/first.jpg'),
            'title' => "SCHOOL",
            'jp' => '●●小学校区の不動産の購入',
			'city' => $city_name
        );
        $dynamics[$city_name] = "横浜市港南区";
        $school_id = "sc".$school_id ;
        $dynamics[$school_id] = "●●小学校区";
        return view('home.area.school', $data);
    }

    public function town($city_name,$town_id)
    {
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/history/first.jpg'),
            'title' => "TOWN",
            'jp' => '横浜市港南区●●町の不動産購入と売却',
			'city' => $city_name
        );
        $dynamics[$city_name] = "横浜市港南区";
        $town_id = "tw".$town_id ;
        $dynamics[$town_id] = "横浜市港南区●●町";

        return view('home.area.town', $data);
    }

    public function station($city_name,$station_id)
    {

        $station = MstStation::getDataStationById($station_id);
        $data['station'] = $station;

        $address1 = substr($station->area_id, 0, 2);
        $address2 = substr($station->area_id, 2, 3);
        $area = MstCity::getData($address1, $address2);
        $data['area'] = $area[0];

        // 周辺駅などを取得
        $station_other = MstStation::getDataByCode($station->area_id);
        $other = [];
        foreach($station_other as $row) {
            switch($row->area_id) {
                case '14111':
                    $row->area_name = 'konan';
                    break;
                case '14115':
                    $row->area_name = 'sakae';
                    break;
                case '14107':
                    $row->area_name = 'isogo';
                    break;
                case '14108':
                    $row->area_name = 'kanazawa';
                    break;
                case '14105':
                    $row->area_name = 'minami';
                    break;
                default:
                    break;
            }

            if(!isset($row->area_name)) {
                continue;
            }

            if(!isset($other[$row->line])) {
                $other[$row->line] = [$row];
            } else {
                array_push($other[$row->line], $row);
            }
        }

        // 学校の取得
        

        $data['other'] = $other;
        $data['css'] = root("css/area/city.css");
        $data['bread' ] = true;
        $data['staticFirst' ] = array(
            'url' => root('img/history/first.jpg'),
            'title' => "STATION",
            'jp' => $station->line.'「'.$station->name.'」駅の不動産の購入',
			'city' => $city_name
        );
        $dynamics[$city_name] = $area[0]['name'];
        $station_id = "st".$station_id ;
        $dynamics[$station_id] = $station->line."「".$station->name."」駅";
        return view('home.area.station', $data);
    }
}
