<?php

namespace App\Http\Controllers\Business;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Controller;
use Dompdf\Dompdf;
use App\Models\MstPropertyType;
use App\Models\MstPropertyTypeSub;
use App\Models\Article;
use App\Models\Facility;
use App\Models\Vendor;
use App\Models\UserInfo;
use App\Models\MstPrefecture;   
use App\Models\MstCity;
use App\Models\MstTown;
use App\Models\MstLine;
use App\Models\MstStation;
use App\Models\MstFloorType;
use App\Models\MstGenkyou;
use App\Models\MstUseArea;
use App\Models\MstStore;
use App\Models\MstStructure;
use App\Models\MstStructureSub;
use App\Models\MstSchool;
use App\Models\MstManner;
use App\Models\MstParking;
use App\Models\MstStatus;
use App\Models\RelationArticlePhoto;
use App\Models\RelationArticleFacility;
use App\Models\RelationVendorArticle;
use App\Models\RelationPriceHistory;
use App\Models\MstManagementForm;
use App\Models\MstFacilityType;
use App\Models\MstCityPlan;

// use Illuminate\Support\Facades\Auth;
// use Illuminate\Routing\Redirector;

// use Illuminate\Support\Facades\App;

class SearchController extends Controller
{
    /**
     * 売出物件　検索
     */
    public function forSale(Request $request)
    {
        $data = $this->getSearchProperty();

        return view('business.pages.for-sale', $data);
    }

    /**
     * 成約物件　検索
     */
    public function close(Request $request)
    {
        $data = $this->getSearchProperty();

        return view('business.pages.close', $data);
    }

    /**
     * マンション建物　検索
     */
    public function mansion(Request $request)
    {
        $data = $this->getSearchPropertyMansion();

        return view('business.pages.mansion', $data);
    }

    /**
     * 分譲地　検索
     */
    public function lot(Request $request)
    {
        $data = $this->getSearchPropertyLot();

        return view('business.pages.lot', $data);
    }


    /**
     * 売出物件　一覧
     */
    public function forSaleList(Request $request)
    {
        $user = Auth::user();
        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        
        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        // $current_status_list = MstGenkyou:: getData();
        // $current_status = [];
        // foreach($current_status_list as $row) {
        //     $current_status[$row['code']] = $row['name'];
        // }

        $params = $request->all();
        unset($params['page']);
        unset($params['notcondition']);
        unset($params['sort']);
        unset($params['_token']);


        $article_list = Article::getSearchDataByCondition($request, 10, null, 2);

        foreach($article_list as &$row) {
            $row->article_name = $row->name;
            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row['floor_plan_text'] = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = str_replace('学校', '', $primary->name);
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                }
            }

            // 間取り画像取得
            $count = 0;
            if(isset($row->floor_file_path)) {
                $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
                $count = 1;
            } else {
                $row->floor_file_path = '';
            }

            // 写真
            $top_image = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($top_image->file_path)) {
                $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
            } else {
                $row->top_file_path = '';
            }

            // 写真の枚数
            $count += RelationArticlePhoto::getCountImgByArticleId($row->building_id);
            $row->file_count = $count;

            // 価格履歴の取得
            $history = RelationPriceHistory::getHistoryById($row->building_id);
            $row->history = $history;

            // 物件種別名、業者取得
            if(is_null($row->property)) {
                // マンションの場合
                $mansion = Article::getDataById($user->company_id, $row->mansion_id);
                $row->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($mansion->building_id);

                // 学校
                if(isset($mansion->primary_school_school)) {
                    $primary = MstSchool::getSchoolByCode($mansion->primary_school_school);
                    if(isset($primary->name)){
                        $row->primary_school_name = str_replace('学校', '', $primary->name);
                    }
                }
                if(isset($mansion->secondary_school_school)) {
                    $secondary = MstSchool::getSchoolByCode($mansion->secondary_school_school);
                    if(isset($secondary->name)){
                        $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                    }
                }

                // 築年月
                $row->age_year = $mansion->age_year;
                $row->age_month = $mansion->age_month;
                $row->age = intval(date('Y')) - intval($mansion->age_year);
            } else {
                // それ以外
                $row->property_name = $this->getPropertyName($row->property, $row->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($row->building_id);
            }
            
            $row['vendor_info'] = $vendor_info;
        }
        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $count = count($article_list);
        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['count'] = $count;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;

// dump($article_list);
        return view('business.pages.for-sale-list', $data);
    }


    /**
     * 成約物件　一覧
     */
    public function closeList(Request $request)
    {
        $user = Auth::user();
        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        
        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        // $current_status_list = MstGenkyou:: getData();
        // $current_status = [];
        // foreach($current_status_list as $row) {
        //     $current_status[$row['code']] = $row['name'];
        // }

        $params = $request->all();
        unset($params['page']);
        unset($params['notcondition']);
        unset($params['sort']);
        unset($params['_token']);


        $article_list = Article::getSearchDataByCondition($request, 10, null, 1);

        foreach($article_list as &$row) {
            $row->article_name = $row->name;
            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row['floor_plan_text'] = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = str_replace('学校', '', $primary->name);
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                }
            }

            // 間取り画像取得
            $count = 0;
            if(isset($row->floor_file_path)) {
                $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
                $count = 1;
            } else {
                $row->floor_file_path = '';
            }

            // 写真
            $top_image = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($top_image->file_path)) {
                $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
            } else {
                $row->top_file_path = '';
            }

            // 写真の枚数
            $count += RelationArticlePhoto::getCountImgByArticleId($row->building_id);
            $row->file_count = $count;

            // 価格履歴の取得
            $history = RelationPriceHistory::getHistoryById($row->building_id);
            $row->history = $history;

            // 物件種別名、業者取得
            if(is_null($row->property)) {
                // マンションの場合
                $mansion = Article::getDataById($user->company_id, $row->mansion_id);
                $row->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($mansion->building_id);

                // 学校
                if(isset($mansion->primary_school_school)) {
                    $primary = MstSchool::getSchoolByCode($mansion->primary_school_school);
                    if(isset($primary->name)){
                        $row->primary_school_name = str_replace('学校', '', $primary->name);
                    }
                }
                if(isset($mansion->secondary_school_school)) {
                    $secondary = MstSchool::getSchoolByCode($mansion->secondary_school_school);
                    if(isset($secondary->name)){
                        $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                    }
                }

                // 築年月
                $row->age_year = $mansion->age_year;
                $row->age_month = $mansion->age_month;
                $row->age = intval(date('Y')) - intval($mansion->age_year);
            } else {
                // それ以外
                $row->property_name = $this->getPropertyName($row->property, $row->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($row->building_id);
            }
            
            $row['vendor_info'] = $vendor_info;
        }
        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $count = count($article_list);
        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['count'] = $count;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;

// dump($article_list);
        return view('business.pages.for-sale-list', $data);
    }

    /**
     * 売出物件　一覧
     */
    public function mansionList(Request $request)
    {
        $params = $request->all();
        unset($params['_token']);
        unset($params['sort']);
        unset($params['page']);


        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $current_status_list = MstGenkyou:: getData();
        $current_status = [];
        foreach($current_status_list as $row) {
            $current_status[$row['code']] = $row['name'];
        }
        $article_list = Article::getMansionDataByCondition($request, 10);

        $room_count = 0;
        foreach($article_list as &$row) {
            $room_count++;

            // 部屋取得
            $room_list = Article::getRoomList($row['building_id']);
            foreach($room_list as &$room) {
                $room->floor_plan_name = MstFloorType::find($room->floor_plan_type)->name??'';
                if(isset($room->floor_plan_type)) {
                    $room->floor_plan_text = $room->floor_plan . $floor_type[$room->floor_plan_type];
                    
                }
                // 業者の取得
                $vendor = RelationVendorArticle::getVendorDataByRainsNo($room->building_id);
                $room->vendor_info = $vendor;

                // 価格履歴の取得
                $history = RelationPriceHistory::getHistoryById($room->building_id);
                $room->history = $history;
            }
            $row->room_list = $room_list;
            $row->room_count = count($room_list);
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row->floor_plan_text = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $row->current_status = $current_status[$row->current_status];
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = $primary->name;
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = $secondary->name;
                }
            }

            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            // 物件種別
            $row->property_name = $this->getPropertyName($row->property, $row->property_sub);

            // // 業者取得
            // $vendor_info = Vendor::getDataListByArticleId($row->id);
            // $row->vendor_info = $vendor_info;

            $count += RelationArticlePhoto::getCountImgByArticleId($row->building_id);
            $row->file_count = $count;
        }

        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $data['room_count'] = $room_count;

        // 
        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $ad_instructions = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];

        $data['method_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        $data['price_change'] = [
            ['code' => 1, 'name' => '価格変更'],
        ];

        return view('business.pages.mansion-list', $data);
    }

    /**
     * 売出物件　一覧
     */
    public function lotList(Request $request)
    {
        $params = $request->all();
        unset($params['_token']);
        unset($params['sort']);
        unset($params['page']);

        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        $current_status_list = MstGenkyou:: getData();
        $current_status = [];
        foreach($current_status_list as $row) {
            $current_status[$row['code']] = $row['name'];
        }
        $article_list = Article::getSearchDataByCondition($request, 10);

        $propety_list = [];
        foreach($article_list as &$row) {
            $row->article_name = $row->name;
            $row->disp_file = str_replace('public', '/storage', $row->floor_file_path);
            // 部屋取得
            $lot_list = Article::getLotList($row['building_id']);

            $lot_count = 0;
            foreach($lot_list as &$lot) {
                $lot_count++;
                $lot->floor_plan_name = MstFloorType::find($lot->floor_plan_type)->name??'';
                if(isset($lot->floor_plan_type)) {
                    $lot->floor_plan_text = $lot->floor_plan . $floor_type[$lot->floor_plan_type];
                    
                }
                // 物件種別
                $property_name = $this->getPropertyName($lot->property, $lot->property_sub);

                $lot->property_name = $property_name;
                if(!in_array($property_name, $propety_list)) {
                    $propety_list[] = $property_name;
                }

                // 写真
                $top_image = RelationArticlePhoto::getTopImagePath($lot->building_id);
                if(isset($top_image->file_path)) {
                    $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
                } else {
                    $row->top_file_path = '';
                }

                // 写真の枚数
                $count += RelationArticlePhoto::getCountImgByArticleId($lot->building_id);
                $lot->file_count = $count;


                // 業者の取得
                $vendor = RelationVendorArticle::getVendorDataByRainsNo($lot->building_id);
                $lot->vendor_info = $vendor;

                // 価格履歴の取得
                $history = RelationPriceHistory::getHistoryById($lot->building_id);
                $lot->history = $history;
            }
            $row->property_list = $propety_list;

            $row->lot_list = $lot_list;
            $row->lot_count = count($lot_list);
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row->floor_plan_text = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $row->current_status = $current_status[$row->current_status];
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = $primary->name;
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = $secondary->name;
                }
            }

            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            // 物件種別
            $row->property_name = $this->getPropertyName($row->property, $row->property_sub);

            // 業者取得
            $vendor_info = Vendor::getDataListByArticleId($row->id);
            $row->vendor_info = $vendor_info;
        }

        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $data['lot_count'] = $lot_count;

        // 
        $data['ad_conf'] = [
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['method_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        $data['price_change'] = [
            ['code' => 1, 'name' => '価格変更'],
        ];

        return view('business.pages.lot-list', $data);
    }

    public function getSearchProperty() {
        $data = [];
        $data['property'] = [
            ['code' => 61, 'name' => 'マンション'],
            ['code' => 1, 'name' => '土地'],
            ['code' => 41, 'name' => '新築戸建'],
            ['code' => 42, 'name' => '中古戸建'],
            ['code' => 5, 'name' => 'テラスハウス'],
            ['code' => 7, 'name' => 'タウンハウス'],
        ];

        $data['revenue'] = [
            ['code' => 1, 'name' => '収益'],
        ];

        $data['ad_conf'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '可'],
            ['code' => 3, 'name' => '不可'],
        ];

        $data['ad_instructions'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '未'],
            ['code' => 2, 'name' => '入稿'],
        ];

        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => '', 'name' => ''],
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData(config('const.DEFAULT_PREF'));
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1);
        $data['secondary_school'] = MstSchool::getSchoolByType(2);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['parking'] = [];

        $data['land_direction'] = [
            ['code' => 1, 'name' => '北'],
            ['code' => 2, 'name' => '北東'],
            ['code' => 3, 'name' => '東'],
            ['code' => 4, 'name' => '南東'],
            ['code' => 5, 'name' => '南'],
            ['code' => 6, 'name' => '南西'],
            ['code' => 7, 'name' => '西'],
            ['code' => 8, 'name' => '北西'],
        ];

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        return $data;
    }

    public function getSearchPropertyMansion() {
        $data = [];
        $data['property'] = [
            ['code' => 1, 'name' => '土地'],
            ['code' => 2, 'name' => '戸建'],
            ['code' => 3, 'name' => 'マンション'],
        ];


        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => 1, 'name' => '東'],
            ['code' => 2, 'name' => '西'],
            ['code' => 3, 'name' => '南'],
            ['code' => 4, 'name' => '北'],
            ['code' => 5, 'name' => '北東'],
            ['code' => 6, 'name' => '北西'],
            ['code' => 7, 'name' => '南東'],
            ['code' => 8, 'name' => '南西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData(config('const.DEFAULT_PREF'));
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1);
        $data['secondary_school'] = MstSchool::getSchoolByType(2);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['parking'] = MstParking::getDataByType(1);

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['shared'] = [
            ['code' => 1, 'name' => 'ゲストルーム'],
            ['code' => 2, 'name' => '24時間ゴミ出し可'],
            ['code' => 3, 'name' => 'プール'],
            ['code' => 4, 'name' => 'エレベーター'],
            ['code' => 5, 'name' => '宅配ボックス'],
            ['code' => 6, 'name' => 'キッズルーム・託児所'],
            ['code' => 7, 'name' => '共用露天風呂'],
            ['code' => 8, 'name' => 'オートロック'],
        ];

        return $data;
    }

    public function getSearchPropertyLot() {
        $data = [];
        $data['property'] = [
            ['code' => 1, 'name' => '土地'],
            ['code' => 2, 'name' => '戸建'],
            ['code' => 3, 'name' => 'マンション'],
        ];


        $data['pet'] = [
            ['code' => 2, 'name' => '飼育可能（制限有）'],
            ['code' => 1, 'name' => '飼育不可'],
        ];
        $data['pet_num'] = [
            ['code' => '', 'name' => '匹数'],
            ['code' => 1, 'name' => 1],
            ['code' => 2, 'name' => 2],
            ['code' => 3, 'name' => 3],
            ['code' => 4, 'name' => 4],
            ['code' => 5, 'name' => 5],
            ['code' => 6, 'name' => '無制限'],
        ];
        $data['balcony'] = [
            ['code' => 1, 'name' => '東'],
            ['code' => 2, 'name' => '西'],
            ['code' => 3, 'name' => '南'],
            ['code' => 4, 'name' => '北'],
            ['code' => 5, 'name' => '北東'],
            ['code' => 6, 'name' => '北西'],
            ['code' => 7, 'name' => '南東'],
            ['code' => 8, 'name' => '南西'],
        ];
        // 都道府県・市区郡・町村の取得
        $data['pref'] = MstPrefecture::getData();
        $data['city'] = MstCity::getData(config('const.DEFAULT_PREF'));
        $data['town'] = [];

        // 学校区の取得
        $data['primary_school'] = MstSchool::getSchoolByType(1);
        $data['secondary_school'] = MstSchool::getSchoolByType(2);

        // 路線の取得
        $data['line'] = MstLine::getData();

        // 現況
        $data['land_status'] = MstGenkyou::getData();

        // 用途
        $data['use_area'] = MstUseArea::getData();

        // 店舗
        $user = Auth::user();
        $data['shop'] = MstStore::getDataAll($user->company_id);

        // 構造
        $data['construction'] = MstStructure::getData();

        // 間取り
        $data['floor_plan'] = [
            ['code' => 1, 'name' => '1R - 1SLDK'],
            ['code' => 2, 'name' => '2k - 2SLDK'],
            ['code' => 3, 'name' => '3k - 3SLDK'],
            ['code' => 4, 'name' => '4k - 4SLDK'],
            ['code' => 5, 'name' => '5K〜'],
        ];

        $data['walk'] = [
            ['code' => 1, 'name' => '徒歩'],
            ['code' => 2, 'name' => 'バス'],
        ];

        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        return $data;
    }

    public function forSaleDetail(Request $request)
    {
        $user = Auth::user();
        $data = [];
        $params = $request->all();
        unset($params['_token']);

        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request, 10, null, 2);

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->detail_id);
        if($item->property == null) {
            $mansion = Article::getDataById($user->company_id, $item->mansion_id);
            $item->total_unit = $mansion->total_unit;
            $item->management_form = $mansion->management_form??null;
            $item->use_area = $mansion->use_area??null;
            $item->land_use = $mansion->land_use??null;
            $item->land_use2 = $mansion->land_use2??null;
        }
        $item->name = $item->article_name;

        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }

        // 担当者
        $charge_info = UserInfo::getDataById($item->hp_charge);
        if($charge_info != null) {
            $item->hp_charge_name = $charge_info->last_name.' '.$charge_info->first_name;
        } else {
            $item->hp_charge_name = "-";
        }
        
        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->detail_id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->detail_id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);

        // // 表示中のページの最初のアイテムのインデックス番号
        // $first = $article_list->firstItem();
        
        // // 表示中のページの最後のアイテムのインデックス番号
        // $last = $article_list->lastItem();

        $count = count($article_list);

        $flag = 0;
        if(isset($request->open)) {
            $flag = 1;
        }

        $vendor_info = Vendor::getDataListByArticleId($request->id);
        $item['vendor_info'] = $vendor_info;

        $data['disp_flag'] = $flag;
        $data['article_list'] = $article_list;
        $data['item'] = $item;
        $data['photos'] = $photos;
        $data['facilities'] = $facilities;
        $data['facility_count'] = $facility_count;
        $data['manner_name'] = $manner_name;
        $data['shop'] = $shop;
        $data['params'] = $params;
        $data['params_single'] = ['target_id' => $request->detail_id];
        $data['count'] = $count;
        // $data['first'] = $first;
        // $data['last'] = $last;

        return view('business.pages.for-sale-detail', $data);
    }

    public function forSaleSinglePrint(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);
        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
            $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);
        $data['shop'] = $shop;
        $item->manner_name = $manner_name;

        $data['items'][0] = $item;
        $data['url'] = url('');

        return view('business.pages.for-sale-print', $data);
    }

    public function forSaleMultiPrint(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;

            // 管理形態
            $item->management_name = MstManagementForm::find($item->management_form)->name??'';

            // 間取り
            $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

            // 構造
            $item->construction_name = MstStructure::find($item->construction)->name??'';
            $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

            // 水道
            $item->sewerage_name = "";
            if($item->sewerage == 1) {
                $item->sewerage_name = "本下水";
            } elseif($item->sewerage == 2) {
                $item->sewerage_name = "集中浄化槽";
            } elseif($item->sewerage == 3) {
                $item->sewerage_name = "個別浄化槽";
            } else {
                $item->sewerage_name = "-";
            }
            
            // ガス・オール電化
            $item->gas = "";
            if($item->gas == 1) {
                $item->gas_name = "都市ガス";
            } elseif($item->gas == 2) {
                $item->gas_name = "集中ＬＰＧ";
            } elseif($item->gas == 3) {
                $item->gas_name = "個別ＬＰＧ";
            } elseif($item->gas == 4) {
                $item->gas_name = "オール電化";
            } else {
                $item->gas_name = "-";
            }
            
            // 車庫
            $garage = [
                ['code' => 1, 'name' => '掘込車庫'],
                ['code' => 0, 'name' => '未選択'],
            ];

            // 地目
            if($item->ground == 1) {
                $item->ground_name = "宅地";
            } elseif($item->ground == 2) {
                $item->ground_name = "田";
            } elseif($item->ground == 3) {
                $item->ground_name = "畑";
            } elseif($item->ground == 4) {
                $item->ground_name = "山林";
            } elseif($item->ground == 5) {
                $item->ground_name = "雑種地";
            } elseif($item->ground == 6) {
                $item->ground_name = "原野";
            } elseif($item->ground == 7) {
                $item->ground_name = "その他";
            } else {
                $item->ground_name = "-";
            }

            // 建築条件
            if($item->land_condition == 1) {
                $item->land_condition_name = "条件なし";
            } elseif($item->land_condition == 2) {
                $item->land_condition_name = "建築条件付き";
            } else {
                $item->land_condition_name = "-";
            }


            // 開発許可番号
            $lot = Article::getDataById($user->company_id, $item->sale_no);
            $item->develop_num = $lot->develop_num??null;

            // 用途地域
            $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
            $item->use_area_name = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
            $item->use_area_name_sub = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
            $item->use_area_name_sub2 = $use_info->name??'';


            // 画像の設定
            if($item->sheet_file_type == 1) {
                $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
            } else {
                $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
            }

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // プロパティ名を取得
            $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($request->id);
            $facility_count = ceil(count($tmp_facilities) / 2);
            $facilities = [];
            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $item->file_path);
                $facilities[] = $facility;
            }

            // 取引様態の取得
            $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
            $item->manner_name = $manner_name;

            // 取扱店舗を取得
            $shop = MstStore::getDataByCode($user->company_id, $item->shop);
            $item->shop_name = $shop;
        }

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');
        return view('business.pages.for-sale-print', $data);
    }



    public function forSaleSinglePrintVendor(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        $data['items'][0] = $item;

        return view('business.pages.for-sale-print-vendor', $data);
    }

    public function forSaleMultiPrintVendor(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);
        }

        $data['items'] = $article_list;

        return view('business.pages.for-sale-print-vendor', $data);
    }

    public function forSaleSinglePdf(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);
        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);
        $data['shop'] = $shop;
        $data['manner_name'] = $manner_name;

        $data['items'][0] = $item;

        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf', $data)
        
        ->setPaper('A4', 'landscape')
        ->setOption('user-style-sheet', base_path() . '/public/css/app.css');
        // $pdf->setOptions(['orientation' => 'Landscape']);

        return $pdf->stream('title.pdf');

        // return view('business.pages.for-sale-pdf', $data);
    }



    public function forSaleMultiPdf(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 管理形態
            $item->management_name = MstManagementForm::find($item->management_form)->name??'';

            // 間取り
            $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

            // 構造
            $item->construction_name = MstStructure::find($item->construction)->name??'';
            $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

            // 水道
            $item->sewerage_name = "";
            if($item->sewerage == 1) {
                $item->sewerage_name = "本下水";
            } elseif($item->sewerage == 2) {
                $item->sewerage_name = "集中浄化槽";
            } elseif($item->sewerage == 3) {
                $item->sewerage_name = "個別浄化槽";
            } else {
                $item->sewerage_name = "-";
            }
            
            // ガス・オール電化
            $item->gas = "";
            if($item->gas == 1) {
                $item->gas_name = "都市ガス";
            } elseif($item->gas == 2) {
                $item->gas_name = "集中ＬＰＧ";
            } elseif($item->gas == 3) {
                $item->gas_name = "個別ＬＰＧ";
            } elseif($item->gas == 4) {
                $item->gas_name = "オール電化";
            } else {
                $item->gas_name = "-";
            }
            
            // 車庫
            $garage = [
                ['code' => 1, 'name' => '掘込車庫'],
                ['code' => 0, 'name' => '未選択'],
            ];

            // 地目
            if($item->ground == 1) {
                $item->ground_name = "宅地";
            } elseif($item->ground == 2) {
                $item->ground_name = "田";
            } elseif($item->ground == 3) {
                $item->ground_name = "畑";
            } elseif($item->ground == 4) {
                $item->ground_name = "山林";
            } elseif($item->ground == 5) {
                $item->ground_name = "雑種地";
            } elseif($item->ground == 6) {
                $item->ground_name = "原野";
            } elseif($item->ground == 7) {
                $item->ground_name = "その他";
            } else {
                $item->ground_name = "-";
            }

            // 建築条件
            if($item->land_condition == 1) {
                $item->land_condition_name = "条件なし";
            } elseif($item->land_condition == 2) {
                $item->land_condition_name = "建築条件付き";
            } else {
                $item->land_condition_name = "-";
            }


            // 開発許可番号
            $lot = Article::getDataById($user->company_id, $item->sale_no);
            $item->develop_num = $lot->develop_num??null;

            // 用途地域
            $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
            $item->use_area_name = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
            $item->use_area_name_sub = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
            $item->use_area_name_sub2 = $use_info->name??'';


            // 画像の設定
            if($item->sheet_file_type == 1) {
                $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
            } else {
                $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
            }

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // プロパティ名を取得
            $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($request->id);
            $facility_count = ceil(count($tmp_facilities) / 2);
            $facilities = [];
            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $item->file_path);
                $facilities[] = $facility;
            }

            // 取引様態の取得
            $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
            $item->manner_name = $manner_name;

            // 取扱店舗を取得
            $shop = MstStore::getDataByCode($user->company_id, $item->shop);
            $item->shop_name = $shop;
        }

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf', $data);
        return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        // return view('business.pages.for-sale-pdf', $data);
    }

    public function forSaleSinglePdfVendor(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        $data['items'][0] = $item;
        $data['url'] = url('');

        // return view('business.pages.for-sale-pdf-vendor', $data);

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-vendor', $data);
        return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
    }

    public function forSaleMultiPdfVendor(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);
        }

        $data['items'] = $article_list;
        $data['url'] = url('');
        
        $pdf = \PDF::loadView('business.pages.for-sale-pdf-vendor', $data);
        return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
    }

    public function forSaleMultiPrintSet1(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 管理形態
            $item->management_name = MstManagementForm::find($item->management_form)->name??'';

            // 間取り
            $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

            // 構造
            $item->construction_name = MstStructure::find($item->construction)->name??'';
            $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

            // 水道
            $item->sewerage_name = "";
            if($item->sewerage == 1) {
                $item->sewerage_name = "本下水";
            } elseif($item->sewerage == 2) {
                $item->sewerage_name = "集中浄化槽";
            } elseif($item->sewerage == 3) {
                $item->sewerage_name = "個別浄化槽";
            } else {
                $item->sewerage_name = "-";
            }
            
            // ガス・オール電化
            $item->gas = "";
            if($item->gas == 1) {
                $item->gas_name = "都市ガス";
            } elseif($item->gas == 2) {
                $item->gas_name = "集中ＬＰＧ";
            } elseif($item->gas == 3) {
                $item->gas_name = "個別ＬＰＧ";
            } elseif($item->gas == 4) {
                $item->gas_name = "オール電化";
            } else {
                $item->gas_name = "-";
            }
            
            // 車庫
            $garage = [
                ['code' => 1, 'name' => '掘込車庫'],
                ['code' => 0, 'name' => '未選択'],
            ];

            // 地目
            if($item->ground == 1) {
                $item->ground_name = "宅地";
            } elseif($item->ground == 2) {
                $item->ground_name = "田";
            } elseif($item->ground == 3) {
                $item->ground_name = "畑";
            } elseif($item->ground == 4) {
                $item->ground_name = "山林";
            } elseif($item->ground == 5) {
                $item->ground_name = "雑種地";
            } elseif($item->ground == 6) {
                $item->ground_name = "原野";
            } elseif($item->ground == 7) {
                $item->ground_name = "その他";
            } else {
                $item->ground_name = "-";
            }

            // 建築条件
            if($item->land_condition == 1) {
                $item->land_condition_name = "条件なし";
            } elseif($item->land_condition == 2) {
                $item->land_condition_name = "建築条件付き";
            } else {
                $item->land_condition_name = "-";
            }


            // 開発許可番号
            $lot = Article::getDataById($user->company_id, $item->sale_no);
            $item->develop_num = $lot->develop_num??null;

            // 用途地域
            $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
            $item->use_area_name = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
            $item->use_area_name_sub = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
            $item->use_area_name_sub2 = $use_info->name??'';


            // 画像の設定
            if($item->sheet_file_type == 1) {
                $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
            } else {
                $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
            }

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // プロパティ名を取得
            $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($request->id);
            $facility_count = ceil(count($tmp_facilities) / 2);
            $facilities = [];
            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $item->file_path);
                $facilities[] = $facility;
            }

            // 取引様態の取得
            $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
            $item->manner_name = $manner_name;

            // 取扱店舗を取得
            $shop = MstStore::getDataByCode($user->company_id, $item->shop);
            $item->shop_name = $shop;

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);
        }

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        // $pdf = \PDF::loadView('business.pages.for-sale-pdf-set1', $data);
        // return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        return view('business.pages.for-sale-pdf-set1', $data);
    }

    public function forSaleSinglePrintSet1(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);
        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);
        $data['shop'] = $shop;
        $data['manner_name'] = $manner_name;

        $data['items'][0] = $item;

        $data['url'] = url('');

        return view('business.pages.for-sale-pdf-set1', $data);
    }

    public function forSaleMultiPdfSet1(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 管理形態
            $item->management_name = MstManagementForm::find($item->management_form)->name??'';

            // 間取り
            $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

            // 構造
            $item->construction_name = MstStructure::find($item->construction)->name??'';
            $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

            // 水道
            $item->sewerage_name = "";
            if($item->sewerage == 1) {
                $item->sewerage_name = "本下水";
            } elseif($item->sewerage == 2) {
                $item->sewerage_name = "集中浄化槽";
            } elseif($item->sewerage == 3) {
                $item->sewerage_name = "個別浄化槽";
            } else {
                $item->sewerage_name = "-";
            }
            
            // ガス・オール電化
            $item->gas = "";
            if($item->gas == 1) {
                $item->gas_name = "都市ガス";
            } elseif($item->gas == 2) {
                $item->gas_name = "集中ＬＰＧ";
            } elseif($item->gas == 3) {
                $item->gas_name = "個別ＬＰＧ";
            } elseif($item->gas == 4) {
                $item->gas_name = "オール電化";
            } else {
                $item->gas_name = "-";
            }
            
            // 車庫
            $garage = [
                ['code' => 1, 'name' => '掘込車庫'],
                ['code' => 0, 'name' => '未選択'],
            ];

            // 地目
            if($item->ground == 1) {
                $item->ground_name = "宅地";
            } elseif($item->ground == 2) {
                $item->ground_name = "田";
            } elseif($item->ground == 3) {
                $item->ground_name = "畑";
            } elseif($item->ground == 4) {
                $item->ground_name = "山林";
            } elseif($item->ground == 5) {
                $item->ground_name = "雑種地";
            } elseif($item->ground == 6) {
                $item->ground_name = "原野";
            } elseif($item->ground == 7) {
                $item->ground_name = "その他";
            } else {
                $item->ground_name = "-";
            }

            // 建築条件
            if($item->land_condition == 1) {
                $item->land_condition_name = "条件なし";
            } elseif($item->land_condition == 2) {
                $item->land_condition_name = "建築条件付き";
            } else {
                $item->land_condition_name = "-";
            }


            // 開発許可番号
            $lot = Article::getDataById($user->company_id, $item->sale_no);
            $item->develop_num = $lot->develop_num??null;

            // 用途地域
            $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
            $item->use_area_name = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
            $item->use_area_name_sub = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
            $item->use_area_name_sub2 = $use_info->name??'';


            // 画像の設定
            if($item->sheet_file_type == 1) {
                $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
            } else {
                $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
            }

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // プロパティ名を取得
            $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($request->id);
            $facility_count = ceil(count($tmp_facilities) / 2);
            $facilities = [];
            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $item->file_path);
                $facilities[] = $facility;
            }

            // 取引様態の取得
            $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
            $item->manner_name = $manner_name;

            // 取扱店舗を取得
            $shop = MstStore::getDataByCode($user->company_id, $item->shop);
            $item->shop_name = $shop;

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);
        }

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-set1', $data);
        return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        // return view('business.pages.for-sale-pdf', $data);
    }

    public function forSaleSinglePdfSet1(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);
        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);
        $data['shop'] = $shop;
        $data['manner_name'] = $manner_name;

        $data['items'][0] = $item;

        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-set1', $data)
        
        ->setPaper('A4', 'landscape')
        ->setOption('user-style-sheet', base_path() . '/public/css/app.css');
        // $pdf->setOptions(['orientation' => 'Landscape']);

        return $pdf->stream('title.pdf');

        // return view('business.pages.for-sale-pdf', $data);
    }




    public function forSaleMultiPrintSet2(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 対象の一覧取得
            $item->room_list = Article::getDataByRoom($item->building_id, 1);
            $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
            foreach($item->sold_room_list as &$room) {
                if($room->land_area_val != null && $room->land_area_val != 0) {
                    // 坪単価
                    $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
                 } else {
                     $room->tsubo = "-";
                 }
            }
        }

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        // $pdf = \PDF::loadView('business.pages.for-sale-pdf-set1', $data);
        // return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        return view('business.pages.for-sale-pdf-set2', $data);
    }

    public function forSaleSinglePrintSet2(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 対象の一覧取得
        $item->room_list = Article::getDataByRoom($item->building_id, 1);
        $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
        foreach($item->sold_room_list as &$room) {
            if($room->land_area_val != null && $room->land_area_val != 0) {
                // 坪単価
                $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
             } else {
                 $room->tsubo = "-";
             }
        }

        $data['items'][0] = $item;

        $data['url'] = url('');

        return view('business.pages.for-sale-pdf-set2', $data);
    }

    public function forSaleMultiPdfSet2(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 対象の一覧取得
            $item->room_list = Article::getDataByRoom($item->building_id, 1);
            $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
            foreach($item->sold_room_list as &$room) {
                // 坪単価
                if($room->land_area_val != null && $room->total_area_val != 0) {
                    $room->tsubo = ceil($room->price / ($room->total_area_val / 3.3));
                } else {
                    $room->tsubo = 0;
                }
            }
        }

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-set2', $data);
        return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        // return view('business.pages.for-sale-pdf', $data);
    }

    public function forSaleSinglePdfSet2(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);

        // 対象の一覧取得
        $item->room_list = Article::getDataByRoom($item->building_id, 1);
        $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
        foreach($item->sold_room_list as &$room) {
            if($room->land_area_val != null && $room->land_area_val != 0) {
                // 坪単価
                $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
             } else {
                 $room->tsubo = "-";
             }
        }
 
        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        $data['items'][0] = $item;

        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-set2', $data)
        
        ->setPaper('A4', 'landscape')
        ->setOption('user-style-sheet', base_path() . '/public/css/app.css');
        // $pdf->setOptions(['orientation' => 'Landscape']);

        return $pdf->stream('title.pdf');

        // return view('business.pages.for-sale-pdf', $data);
    }






    public function forSaleMultiPrintSet3(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 管理形態
            $item->management_name = MstManagementForm::find($item->management_form)->name??'';

            // 間取り
            $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

            // 構造
            $item->construction_name = MstStructure::find($item->construction)->name??'';
            $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

            // 水道
            $item->sewerage_name = "";
            if($item->sewerage == 1) {
                $item->sewerage_name = "本下水";
            } elseif($item->sewerage == 2) {
                $item->sewerage_name = "集中浄化槽";
            } elseif($item->sewerage == 3) {
                $item->sewerage_name = "個別浄化槽";
            } else {
                $item->sewerage_name = "-";
            }
            
            // ガス・オール電化
            $item->gas = "";
            if($item->gas == 1) {
                $item->gas_name = "都市ガス";
            } elseif($item->gas == 2) {
                $item->gas_name = "集中ＬＰＧ";
            } elseif($item->gas == 3) {
                $item->gas_name = "個別ＬＰＧ";
            } elseif($item->gas == 4) {
                $item->gas_name = "オール電化";
            } else {
                $item->gas_name = "-";
            }
            
            // 車庫
            $garage = [
                ['code' => 1, 'name' => '掘込車庫'],
                ['code' => 0, 'name' => '未選択'],
            ];

            // 地目
            if($item->ground == 1) {
                $item->ground_name = "宅地";
            } elseif($item->ground == 2) {
                $item->ground_name = "田";
            } elseif($item->ground == 3) {
                $item->ground_name = "畑";
            } elseif($item->ground == 4) {
                $item->ground_name = "山林";
            } elseif($item->ground == 5) {
                $item->ground_name = "雑種地";
            } elseif($item->ground == 6) {
                $item->ground_name = "原野";
            } elseif($item->ground == 7) {
                $item->ground_name = "その他";
            } else {
                $item->ground_name = "-";
            }

            // 建築条件
            if($item->land_condition == 1) {
                $item->land_condition_name = "条件なし";
            } elseif($item->land_condition == 2) {
                $item->land_condition_name = "建築条件付き";
            } else {
                $item->land_condition_name = "-";
            }


            // 開発許可番号
            $lot = Article::getDataById($user->company_id, $item->sale_no);
            $item->develop_num = $lot->develop_num??null;

            // 用途地域
            $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
            $item->use_area_name = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
            $item->use_area_name_sub = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
            $item->use_area_name_sub2 = $use_info->name??'';


            // 画像の設定
            if($item->sheet_file_type == 1) {
                $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
            } else {
                $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
            }

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // プロパティ名を取得
            $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($request->id);
            $facility_count = ceil(count($tmp_facilities) / 2);
            $facilities = [];
            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $item->file_path);
                $facilities[] = $facility;
            }

            // 取引様態の取得
            $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
            $item->manner_name = $manner_name;

            // 取扱店舗を取得
            $shop = MstStore::getDataByCode($user->company_id, $item->shop);
            $item->shop_name = $shop;

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 対象の一覧取得
            $item->room_list = Article::getDataByRoom($item->building_id, 1);
            $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
            foreach($item->sold_room_list as &$room) {
                if($room->land_area_val != null && $room->land_area_val != 0) {
                    // 坪単価
                    $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
                 } else {
                     $room->tsubo = "-";
                 }
            }
        }

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        // $pdf = \PDF::loadView('business.pages.for-sale-pdf-set1', $data);
        // return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        return view('business.pages.for-sale-pdf-set3', $data);
    }

    public function forSaleSinglePrintSet3(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);
        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 対象の一覧取得
        $item->room_list = Article::getDataByRoom($item->building_id, 1);
        $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
        foreach($item->sold_room_list as &$room) {
            if($room->land_area_val != null && $room->land_area_val != 0) {
                // 坪単価
                $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
             } else {
                 $room->tsubo = "-";
             }
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);
        $data['shop'] = $shop;
        $data['manner_name'] = $manner_name;

        $data['items'][0] = $item;

        $data['url'] = url('');

        return view('business.pages.for-sale-pdf-set3', $data);
    }

    public function forSaleMultiPdfSet3(Request $request) {
        $user = Auth::user();
        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);
        foreach($article_list as &$item) {
            $item->article_name = $item->name;
            // 管理形態
            $item->management_name = MstManagementForm::find($item->management_form)->name??'';

            // 間取り
            $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

            // 構造
            $item->construction_name = MstStructure::find($item->construction)->name??'';
            $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

            // 水道
            $item->sewerage_name = "";
            if($item->sewerage == 1) {
                $item->sewerage_name = "本下水";
            } elseif($item->sewerage == 2) {
                $item->sewerage_name = "集中浄化槽";
            } elseif($item->sewerage == 3) {
                $item->sewerage_name = "個別浄化槽";
            } else {
                $item->sewerage_name = "-";
            }
            
            // ガス・オール電化
            $item->gas = "";
            if($item->gas == 1) {
                $item->gas_name = "都市ガス";
            } elseif($item->gas == 2) {
                $item->gas_name = "集中ＬＰＧ";
            } elseif($item->gas == 3) {
                $item->gas_name = "個別ＬＰＧ";
            } elseif($item->gas == 4) {
                $item->gas_name = "オール電化";
            } else {
                $item->gas_name = "-";
            }
            
            // 車庫
            $garage = [
                ['code' => 1, 'name' => '掘込車庫'],
                ['code' => 0, 'name' => '未選択'],
            ];

            // 地目
            if($item->ground == 1) {
                $item->ground_name = "宅地";
            } elseif($item->ground == 2) {
                $item->ground_name = "田";
            } elseif($item->ground == 3) {
                $item->ground_name = "畑";
            } elseif($item->ground == 4) {
                $item->ground_name = "山林";
            } elseif($item->ground == 5) {
                $item->ground_name = "雑種地";
            } elseif($item->ground == 6) {
                $item->ground_name = "原野";
            } elseif($item->ground == 7) {
                $item->ground_name = "その他";
            } else {
                $item->ground_name = "-";
            }

            // 建築条件
            if($item->land_condition == 1) {
                $item->land_condition_name = "条件なし";
            } elseif($item->land_condition == 2) {
                $item->land_condition_name = "建築条件付き";
            } else {
                $item->land_condition_name = "-";
            }


            // 開発許可番号
            $lot = Article::getDataById($user->company_id, $item->sale_no);
            $item->develop_num = $lot->develop_num??null;

            // 用途地域
            $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
            $item->use_area_name = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
            $item->use_area_name_sub = $use_info->name??'';
            $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
            $item->use_area_name_sub2 = $use_info->name??'';


            // 画像の設定
            if($item->sheet_file_type == 1) {
                $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
            } else {
                $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
            }

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // プロパティ名を取得
            $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($request->id);
            $facility_count = ceil(count($tmp_facilities) / 2);
            $facilities = [];
            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $item->file_path);
                $facilities[] = $facility;
            }

            // 取引様態の取得
            $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
            $item->manner_name = $manner_name;

            // 取扱店舗を取得
            $shop = MstStore::getDataByCode($user->company_id, $item->shop);
            $item->shop_name = $shop;

            // 業者シート画像
            $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

            // 対象の一覧取得
            $item->room_list = Article::getDataByRoom($item->building_id, 1);
            $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
            foreach($item->sold_room_list as &$room) {
                if($room->land_area_val != null && $room->land_area_val != 0) {
                    // 坪単価
                    $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
                 } else {
                     $room->tsubo = "-";
                 }
            }
        }

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

// dump($article_list);
        $data['items'] = $article_list;
        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-set3', $data);
        return $pdf->inline('thisis.pdf');  //ブラウザ上で開ける
        
        // return view('business.pages.for-sale-pdf', $data);
    }

    public function forSaleSinglePdfSet3(Request $request) {
        $user = Auth::user();
        $data = [];

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->target_id);
        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 対象の一覧取得
        $item->room_list = Article::getDataByRoom($item->building_id, 1);
        $item->sold_room_list = Article::getDataByRoom($item->building_id, 2);
        foreach($item->sold_room_list as &$room) {
            if($room->land_area_val != null && $room->land_area_val != 0) {
                // 坪単価
                $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
             } else {
                 $room->tsubo = "-";
             }
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);
        $data['shop'] = $shop;
        $data['manner_name'] = $manner_name;

        $data['items'][0] = $item;

        $data['url'] = url('');

        $pdf = \PDF::loadView('business.pages.for-sale-pdf-set3', $data)
        
        ->setPaper('A4', 'landscape')
        ->setOption('user-style-sheet', base_path() . '/public/css/app.css');
        // $pdf->setOptions(['orientation' => 'Landscape']);

        return $pdf->stream('title.pdf');

        // return view('business.pages.for-sale-pdf', $data);
    }

    
    

    public function closeDetail(Request $request)
    {
        $user = Auth::user();
        $data = [];

        $params = $request->all();
        unset($params['_token']);

        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request, null, null, 1);

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->detail_id);
        if($item->property == null) {
            $mansion = Article::getDataById($user->company_id, $item->mansion_id);
            $item->total_unit = $mansion->total_unit;
            $item->management_form = $mansion->management_form??null;
            $item->use_area = $mansion->use_area??null;
            $item->land_use = $mansion->land_use??null;
            $item->land_use2 = $mansion->land_use2??null;
        }
        $item->name = $item->article_name;

        // 管理形態
        $item->management_name = MstManagementForm::find($item->management_form)->name??'';

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 水道
        $item->sewerage_name = "";
        if($item->sewerage == 1) {
            $item->sewerage_name = "本下水";
        } elseif($item->sewerage == 2) {
            $item->sewerage_name = "集中浄化槽";
        } elseif($item->sewerage == 3) {
            $item->sewerage_name = "個別浄化槽";
        } else {
            $item->sewerage_name = "-";
        }
        
        // ガス・オール電化
        $item->gas = "";
        if($item->gas == 1) {
            $item->gas_name = "都市ガス";
        } elseif($item->gas == 2) {
            $item->gas_name = "集中ＬＰＧ";
        } elseif($item->gas == 3) {
            $item->gas_name = "個別ＬＰＧ";
        } elseif($item->gas == 4) {
            $item->gas_name = "オール電化";
        } else {
            $item->gas_name = "-";
        }
        
        // 車庫
        $garage = [
            ['code' => 1, 'name' => '掘込車庫'],
            ['code' => 0, 'name' => '未選択'],
        ];

        // 地目
        if($item->ground == 1) {
            $item->ground_name = "宅地";
        } elseif($item->ground == 2) {
            $item->ground_name = "田";
        } elseif($item->ground == 3) {
            $item->ground_name = "畑";
        } elseif($item->ground == 4) {
            $item->ground_name = "山林";
        } elseif($item->ground == 5) {
            $item->ground_name = "雑種地";
        } elseif($item->ground == 6) {
            $item->ground_name = "原野";
        } elseif($item->ground == 7) {
            $item->ground_name = "その他";
        } else {
            $item->ground_name = "-";
        }

        // 建築条件
        if($item->land_condition == 1) {
            $item->land_condition_name = "条件なし";
        } elseif($item->land_condition == 2) {
            $item->land_condition_name = "建築条件付き";
        } else {
            $item->land_condition_name = "-";
        }


        // 開発許可番号
        $lot = Article::getDataById($user->company_id, $item->sale_no);
        $item->develop_num = $lot->develop_num??null;

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $item->use_area)->first();
        $item->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use)->first();
        $item->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $item->land_use2)->first();
        $item->use_area_name_sub2 = $use_info->name??'';


        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }

        // 業者シート画像
        $item->disp_sheet_file = str_replace('public', '/storage', $item->sheet_file_path2);

        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner_name = MstManner::where('code', '=', $item->company_manner)->first()->name??'';
        
        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);

        // // 表示中のページの最初のアイテムのインデックス番号
        // $first = $article_list->firstItem();
        
        // // 表示中のページの最後のアイテムのインデックス番号
        // $last = $article_list->lastItem();

        $count = count($article_list);

        $flag = 0;
        if(isset($request->open)) {
            $flag = 1;
        }

        $vendor_info = Vendor::getDataListByArticleId($request->id);
        $item['vendor_info'] = $vendor_info;

        $data['disp_flag'] = $flag;
        $data['article_list'] = $article_list;
        $data['item'] = $item;
        $data['photos'] = $photos;
        $data['facilities'] = $facilities;
        $data['facility_count'] = $facility_count;
        $data['manner_name'] = $manner_name;
        $data['shop'] = $shop;
        $data['params'] = $params;
        $data['params_single'] = ['target_id' => $request->id];

        $data['count'] = $count;
        // $data['first'] = $first;
        // $data['last'] = $last;

        

        return view('business.pages.for-sale-detail', $data);
    }

    public function mansionParentDetail(Request $request)
    {
        $user = Auth::user();
        $data = [];

        $page = 0;
        if(isset($request->page)) {
            $page = $request->page - 1;
        }
        $params = $request->all();
        unset($params['_token']);

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->detail_id);

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 土地権利
        $item->land_right_name = '';
        if($item->land_right == 1) {
            $item->land_right_name = '所有権';

        } elseif($item->land_right == 2) {
            $item->land_right_name = '借地権のみ';

        } elseif($item->land_right == 3) {
            $item->land_right_name = '所有権・借地権混在';

        }

        // 用途
        $item->use_area_name = MstUseArea::find($item->use_area)->name??'';
        $item->use_area_name_sub = MstUseArea::find($item->land_use)->name??'';
        $item->use_area_name_sub2 = MstUseArea::find($item->land_use2)->name??'';

        // 共用部

        // 管理形態
        $item->management_form_name = MstManagementForm::find($item->management_form)->name??'';

        // 学校区
        if(isset($item->primary_school_school)) {
            $primary = MstSchool::getSchoolByCode($item->primary_school_school);
            if(isset($primary->name)){
                $item->primary_school_name = str_replace('学校', '', $primary->name);
            }
        }
        if(isset($item->secondary_school_school)) {
            $secondary = MstSchool::getSchoolByCode($item->secondary_school_school);
            if(isset($secondary->name)){
                $item->secondary_school_name = str_replace('学校', '', $secondary->name);
            }
        }

        // 対象の一覧取得
        $room_list = Article::getDataByRoom($item->building_id, 1);
// dump($room_list);
        $facilities = [];
        $facilities_few = [];
        $photos = [];
        foreach($room_list as $room) {
            if($room->land_area_val != null && $room->land_area_val != 0) {
                // 坪単価
                $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
             } else {
                 $room->tsubo = "-";
             }

            // 画像の設定
            if($room->sheet_file_type == 1) {
                $room->disp_file = str_replace('public', '/storage', $room->sheet_file_path3);
            } else {
                $room->disp_file = str_replace('public', '/storage', $room->floor_file_path);
            }
            // 写真画像の取得
            $photos = RelationArticlePhoto::getDispImgByArticleId($room->building_id);
            foreach($photos as $photo) {
                $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
            }

            // 周辺物件を取得
            $tmp_facilities = RelationArticleFacility::getData($room->building_id);
            

            foreach($tmp_facilities as $tmp_facility) {
                $facility = Facility::getDataById($tmp_facility->facility_id);
                $facility->disp_file = str_replace('public', '/storage', $facility->file_path);
                $facility->kind_name = MstFacilityType::find($facility->kind)->name??'';
                $facility->access = '徒歩'. $tmp_facility->time. '分(約' . $tmp_facility->distance . 'm)';
                $facility->distance = $tmp_facility->distance;
                $facility->time = $tmp_facility->time;
                $facilities[] = $facility;
                if(count($facilities_few) < 6) {
                    $facilities_few[] = $facility;
                }
            }
        }
        $sold_room_list = Article::getDataByRoom($item->building_id, 2);
        foreach($sold_room_list as $room) {
            if($room->land_area_val != null && $room->land_area_val != 0) {
                // 坪単価
                $room->tsubo = ceil($room->price / ($room->land_area_val / 3.3));
             } else {
                 $room->tsubo = "-";
             }
        }
        $item->facilirty_few = $facilities_few;
        $facility_count = ceil(count($facilities) / 2);


        // 取引様態の取得
        $manner = MstManner::where('code', '=', $item->company_manner)->first()->name??'';

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);

        // // 表示中のページの最初のアイテムのインデックス番号
        // $first = $article_list->firstItem();
        
        // // 表示中のページの最後のアイテムのインデックス番号
        // $last = $article_list->lastItem();

        $count = count($room_list);

        $data['article_list'] = $room_list;
        $data['sold_article_list'] = $sold_room_list;
        $data['item'] = $item;
        $data['photos'] = $photos;
        $data['facilities'] = $facilities;
        $data['facility_count'] = $facility_count;
        $data['manner'] = $manner;
        $data['shop'] = $shop;
        $data['params'] = $params;
        $data['params_single'] = ['target_id' => $request->id];

        $data['count'] = $count;
        // $data['first'] = $first;
        // $data['last'] = $last;

        return view('business.pages.mansion-parent-detail', $data);
    }

    public function mansionDetail(Request $request)
    {
        $user = Auth::user();
        $data = [];

        $page = 0;
        if(isset($request->page)) {
            $page = $request->page - 1;
        }
        $params = $request->all();
        unset($params['_token']);

        // 対象１件を取得
        $mansion = Article::getDataById($user->company_id, $request->id);

        // 対象の一覧取得
        $room_list = Article::getDataByRoom($mansion->building_id);

        $item = $room_list[$page];

        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($mansion->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($mansion->construction_sub)->name??'';

        // 管理形態
        $item->construction_name = MstStructure::find($mansion->management_form)->name??'';

        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }
        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($item->building_id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner = MstManner::where('code', '=', $item->company_manner)->first()->name??'';

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);

        // // 表示中のページの最初のアイテムのインデックス番号
        // $first = $article_list->firstItem();
        
        // // 表示中のページの最後のアイテムのインデックス番号
        // $last = $article_list->lastItem();

        $count = count($room_list);

        $data['article_list'] = $room_list;
        $data['mansion'] = $mansion;
        $data['item'] = $item;
        $data['photos'] = $photos;
        $data['facilities'] = $facilities;
        $data['facility_count'] = $facility_count;
        $data['manner'] = $manner;
        $data['shop'] = $shop;
        $data['params'] = $params;
        $data['params_single'] = ['target_id' => $request->id];

        $data['count'] = $count;
        // $data['first'] = $first;
        // $data['last'] = $last;

        return view('business.pages.mansion-detail', $data);
    }


    public function lotParentDetail(Request $request)
    {
        $user = Auth::user();
        $data = [];

        $params = $request->all();
        unset($params['_token']);

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->id);
        $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        

         // 土地権利
         $item->land_right_name = '';
         if($item->land_right == 1) {
             $item->land_right_name = '所有権';
 
         } elseif($item->land_right == 2) {
             $item->land_right_name = '借地権のみ';
 
         } elseif($item->land_right == 3) {
             $item->land_right_name = '所有権・借地権混在';
 
         }

         // 地目
        $item->ground_name = '';
        if($item->ground == 1) {
            $item->ground_name = '宅地';

        } elseif($item->ground == 2) {
            $item->ground_name = '田';

        } elseif($item->ground == 3) {
            $item->ground_name = '畑';

        } elseif($item->ground == 4) {
            $item->ground_name = '山林';

        } elseif($item->ground == 5) {
            $item->ground_name = '雑種地';

        } elseif($item->ground == 6) {
            $item->ground_name = '原野';

        } elseif($item->ground == 7) {
            $item->ground_name = 'その他';

        }

        // 地役権
        $item->easement_name = '';
        if($item->easement == 1) {
            $item->easement_name = '無';

        } elseif($item->easement == 2) {
            $item->easement_name = '地役権';

        } elseif($item->easement == 3) {
            $item->easement_name = '通行地役権';

        } elseif($item->easement == 4) {
            $item->easement_name = '引水地役権';

        } elseif($item->easement == 5) {
            $item->easement_name = '眺望地役権';

        } elseif($item->easement == 6) {
            $item->easement_name = '通路賃借権';

        }

        // 都市計画
        if($item->city_plan != 0) {
            $cp = MstCityPlan::where('code', '=', $item->city_plan)->first();
            if($cp != null) {
                $item->city_plan_name = $cp->name??'';
            }

        } else {
            $item->city_plan_name = '';
        }
 
         // 用途
         $item->use_area_name = MstUseArea::find($item->use_area)->name??'';
         $item->use_area_name_sub = MstUseArea::find($item->land_use)->name??'';
         $item->use_area_name_sub2 = MstUseArea::find($item->land_use2)->name??'';
 
         // 共用部
 
         // 管理形態
         $item->management_form_name = MstManagementForm::find($item->management_form)->name??'';
 
         // 学校区
         if(isset($item->primary_school_school)) {
             $primary = MstSchool::getSchoolByCode($item->primary_school_school);
             if(isset($primary->name)){
                 $item->primary_school_name = str_replace('学校', '', $primary->name);
             }
         }
         if(isset($item->secondary_school_school)) {
             $secondary = MstSchool::getSchoolByCode($item->secondary_school_school);
             if(isset($secondary->name)){
                 $item->secondary_school_name = str_replace('学校', '', $secondary->name);
             }
         }
 
         // 対象の一覧取得
         $lot_list = Article::getLotList($item->building_id);
         $article_list = Article::getArticleList($item->building_id, 1);
         foreach($article_list as &$row) {
             if($row->land_area_val != null && $row->land_area_val != 0) {
                // 坪単価
                $row->tsubo = ceil($row->price / ($row->land_area_val / 3.3));
             } else {
                 $row->tsubo = "-";
             }
         }
         $sold_lot_list = Article::getArticleList($item->building_id, 2);
         foreach($sold_lot_list as $row) {
            if($row->land_area_val != null && $row->land_area_val != 0) {
                // 坪単価
                $row->tsubo = ceil($row->price / ($row->land_area_val / 3.3));
             } else {
                 $row->tsubo = "-";
             }
        }

         $facilities = [];
         $facilities_few = [];
         $photos = [];
         foreach($lot_list as $lot) {
             // 画像の設定
             if($lot->sheet_file_type == 1) {
                 $lot->disp_file = str_replace('public', '/storage', $lot->sheet_file_path3);
             } else {
                 $lot->disp_file = str_replace('public', '/storage', $lot->floor_file_path);
             }
             // 写真画像の取得
             $photos = RelationArticlePhoto::getDispImgByArticleId($lot->building_id);
             foreach($photos as $photo) {
                 $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
             }
 
             // 周辺物件を取得
             $tmp_facilities = RelationArticleFacility::getData($lot->building_id);
             
 
             foreach($tmp_facilities as $tmp_facility) {
                 $facility = Facility::getDataById($tmp_facility->facility_id);
                 $facility->disp_file = str_replace('public', '/storage', $facility->file_path);
                 $facility->kind_name = MstFacilityType::find($facility->kind)->name??'';
                 $facility->access = '徒歩'. $tmp_facility->time. '分(約' . $tmp_facility->distance . 'm)';
                 $facility->distance = $tmp_facility->distance;
                 $facility->time = $tmp_facility->time;
                 $facilities[] = $facility;
                 if(count($facilities_few) < 6) {
                     $facilities_few[] = $facility;
                 }
             }
         }
         $item->facilirty_few = $facilities_few;
         $facility_count = ceil(count($facilities) / 2);

        

        // 取引様態の取得
        $manner = MstManner::where('code', '=', $item->company_manner)->first()->name??'';

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);

        // // 表示中のページの最初のアイテムのインデックス番号
        // $first = $article_list->firstItem();
        
        // // 表示中のページの最後のアイテムのインデックス番号
        // $last = $article_list->lastItem();

        // $count = count($article_list);

        $data['item'] = $item;
        $data['article_list'] = $article_list;
        $data['sold_lot_list'] = $sold_lot_list;
        $data['photos'] = $photos;
        $data['facilities'] = $facilities;
        $data['facility_count'] = $facility_count;
        $data['manner'] = $manner;
        $data['shop'] = $shop;
        $data['params'] = $params;
        $data['params_single'] = ['target_id' => $request->id];

        // $data['count'] = $count;
        // $data['first'] = $first;
        // $data['last'] = $last;


        return view('business.pages.lot-parent-detail', $data);
    }

    public function lotDetail(Request $request)
    {
        $user = Auth::user();
        $data = [];

        $params = $request->all();
        unset($params['_token']);

        // 対象の一覧取得
        $article_list = Article::getSearchDataByCondition($request);

        // 対象１件を取得
        $item = Article::getDataById($user->company_id, $request->id);
        // 間取り
        $item->floor_plan_name = MstFloorType::find($item->floor_plan_type)->name??'';

        // 構造
        $item->construction_name = MstStructure::find($item->construction)->name??'';
        $item->construction_sub_name = MstStructureSub::find($item->construction_sub)->name??'';

        // 管理形態
        $item->construction_name = MstStructure::find($item->management_form)->name??'';

        // 画像の設定
        if($item->sheet_file_type == 1) {
            $item->disp_file = str_replace('public', '/storage', $item->sheet_file_path3);
        } else {
            $item->disp_file = str_replace('public', '/storage', $item->floor_file_path);
        }
        // 写真画像の取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // プロパティ名を取得
        $item->property_name = $this->getPropertyName($item->property, $item->property_sub);

        // 周辺物件を取得
        $tmp_facilities = RelationArticleFacility::getData($request->id);
        $facility_count = ceil(count($tmp_facilities) / 2);
        $facilities = [];
        foreach($tmp_facilities as $tmp_facility) {
            $facility = Facility::getDataById($tmp_facility->facility_id);
            $facility->disp_file = str_replace('public', '/storage', $item->file_path);
            $facilities[] = $facility;
        }

        // 取引様態の取得
        $manner = MstManner::where('code', '=', $item->company_manner)->first()->name??'';

        // 取扱店舗を取得
        $shop = MstStore::getDataByCode($user->company_id, $item->shop);

        // // 表示中のページの最初のアイテムのインデックス番号
        // $first = $article_list->firstItem();
        
        // // 表示中のページの最後のアイテムのインデックス番号
        // $last = $article_list->lastItem();

        $count = count($article_list);

        $data['article_list'] = $article_list;
        $data['item'] = $item;
        $data['photos'] = $photos;
        $data['facilities'] = $facilities;
        $data['facility_count'] = $facility_count;
        $data['manner'] = $manner;
        $data['shop'] = $shop;
        $data['params'] = $params;
        $data['params_single'] = ['target_id' => $request->id];

        $data['count'] = $count;
        // $data['first'] = $first;
        // $data['last'] = $last;

        return view('business.pages.lot-detail', $data);
    }



    //TODO delete
    public function sample(Request $request)
    {
        return view('business.objects.projects.modal-print');
    }
    public function sample2(Request $request)
    {
        return view('business.objects.projects.modal-select-layout');
    }


    public static function getPropertyName($property, $property_sub) {
        $res = '';
        if($property > 3) {
            $res .= MstPropertyTypeSub::find($property_sub)->name??'';
        }

        if($property != null) {
            $res .= MstPropertyType::find($property)->name??'';
        } else {
            $res .= 'マンション（部屋）';
        }
        

        return $res;
    }

    public static function createConditionList($con) {
        // dump($con);
        $user = Auth::user();
        $res = [];
        $property_name = "";
        $add = "";
        $pref = 0;
        $city = 0;
        $town = 0;
        $price = "";
        $years = "";
        $months = "";
        $construction = "";
        $floor_area = "";
        $land = "";
        $floor = "";
        $school = "";
        $parking = "";
        $land_status = "";
        $land_kind = "";
        $shop = "";
        $balcony_direction = "";
        $balcony_area = "";
        $pet = "";
        $pet_num = "";
        $use_area = "";
        $management_company = "";
        $construction_name = "";
        foreach($con as $key => $val) {
            if($key == 'property') {
                $property_name = "";
                foreach($val as $row) {
                    $tmp = "";
                    $tmp_sub = "";
                    if($row == 41) {
                        $property = 4;
                        $property_sub = 1;
                        $tmp_sub = MstPropertyTypeSub::find($property_sub)->name??'';
                    } elseif($row == 42) {
                        $property = 4;
                        $property_sub = 2;
                        $tmp_sub = MstPropertyTypeSub::find($property_sub)->name??'';
                    } else {
                        $property = $row;
                    }
                    $tmp = MstPropertyType::find($property)->name??'';
                    $property_name .= $tmp_sub . $tmp;
                }
                
            }
            if($key == 'address1') {
                foreach($val as $row) {
                    $add .= MstPrefecture::where('code', '=', $row)->first()->name??'';
                    $pref .= $row;
                }
                
            }
            if($key == 'address2') {
                foreach($val as $row) {
                    $add .= MstCity::where('pref_code', '=', $pref)->where('code', '=', $val)->first()->name??'';
                    $city .= $row;
                }
            }
            if($key == 'address3') {
                foreach($val as $row) {
                    $add .= MstTown::where('pref_code', '=', $pref)->where('city_code', '=', $city)->where('code', '=', $val)->first()->name??'';
                    $add .= $row;
                }
            }
            if($key == 'address4') {
                foreach($val as $row) {
                    $add .= $row;
                }
            }
            if($key == 'building_id') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $res['物件ID'] = $row;
                    }
                }
            }
            if($key == 'price_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $price .= $row."万円";
                    }
                }
            }
            if($key == 'price_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($price != "") {
                            $price .= "〜";
                        }
                        $price .= $row."万円";
                    } else {
                        if($price != "") {
                            $price .= "〜";
                        }
                    }
                }
            }
            if($key == 'access1') {
            
            }
            if($key == 'access2') {
            
            }
            if($key == 'access3') {
            
            }
            if($key == 'bus') {
            
            }
            if($key == 'walk') {
            
            }
            if($key == 'primary_school') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $school .= MstSchool::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'secondary_school') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($school != "") {
                            $school .= " ";
                        }
                        $school .= MstSchool::where('code', '=', $row)->first()->name??'';
                    }
                }
            }

            if($key == 'land_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $land .= $row."㎡";
                    }
                }
            }
            if($key == 'land_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($land != "") {
                            $land .= "〜";
                        }
                        $land .= $row."㎡";
                    } else {
                        if($land != "") {
                            $land .= "〜";
                        }
                    }
                }
            }
            if($key == 'floor_area_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $floor_area .= $row."㎡";
                    }
                }
            }
            if($key == 'floor_area_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($floor_area != "") {
                            $floor_area .= "〜";
                        }
                        $floor_area .= $row."㎡";
                    } else {
                        if($floor_area != "") {
                            $floor_area .= "〜";
                        }
                    }
                }
            }
            if($key == 'floor_plan') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 1:
                            $res['間取り'] = '1R - 1SLDK';
                            break;
                            case 2:
                            $res['間取り'] = '2K - 2SLDK';
                            break;
                            case 3:
                            $res['間取り'] = '3K - 3SLDK';
                            break;
                            case 4:
                            $res['間取り'] = '4K - 4SLDK';
                            break;
                            case 5:
                            $res['間取り'] = '5K〜';
                            break;
    
                        }
                    }
                }


            }
            if($key == 'name') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $res['物件名'] = $row;
                    }
                }
            }
            if($key == 'mansion_name') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $res['マンション名'] = $row;
                    }
                }
            }
            if($key == 'years_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $years .= $row."年";
                    }
                }
            }
            if($key == 'years_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($years != "") {
                            $years .= "〜";
                        }
                        $years .= $row."年";
                    } else {
                        if($years != "") {
                            $years .= "〜";
                        }
                    }
                }
            }

            if($key == 'year_month_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $months .= $row;
                    }
                }
            }
            if($key == 'year_month_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($months != "") {
                            $months .= "〜";
                        }
                        $months .= $row;
                    } else {
                        if($months != "") {
                            $months .= "〜";
                        }
                    }
                }
            }
            if($key == 'construction') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $construction .= MstStructure::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'parking') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $parking .= MstParking::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'land_status') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $land_status .= MstGenkyou::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'use_area') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $use_area .= MstUseArea::where('code', '=', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'floor_from') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $floor .= $row."㎡";
                    }
                }
            }
            if($key == 'floor_to') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        if($floor != "") {
                            $floor .= "〜";
                        }
                        $floor .= $row."㎡";
                    } else {
                        if($floor != "") {
                            $floor .= "〜";
                        }
                    }
                }
            }
            if($key == 'land_kind') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 1:
                                $land_kind = "北";
                            break;
                            case 2:
                                $land_kind = "北東";
                            break;
                            case 3:
                                $land_kind = "東";
                            break;
                            case 4:
                                $land_kind = "南東";
                            break;
                            case 5:
                                $land_kind = "南";
                            break;
                            case 6:
                                $land_kind = "南西";
                            break;
                            case 7:
                                $land_kind = "西";
                            break;
                            case 8:
                                $land_kind = "北西";
                            break;
                        }
                    }
                }
            }

            if($key == 'search_shop') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $shop .= MstStore::where('company_id', '=', $user->company_id)->where('code', $row)->first()->name??'';
                    }
                }
            }
            if($key == 'balcony_direction') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 1:
                                $balcony_direction = "北";
                            break;
                            case 2:
                                $balcony_direction = "北東";
                            break;
                            case 3:
                                $balcony_direction = "東";
                            break;
                            case 4:
                                $balcony_direction = "南東";
                            break;
                            case 5:
                                $balcony_direction = "南";
                            break;
                            case 6:
                                $balcony_direction = "南西";
                            break;
                            case 7:
                                $balcony_direction = "西";
                            break;
                            case 8:
                                $balcony_direction = "北西";
                            break;
                        }
                    }
                }
            }

            if($key == 'balcony_area') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $balcony_area .= $row."㎡";
                    }
                }
            }
            if($key == 'is_pet') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        switch($row) {
                            case 2:
                                $pet = "飼育可能（制限有）";
                            break;
                            case 1:
                                $pet = "飼育不可";
                            break;
                        }
                    }
                }
            }
            if($key == 'pet_num') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $pet_num .= $row."匹";
                    }
                }
            }

            if($key == 'management_company') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $management_company .= $row;
                    }
                }
            }

            if($key == 'construction_name') {
                foreach($val as $row) {
                    if(!empty($row)) {
                        $construction_name .= $row;
                    }
                }
            }
            if($key == 'owner') {
            
            }
            if($key == 'registed_from') {
            
            }
            if($key == 'registed_to') {
            
            }
            if($key == 'checked_from') {
            
            }
            if($key == 'checked_to') {
            
            }
            if($key == 'changed_price_from') {
            
            }
            if($key == 'changed_price_to') {
            
            }
            if($key == 'ad_checked_from') {
            
            }
            if($key == 'ad_checked_to') {
            
            }
            if($key == 'flyer') {
            
            }
            if($key == 'vender_name') {
            
            }
            if($key == 'vender_kind') {
            
            }
            if($key == 'vender_tel') {
            
            }
        }

        if($property_name != "") {
            $res['物件種別'] = $property_name;
        }

        if($add != "") {
            $res['所在地'] = $add;
        }

        if($price != "") {
            $res['価格'] = $price;
        }
        if($years != "") {
            $res['築年数'] = $years;
        }
        if($months != "") {
            $res['築年月'] = $months;
        }
        if($construction != "") {
            $res['構造'] = $construction;
        }
        if($parking != "") {
            $res['駐車場'] = $parking;
        }
        if($land_status != "") {
            $res['現況'] = $land_status;
        }
        if($use_area != "") {
            $res['用途地域'] = $use_area;
        }
        if($land_kind != "") {
            $res['接道方向'] = $land_kind;
        }
        if($shop != "") {
            $res['取扱店舗'] = $shop;
        }
        if($balcony_direction != "") {
            $res['バルコニー'] = $balcony_direction." ".$balcony_area;
        }

        if($pet != "") {
            $res['ペット'] = $pet." ".$pet_num;
        }
        if($management_company != "") {
            $res['事業主'] = $management_company;
        }
        if($construction_name != "") {
            $res['施工'] = $construction_name;
        }

        if($school != "") {
            $res['学校区'] = $school;
        }

        if($land != "") {
            $res['土地面積'] = $land;
        }

        if($floor_area != "") {
            $res['延床面積'] = $floor_area;
        }

        if($floor != "") {
            $res['階建'] = $floor;
        }

        return $res;
    }


    /**
     * 売出物件　一覧
     */
    public function listPrint(Request $request)
    {
        $user = Auth::user();
        $count = 0;
        $tmp_con = $request->all();
        $condition = $this->createConditionList($tmp_con);

        
        $floor_type_list = MstFloorType::getData();
        $floor_type = [];
        foreach($floor_type_list as $row) {
            $floor_type[$row['code']] = $row['name'];
        }
        // $current_status_list = MstGenkyou:: getData();
        // $current_status = [];
        // foreach($current_status_list as $row) {
        //     $current_status[$row['code']] = $row['name'];
        // }

        $params = $request->all();
        unset($params['page']);
        unset($params['notcondition']);
        unset($params['sort']);
        unset($params['_token']);


        $article_list = Article::getSearchDataByCondition($request, 10, null, 2);

        foreach($article_list as &$row) {
            $row->article_name = $row->name;
            // NEW判定
            if($row->created_at > date("Y-m-d",strtotime("-".config('const.NEW')." day"))) {
                $row->new = true;
            } else {
                $row->new = false;
            }
            
            $address = "";
            if(isset($row->address1)) {
                $add = MstPrefecture::getData($row->address1);
                $address .= $add[0]["name"];
            }
            if(isset($row->address2)) {
                $add = MstCity::getData($row->address1, $row->address2);
                $address .= $add[0]["name"];
            }
            if(isset($row->address3)) {
                $add = MstTown::getData($row->address1, $row->address2, $row->address3);
                $address .= $add[0]["name"];
            }
            if(isset($row->address4)) {
                $address .= $row->address4;
            }
            $row->address = $address;
            if(isset($row->floor_plan_type)) {
                $row['floor_plan_text'] = $row->floor_plan . $floor_type[$row->floor_plan_type];
                
            }
            if(isset($row->current_status)) {
                $status = MstGenkyou::getDataByCode($row->current_status);
                $row->current_status = $status->name??'';
            }
            if(isset($row->age_month)) {
                $row->age = intval(date('Y')) - intval($row->age_year);
            }

            if(isset($row->primary_school_school)) {
                $primary = MstSchool::getSchoolByCode($row->primary_school_school);
                if(isset($primary->name)){
                    $row->primary_school_name = str_replace('学校', '', $primary->name);
                }
            }
            if(isset($row->secondary_school_school)) {
                $secondary = MstSchool::getSchoolByCode($row->secondary_school_school);
                if(isset($secondary->name)){
                    $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                }
            }

            // 間取り画像取得
            $count = 0;
            if(isset($row->floor_file_path)) {
                $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
                $count = 1;
            } else {
                $row->floor_file_path = '';
            }

            // 写真
            $top_image = RelationArticlePhoto::getTopImagePath($row->building_id);
            if(isset($top_image->file_path)) {
                $row->top_file_path = str_replace('public', '/storage', $top_image->file_path);
            } else {
                $row->top_file_path = '';
            }

            // 写真の枚数
            $count += RelationArticlePhoto::getCountImgByArticleId($row->building_id);
            $row->file_count = $count;

            // 価格履歴の取得
            $history = RelationPriceHistory::getHistoryById($row->building_id);
            $row->history = $history;

            // 物件種別名、業者取得
            if(is_null($row->property)) {
                // マンションの場合
                $mansion = Article::getDataById($user->company_id, $row->mansion_id);
                $row->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($mansion->building_id);

                // 学校
                if(isset($mansion->primary_school_school)) {
                    $primary = MstSchool::getSchoolByCode($mansion->primary_school_school);
                    if(isset($primary->name)){
                        $row->primary_school_name = str_replace('学校', '', $primary->name);
                    }
                }
                if(isset($mansion->secondary_school_school)) {
                    $secondary = MstSchool::getSchoolByCode($mansion->secondary_school_school);
                    if(isset($secondary->name)){
                        $row->secondary_school_name = str_replace('学校', '', $secondary->name);
                    }
                }

                // 築年月
                $row->age_year = $mansion->age_year;
                $row->age_month = $mansion->age_month;
                $row->age = intval(date('Y')) - intval($mansion->age_year);
            } else {
                // それ以外
                $row->property_name = $this->getPropertyName($row->property, $row->property_sub);
                $vendor_info = Vendor::getDataListByArticleId($row->building_id);
            }
            
            $row['vendor_info'] = $vendor_info;
        }
        // 表示中のページの最初のアイテムのインデックス番号
        $first = $article_list->firstItem();
        
        // 表示中のページの最後のアイテムのインデックス番号
        $last = $article_list->lastItem();

        // 取引様態
        $manner = MstManner::getData();
        array_unshift($manner, ['code' => '', 'name' => '']);

        $data['manner'] = $manner;

        $data['ad_conf'] = [
            ['code' => 1, 'name' => 'TEL'],
            ['code' => 2, 'name' => 'FAX'],
        ];

        // ステータス
        $data['statuses'] = MstStatus::getData();

        $count = count($article_list);
        $data['article_list'] = $article_list;
        $data['condition'] = $condition;
        $data['count'] = $count;
        $data['first'] = $first;
        $data['last'] = $last;
        $data['params'] = $params;

// dump($article_list);
        return view('business.pages.for-sale-list', $data);
    }

}

