<?php

namespace App\Http\Controllers;

use Common;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use App\Http\Requests\ArticlePost;
use App\Models\Article;
use App\Models\Facility;
use App\Models\MstCompany;
use App\Models\MstPropertyType;
use App\Models\MstStatus;
use App\Models\MstPrefecture;
use App\Models\MstCity;
use App\Models\MstTown;
use App\Models\MstLawrestriction;
use App\Models\MstOtherrestriction;
use App\Models\MstStore;
use App\Models\MstSchool;
use App\Models\MstLine;
use App\Models\MstStation;
use App\Models\MstArea;
use App\Models\User;
use App\Models\UserInfo;
use App\Models\RelationArticlePhoto;
use App\Models\RelationCitySchool;
use App\Models\RelationStorePhoto;
use App\Models\MstFloorType;
use App\Models\MstStructure;
use App\Models\MstStructureSub;
use App\Models\MstUseArea;
use App\Models\MstManner;
use App\Models\MstManagementForm;
use App\Models\MstGenkyou;

class BuyController extends Controller
{
    private $parentProperty;
    
    public function index()
    {
        $css = root("css/buy/index.css");
      	$js = root("js/buy/index.js");
        $extra = true;
        $greyBread = true;
        $data['css'] = $css;
        $data['js'] = $js;
        $data['greyBread'] = $greyBread;
        $data['extra'] = true;

        $data['recommend'] = $this->getRecommendArticle(6);
        $data['common_list'] = $this->getCountCommonArticle();

        $data['keywords'] = '横浜市,家,買う';
        $data['title'] = '【ミック売買サイト】横浜市で家を買う';
        $data['description'] = '横浜市（港南区、南区、磯子区、金沢区、栄区）で家を買いたいとお考えならミックまで。中古マンション、新築一戸建て、中古一戸建て、土地を検索することができます。検索条件の保存や物件のお気に入り登録など、便利な機能もいっぱい！';


        return view('home.buy.index', $data);
    }

    public function bukkenlist(Request $request) {
      $params = $request->all();
      $uri = "";
      $pp = "";
      $spp = "";
      foreach($params as $key => $val) {
        $uri_val = "";
        if(is_array($val)) {
          $uri_val = implode(',', $val);
        } else {
          $uri_val = $val;
        }
        if($key != "pp" && $key != "spp") {
          $uri.= '&'.$key.'='.$uri_val;
        } elseif($key == "pp") {
          $pp = $uri_val;
        } elseif($key == "spp") {
          $spp = $uri_val;
        }
      }

      $url_params = str_replace(url(''), '', url()->full());
      $url_params_org = preg_replace('/.*?\?/', '', $url_params);
      $data['url_params'] = '?'.$url_params_org;

      if(strpos($url_params, 'konan') !== false){
        $params['area'] = 14111;
        $request->area = 14111;
        $search_url1 = 'konan';
      } else if(strpos($url_params, 'sakae') !== false) {
        $params['area'] = 14115;
        $request->area = 14115;
        $search_url1 = 'sakae';
      } else if(strpos($url_params, 'isogo') !== false) {
        $params['area'] = 14107;
        $request->area = 14107;
        $search_url1 = 'isogo';
      } else if(strpos($url_params, 'kanazawa') !== false) {
        $params['area'] = 14108;
        $request->area = 14108;
        $search_url1 = 'kanazawa';
      } else if(strpos($url_params, 'minami') !== false) {
        $params['area'] = 14105;
        $request->area = 14105;
        $search_url1 = 'minami';
      } else {
        $search_url1 = '';
      }

      if(strpos($url_params, '/nhouse') !== false || ($pp == 2 && $spp == 1)){
        $params['pp'] = 2;
        $params['spp'] = 1;
        $request->pp = 2;
        $request->spp = 1;
        $search_url2 = "/nhouse";
      } else if(strpos($url_params, '/uhouse') !== false || ($pp == 2 && $spp == 2)) {
        $params['pp'] = 2;
        $params['spp'] = 2;
        $request->pp = 2;
        $request->spp = 2;
        $search_url2 = "/uhouse";
      } else if(strpos($url_params, '/land') !== false || $pp == 1) {
        $params['pp'] = 1;
        $request->pp = 1;
        $search_url2 = "/land";
      } else if(strpos($url_params, '/mansion') !== false || $pp == 3) {
        $params['pp'] = 3;
        $params['spp'] = 2;
        $request->pp = 3;
        $request->spp = 2;
        $search_url2 = "/mansion";
      } else {
        $search_url2 = '';
      }

      $data['search_url1'] = $search_url1;
      $data['search_url2'] = $search_url2;

      if($search_url1 == 'konan' && $search_url2 == '/nhouse') {
        $data['keywords'] = '港南区,横浜市,新築一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市港南区の新築一戸建て';
        $data['description'] = '横浜市港南区で現在売出中の新築一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'konan' && $search_url2 == '/uhouse') {
        $data['keywords'] = '港南区,横浜市,中古一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市港南区の中古一戸建て';
        $data['description'] = '横浜市港南区で現在売出中の中古一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'konan' && $search_url2 == '/mansion') {
        $data['keywords'] = '港南区,横浜市,中古マンション';
        $data['title'] = '【ミック売買サイト】横浜市港南区の中古マンション';
        $data['description'] = '横浜市港南区で現在売出中の中古マンションを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'konan' && $search_url2 == '/land') {
        $data['keywords'] = '港南区,横浜市,土地';
        $data['title'] = '【ミック売買サイト】横浜市港南区の土地';
        $data['description'] = '横浜市港南区で現在売出中の土地を探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'sakae' && $search_url2 == '/nhouse') {
        $data['keywords'] = '栄区,横浜市,新築一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市栄区の新築一戸建て';
        $data['description'] = '横浜市栄区で現在売出中の新築一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'sakae' && $search_url2 == '/uhouse') {
        $data['keywords'] = '栄区,横浜市,中古一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市栄区の中古一戸建て';
        $data['description'] = '横浜市栄区で現在売出中の中古一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'sakae' && $search_url2 == '/mansion') {
        $data['keywords'] = '栄区,横浜市,中古マンション';
        $data['title'] = '【ミック売買サイト】横浜市栄区の中古マンション';
        $data['description'] = '横浜市栄区で現在売出中の中古マンションを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'sakae' && $search_url2 == '/land') {
        $data['keywords'] = '栄区,横浜市,土地';
        $data['title'] = '【ミック売買サイト】横浜市栄区の土地';
        $data['description'] = '横浜市栄区で現在売出中の土地を探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'isogo' && $search_url2 == '/nhouse') {
        $data['keywords'] = '磯子区,横浜市,新築一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市磯子区の新築一戸建て';
        $data['description'] = '横浜市磯子区で現在売出中の新築一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'isogo' && $search_url2 == '/uhouse') {
        $data['keywords'] = '磯子区,横浜市,中古一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市磯子区の中古一戸建て';
        $data['description'] = '横浜市磯子区で現在売出中の中古一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'isogo' && $search_url2 == '/mansion') {
        $data['keywords'] = '磯子区,横浜市,中古マンション';
        $data['title'] = '【ミック売買サイト】横浜市磯子区の中古マンション';
        $data['description'] = '横浜市磯子区で現在売出中の中古マンションを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'isogo' && $search_url2 == '/land') {
        $data['keywords'] = '磯子区,横浜市,土地';
        $data['title'] = '【ミック売買サイト】横浜市磯子区の土地';
        $data['description'] = '横浜市磯子区で現在売出中の土地を探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'kanazawa' && $search_url2 == '/nhouse') {
        $data['keywords'] = '金沢区,横浜市,新築一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市金沢区の新築一戸建て';
        $data['description'] = '横浜市金沢区で現在売出中の新築一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'kanazawa' && $search_url2 == '/uhouse') {
        $data['keywords'] = '金沢区,横浜市,中古一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市金沢区の中古一戸建て';
        $data['description'] = '横浜市金沢区で現在売出中の中古一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'kanazawa' && $search_url2 == '/mansion') {
        $data['keywords'] = '金沢区,横浜市,中古マンション';
        $data['title'] = '【ミック売買サイト】横浜市金沢区の中古マンション';
        $data['description'] = '横浜市金沢区で現在売出中の中古マンションを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'kanazawa' && $search_url2 == '/land') {
        $data['keywords'] = '金沢区,横浜市,土地';
        $data['title'] = '【ミック売買サイト】横浜市金沢区の土地';
        $data['description'] = '横浜市金沢区で現在売出中の土地を探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'minami' && $search_url2 == '/nhouse') {
        $data['keywords'] = '南区,横浜市,新築一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市南区の新築一戸建て';
        $data['description'] = '横浜市南区で現在売出中の新築一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'minami' && $search_url2 == '/uhouse') {
        $data['keywords'] = '南区,横浜市,中古一戸建て';
        $data['title'] = '【ミック売買サイト】横浜市南区の中古一戸建て';
        $data['description'] = '横浜市南区で現在売出中の中古一戸建てを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'minami' && $search_url2 == '/mansion') {
        $data['keywords'] = '南区,横浜市,中古マンション';
        $data['title'] = '【ミック売買サイト】横浜市南区の中古マンション';
        $data['description'] = '横浜市南区で現在売出中の中古マンションを探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } elseif($search_url1 == 'minami' && $search_url2 == '/land') {
        $data['keywords'] = '南区,横浜市,土地';
        $data['title'] = '【ミック売買サイト】横浜市南区の土地';
        $data['description'] = '横浜市南区で現在売出中の土地を探すことができます。詳細な条件で絞り込み検索できるだけでなく、検索条件の保存や物件のお気に入り登録など、便利な機能がいっぱい！もちろん、お問い合わせいただいたら即日対応いたします。';
      } else {
        $data['dynamics']['bukkenlist'] = '指定した条件の物件';
      }
      
      

      $other = false;
      $area_info = [];
      $target_area = [];
      $area_list = MstArea::select('code')->get()->toArray();
      foreach($area_list as $row) {
        $target_area[] = $row['code'];
      }
      
      $css = root("css/buy/bukkenlist2.css");
      $js = root("js/buy/index.js");

      $data['css'] = $css;
      $data['js'] = $js;
      $data['bread'] = true;
      $data['extra'] = true;
      $data['new_target'] = date("Y-m-d",strtotime("-".config('const.NEW')." day"));

      foreach($params as $key => $val) {
        $data[$key] = $val;
      }

      // 物件情報を取得
      $request->disp = 1;
      $request->close = 2;
      
      $article = Article::getDataByConditionFront($request, 10);
// dump($article);
      foreach($article as &$row) {
        $count = 0;
        if(!is_null($row->room_id)) {
          // 間取り画像
          if(isset($row->room_floor_file_path) && $row->room_floor_file_path != null) {
            $row->floor_file_path = str_replace('public', '/storage', $row->room_floor_file_path);
            $count ++;
          }

          // 写真の枚数を取得
          $photo_info = RelationArticlePhoto::getImgByArticleId($row->room_id);
          foreach($photo_info as $photo) {
            if(isset($photo->file_path) && $photo->file_path != null) {
              $photo->file_path = str_replace('public', '/storage', $photo->file_path);
              $count ++;
            }
          }
        } else {
          // 間取り画像
          if(isset($row->floor_file_path) && $row->floor_file_path != null) {
            $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
            $count ++;
          }

          // 写真の枚数を取得
          $photo_info = RelationArticlePhoto::getImgByArticleId($row->id);
          foreach($photo_info as $photo) {
            if(isset($photo->file_path) && $photo->file_path != null) {
              $photo->file_path = str_replace('public', '/storage', $photo->file_path);
              $count ++;
            }
          }
        }

        $row->photo_info = $photo_info;
        $row->file_count = $count;
      }

      // エリア情報を取得
      $select = '';
      if(isset($request->area)) {
        $area_list = explode(',', $request->area);
        $area_info = [];
        foreach($area_list as $row) {
          $tmp = MstArea::getDataByCode($row);
          if(!empty($tmp)) {
            $area_info[] = $tmp;
          }
        }
        if(count($area_info) != 1) {
          $other = true;
        } else {
          $select = $area_info[0]->code;
        }
      } else {
          // その他エリア
          $other = true;
      }

      // サイドの情報を生成
      $data['side_area'] = [
        ['name' => '横浜市港南区', 'area_id' => 14111, 'count' => Article::getCountByArea(1, 111)],
        ['name' => '横浜市栄区', 'area_id' => 14115, 'count' => Article::getCountByArea(1, 115)],
        ['name' => '横浜市磯子区', 'area_id' => 14107, 'count' => Article::getCountByArea(1, 107)],
        ['name' => '横浜市金沢区', 'area_id' => 14108, 'count' => Article::getCountByArea(1, 108)],
        ['name' => '横浜市南区', 'area_id' => 14105, 'count' => Article::getCountByArea(1, 105)],
        ['name' => 'その他', 'area_id' => 99999, 'count' => Article::getCountByArea(1, 999)],
      ];
      
      // エリア欄
      $area_uri = $this->getUrl(['area'], $params);
      // 種別欄
      $property_uri = $this->getUrl(['pp', 'spp'], $params);


      $data['other'] = $other;
      $data['items'] = $article;

      $data['uri'] = $uri;

      $data['count'] = $article->total();
      $data['first'] = $article->firstItem();
      $data['last'] = $article->lastItem();
      $data['params'] = $params;

      $data['area_list'] = $area_info;
      $data['selected_area_code'] = $select;
      $data['area_uri'] = $area_uri;
      $data['property_uri'] = $property_uri;
      $data['pp'] = isset($request->pp)? $request->pp: '';
      $data['spp'] = isset($request->spp)? $request->spp: '';

      if($request->get('grid') ==  1){
          if($request->ajax()){
              return view('home.buy.ajax_bukkenlist_grid', $data);
          }
          return view('home.buy.bukkenlist_grid', $data);
      }
      
      if($request->ajax()){
          return view('home.buy.ajax_bukkenlist', $data);
      }
      return view('home.buy.bukkenlist', $data);
    }



    public function bukkenlistOther(Request $request) {
      $params = $request->all();
      $uri = "";
      $pp = "";
      $spp = "";
      foreach($params as $key => $val) {
        $uri_val = "";
        if(is_array($val)) {
          $uri_val = implode(',', $val);
        } else {
          $uri_val = $val;
        }
        if($key != "pp" && $key != "spp") {
          $uri.= '&'.$key.'='.$uri_val;
        } elseif($key == "pp") {
          $pp = $uri_val;
        } elseif($key == "spp") {
          $spp = $uri_val;
        }
      }

      $url_params = str_replace(url(''), '', url()->full());
      $url_params_org = preg_replace('/.*?\?/', '', $url_params);
      $data['url_params'] = '?'.$url_params_org;
      $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];

      if(strpos($url_params, 'new') !== false){
        $request->commitment = 'new';
        $data['theme'] = '新着物件';
        $data['canonical_url'] = $base_url.'/buy/new.html';
        $data['keywords'] = '新着,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の新着物件一覧';
        $data['description'] = '横浜市の新着物件を一覧でご覧いただけます。最近新しく売り出された不動産です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['new.html'] = '横浜市の新着物件';
      } else if(strpos($url_params, 'pricedown') !== false){	
        $request->commitment = 'pricedown';
        $data['theme'] = 'プライスダウン';
        $data['canonical_url'] = $base_url.'/buy/pricedown.html';
        $data['keywords'] = '値下げ,プライスダウン,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のプライスダウン物件一覧';
        $data['description'] = '横浜市のプライスダウン物件を一覧でご覧いただけます。最近値下げした不動産です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['pricedown.html'] = '横浜市のプライスダウン';
      } else if(strpos($url_params, 'openhouse') !== false){
        $request->commitment = 'openhouse';
        $data['theme'] = 'オープンハウス';
        $data['canonical_url'] = $base_url.'/buy/openhouse.html';
        $data['keywords'] = 'オープンハウス,見学,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の見学可能なオープンハウス物件一覧';
        $data['description'] = '横浜市のオープンハウス物件を一覧でご覧いただけます。現地にお越しいただければ、室内を見学いただける不動産です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['openhouse.html'] = '横浜市のオープンハウス';
      } else if(strpos($url_params, 'produce') !== false){
        $request->commitment = 'produce';
        $data['theme'] = '自社プロデュース';
        $data['canonical_url'] = $base_url.'/buy/produce.html';
        $data['keywords'] = 'プロデュース,ミック,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のミックプロデュースの物件一覧';
        $data['description'] = '横浜市の自社プロデュース物件を一覧でご覧いただけます。ミックがプロデュースした不動産です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['produce.html'] = '横浜市の自社プロデュース';
      } else if(strpos($url_params, 'flat') !== false){
        $request->commitment = 'flat';
        $data['theme'] = '高低差なし';
        $data['canonical_url'] = $base_url.'/buy/flat.html';
        $data['keywords'] = '平坦地,平地,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の高低差なしの物件一覧';
        $data['description'] = '横浜市の高低差なし物件を一覧でご覧いただけます。敷地内に高低差がなく平坦な不動産です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['flat.html'] = '横浜市の高低差なし';
      } else if(strpos($url_params, 'bus') !== false){
        $request->commitment = 'bus';
        $data['theme'] = 'バス停1分以内';
        $data['canonical_url'] = $base_url.'/buy/bus.html';
        $data['keywords'] = 'バス,1分,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のバス停1分以内の物件一覧';
        $data['description'] = '横浜市でバス停から徒歩1分以内の物件を一覧でご覧いただけます。バス便エリアでも、バス停から近い不動産は人気があります。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['bus.html'] = '横浜市のバス停1分以内';
      } else if(strpos($url_params, 'stwalk') !== false){
        $request->commitment = 'stwalk';
        $data['theme'] = '駅徒歩5分以内';
        $data['canonical_url'] = $base_url.'/buy/stwalk.html';
        $data['keywords'] = '徒歩5分,駅近,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の駅徒歩5分以内の物件一覧';
        $data['description'] = '横浜市で駅から徒歩5分以内の物件を一覧でご覧いただけます。駅近だと通勤通学も買い物なども便利。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['stwalk.html'] = '横浜市の駅徒歩5分以内';
      } else if(strpos($url_params, 'scwalk') !== false){
        $request->commitment = 'scwalk';
        $data['theme'] = '小学校10分以内';
        $data['canonical_url'] = $base_url.'/buy/scwalk.html';
        $data['keywords'] = '小学校,10分,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の小学校10分以内の物件一覧';
        $data['description'] = '横浜市で小学校から徒歩10分以内の物件を一覧でご覧いただけます。小学校が近いとお子様の通学が安心。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['scwalk.html'] = '横浜市の小学校10分以内';
      } else if(strpos($url_params, 'entry') !== false){
        $request->commitment = 'entry';
        $data['theme'] = '即入居可';
        $data['canonical_url'] = $base_url.'/buy/entry.html';
        $data['keywords'] = '即入居可,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の即入居可の物件一覧';
        $data['description'] = '横浜市で即入居可能な物件を一覧でご覧いただけます。引越の時期が決まっているお客様に最適です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['entry.html'] = '横浜市のオープンハウス';
      } else if(strpos($url_params, 'reform') !== false){
        $request->commitment = 'reform';
        $data['theme'] = 'リフォーム・リノベーション';
        $data['canonical_url'] = $base_url.'/buy/reform.html';
        $data['keywords'] = 'リフォーム,リノベーション,物件,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のリフォーム・リノベーション済の物件一覧';
        $data['description'] = '横浜市でリフォーム・リノベーション済の物件を一覧でご覧いただけます。築年数が古くても室内はきれいな不動産です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['reform.html'] = '横浜市のリフォーム・リノベーション';
      } else if(strpos($url_params, 'pet') !== false){
        $request->commitment = 'pet';
        $data['theme'] = 'ペット飼育可';
        $data['canonical_url'] = $base_url.'/buy/pet.html';
        $data['keywords'] = 'ペット,マンション,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のペット飼育可のマンション一覧';
        $data['description'] = '横浜市でペット飼育可の中古マンションを一覧でご覧いただけます。ペット用の便利な設備を備えたマンションもあります。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['pet.html'] = '横浜市のペット飼育可';
      } else if(strpos($url_params, 'fee') !== false){
        $request->commitment = 'fee';
        $data['theme'] = '管理費・修繕費2万円以下';
        $data['canonical_url'] = $base_url.'/buy/fee.html';
        $data['keywords'] = '管理費,マンション,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の管理費・修繕費2万円以下のマンション一覧';
        $data['description'] = '横浜市で管理費・修繕費2万円以下の中古マンションを一覧でご覧いただけます。住宅ローンの支払いとは別に毎月かかるのが管理費や修繕費です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['fee.html'] = '横浜市の管理費・修繕費2万円以下';
      } else if(strpos($url_params, 'ldk') !== false){
        $request->commitment = 'ldk';
        $data['theme'] = 'LDK15帖以上';
        $data['canonical_url'] = $base_url.'/buy/ldk.html';
        $data['keywords'] = 'LDK,15帖,マンション横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のLDK15帖以上のマンション一覧';
        $data['description'] = '横浜市でLDK15帖以上の中古マンションを一覧でご覧いただけます。LDKが広いと家族が集まりやすく団らんの場になります。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['ldk.html'] = '横浜市のLDK15帖以上';
      } else if(strpos($url_params, 'elevator') !== false){
        $request->commitment = 'elevator';
        $data['theme'] = 'エレベーター有';
        $data['canonical_url'] = $base_url.'/buy/elevator.html';
        $data['keywords'] = 'エレベーター,マンション,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のエレベーター有のマンション一覧';
        $data['description'] = '横浜市でエレベーターがある中古マンションを一覧でご覧いただけます。エレベーターがあると、毎日の暮らしが格段に便利です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['elevator.html'] = '横浜市のエレベーター有';
      } else if(strpos($url_params, 'parking') !== false){
        $request->commitment = 'parking';
        $data['theme'] = '2台以上駐車可';
        $data['canonical_url'] = $base_url.'/buy/parking.html';
        $data['keywords'] = '駐車,2台,一戸建て,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の2台以上駐車可の一戸建て一覧';
        $data['description'] = '横浜市で2台以上駐車可能な一戸建てを一覧でご覧いただけます。通勤や買い物などのために車を2台以上所有しているご家族に最適。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['parking.html'] = '横浜市の2台以上駐車可';
      } else if(strpos($url_params, 'floors') !== false){
        $request->commitment = 'floors';
        $data['theme'] = '2階建';
        $data['canonical_url'] = $base_url.'/buy/floors.html';
        $data['keywords'] = '2階建,一戸建て,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の2階建の一戸建て一覧';
        $data['description'] = '横浜市で2階建の一戸建てを一覧でご覧いただけます。階段の昇降が少ないと家事動線が便利です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['floors.html'] = '横浜市の2階建';
      } else if(strpos($url_params, 'conditions') !== false){
        $request->commitment = 'conditions';
        $data['theme'] = '建築条件なし';
        $data['canonical_url'] = $base_url.'/buy/conditions.html';
        $data['keywords'] = '建築条件なし,土地,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の建築条件なしの土地一覧';
        $data['description'] = '横浜市で建築条件なしの土地を一覧でご覧いただけます。ご希望の工務店やハウスメーカーで建築いただけます。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['conditions.html'] = '横浜市の建築条件なし';
      } else if(strpos($url_params, 'corner') !== false){
        $request->commitment = 'corner';
        $data['theme'] = '角地';
        $data['canonical_url'] = $base_url.'/buy/corner.html';
        $data['keywords'] = '角地,土地,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の角地の土地一覧';
        $data['description'] = '横浜市の角地を一覧でご覧いただけます。2方以上が道路に面している土地であるため開放的です。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['corner.html'] = '横浜市の角地';
      } else if(strpos($url_params, 'recommended') !== false){
        $request->commitment = 'recommended';
        $data['theme'] = 'おすすめ';
        $data['canonical_url'] = $base_url.'/buy/recommended.html';
        $data['keywords'] = 'おすすめ,土地,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市のおすすめの物件一覧';
        $data['description'] = '横浜市のおすすめを一覧でご覧いただけます。それぞれの物件の詳細な情報だけでなく、メリットやデメリット、周辺施設情報などもご紹介しています。もちろん、お問い合わせいただいたら即日対応いたします。';
        $data['dynamics']['recommended.html'] = '横浜市のおすすめ';
      }


      $other = false;
      $area_info = [];
      $target_area = [];
      $area_list = MstArea::select('code')->get()->toArray();
      foreach($area_list as $row) {
        $target_area[] = $row['code'];
      }
      
      $css = root("css/buy/bukkenlist2.css");
      $js = root("js/buy/index.js");

      $data['css'] = $css;
      $data['js'] = $js;
      $data['bread'] = true;
      $data['extra'] = true;
      $data['new_target'] = date("Y-m-d",strtotime("-".config('const.NEW')." day"));

      foreach($params as $key => $val) {
        $data[$key] = $val;
      }

      // 物件情報を取得
      $request->disp = 1;
      $request->close = 2;
      
      $article = Article::getDataByConditionFront($request, 10);
// dump($article);
      foreach($article as &$row) {
        $count = 0;
        if(!is_null($row->room_id)) {
          // 間取り画像
          if(isset($row->room_floor_file_path) && $row->room_floor_file_path != null) {
            $row->floor_file_path = str_replace('public', '/storage', $row->room_floor_file_path);
            $count ++;
          }

          // 写真の枚数を取得
          $photo_info = RelationArticlePhoto::getImgByArticleId($row->room_id);
          foreach($photo_info as $photo) {
            if(isset($photo->file_path) && $photo->file_path != null) {
              $photo->file_path = str_replace('public', '/storage', $photo->file_path);
              $count ++;
            }
          }
        } else {
          // 間取り画像
          if(isset($row->floor_file_path) && $row->floor_file_path != null) {
            $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
            $count ++;
          }

          // 写真の枚数を取得
          $photo_info = RelationArticlePhoto::getImgByArticleId($row->id);
          foreach($photo_info as $photo) {
            if(isset($photo->file_path) && $photo->file_path != null) {
              $photo->file_path = str_replace('public', '/storage', $photo->file_path);
              $count ++;
            }
          }
        }
        $open_text = "";
        if(strpos($url_params, 'openhouse') !== false){
          if($row->event_category == 1) {
            $open_text .= '【現地見学会】';
          } elseif($row->event_category == 2) {
            $open_text .= '【現地案内会】';
          } elseif($row->event_category == 3) {
            $open_text .= '【現地販売会】';
          } elseif($row->event_category == 4) {
            $open_text .= '【オープンハウス】';
          } elseif($row->event_category == 5) {
            $open_text .= '【オープンルーム】';
          }


          if($row->event_schedule == 1) {
            $open_text .= '毎週土日祝';
          } elseif($row->event_schedule == 2) {
            $open_text .= '毎週土日';
          } elseif($row->event_schedule == 3) {
            $day_text = "";
            $event = explode(',', $row->event_day);
            foreach($event as $day) {
                if($day_text != "") {
                    $day_text .= ',';
                }
                $day_text .= date('m/d',  strtotime($day));
            }
            $open_text .= $day_text;
          } elseif($row->event_schedule == 4) {
            $open_text .= $row->from_event.'〜'.$row->to_event;
          } elseif($row->event_schedule == 5) {
            $open_text .= '公開中';
          }

          $open_text .= $row->from_hour . ':'. str_pad($row->from_minute, 2, 0, STR_PAD_LEFT).'〜';
          $open_text .= $row->to_hour . ':'. str_pad($row->to_minute, 2, 0, STR_PAD_LEFT);
          
          $row->open_text = $open_text;

        }

        $row->photo_info = $photo_info;
        $row->file_count = $count;
      }

      $data['items'] = $article;

      $data['count'] = $article->total();
      $data['first'] = $article->firstItem();
      $data['last'] = $article->lastItem();
      $data['params'] = $params;

      // $data['area_list'] = $area_info;
      // $data['selected_area_code'] = $select;
      // $data['area_uri'] = $area_uri;
      // $data['property_uri'] = $property_uri;
      // $data['pp'] = isset($request->pp)? $request->pp: '';
      // $data['spp'] = isset($request->spp)? $request->spp: '';

      if($request->get('grid') ==  1){
          if($request->ajax()){
              return view('home.buy.ajax_bukkenlist_grid', $data);
          }
          return view('home.buy.bukkenlist_grid', $data);
      }
      
      if($request->ajax()){
          return view('home.buy.ajax_bukkenlist', $data);
      }
      return view('home.buy.bukkenlist_other', $data);
    }

    public function bukkenlistSendMail(Request $request) {
      $params = $request->all();
      $to_web = 'it-net@319.jp';
      $to_web = 'toshiki.wakamiya@wills.co.jp';
      $to_address = $to_web;
      
      // タイトル
      $subject = 'webよりお問い合わせがありました。';
      Mail::send(array('text' => 'emails.mail'), $params, function($message) use($to_address, $subject) {
        // 第3引数にはコールバック関数を指定し、
        // その中で、送信先やタイトルの指定を行う.
        $message
            ->to($to_address)
            // ->bcc('admin@sample.com')
            ->subject($subject);
      });
      $other = false;
      $area_info = [];
      $target_area = [];
      $area_list = MstArea::select('code')->get()->toArray();
      foreach($area_list as $row) {
        $target_area[] = $row['code'];
      }
      $params = $request->all();
      $css = root("css/buy/bukkenlist2.css");
      $js = root("js/buy/index.js");

      $data['css'] = $css;
      $data['js'] = $js;
      $data['bread'] = true;
      $data['extra'] = true;
      $data['new_target'] = date("Y-m-d",strtotime("-".config('const.NEW')." day"));

      foreach($params as $key => $val) {
        $data[$key] = $val;
      }
      
      // $data['pm'] = $request->pm;
      // $data['price_from'] = $request->price_from;
      // $data['price_to'] = $request->price_to;
      // $data['floor_plan'] = $request->floor_plan;
      // $data['land_from'] = $request->land_from;
      // $data['buildingArea'] = $request->buildingArea;

      // $data['walk'] = $request->walk;
      // $data['years_from'] = $request->years_from;
      // $data['years_to'] = $request->years_to;
      // $data['hillLevel'] = $request->hillLevel;
      // $data['area'] = $request->area;
      // $data['station'] = $request->stc;

      // $data['params'] = array(
      //   'pm' => $request->pm,
      //   'price_from'  => $request->price_from,
      //   'price_to'  => $request->price_to,
      //   'floor_plan'  => $request->floor_plan,
      //   'land_from'  => $request->land_from,
      //   'buildingArea'  => $request->buildingArea,
      //   'walk'  => $request->walk,
      //   'years_from'  => $request->years_from,
      //   'years_to'  => $request->years_to,
      //   'hillLevel'  => $request->hillLevel,
      //   'area'  => $request->area,
      // );


      // 物件情報を取得
      $request->disp = 1;
      $request->close = 2;

      $article = Article::getDataByConditionFront($request, 10);
// dump($article);
      foreach($article as &$row) {
        $count = 0;
        if(!is_null($row->room_id)) {
          // 間取り画像
          if(isset($row->room_floor_file_path) && $row->room_floor_file_path != null) {
            $row->floor_file_path = str_replace('public', '/storage', $row->room_floor_file_path);
            $count ++;
          }

          // 写真の枚数を取得
          $photo_info = RelationArticlePhoto::getImgByArticleId($row->room_id);
          foreach($photo_info as $photo) {
            if(isset($photo->file_path) && $photo->file_path != null) {
              $photo->file_path = str_replace('public', '/storage', $photo->file_path);
              $count ++;
            }
          }
        } else {
          // 間取り画像
          if(isset($row->floor_file_path) && $row->floor_file_path != null) {
            $row->floor_file_path = str_replace('public', '/storage', $row->floor_file_path);
            $count ++;
          }

          // 写真の枚数を取得
          $photo_info = RelationArticlePhoto::getImgByArticleId($row->id);
          foreach($photo_info as $photo) {
            if(isset($photo->file_path) && $photo->file_path != null) {
              $photo->file_path = str_replace('public', '/storage', $photo->file_path);
              $count ++;
            }
          }
        }

        $row->photo_info = $photo_info;
        $row->file_count = $count;
      }

      // エリア情報を取得
      $select = '';
      if(isset($request->area)) {
        $area_list = explode(',', $request->area);
        $area_info = [];
        foreach($area_list as $row) {
          $tmp = MstArea::getDataByCode($row);
          if(!empty($tmp)) {
            $area_info[] = $tmp;
          }
        }
        if(count($area_info) != 1) {
          $other = true;
        } else {
          $select = $area_info[0]->code;
        }
      } else {
          // その他エリア
          $other = true;
      }

      // サイドの情報を生成
      $data['side_area'] = [
        ['name' => '横浜市港南区', 'area_id' => 14111, 'count' => Article::getCountByArea(1, 111)],
        ['name' => '横浜市栄区', 'area_id' => 14115, 'count' => Article::getCountByArea(1, 115)],
        ['name' => '横浜市磯子区', 'area_id' => 14107, 'count' => Article::getCountByArea(1, 107)],
        ['name' => '横浜市金沢区', 'area_id' => 14108, 'count' => Article::getCountByArea(1, 108)],
        ['name' => '横浜市南区', 'area_id' => 14105, 'count' => Article::getCountByArea(1, 105)],
        ['name' => 'その他', 'area_id' => 99999, 'count' => Article::getCountByArea(1, 999)],
      ];
      
      // エリア欄
      $area_uri = $this->getUrl(['area'], $params);
      // 種別欄
      $property_uri = $this->getUrl(['pp', 'spp'], $params);

      $data['other'] = $other;
      $data['items'] = $article;

      $data['count'] = $article->total();
      $data['first'] = $article->firstItem();
      $data['last'] = $article->lastItem();
      $data['params'] = $params;

      $data['area_list'] = $area_info;
      $data['selected_area_code'] = $select;
      $data['area_uri'] = $area_uri;
      $data['property_uri'] = $property_uri;
      $data['pp'] = isset($request->pp)? $request->pp: '';
      $data['spp'] = isset($request->spp)? $request->spp: '';

      $data['send'] = 1;

      if($request->get('grid') ==  1){
          if($request->ajax()){
              return view('home.buy.ajax_bukkenlist_grid', $data);
          }
          return view('home.buy.bukkenlist_grid', $data);
      }
      
      if($request->ajax()){
          return view('home.buy.ajax_bukkenlist', $data);
      }
      return view('home.buy.bukkenlist', $data);
    }

    public function getUrl($names, $params) {
      $res = "";
      foreach($names as $name) {
        unset($params[$name]);
      }
      
      foreach($params as $key => $val) {
        if(is_array($val)) {
          foreach($val as $row) {
            $res .= '&'.$key.'[]='.$row;
          }
        } else {
          $res .= '&'.$key.'='.$val;
        }
      }

      return $res;
    }

    

    /**
     * 詳細画面の表示
     * @return string
     */
    public function detail(Request $request)
    {
        $mansion = [];
        $data['css'] = "/css/buy/detail.css";
        $data['extra'] = true;
        $data['greyBread'] = true;
        $data['use_area'] = ['', '1種低層', '2種低層', '1種中高', '2種中高', '1種住居', '2種住居', '準住居', '近隣商業', '商業', '準工業', '工業', '工専', '田園住居地域'];
        $data['ground'] = ['', '宅地', '田', '畑', '山林', '雑種地', '原野', 'その他'];

        // 物件データを取得
        $article = Article::getDataByIdFront(config('const.COMPANY_ID'), $request->id);

        if(is_null($article) || $article->property == 6 || $article->property == 7) {
          print('存在しない物件、または不正なアクセスです。');
          exit;
        } else if($article->property == null) {
          $mansion = Article::getMansionDataByIdFront(config('const.COMPANY_ID'), $article->mansion_id);
          $article->building_rate = $mansion->building_rate??null;
          $article->volume_rate = $mansion->volume_rate??null;
          $article->use_area = $mansion->use_area??null;
          $article->land_use = $mansion->land_use??null;
          $article->land_use2 = $mansion->land_use2??null;
          $article->construction = $mansion->construction??null;
          $article->construction_sub = $mansion->construction_sub??null;
          $article->floor = $mansion->floor??null;


          $article->main_traffic = $mansion->main_traffic??null;
          $article->main_traffic_line = $mansion->main_traffic_line??null;
          $article->main_traffic_station = $mansion->main_traffic_station??null;
          $article->main_traffic_time = $mansion->main_traffic_time??null;


          $article->primary_school_city = $mansion->primary_school_city??null;
          $article->primary_school_school = $mansion->primary_school_school??null;
          $article->primary_school_distance = $mansion->primary_school_distance??null;
          $article->secondary_school_city = $mansion->secondary_school_city??null;
          $article->secondary_school_school = $mansion->secondary_school_school??null;
          $article->secondary_school_distance = $mansion->secondary_school_distance??null;

          $article->primary_school2_city = $mansion->primary_school2_city??null;
          $article->primary_school2_school = $mansion->primary_school2_school??null;
          $article->primary_school2_distance = $mansion->primary_school2_distance??null;
          $article->secondary_school2_city = $mansion->secondary_school2_city??null;
          $article->secondary_school2_school = $mansion->secondary_school2_school??null;
          $article->secondary_school2_distance = $mansion->secondary_school2_distance??null;


          $article->management_company = $mansion->management_company??null;
          $article->management_form = $mansion->management_form??null;
          
          
        }

        $type = 0;
        if($article->property == 1 || $article->property == 2 || $article->property == 3) {
          $type = 4;
        } elseif($article->property == 6 || $article->property == 7 || $article->property == null) {
          $type = 1;
        } elseif($article->property == 4 || $article->property == 5) {
          if($article->property_sub == 1) {
              $type = 2;
          } else {
              $type  = 3;
          }
        }

        if($type == 0) {
          print('存在しない物件、または不正なアクセスです。');
          exit;
        }
        $article->type = $type;

        if(isset($article->primary_school_school)) {
          $primary = MstSchool::getSchoolByCode($article->primary_school_school);
          if(isset($primary->name)){
              $article->primary_school_name = $primary->name;
          }
        }
        if(isset($article->primary_school2_school)) {
          $primary = MstSchool::getSchoolByCode($article->primary_school2_school);
          if(isset($primary->name)){
              $article->primary_school2_name = $primary->name;
          }
        }
        if(isset($article->secondary_school_school)) {
            $secondary = MstSchool::getSchoolByCode($article->secondary_school_school);
            if(isset($secondary->name)){
                $article->secondary_school_name = $secondary->name;
            }
        }
        if(isset($article->secondary_school2_school)) {
            $secondary = MstSchool::getSchoolByCode($article->secondary_school2_school);
            if(isset($secondary->name)){
                $article->secondary_school2_name = $secondary->name;
            }
        }

        // 取引様態
        if($article->company_manner != 0) {
          $article->manner_name = MstManner::where('code', '=', $article->company_manner)->first()->name??'';
        } else {
          $article->manner_name = "-";
        }

        // 管理形態
        $article->management_name = MstManagementForm::find($article->management_form)->name??'';
        
        // 現況
        $article->land_status_name = MstGenkyou::find($article->land_status)->name??'';
        

        // 間取り
        $article->floor_plan_name = MstFloorType::find($article->floor_plan_type)->name??'';

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $article->use_area)->first();
        $article->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $article->land_use)->first();
        $article->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $article->land_use2)->first();
        $article->use_area_name_sub2 = $use_info->name??'';

        // 構造
        $article->construction_name = MstStructure::find($article->construction)->name??'';
        $article->construction_sub_name = MstStructureSub::find($article->construction_sub)->name??'';
        // 完成時期
        $today = date('Y/m/d');
        $target_day = $article->completed_year."/".$article->completed_month."/1";
        if(strtotime($today) < strtotime($target_day)){
          $article->completed_text = '予定';
        }

        // 分譲地データ
        $develop_num = "";
        if(isset($article->sale_no) && $article->sale_no != "") {
          $lot = Article::getLotInfo(config('const.COMPANY_ID'), $article->sale_no);
          $develop_num = $lot->develop_num;
        }
        $article->developer_number = $develop_num;

        // 物件種別
        if($article->property != null) {
          $article->property_name = $this->getPropertyName($article->property, $article->property_sub);
        } else {
          $article->property_name = $this->getPropertyName($mansion->property, $mansion->property_sub);
        }
        

        // dump($article->update);
        $article->update = date('Y/m/d',  strtotime($article->update));
        $timestamp = strtotime('+14 day ' . $article->update );
        $article->next_update = date("Y/m/d", $timestamp);

        // パンくず
        $data['dynamics'][$article->building_id] = $article->article_name.' ('.$article->main_traffic_station.') '.$article->property_name	;
        // if($article->property == null && $article->mansion_id != null) {
        //   $parent = Article::getParentMansionProperty(config('const.COMPANY_ID'), $article->mansion_id);
        //   $article->property = $parent->property;
        // }
        $article->file_path = str_replace('public', '/storage', $article->file_path);

        // 写真データを取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // 取扱店舗を取得
        $store = MstStore::getDataById($article->shop);
        $store_photo = RelationStorePhoto::getTopImagePath($store->id);
        if(isset($store_photo->file_path)) {
          $store->file_path = str_replace('public', '/storage', $store_photo->file_path);
        }

        // 担当者を取得
        $charge = UserInfo::getDataById($article->hp_charge);
        if(isset($charge->file_path)) {
          $charge->file_path = str_replace('public', '/storage', $charge->file_path);
        }

        // おすすめ物件の取得
        $recommend = Article::getDetailRecommendDispData($request->id, $article->property, $article->address2, 10);

        // 周辺施設
        $facility = Facility::getRelatonFacility($request->id);
        foreach($facility as &$row) {
          $row->disp_file_path = str_replace('public', '/storage', $row->file_path);
        }

        $open_text = "";
        if($article->event_category == 1) {
          $open_text .= '【現地見学会】';
        } elseif($article->event_category == 2) {
          $open_text .= '【現地案内会】';
        } elseif($article->event_category == 3) {
          $open_text .= '【現地販売会】';
        } elseif($article->event_category == 4) {
          $open_text .= '【オープンハウス】';
        } elseif($article->event_category == 5) {
          $open_text .= '【オープンルーム】';
        }


        if($article->event_schedule == 1) {
          $open_text .= '毎週土日祝';
        } elseif($article->event_schedule == 2) {
          $open_text .= '毎週土日';
        } elseif($article->event_schedule == 3) {
          $day_text = "";
          $event = explode(',', $article->event_day);
          foreach($event as $day) {
              if($day_text != "") {
                  $day_text .= ',';
              }
              $day_text .= date('m/d',  strtotime($day));
          }
          $open_text .= $day_text;
        } elseif($article->event_schedule == 4) {
          $open_text .= $article->from_event.'〜'.$article->to_event;
        } elseif($article->event_schedule == 5) {
          $open_text .= '公開中';
        }

        $open_text .= $article->from_hour . ':'. str_pad($article->from_minute, 2, 0, STR_PAD_LEFT).'〜';
        $open_text .= $article->to_hour . ':'. str_pad($article->to_minute, 2, 0, STR_PAD_LEFT);
        
        $article->open_text = $open_text;



        $data['article'] = $article;
        $data['recommend'] = $recommend;
        $data['facility'] = $facility;
        $data['photos'] = $photos;
        $data['store'] = $store;
        $data['charge'] = $charge;

        return view('home.buy.detail', $data);
    }





    public static function getRecommendArticle($num = 6) {
        $articles = Article::getFrontRecommendDispData($num);
        foreach($articles as &$row) {
          if(isset($row->floor_file_path)) {
            $row->file_path = str_replace('public', '/storage', $row->floor_file_path);
          }
        }
        return $articles;
    }

    public static function getPropertyName($property, $property_sub) {
      $res = '';

      if($property == 1) {
        $res .= '土地';
      } else if($property == 2) {
        $res .= '土地（借地権）';
      } else if($property == 3) {
        $res .= '土地（底地権）';
      } else if($property == 4) {
        if($property_sub == 1) { 
          $res .= '新築';
        } else { 
          $res .= '中古';
        }
        $res .= '戸建';
      } else if($property == 5) {
        if($property_sub == 1) { 
          $res .= '新築';
        } else { 
          $res .= '中古';
        }
        $res .= 'テラスハウス';
      } else if($property == 6) {
        if($property_sub == 1) { 
          $res .= '新築';
        } else { 
          $res .= '中古';
        }
        $res .= 'マンション';
      } else if($property == 7) {
        if($property_sub == 1) { 
          $res .= '新築';
        } else { 
          $res .= '中古';
        }
        $res .= 'タウンハウス';
      }

      return $res;
    }

    public static function getCountCommonArticle() {
        $result = [];
        $pid = 14;
        $target_area = [
          ['code' => 111, 'icon' => 'mapicon-konan.png', 'url' => 'konan'],
          ['code' => 105, 'icon' => 'mapicon-minami.png', 'url' => 'minami'],
          ['code' => 107, 'icon' => 'mapicon-isogo.png', 'url' => 'isogo'],
          ['code' => 108, 'icon' => 'mapicon-kanazawa.png', 'url' => 'kanazawa'],
          ['code' => 115, 'icon' => 'mapicon-sakae.png', 'url' => 'sakae'],
        ];
  
        foreach($target_area as $area) {
          $count = Article::getCountByCityId($pid, $area['code']);
          $name = MstCity::getName($pid, $area['code']);
          $count_mansion = Article::getCountByAreaProperty($pid, $area['code'], null);
          $count_house_new = Article::getCountByAreaProperty($pid, $area['code'], 4, 1);
          $count_house_old = Article::getCountByAreaProperty($pid, $area['code'], 4, 2);
          $count_land = Article::getCountByAreaProperty($pid, $area['code'], 1);
  
          $result[] = [
              'icon' => $area['icon'],
              'pref' => $pid,
              'city' => $area['code'],
              'area_id' => $pid.$area['code'],
              'count' => $count,
              'name' => $name->name,
              'url' => $area['url'],
              'sub_list' => [
                ['name' => '中古マンション', 'count' => $count_mansion, 'url' => 'mansion', 'pp' => 3, 'spp' => 2],
                ['name' => '新築一戸建て', 'count' => $count_house_new, 'url' => 'nhouse', 'pp' => 2, 'spp' => 1],
                ['name' => '中古一戸建て', 'count' => $count_house_old, 'url' => 'uhouse', 'pp' => 2, 'spp' => 2],
                ['name' => '土地', 'count' => $count_land, 'url' => 'land', 'pp' => 1]
              ]
          ];
      }
        return $result;
    }

    public function print(Request $request)
    {
        $data['css'] = root("css/buy/print.css");

        $article = Article::getDataById(config('const.COMPANY_ID'), $request->id);

        if(isset($article->primary_school_school)) {
          $primary = MstSchool::getSchoolByCode($article->primary_school_school);
          if(isset($primary->name)){
              $article->primary_school_name = $primary->name;
          }
        }
        if(isset($article->secondary_school_school)) {
            $secondary = MstSchool::getSchoolByCode($article->secondary_school_school);
            if(isset($secondary->name)){
                $article->secondary_school_name = $secondary->name;
            }
        }

        // 取引様態
        if($article->company_manner != 0) {
          $article->manner_name = MstManner::where('code', '=', $article->company_manner)->first()->name??'';
        } else {
          $article->manner_name = "";
        }

        // 管理形態
        $article->management_name = MstManagementForm::find($article->management_form)->name??'';
        
        // 現況
        $article->land_status_name = MstGenkyou::find($article->land_status)->name??'';
        

        // 間取り
        $article->floor_plan_name = MstFloorType::find($article->floor_plan_type)->name??'';

        // 用途地域
        $use_info = MstUseArea::where('code', '=', $article->use_area)->first();
        $article->use_area_name = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $article->land_use)->first();
        $article->use_area_name_sub = $use_info->name??'';
        $use_info = MstUseArea::where('code', '=', $article->land_use2)->first();
        $article->use_area_name_sub2 = $use_info->name??'';

        // 構造
        $article->construction_name = MstStructure::find($article->construction)->name??'';
        $article->construction_sub_name = MstStructureSub::find($article->construction_sub)->name??'';
        // 完成時期
        $today = date('Y/m/d');
        $target_day = $article->completed_year."/".$article->completed_month."/1";
        if(strtotime($today) < strtotime($target_day)){
          $article->completed_text = '予定';
        }

        // 分譲地データ
        $develop_num = "";
        if(isset($article->sale_no) && $article->sale_no != "") {
          $lot = Article::getLotInfo(config('const.COMPANY_ID'), $article->sale_no);
          $develop_num = $lot->develop_num;
        }
        $article->developer_number = $develop_num;

        // 物件種別
        $article->property_name = $this->getPropertyName($article->property, $article->property_sub);

        // dump($article->update);
        $article->update = date('Y/m/d',  strtotime($article->update));
        $timestamp = strtotime('+14 day ' . $article->update );
        $article->next_update = date("Y/m/d", $timestamp);

        // 写真データを取得
        $photos = RelationArticlePhoto::getDispImgByArticleId($request->id);
        foreach($photos as $photo) {
          $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // 取扱店舗を取得
        $store = MstStore::getDataById($article->shop);

        // 担当者を取得
        $charge = UserInfo::getDataById($article->hp_charge);
        if(isset($charge->file_path)) {
          $charge->file_path = str_replace('public', '/storage', $charge->file_path);
        }



        $data['article'] = $article;
        $data['photos'] = $photos;
        $data['store'] = $store;
        $data['charge'] = $charge;
        return view('home.buy.print', $data);
    }


    public function flow()
    {
        $data['css'] = root("css/buy/flow.css");
        $data['extra'] = true;
        $data['bread'] = true;
        $data['contents'] = array(
      '01' => array(
        'title' => 'お住まい探しのご相談',
        'text' => 'お客様のご希望条件等をお伺いいたします。
        地域や沿線、駅からの距離、間取りや広さ、日当たり、価格等、こだわり条件はもちろん、
        資金計画、税金、法律のことなど何でもお気軽にご相談ください。'
      ),
      '02' => array(
        'title' => '現地ご案内・物件見学',
        'text' => 'おおよその予算・エリア・種別などが決まりましたら、ご希望に沿った物件をお探します。
        条件に近い物件が見つかったら、実際に物件見学に行ってみましょう。

        現地まで担当スタッフがご案内し、物件についてご説明いたします。
        見学の際は、周辺の生活情報、教育施設や公共施設、交通機関などについてもご案内いたします。'
      ),
      '03' => array(
        'title' => '購入のお申し込み',
        'text' => '購入したい物件と希望条件が決まれば、購入の申し込みをおこないます。
        価格・条件などにご納得いただければ、購入申込書にご記入いただきます。
        また同時並行してローンの事前確認を行いましょう。'
      ),
      '04' => array(
        'title' => '売買契約',
        'text' => '安心・安全なお取引きのため、事前に物件調査を慎重におこない、契約関係書類を作成いたします。
        不動産にかかわる大切な事項をご説明し、ご理解・ご納得いただければ
        売買契約書への署名、売主様へ手付金をお支払いいただき、売買契約が成立いたします。'
      ),
      '05' => array(
        'title' => '住宅ローン契約',
        'text' => '住宅ローンを利用される場合、売買契約後に金融機関に借入の申し込みを行います。
        ご準備いただく書類（公的証明等）がございますが、丁寧にご説明いたします。
        住宅ローンはさまざまな商品がありますので、お客様のライフスタイルに合った商品を選びましょう。 '
      ),
      '06' => array(
        'title' => '代金決済・お引渡し',
        'text' => '総額から手付金を引いた残代金のお支払いと同時にお引渡しとなります。
        また不動産登記手続きもおこないます（司法書士が代行）。

        ご購入に関する諸費用（仲介手数料、登記費用、税金の精算、金融機関の手数料等）のお支払いは
        担当スタッフがしっかりとサポートをいたしますのでご安心ください。
        鍵を受け取ったら、お取引きは完了です。

        '
      )
    );
        $staticFirst =array(
            'url' => root('img/buy/flow-first.jpg'),
            'title' => "FLOW",
            'jp' => '購入の流れ',
            'text' => 'お住まい探しをスタートしてからご入居までの流れをご案内します。'
        );
        $data['dynamics']['flow.html'] = '購入の流れ';
        return view('home.buy.flow', $data);
    }

    public function cost()
    {
      $data['css'] = root("css/buy/cost.css");
      $data['extra'] = true;
      $data['bread'] = true;
      $data['staticFirst'] =array(
          'url' => root('img/buy/cost-first.jpg'),
          'title' => "COST",
          'jp' => '購入の費用',
          'text' => '不動産に購入にかかる諸費用や税金についてご説明します。'
      );
      $data['dynamics']['cost.html'] = '購入の費用';

      return view('home.buy.cost', $data);
    }

    public function school()
    {
      $css = root("css/buy/school.css");
      $extra = true;
      $bread = true;
      $res = [];
      $school_list = MstSchool::getData();
      foreach($school_list as $school) {
        if(!array_key_exists($school['area'], $res)) {
          $res[$school['area']] = ['primary' => [], 'secondary' => []];
        }
        if($school['type'] == 1) {
          array_push($res[$school['area']]['primary'], ['code' => $school['code'], 'name' => $school['name'], 'count' => $school['count'], 'area' => $school['pref_id'].$school['city_id']]);
        } elseif($school['type'] == 2) {
          array_push($res[$school['area']]['secondary'], ['code' => $school['code'], 'name' => $school['name'], 'count' => $school['count'], 'area' => $school['pref_id'].$school['city_id']]);
        }
      }

      $data['items'] = $res;
      $data['css'] = $css;
      $data['extra'] = $extra;
      $data['bread'] = $bread;
      $data['dynamics']['school'] = '学校区から探す';
      return view('home.buy.school', $data);
    }

    public function line()
    {
      $css = root("css/buy/line.css");
      $extra = true;
      $bread = true;
      $res = [];
      $line_list = MstLine::getDataAll();
      foreach($line_list as $line) {
       $stations =  MstStation::getDataByLine($line['id']);
       $res[] = ['line' => $line, 'stations' => $stations];
      }

      $data['items'] = $res;
      $data['css'] = $css;
      $data['extra'] = $extra;
      $data['bread'] = $bread;
      $data['dynamics']['line'] = '沿線・駅から探す';
      return view('home.buy.line', $data);
    }

    public function loan(Request $request)
    {
      $data['css'] = root("css/buy/loan.css");
      $data['js'] = root("js/buy/loan.js");
      $data['extra'] = true;
      $data['bread'] = true;
      $id = $request->id;

      // 価格の取得
      $article = Article::getDataById(config('const.COMPANY_ID'), $id);
	    $data['price'] = $article->price;
      return view('home.buy.loan', $data);
    }
    public function contact(Request $request)
    {
      $data['css'] = root("css/buy/contact.css");
      $data['extra'] = true;
      $data['bread'] = true;
      $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "CONTACT",
        'jp' => '物件のお問い合わせ',
        'text' => '下記の入力フォームに必要事項をご入力の上、送信ボタンをクリックしてください。
        必須マークの項目は必ずご入力をお願いします。 '
      );
      $id = $request->id;
      $article = Article::getDataById(config('const.COMPANY_ID'), $id);
      $data['id'] = $article->building_id;
      $data['name'] = $article->article_name??'-';

      return view('home.buy.contact', $data);
    }
    public function reserve(Request $request)
    {
      $data['css'] = root("css/buy/contact.css");
      $data['extra'] = true;
      $data['bread'] = true;
      $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "RESERVE",
        'jp' => '物件の来場予約',
        'text' => '下記の入力フォームに必要事項をご入力の上、送信ボタンをクリックしてください。
        必須マークの項目は必ずご入力をお願いします。 '
      );
      $id = $request->id;
      $article = Article::getDataById(config('const.COMPANY_ID'), $id);
      $data['id'] = $article->building_id;
      $data['name'] = $article->article_name??'-';

      return view('home.buy.reserve', $data);
    }
  


}
