<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Reform;
use App\Models\RelationReformPhoto;

use DateTime;

class ReformController extends Controller
{
  public function index()
  {
        $data['css'] = root("css/reform/index.css");
        $data['reformextra'] = true;
        $data['bread'] = true;
        $data['staticFirst'] =array(
        'url' => root('img/reform/indextop.jpg'),
        'title' => "REFORM",
        'jp' => '中古＋リフォーム',
        'text' => "購入しやすい中古マンションや戸建を、家族の夢を叶える、細部まで丁寧につくりこまれた
        オーダーメイド住空間”へつくり替えます。
        物件探しから、リフォーム設計・施工、インテリア・家具コーディネート、
        ご入居までを私たちがワンストップでご提供します。"
        );

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/reform';
        $data['keywords'] = '横浜市,リフォーム,リノベーション,中古物件';
        $data['title'] = '【ミック売買サイト】横浜市でリフォーム・リノベーション';
        $data['description'] = '横浜市で中古物件を買ってリフォーム・リノベーションするならミック。中古物件を買ってリノベーションすれば、ご希望のエリアに、予算内で、理想の空間を実現することが可能。ミックの中古+リフォームで、新築以上の喜びを実現しませんか？';
        $data['dynamics']['reform'] = 'リフォーム';

        return view('home.reform.index', $data);
  }

    public function example()
    {
        $data = [];
        $data['css'] = root("css/reform/example.css");
        $data['reformextra'] = true;
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/reform/exampletop.jpg'),
            'title' => "FILE",
            'jp' => '中古＋リフォームの事例',
            'text' => "ご家族のこだわりにあわせたオーダーメイド設計だから、
            リフォームして生まれた住まいのカタチも多種多様。
            個性溢れるオーダーメイド空間と住みごこち、くらしの変化などをご覧ください。"
        );

        $data['category'] = [ '1' => 'マンション', '2' => '戸建'];

        // リフォーム事例を取得
        $reform = Reform::getDispDataAll(1);

        foreach($reform as &$row) {
            // 築年計算
            $today = date('Y/m/1');
            $target_day = $row->from_year.'/'.$row->from_month.'/1';

            $d1 = new DateTime($today);
            $d2 = new DateTime($target_day);
            $diff = $d2->diff($d1);
            $row->age = $diff->y;

            // 画像取得
            $image = RelationReformPhoto::getListImageByReformId($row->id);
            if(!empty($image)) {
                $row->file_path = str_replace('public', '/storage', $image->file_path);
            }   
        }

        $data['reform'] = $reform;

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/reform/works';
        $data['keywords'] = 'リフォーム,中古,施工,事例,横浜市';
        $data['title'] = '【ミック売買サイト】横浜市の中古＋リフォーム施工事例';
        $data['description'] = '中古+リフォームの施工事例をご紹介しています。ミックのリフォーム、リノベーションによって、横浜市内で理想の暮らしを実現されたお客様が多数いらっしゃいます。こだわりのポイントを、BeforeとAfterの図面と写真でぜひご覧ください。';
        $data['dynamics']['works'] = '事例一覧';

        return view('home.reform.example', $data);
    }

    public function detail(Request $request)
    {
        $data = [];
        $data['css'] = root("css/reform/detail.css");
        $data['reformextra'] = true;
        $data['bread'] = true;
        $data['category'] = [ '1' => 'マンション', '2' => '戸建'];
        

        $reform = Reform::getDataByCode(config('const.COMPANY_ID'), $request->example_id);
        if(is_null($reform)){
            print('存在しない物件、または不正なアクセスです。');
            exit;
        }
        $reform->disp_before = str_replace('public', '/storage', $reform->before_file_path);
        $reform->disp_after = str_replace('public', '/storage', $reform->after_file_path);

        $photos = RelationReformPhoto::getImageByReformId($request->example_id);
        foreach($photos as &$photo) {
            $photo->disp_file_path = str_replace('public', '/storage', $photo->file_path);
        }   
    
        $all_reform = Reform::getDispDataAll(config('const.COMPANY_ID'));
        $tmp1 = [];
        $tmp2 = [];
        foreach($all_reform as $key => $val) {
            $tmp1[$val->id] = $key;
            $tmp2[$key] = $val->id;
        }
        $data['prev'] = isset($tmp2[$tmp1[$reform->id]-1])? $tmp2[$tmp1[$reform->id]-1]: '';
        $data['next'] = isset($tmp2[$tmp1[$reform->id]+1])? $tmp2[$tmp1[$reform->id]+1]: '';

        if(empty($reform)) {
            // 不正なIDへのアクセスの場合
            $URL = url('');
            header('Location: '.$URL.'/reform/works/');
            die();
        }

        // 築年計算
        $today = date('Y/m/1');
        $target_day = $reform->from_year.'/'.$reform->from_month.'/1';

        $d1 = new DateTime($today);
        $d2 = new DateTime($target_day);
        $diff = $d2->diff($d1);
        $reform->age = $diff->y;

        $data['reform'] = $reform;
        $data['photos'] = $photos;
        $data['photos_count'] = count($photos);
        $data['dynamics'] = [ $request->example_id => $reform->title]; //TODO

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/reform/works';
        if($reform->category == 2){
            $data['keywords'] = $reform->area.',一戸建て,'.$reform->from_year.'年'.$reform->from_month.'月築,'.$reform->cost.'万円,リフォーム,事例,'.$reform->code;
            $data['title'] = '【ミック売買サイト】'.$reform->area.'の一戸建てのリフォーム事例（'.$reform->code.'）';
            $data['description'] = '【事例タイトル】横浜市'.$reform->area.'の一戸建てのリフォーム事例（改装費用：約'.$reform->cost.'万円、築年数：'.$reform->age.'年、No.'.$reform->code.'）です。中古+リフォームの施工事例を写真でご覧ください。';
    
        } elseif($reform->category == 1) {
            $data['keywords'] = $reform->area.',マンション,'.$reform->from_year.'年'.$reform->from_month.'月築,'.$reform->cost.'万円,リフォーム,事例,'.$reform->code;
            $data['title'] = '【ミック売買サイト】'.$reform->area.'の一戸建てのリフォーム事例（'.$reform->code.'）';
            $data['description'] = '事例タイトル】横浜市'.$reform->area.'のマンションのリフォーム事例（改装費用：約'.$reform->cost.'万円、築年数：'.$reform->age.'年、No.'.$reform->code.'）です。中古+リフォームの施工事例を写真でご覧ください。';
    
        }

        return view('home.reform.detail', $data);
    }
    public function merit()
    {
        $data['css'] = root("css/reform/merit.css");
        $data['reformextra'] = true;
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/reform/meritfirst.jpg'),
            'title' => "MERIT",
            'jp' => '中古＋リフォームのメリット',
            'text' => "住まいの立地や間取り、デザインはとことん妥協したくない。
            無駄な費用は抑えて、こだわりたいところにはお金をかけたい。
            三春情報センターの「中古＋リフォーム」にはたくさんのメリットがあります。",
            'grey' => true
        );

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/reform/mert.html';
        $data['keywords'] = 'メリット,リフォーム,中古';
        $data['title'] = '【ミック売買サイト】中古＋リフォームのメリット';
        $data['description'] = '理想の住まいを実現するための新しい選択肢、中古＋リフォームにはメリットがたくさん！三春情報センターなら、トータルプランニングでオーダーメイドの住空間を予算内で実現できます。ワンランク上のご満足と心地よさを感じてください。';
        $data['dynamics']['merit.html'] = 'リフォームのメリット';

        return view('home.reform.merit', $data);
    }
    public function flow()
    {
        $data['css'] = root("css/reform/flow.css");
        $data['reformextra'] = true;
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/reform/flowfirst.jpg'),
            'title' => "FLOW",
            'jp' => '中古＋リフォームの流れ',
        );

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/reform/flow.html';
        $data['keywords'] = '流れ,リフォーム,中古';
        $data['title'] = '【ミック売買サイト】中古＋リフォームの流れ';
        $data['description'] = '中古＋リフォームをお考えなら、まずミックにお越しください。ご相談は無料です。リフォームする物件を選び、基本プランが決定すれば、資金計画を立ててご契約。その後、詳細なデザインを決めていきます。ご入居後もサポートいたしますので、ご安心ください。';
        $data['dynamics']['flow.html'] = 'リフォームの流れ';

        return view('home.reform.flow', $data);
    }
    public function contact()
    {
        //$css = root("css/reform/contact.css");
		$data['css'] = root("css/contact/index.css");
        $data['reformextra'] = true;
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/staff/top.jpg'),
            'title' => "CONTACT",
            'jp' => 'リフォームのお問い合わせ',
            'text' => "下記の入力フォームに必要事項をご記入の上、「確認」ボタンをクリックしてください。
　　必須マークの項目はご記入をお願いします。 ",
        );
        $data['dynamics']['contact.html'] = 'お問い合わせ';

        return view('home.reform.contact', $data);
    }
    public function reserve()
    {
        $css = root("css/reform/contact.css");
        $reformextra = true;
        $bread = true;
        $staticFirst =array(
            'url' => root('img/staff/top.jpg'),
            'title' => "CONTACT",
            'jp' => 'リフォームの来場予約',
            'text' => "下記の入力フォームに必要事項をご記入の上、「確認」ボタンをクリックしてください。
　　必須マークの項目はご記入をお願いします。 ",
        );
        return view('home.reform.reserve', compact('css', 'reformextra', 'bread', 'staticFirst'));
    }
}
