<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SellController extends Controller
{
    public function index()
    {
        $data['css'] = root("css/sell/index.css");
      	$data['sellextra'] = true;
        $data['bread'] = true;
        $data['staticFirst'] = array(
            'url' => root('img/sell/sell-first.jpg'),
            'title' => "SELL",
            'jp' => '売却',
            'text' => '三春情報センターの「売却の強み」をご紹介します。'
        );
        $data['keywords'] = '横浜市,家,売る';
        $data['title'] = '【ミック売買サイト】横浜市で家を売る';
        $data['description'] = '横浜市（港南区、南区、磯子区、金沢区、栄区）で家を売りたいとお考えならミックにご相談ください。ご自宅マンションや一戸建て、ご所有の土地など、不動産売却のお力になります。まずは相場価格が知りたいというお問い合わせも大歓迎です。';

        return view('home.sell.index', $data);

    }
    public function flow()
  {
      $data['css'] = root("css/sell/flow.css");
      $data['sellextra'] = true;
      $data['bread'] = true;
      $data['staticFirst'] = array(
          'url' => root('img/sell/sell-flow-first.jpg'),
          'title' => "FLOW",
          'jp' => '売却の流れ',
      'text' => 'お住まい探しをスタートしてからご入居までの<br />流れをご案内します。'
      );
      $data['dynamics']['flow.html'] = '売却の流れ';
      return view('home.sell.flow', $data);
  }
  public function type()
  {
    $data['css'] = root("css/sell/type.css");
   	$data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/sell/sell-type-first.jpg'),
        'title' => "TYPE",
        'jp' => '売却の種類',
    'text' => 'ご要望に合わせて２つの売却方法を<br />ご提案いたします。'
    );
    $data['dynamics']['type.html'] = '売却の種類';

    return view('home.sell.type', $data);
  }
  public function simple_mansion()
  {
    //$data['css'] = root("css/sell/mansion.css");
	$data['css'] = root("css/contact/index.css");
    $data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "CONTACT",
        'jp' => 'マンションの簡易査定',
    'text' => 'ご自宅マンションの概要を入力するだけで、おおよその価格が分かる無料のサービスです。
売却の検討をはじめたばかりで、まずは概算の金額が知りたい方におすすめです。'
    );
    $data['keywords'] = 'マンション,横浜市,価格,査定,自宅';
    $data['title'] = '【ミック売買サイト】横浜市のご自宅マンションの簡易価格査定';
    $data['description'] = '横浜市内のマンションの価格査定はミックにご依頼ください。簡易査定なら、インターネット上でご自宅マンションの概要を入力いただくだけで、査定書をメールでお送りいたします。売却を検討される前の、ひとまず価格を知りたいというお問い合わせも大歓迎です。';
    $data['dynamics']['simple_mansion.html'] = 'マンションの簡易査定';

    return view('home.sell.simple_mansion', $data);
  }
  public function simple_land()
  {
    //$data['css'] = root("css/sell/land.css");
	$data['css'] = root("css/contact/index.css");
    $data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "CONTACT",
        'jp' => '土地の簡易査定',
    'text' => '土地の概要を入力するだけで、おおよその価格が分かる無料のサービスです。
売却の検討をはじめたばかりで、まずは概算の金額が知りたい方におすすめです。'
    );
    $data['keywords'] = '土地,横浜市,価格,査定';
    $data['title'] = '【ミック売買サイト】横浜市の土地の簡易価格査定';
    $data['description'] = '横浜市内の土地の価格査定はミックにご依頼ください。簡易査定なら、インターネット上でご所有の土地の概要を入力いただくだけで、査定書をメールでお送りいたします。売却を検討される前の、ひとまず価格を知りたいというお問い合わせも大歓迎です。';
    $data['dynamics']['simple_land.html'] = '土地の簡易査定';

    return view('home.sell.simple_land', $data);
  }
  public function simple_house()
  {
    //$data['css'] = root("css/sell/house.css");
	$data['css'] = root("css/contact/index.css");
    $data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "CONTACT",
        'jp' => '戸建の簡易査定',
    'text' => 'ご自宅戸建の概要を入力するだけで、おおよその価格が分かる無料のサービスです。
売却の検討をはじめたばかりで、まずは概算の金額が知りたい方におすすめです。'
    );
    $data['keywords'] = '一戸建て,横浜市,価格,査定,自宅';
    $data['title'] = '【ミック売買サイト】横浜市のご自宅一戸建ての簡易価格査定';
    $data['description'] = '横浜市内の一戸建ての価格査定はミックにご依頼ください。簡易査定なら、インターネット上でご自宅一戸建ての概要を入力いただくだけで、査定書をメールでお送りいたします。売却を検討される前の、ひとまず価格を知りたいというお問い合わせも大歓迎です。';
    $data['dynamics']['simple_house.html'] = '戸建の簡易査定';

    return view('home.sell.simple_house', $data);
  }
  public function visit_mansion()
  {
	$data['css'] = root("css/contact/index.css");
    $data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "ASSESSMENT",
        'jp' => 'マンションの無料訪問査定',
    'text' => 'ご自宅マンションの正確な価格がわかる無料のサービス。
ご自宅にお伺いし、現地調査を行ったうえで価格査定書を作成します。
合わせて売却方法や税金、買替え先のご相談・ご提案などさせていただくこともできます。'
    );
    $data['keywords'] = 'マンション,横浜市,無料,査定,自宅';
    $data['title'] = '【ミック売買サイト】横浜市のご自宅マンションの無料訪問査定';
    $data['description'] = '横浜市内でマンションの売却をご検討中なら、ミックの無料訪問査定がオススメです。横浜市の不動産売却のプロがご自宅マンションを訪問させていただき、詳細な調査をおこなったうえで、正確な査定価格を算出。価格査定書を無料で作成いたします。';
    $data['dynamics']['visit_mansion.html'] = 'マンションの無料訪問査定';

    return view('home.sell.visit_mansion', $data);
  }
  public function visit_house()
  {
    //$data['css'] = root("css/sell/assesment.css");
	$data['css'] = root("css/contact/index.css");
    $data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "ASSESSMENT",
        'jp' => '戸建の無料訪問査定',
    'text' => 'ご自宅戸建の正確な価格がわかる無料のサービス。
ご自宅にお伺いし、現地調査を行ったうえで価格査定書を作成します。
合わせて売却方法や税金、買替え先のご相談・ご提案などさせていただくこともできます。'
    );
    $data['keywords'] = '一戸建て,横浜市,無料,査定,自宅';
    $data['title'] = '【ミック売買サイト】横浜市のご自宅一戸建ての無料訪問査定';
    $data['description'] = '横浜市内で一戸建ての売却をご検討中なら、ミックの無料訪問査定がオススメです。横浜市の不動産売却のプロがご自宅一戸建てを訪問させていただき、詳細な調査をおこなったうえで、正確な査定価格を算出。価格査定書を無料で作成いたします。';
    $data['dynamics']['visit_house.html'] = '戸建の無料訪問査定';

    return view('home.sell.visit_house', $data);
  }
  public function visit_land()
  {
    //$data['css'] = root("css/sell/assesment.css");
	$data['css'] = root("css/contact/index.css");
    $data['sellextra'] = true;
    $data['bread'] = true;
    $data['staticFirst'] = array(
        'url' => root('img/staff/top.jpg'),
        'title' => "ASSESSMENT",
        'jp' => '土地の無料訪問査定',
    'text' => 'ご所有土地の正確な価格がわかる無料のサービス。
ご自宅にお伺いし、現地調査を行ったうえで価格査定書を作成します。
合わせて売却方法や税金、買替え先のご相談・ご提案などさせていただくこともできます。'
    );
    $data['keywords'] = '土地,横浜市,無料,査定';
    $data['title'] = '【ミック売買サイト】横浜市の土地の無料訪問査定';
    $data['description'] = '横浜市内で土地の売却をご検討中なら、ミックの無料訪問査定がオススメです。横浜市の不動産売却のプロがご所有の土地を訪問させていただき、詳細な調査をおこなったうえで、正確な査定価格を算出。価格査定書を無料で作成いたします。';
    $data['dynamics']['visit_land.html'] = '土地の無料訪問査定';

    return view('home.sell.visit_land', $data);
  }
}
