<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MstStore;
use App\Models\RelationStorePhoto;
use App\Models\UserInfo;

class ShopController extends Controller
{
    public function index(){
        $data['css'] = root("css/shop/index.css");
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/shop/shop-first.jpg'),
            'title' => "SHOP",
            'jp' => '店舗紹介',
            'text' => '三春情報センターは19店舗を展開しています。<br>お住いのご相談はお近くの営業所まで。'
        );

        $area_list = [111 => '港南区', 115 => '栄区', 107 => '磯子区', 108 => '金沢区', 105 => '南区', 204 => '鎌倉市', 999 => 'その他'];
        $shop_list = [];
        foreach($area_list as $key => $val) {
            $shops = MstStore::getDataByArea(config('const.COMPANY_ID'), $key);
            foreach($shops as &$shop) {
                $photo = RelationStorePhoto::getListPhoto(config('const.COMPANY_ID'), $shop->code);
                if(isset($photo->file_path)) {
                    $shop->file_path = str_replace('public', '/storage', $photo->file_path);
                }
            }

            $shop_list[$key] = ['area_name' => $val, 'shop' => $shops];
        }
        // dump($shop_list);
        $data['shops'] = $shop_list;

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/shop';
        $data['keywords'] = '店舗,横浜市,不動産,ミック';
        $data['title'] = '【ミック売買サイト】店舗紹介';
        $data['description'] = 'ミックの店舗をご紹介。不動産仲介や注文住宅、リフォーム相談、保険の見直し、マンション管理などのサービスを行っています。栄区で昭和52年に創業以来、地元密着でお客様の「よりよい暮らし」をお手伝いしている三春情報センターです。';
        // $data['dynamics']['/reform/works/'] = '事例一覧';

        return view('home.shop.index', $data);

    }

    public function detail($shop_id){
        $data['css'] = root("css/shop/detail.css");
        $data['bread'] = true;
        

        // ショップ情報を取得
        $shop = MstStore::getDataByCodeFrontByKana(config('const.COMPANY_ID'), $shop_id);
        if(is_null($shop)){
            print('存在しない物件、または不正なアクセスです。');
            exit;
        }
        // 写真情報を取得
        $photos = RelationStorePhoto::getPhotoDataFront(config('const.COMPANY_ID'), $shop->code);
        foreach($photos as &$photo) {
            $photo->file_path = str_replace('public', '/storage', $photo->file_path);
        }

        // スタッフ情報を取得
        $staffs = UserInfo::getDataByStore(config('const.COMPANY_ID'), $shop->code);
        foreach($staffs as $staff) {
            $staff->file_path = str_replace('public', '/storage', $staff->file_path);
        }

        $data['dynamics'] = [$shop->code => $shop->name];
        $data['shop'] = $shop;
        $data['photos'] = $photos;
        $data['staffs'] = $staffs;

        $url_params = str_replace(url(''), '', url()->full());
        $url_params_org = preg_replace('/.*?\?/', '', $url_params);
        $base_url = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"];
        $data['canonical_url'] = $base_url.'/shop';
        $data['keywords'] = $shop->name.','.$shop->city_name.$shop->town_name.',不動産,ミック';
        $data['title'] = '【ミック売買サイト】'.$shop->name.'（'.$shop->city_name.$shop->town_name.'）';
        $data['description'] = 'ミック'.$shop->name.'は、'.$shop->city_name.$shop->town_name.'で不動産仲介や注文住宅、リフォーム相談、保険の見直し、マンション管理などのサービスを行っています。横浜市の不動産に関するご相談なら、地元密着の三春情報センター'.$shop->name.'にお越しください。';
        // $data['dynamics']['/reform/works/'] = '事例一覧';


        return view('home.shop.detail', $data);
    }
}
