<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\UserInfo;
use App\Models\MstStore;
use App\Models\CustomItem;
use App\Models\CustomContent;
use App\Models\RelationCustomItem;

class StaffController extends Controller
{
    public function index(Request $request)
    {
        $data['css'] = root("css/staff/index.css");
        $data['bread'] = true;

        $data['staticFirst'] =array(
            'url' => root('img/staff/top.jpg'),
            'title' => "STAFF",
            'jp' => 'スタッフ紹介',
            'text' => '三春情報センターのスタッフ紹介です。クリックで詳細をご覧いただけます。',
        );

        $area_list = [
            111 => '港南区',
            115 => '栄区',
            107 => '磯子区',
            108 => '金沢区',
            105 => '南区',
            999 => 'その他',
        ];

        
        $shop_list = [];
        $staff_list = [];
        foreach($area_list as $key => $val) {
            // 店舗リストを取得
            $tmp_shop_list = MstStore::getStoreListToTop(config('const.COMPANY_ID'), config('const.DEFAULT_PREF'), $key);
            $shop_list[$key] = ['area_name' => $val, 'shops' => $tmp_shop_list];

            // スタッフリストを取得
            foreach($tmp_shop_list as $shop) {
                $tmp_user_list = UserInfo::getDataByStore(config('const.COMPANY_ID'), $shop->code);
                foreach($tmp_user_list as $staff) {
                    $staff->file_path = str_replace('public', '/storage', $staff->file_path);
                }
                $staff_list[] = ['shop' => $shop, 'staffs' => $tmp_user_list];
            }
        }
        $data['shop_list'] = $shop_list;
        $data['staff_list'] = $staff_list;

        $data['keywords'] = 'スタッフ,紹介,横浜市,ミック';
        $data['title'] = '【ミック売買サイト】スタッフ紹介';
        $data['description'] = 'ミックのスタッフをご紹介します。ミックには、港南区、南区、磯子区、金沢区、栄区を中心とした横浜市の不動産のプロが多数在籍しています。売出物件のご紹介やご自宅の価格査定など、お客様のご希望に対応させていただく各店舗のスタッフをご紹介します。';
        $data['dynamics']['stafflist'] = 'スタッフ紹介';

        return view('home.staff.index', $data);
    }
    public function contact($staff_id = null)
    {
		$data['css'] = root("css/contact/index.css");
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/staff/top.jpg'),
            'title' => "STAFF",
            'jp' => 'お問い合わせ',
            'text' => '下記の入力フォームに必要事項をご入力の上、送信ボタンをクリックしてください。
             必須マークの項目は必ずご入力をお願いします。 ',
        );

        $staff = null;
        $store = null;
        if(isset($staff_id)) {
            $staff = UserInfo::getDataByNumber($staff_id);
            // 店舗情報の取得
            $store = MstStore::getDataById($staff->store);
        }
        $data['staff'] = $staff;

        $data['keywords'] = '問い合わせ,'.$staff->last_name.$staff->first_name.$store->name.',スタッフ紹介,横浜市,ミック';
        $data['title'] = '【ミック売買サイト】お問い合わせ｜'.$staff->last_name.$staff->first_name.'（'.$store->name.'）';
        $data['description'] = 'ミック'.$store->name.'の'.$staff->last_name.$staff->first_name.'へのお問い合わせはこちらから。横浜市の不動産について、ご不明なことやご相談などがあれば、地元密着の三春情報センターのスタッフ、氏名にご相談ください。いただいたお問い合わせには即日対応いたします。';

        return view('home.staff.contact', $data);
    }

    public function detail($staff_id)
    {
        $data['css'] = root("css/staff/detail.css");
        $data['bread'] = true;
        $data['blood'] = [ '', 'A', 'B', 'O', 'AB'];

        // スタッフ情報の取得
        if(!isset($staff_id)) {
            $URL = url('');
            header('Location: '.$URL.'/stafflist');
            die();
        }
        $staff = UserInfo::getDataByNumber($staff_id);
        if(isset($staff->file_path)) {
          $staff->file_path = str_replace('public', '/storage', $staff->file_path);
        }

        // 店舗情報の取得
        $store = MstStore::getDataById($staff->store);

        // カスタム項目
        $customs = CustomItem::getData(1);
        foreach($customs as &$row) {
            $custom_anser = RelationCustomItem::getItem($staff_id, $row->code);
            $row->ans = $custom_anser['memo'];
        }

        $data['keywords'] = $staff->last_name.$staff->first_name.','.$store->name.',スタッフ紹介,横浜市,ミック';
        $data['title'] = '【ミック売買サイト】'.$staff->last_name.$staff->first_name.'（'.$store->name.'）';
        $data['description'] = $staff->last_name.$staff->first_name.'はミック'.$store->name.'の職種です。売出物件のご紹介やご自宅の価格査定、リフォーム相談、保険の見直しなど、不動産に関することなら、地元密着の三春情報センターまで。横浜市の不動産のプロが多数在籍しているため、なんでもご相談いただけます。';

        $data['staff'] = $staff;
        $data['store'] = $store;
        $data['customs'] = $customs;
        $data['dynamics'] = [$staff_id => $staff->last_name.' '.$staff->first_name];

        return view('home.staff.detail', $data);
    }

}
