<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Article;
use App\Models\News;
use App\Models\RelationArticlePhoto;
use App\Models\MstCity;
use Common;

class TestController extends Controller
{
    public function index(){
        $data = [];
        $data['css'] = root("css/index.css");



        //郵便番号
        $postNumber = '8700926';

        //APIからデータを取得～配列に変換
        $googleMapsApiData = json_decode(@file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?address=105-0003&language=ja&sensor=false&key=AIzaSyD6UqHLH6ErK8RZNISlqTRFKiER0XdT9o0'), true);

        //APIから正しくデータを取得できたかチェック
        if($googleMapsApiData['status'] !== 'OK'){
            echo 'すてーたすがOKではありません。';
            exit;
        }

        //都道府県を取得
        $addressArray = $googleMapsApiData['results'][0]['address_components'];
        unset($addressArray[0]);//郵便番号のトコを消して、、、
        array_pop($addressArray);//国のトコも消して、、、
        $addressArray = array_reverse($addressArray);//配列を逆さにして、、、
        $tdfk = $addressArray[0]['long_name'];//コレが都道府県
        unset($addressArray[0]);//市区町村の取得用に都道府県も消して、、、

        //市区町村を取得
        $skcsStrings = '';
        foreach($addressArray as $v){
            $skcsStrings .= $v['long_name'];//市区町村部分の文字列を連結させて、、、
        }
        $skcs = $skcsStrings;//コレが市区町村以下

        //緯度経度を取得
        $lat = $googleMapsApiData['results'][0]['geometry']['location']['lat'];//コレが緯度
        $lng = $googleMapsApiData['results'][0]['geometry']['location']['lng'];//コレが経度
        dump($lat);
        dump($lng);
        return view('home.test', $data);
    }
	
	  public function search(){
        $css = root("css/index.css");
      return view('home.test', compact('css'));
    }




    public static function getRecommendArticle($num = 6) {
      $articles = Article::getFrontRecommendDispData($num);

      foreach($articles as &$row) {
        if(isset($row->floor_file_path)) {
          $row->file_path = str_replace('public', '/storage', $row->floor_file_path);
        }
      }
      return $articles;
  }

  public static function getCountCommonArticle() {
      $result = [];
      $pid = 14;
      $target_area = [
        ['code' => 111, 'icon' => 'mapicon-konan.png', 'url' => 'konan'],
        ['code' => 105, 'icon' => 'mapicon-minami.png', 'url' => 'minami'],
        ['code' => 107, 'icon' => 'mapicon-isogo.png', 'url' => 'isogo'],
        ['code' => 108, 'icon' => 'mapicon-kanazawa.png', 'url' => 'kanazawa'],
        ['code' => 115, 'icon' => 'mapicon-sakae.png', 'url' => 'sakae'],
      ];

      foreach($target_area as $area) {
        $count = Article::getCountByCityId($pid, $area['code']);
        $name = MstCity::getName($pid, $area['code']);
        $count_mansion = Article::getCountByAreaProperty($pid, $area['code'], null);
        $count_house_new = Article::getCountByAreaProperty($pid, $area['code'], 4, 1);
        $count_house_old = Article::getCountByAreaProperty($pid, $area['code'], 4, 2);
        $count_land = Article::getCountByAreaProperty($pid, $area['code'], 1);

        $result[] = [
            'icon' => $area['icon'],
            'pref' => $pid,
            'city' => $area['code'],
            'area_id' => $pid.$area['code'],
            'count' => $count,
            'name' => $name->name,
            'url' => $area['url'],
            'sub_list' => [
              ['name' => '中古マンション', 'count' => $count_mansion, 'url' => 'mansion', 'pp' => 3, 'spp' => 2],
              ['name' => '新築一戸建て', 'count' => $count_house_new, 'url' => 'nhouse', 'pp' => 2, 'spp' => 1],
              ['name' => '中古一戸建て', 'count' => $count_house_old, 'url' => 'uhouse', 'pp' => 2, 'spp' => 2],
              ['name' => '土地', 'count' => $count_land, 'url' => 'land', 'pp' => 1]
            ]
        ];
    }
      return $result;
  }
}
