<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Article;
use App\Models\News;
use App\Models\RelationArticlePhoto;
use App\Models\MstCity;
use Common;

class TopController extends Controller
{
    public function index(){
      $css = root("css/index.css");
      $data['common_list'] = $this->getCountCommonArticle();
      $data['css'] = $css;
      $data['keywords'] = '横浜市,不動産,三春情報センター,ミック';
      $data['title'] = '【ミック売買サイト】横浜市の不動産の購入・売却・リフォーム';
      $data['description'] = '横浜市の不動産のことならミックにお任せください。ご自宅の購入はもちろん、売却、リフォームなど、不動産のことなら何でもご相談いただけます。横浜市（港南区、南区、磯子区、金沢区、栄区）で家を買うなら三春情報センターのミック。';

      $data['new_target'] = date("Y-m-d",strtotime("-".config('const.NEW')." day"));

      // オープンハウスの取得
      $opens = Article::getOpenHouseData(config('const.COMPANY_ID'));
      foreach($opens as $open) {
        // 画像取得
        $open_photo = RelationArticlePhoto::getTopImagePath($open->building_id);
        if(isset($open_photo->file_path)) {
          $open->open_file_path = str_replace('public', '/storage', $open_photo->floor_file_path);
        } else {
          $open->open_file_path = "";
        }

        $open->from_minute = str_pad($open->from_minute, 2, 0, STR_PAD_LEFT);
        $open->to_minute = str_pad($open->to_minute, 2, 0, STR_PAD_LEFT);
      }
      $data['open'] = $opens;
      

      // トピックスの取得
      $news = News::getData(config('const.COMPANY_ID'));
      $data['topics'] = $news;
      
      // おすすめ物件の取得
      $data['recommend'] = $this->getRecommendArticle();
      // print_r($data['recommend']);

      return view('home.index', $data);
    }
	
	  public function search(){
        $css = root("css/index.css");
      return view('home.index',compact('css'));
    }




    public static function getRecommendArticle($num = 6) {
      $articles = Article::getFrontRecommendDispData($num);

      foreach($articles as &$row) {
        if(isset($row->floor_file_path)) {
          $row->file_path = str_replace('public', '/storage', $row->floor_file_path);
        }
      }
      return $articles;
  }

  public static function getCountCommonArticle() {
      $result = [];
      $pid = 14;
      $target_area = [
        ['code' => 111, 'icon' => 'mapicon-konan.png', 'url' => 'konan'],
        ['code' => 105, 'icon' => 'mapicon-minami.png', 'url' => 'minami'],
        ['code' => 107, 'icon' => 'mapicon-isogo.png', 'url' => 'isogo'],
        ['code' => 108, 'icon' => 'mapicon-kanazawa.png', 'url' => 'kanazawa'],
        ['code' => 115, 'icon' => 'mapicon-sakae.png', 'url' => 'sakae'],
      ];

      foreach($target_area as $area) {
        $count = Article::getCountByCityId($pid, $area['code']);
        $name = MstCity::getName($pid, $area['code']);
        $count_mansion = Article::getCountByAreaProperty($pid, $area['code'], null);
        $count_house_new = Article::getCountByAreaProperty($pid, $area['code'], 4, 1);
        $count_house_old = Article::getCountByAreaProperty($pid, $area['code'], 4, 2);
        $count_land = Article::getCountByAreaProperty($pid, $area['code'], 1);

        $result[] = [
            'icon' => $area['icon'],
            'pref' => $pid,
            'city' => $area['code'],
            'area_id' => $pid.$area['code'],
            'count' => $count,
            'name' => $name->name,
            'url' => $area['url'],
            'sub_list' => [
              ['name' => '中古マンション', 'count' => $count_mansion, 'url' => 'mansion', 'pp' => 3, 'spp' => 2],
              ['name' => '新築一戸建て', 'count' => $count_house_new, 'url' => 'nhouse', 'pp' => 2, 'spp' => 1],
              ['name' => '中古一戸建て', 'count' => $count_house_old, 'url' => 'uhouse', 'pp' => 2, 'spp' => 2],
              ['name' => '土地', 'count' => $count_land, 'url' => 'land', 'pp' => 1]
            ]
        ];
    }
      return $result;
  }
}
