<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\News;

class TopicsController extends Controller
{
    public function index(){
        $data['css'] = root("css/topics/index.css");
        $data['bread'] = true;
        $data['staticFirst'] =array(
            'url' => root('img/topics/top.jpg'),
            'title' => "TOPICS",
            'jp' => 'トピックス'
        );
        $topics = News::getTopicsDispData(config('const.COMPANY_ID'));
        foreach($topics as &$topic) {
            $topic->disp_file_path = str_replace('public', '/storage', $topic->file_path);
            $text = $topic->news_link_target_text;
            $text = nl2br($text);
            $text = preg_replace("/(https?:\/\/)(?!w3g.jp)([-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/", "<a href=\"\\1\\2\" style=\"color: blue; text-decoration: underline;\" target=\"_blank\" rel=\"nofollow\">\\1\\2</a>", $text);
            $text = preg_replace("/(https?:\/\/w3g.jp)([-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/", "<a href=\"\\2\">\\1\\2</a>", $text);
            $topic->news_link_target_text = $text;
        }
        $data['topics'] = $topics;
        $data['new_target'] = date("Y-m-d",strtotime("-".config('const.NEW')." day"));
        return view('home.topics.index', $data);
    }
}
