<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Validator;

class ArticlePost extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];

        // 1.物件登録_基本情報
        $rules_base = [
            //
            'name' => 'required|max:30',
            'name_portal' => 'nullable|max:30',
            'memo1' => 'nullable|max:500',
            'memo2' => 'nullable|max:500',
            'section' => 'nullable|integer',
            'other_comment' => 'nullable|max:150',
        ];

        if(!isset($this->room)) {
            $tmp = [
                // 'zip' => 'required',
                'address1' => 'required|integer',
                'address2' => 'required|integer',
                'address3' => 'required|integer',
            ];

            $rule_base = array_merge($rules_base, $tmp);
        }

        
        // 主要交通
        if ($this->main_traffic == "1") {
            $rules_base['main_traffic_line'] = 'required';
            $rules_base['main_traffic_station'] = 'required';
            $rules_base['main_traffic_time'] = 'required|integer';
        } elseif($this->main_traffic == "2") {
            $rules_base['main_traffic_bus_time'] = 'required|integer';
            $rules_base['main_traffic_bus'] = 'required';
            $rules_base['main_traffic_bus_walk'] = 'required|integer';
        }


        // 2.物件登録_価格
        $rules_price = [];
        if(isset($this->price)) {
            $rules_price = [
                'price' => 'required|integer',
            ];
        }
        

        if ($this->council == "1" || $this->council == "2" || $this->council == "3") {
            if($this->council_presence == "2") {
                if($this->council_cost_unit != 0) {
                    $rules_price['council_cost'] = 'required|integer';
                }
            }
        }
        if ($this->spring == "1" || $this->spring == "2") {
            if($this->spring_presence == "2") {
                if($this->spring_cost_unit != 0) {
                    $rules_price['spring_cost'] = 'required|integer';
                }
            }
        }

        if ($this->another_cost_name1 != "") {
            if($this->another_cost_unit1 != "0") {
                $rules_price['another_cost1'] = 'required|integer';
            }
        }

        if ($this->another_cost_name2 != "") {
            if($this->another_cost_unit2 != "0") {
                $rules_price['another_cost2'] = 'required|integer';
            }
        }

        // 3.物件概要
        $rules_overview = [];
        if(isset($this->land_area)) {
            if ($this->land_area != "0") {
                $rules_overview['land_area_val'] = 'required|numeric';
            }
        }

        if ($this->land_condition1 == "1") {
            if($this->land_condition_unit1 != "0") {
                $rules_overview['land_condition_area1'] = 'required';
            }
        }

        if ($this->land_condition2 == "1") {
            if($this->land_condition_unit2 != "0") {
                $rules_overview['land_condition_area2'] = 'required';
            }
        }

        if ($this->land_condition3 == "1") {
            $rules_overview['land_condition_area3'] = 'required';
        }

        if ($this->current_status == "3") {
            $rules_overview['comp_year'] = 'required';
            $rules_overview['comp_month'] = 'required';
        }

        if ($this->land_delivery == "3") {
            $rules_overview['delivery_year'] = 'required';
            $rules_overview['delivery_month'] = 'required';
        }

        if ($this->land_condition == "2") {
            if ($this->land_condition_not == "2") {
                $rules_overview['building_plan_place'] = 'required|numeric';
                $rules_overview['building_plan_area'] = 'required|numeric';
            }
        }

        if ($this->ground == "7") {
            $rules_overview['ground_text'] = 'required|string';
        }

        if($this->property == "1" || $this->property == "2" || $this->property == "3") {
            $rules_overview['building_rate'] = 'required';
            $rules_overview['volume_rate'] = 'required';
        } else {
            if ($this->city_plan == "1" || $this->city_plan == "2" || $this->city_plan == "3" || $this->city_plan == "5") {
                $rules_overview['building_rate'] = 'required';
                $rules_overview['volume_rate'] = 'required';
            } else {
                $rules_overview['building_rate'] = 'nullable';
                $rules_overview['volume_rate'] = 'nullable';
            }
        }

        if ($this->road_burden == "2") {
            $rules_overview['road_burden_area'] = 'required|numeric|max:999';
        } elseif($this->road_burden == "3") {
            $rules_overview['road_burden_area'] = 'required|numeric|max:999';
            $rules_overview['road_numerator'] = 'required|numeric';
            $rules_overview['road_denominator'] = 'required|numeric';   
        }

        if ($this->easement == "2" || $this->easement == "3" || $this->easement == "4" || $this->easement == "5" || $this->easement == "6") {
            $rules_overview['easement_area'] = 'required|numeric';
        }

        if ($this->set == "2" || $this->set == "3") {
            $rules_overview['set_area'] = 'required|numeric';
        }

        
        
        // 4.投資・事業用
        if ($this->classfication == "2") {
            if ($this->classfication == "9") {
                $rules_overview['use_method_text'] = 'required';
            }
        }

        
        


        

        // return array_merge($rules_price);
        return array_merge($rules_base, $rules_price, $rules_overview);
    }
}
