<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Validator;

class MansionPost extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        // 1.物件登録_基本情報
        $rules_base = [
            //
            'name' => 'required',
            // 'zip' => 'required',
            'address1' => 'required|integer',
            'address2' => 'required|integer',
            'address3' => 'required|integer',
            'memo1' => 'nullable|max:500',
            'memo2' => 'nullable|max:500',
            'other_comment' => 'nullable|max:150',
        ];

        if ($this->main_traffic == "1") {
            $rules_base['main_traffic_line'] = 'required';
            $rules_base['main_traffic_station'] = 'required';
            $rules_base['main_traffic_time'] = 'required|integer';
        } elseif($this->main_traffic == "2") {
            $rules_base['main_traffic_bus_time'] = 'required|integer';
            $rules_base['main_traffic_bus'] = 'required';
            $rules_base['main_traffic_bus_walk'] = 'required|integer';
        }

        if($this->age_year == null) {
            $rules_base['age_year'] = 'required';
        }
        if($this->age_month == null) {
            $rules_base['age_month'] = 'required';
        }

        // 2.物件概要
        $rules = [];
        if(isset($this->building_id)) {
            $rules['building_id'] = 'integer';
        }
        if(isset($this->company_id)) {
            $rules['company_id'] = 'integer';
        }
        if(isset($this->rains_no)) {
            $rules['rains_no'] = 'integer';
        }
        if(isset($this->sale_no)) {
            $rules['sale_no'] = 'integer';
        }
        if(isset($this->property)) {
            $rules['property'] = 'integer';
        }
        if(isset($this->property_sub)) {
            $rules['property_sub'] = 'integer';
        }
        if(isset($this->status)) {
            $rules['status'] = 'integer';
        }
        if(isset($this->company_manner)) {
            $rules['company_manner'] = 'integer';
        }
        if(isset($this->shop)) {
            $rules['shop'] = 'integer';
        }
        if(isset($this->address1)) {
            $rules['address1'] = 'integer|required';
        }
        if(isset($this->address2)) {
            $rules['address2'] = 'integer|required';
        }
        if(isset($this->address3)) {
            $rules['address3'] = 'integer|required';
        }
        if(isset($this->lat)) {
            $rules['lat'] = 'numeric|max:999.999999';
        }
        if(isset($this->lng)) {
            $rules['lng'] = 'numeric|max:999.999999';
        }
        if(isset($this->main_traffic)) {
            $rules['main_traffic'] = 'integer';
        }
        if(isset($this->main_traffic_line_id)) {
            $rules['main_traffic_line_id'] = 'integer';
        }
        if(isset($this->main_traffic_station_id)) {
            $rules['main_traffic_station_id'] = 'integer';
        }
        if(isset($this->main_traffic_time)) {
            $rules['main_traffic_time'] = 'integer';
        }
        if(isset($this->main_traffic_bus_time)) {
            $rules['main_traffic_bus_time'] = 'integer';
        }
        if(isset($this->main_traffic_bus_walk)) {
            $rules['main_traffic_bus_walk'] = 'integer';
        }
        if(isset($this->sub_traffic1)) {
            $rules['sub_traffic1'] = 'integer';
        }
        if(isset($this->sub_traffic1_line_id)) {
            $rules['sub_traffic1_line_id'] = 'integer';
        }
        if(isset($this->sub_traffic1_station_id)) {
            $rules['sub_traffic1_station_id'] = 'integer';
        }
        if(isset($this->sub_traffic1_time)) {
            $rules['sub_traffic1_time'] = 'integer';
        }
        if(isset($this->sub_traffic1_bus_time)) {
            $rules['sub_traffic1_bus_time'] = 'integer';
        }
        if(isset($this->sub_traffic1_bus_walk)) {
            $rules['sub_traffic1_bus_walk'] = 'integer';
        }
        if(isset($this->sub_traffic2)) {
            $rules['sub_traffic2'] = 'integer';
        }
        if(isset($this->sub_traffic2_line_id)) {
            $rules['sub_traffic2_line_id'] = 'integer';
        }
        if(isset($this->sub_traffic2_station_id)) {
            $rules['sub_traffic2_station_id'] = 'integer';
        }
        if(isset($this->sub_traffic2_time)) {
            $rules['sub_traffic2_time'] = 'integer';
        }
        if(isset($this->sub_traffic2_bus_time)) {
            $rules['sub_traffic2_bus_time'] = 'integer';
        }
        if(isset($this->sub_traffic2_bus_walk)) {
            $rules['sub_traffic2_bus_walk'] = 'integer';
        }
        if(isset($this->primary_school_school)) {
            $rules['primary_school_school'] = 'integer';
        }
        if(isset($this->primary_school_distance)) {
            $rules['primary_school_distance'] = 'integer';
        }
        if(isset($this->secondary_school_school)) {
            $rules['secondary_school_school'] = 'integer';
        }
        if(isset($this->secondary_school_distance)) {
            $rules['secondary_school_distance'] = 'integer';
        }
        if(isset($this->price)) {
            $rules['price'] = 'numeric|max:999999999.9';
        }
        if(isset($this->price_closing)) {
            $rules['price_closing'] = 'integer';
        }
        if(isset($this->tax)) {
            $rules['tax'] = 'integer';
        }
        if(isset($this->council)) {
            $rules['council'] = 'integer';
        }
        if(isset($this->council_presence)) {
            $rules['council_presence'] = 'integer';
        }
        if(isset($this->council_cost)) {
            $rules['council_cost'] = 'integer';
        }
        if(isset($this->council_cost_unit)) {
            $rules['council_cost_unit'] = 'integer';
        }
        if(isset($this->spring)) {
            $rules['spring'] = 'integer';
        }
        if(isset($this->spring_presence)) {
            $rules['spring_presence'] = 'integer';
        }
        if(isset($this->spring_cost)) {
            $rules['spring_cost'] = 'integer';
        }
        if(isset($this->spring_cost_unit)) {
            $rules['spring_cost_unit'] = 'integer';
        }
        if(isset($this->another_cost1)) {
            $rules['another_cost1'] = 'integer';
        }
        if(isset($this->another_cost_unit1)) {
            $rules['another_cost_unit1'] = 'integer';
        }
        if(isset($this->another_cost2)) {
            $rules['another_cost2'] = 'integer';
        }
        if(isset($this->another_cost_unit2)) {
            $rules['another_cost_unit2'] = 'integer';
        }
        if(isset($this->broadcasting)) {
            $rules['broadcasting'] = 'integer';
        }
        if(isset($this->broadcasting_presence)) {
            $rules['broadcasting_presence'] = 'integer';
        }
        if(isset($this->broadcasting_cost)) {
            $rules['broadcasting_cost'] = 'integer';
        }
        if(isset($this->broadcasting_fixed_presence)) {
            $rules['broadcasting_fixed_presence'] = 'integer';
        }
        if(isset($this->broadcasting_fixed_cost)) {
            $rules['broadcasting_fixed_cost'] = 'integer';
        }
        if(isset($this->broadcasting_fixed_cost_unit)) {
            $rules['broadcasting_fixed_cost_unit'] = 'integer';
        }
        if(isset($this->internet)) {
            $rules['internet'] = 'integer';
        }
        if(isset($this->internet_presence)) {
            $rules['internet_presence'] = 'integer';
        }
        if(isset($this->internet_cost)) {
            $rules['internet_cost'] = 'integer';
        }
        if(isset($this->internet_fixed_presence)) {
            $rules['internet_fixed_presence'] = 'integer';
        }
        if(isset($this->internet_fixed_cost)) {
            $rules['internet_fixed_cost'] = 'integer';
        }
        if(isset($this->internet_fixed_cost_unit)) {
            $rules['internet_fixed_cost_unit'] = 'integer';
        }
        if(isset($this->catv)) {
            $rules['catv'] = 'integer';
        }
        if(isset($this->catv_presence)) {
            $rules['catv_presence'] = 'integer';
        }
        if(isset($this->catv_cost)) {
            $rules['catv_cost'] = 'integer';
        }
        if(isset($this->catv_fixed_presence)) {
            $rules['catv_fixed_presence'] = 'integer';
        }
        if(isset($this->catv_fixed_cost)) {
            $rules['catv_fixed_cost'] = 'integer';
        }
        if(isset($this->catv_fixed_cost_unit)) {
            $rules['catv_fixed_cost_unit'] = 'integer';
        }
        if(isset($this->total_unit)) {
            $rules['total_unit'] = 'integer';
        }
        if(isset($this->age_year)) {
            $rules['age_year'] = 'integer';
        }
        if(isset($this->age_month)) {
            $rules['age_month'] = 'integer';
        }
        if(isset($this->construction)) {
            $rules['construction'] = 'integer';
        }
        if(isset($this->construction_sub)) {
            $rules['construction_sub'] = 'integer';
        }
        if(isset($this->floor)) {
            $rules['floor'] = 'integer';
        }
        if(isset($this->whereabouts)) {
            $rules['whereabouts'] = 'integer';
        }
        if(isset($this->underground)) {
            $rules['underground'] = 'integer';
        }
        if(isset($this->maisonette)) {
            $rules['maisonette'] = 'integer';
        }
        if(isset($this->maisonette_from)) {
            $rules['maisonette_from'] = 'integer';
        }
        if(isset($this->maisonette_to)) {
            $rules['maisonette_to'] = 'integer';
        }
        if(isset($this->site_area)) {
            $rules['site_area'] = 'numeric|max:99999.99';
        }
        if(isset($this->management_form)) {
            $rules['management_form'] = 'integer';
        }
        if(isset($this->pet)) {
            $rules['pet'] = 'integer';
        }
        if(isset($this->pet_count)) {
            $rules['pet_count'] = 'integer';
        }
        if(isset($this->land_right)) {
            $rules['land_right'] = 'integer';
        }
        if(isset($this->leasehold_kind)) {
            $rules['leasehold_kind'] = 'integer';
        }
        if(isset($this->leasehold_rate)) {
            $rules['leasehold_rate'] = 'integer';
        }
        if(isset($this->land_rent)) {
            $rules['land_rent'] = 'integer';
        }
        if(isset($this->land_rent_val)) {
            $rules['land_rent_val'] = 'integer';
        }
        if(isset($this->land_rent_unit)) {
            $rules['land_rent_unit'] = 'integer';
        }
        if(isset($this->leasehold_period)) {
            $rules['leasehold_period'] = 'integer';
        }
        if(isset($this->leasehold_period_year)) {
            $rules['leasehold_period_year'] = 'integer';
        }
        if(isset($this->leasehold_period_month)) {
            $rules['leasehold_period_month'] = 'integer';
        }
        if(isset($this->right_cost)) {
            $rules['right_cost'] = 'integer';
        }
        if(isset($this->right_cost_val)) {
            $rules['right_cost_val'] = 'integer';
        }
        if(isset($this->deposit_cost)) {
            $rules['deposit_cost'] = 'integer';
        }
        if(isset($this->deposit_cost_val)) {
            $rules['deposit_cost_val'] = 'integer';
        }
        if(isset($this->security_deposit_cost)) {
            $rules['security_deposit_cost'] = 'integer';
        }
        if(isset($this->security_deposit_cost_val)) {
            $rules['security_deposit_cost_val'] = 'integer';
        }
        if(isset($this->total_area)) {
            $rules['total_area'] = 'integer';
        }
        if(isset($this->total_area_val)) {
            $rules['total_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->balcony_area)) {
            $rules['balcony_area'] = 'integer';
        }
        if(isset($this->balcony_area_val)) {
            $rules['balcony_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->loof_balcony_area)) {
            $rules['loof_balcony_area'] = 'integer';
        }
        if(isset($this->loof_balcony_area_val)) {
            $rules['loof_balcony_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->loof_balcony_area_cost)) {
            $rules['loof_balcony_area_cost'] = 'integer';
        }
        if(isset($this->loof_balcony_area_unit)) {
            $rules['loof_balcony_area_unit'] = 'integer';
        }
        if(isset($this->garden_area)) {
            $rules['garden_area'] = 'integer';
        }
        if(isset($this->garden_area_val)) {
            $rules['garden_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->garden_area_cost)) {
            $rules['garden_area_cost'] = 'integer';
        }
        if(isset($this->garden_area_unit)) {
            $rules['garden_area_unit'] = 'integer';
        }
        if(isset($this->terrace_area)) {
            $rules['terrace_area'] = 'integer';
        }
        if(isset($this->terrace_area_val)) {
            $rules['terrace_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->terrace_area_cost)) {
            $rules['terrace_area_cost'] = 'integer';
        }
        if(isset($this->terrace_area_unit)) {
            $rules['terrace_area_unit'] = 'integer';
        }
        if(isset($this->land_area)) {
            $rules['land_area'] = 'integer';
        }
        if(isset($this->land_area_val)) {
            $rules['land_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->total_area_val)) {
            $rules['total_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->land_condition1)) {
            $rules['land_condition1'] = 'integer';
        }
        if(isset($this->land_condition_area1)) {
            $rules['land_condition_area1'] = 'numeric|max:99999.99';
        }
        if(isset($this->land_condition_unit1)) {
            $rules['land_condition_unit1'] = 'integer';
        }
        if(isset($this->land_condition2)) {
            $rules['land_condition2'] = 'integer';
        }
        if(isset($this->land_condition_area2)) {
            $rules['land_condition_area2'] = 'numeric|max:99999.99';
        }
        if(isset($this->land_condition_unit2)) {
            $rules['land_condition_unit2'] = 'integer';
        }
        if(isset($this->land_condition3)) {
            $rules['land_condition3'] = 'integer';
        }
        if(isset($this->land_condition_area3)) {
            $rules['land_condition_area3'] = 'numeric|max:99999.99';
        }
        if(isset($this->building_condition1)) {
            $rules['building_condition1'] = 'integer';
        }
        if(isset($this->building_condition_area1)) {
            $rules['building_condition_area1'] = 'numeric|max:99999.99';
        }
        if(isset($this->building_condition2)) {
            $rules['building_condition2'] = 'integer';
        }
        if(isset($this->building_condition_area2)) {
            $rules['building_condition_area2'] = 'numeric|max:99999.99';
        }
        if(isset($this->building_condition3)) {
            $rules['building_condition3'] = 'integer';
        }
        if(isset($this->building_condition_area3)) {
            $rules['building_condition_area3'] = 'numeric|max:99999.99';
        }
        if(isset($this->building_condition4)) {
            $rules['building_condition4'] = 'integer';
        }
        if(isset($this->building_condition_select)) {
            $rules['building_condition_select'] = 'integer';
        }
        if(isset($this->land_not)) {
            $rules['land_not'] = 'integer';
        }
        if(isset($this->land_status)) {
            $rules['land_status'] = 'integer';
        }
        if(isset($this->comp_year)) {
            $rules['comp_year'] = 'integer';
        }
        if(isset($this->comp_month)) {
            $rules['comp_month'] = 'integer';
        }
        if(isset($this->land_delivery)) {
            $rules['land_delivery'] = 'integer';
        }
        if(isset($this->delivery_year)) {
            $rules['delivery_year'] = 'integer';
        }
        if(isset($this->delivery_month)) {
            $rules['delivery_month'] = 'integer';
        }
        if(isset($this->land_delivery_time)) {
            $rules['land_delivery_time'] = 'integer';
        }
        if(isset($this->land_condition)) {
            $rules['land_condition'] = 'integer';
        }
        if(isset($this->land_condition_not)) {
            $rules['land_condition_not'] = 'integer';
        }
        if(isset($this->building_plan_place)) {
            $rules['building_plan_place'] = 'integer';
        }
        if(isset($this->building_plan_area)) {
            $rules['building_plan_area'] = 'numeric|max:99999.99';
        }
        if(isset($this->ground)) {
            $rules['ground'] = 'integer';
        }
        if(isset($this->road_burden)) {
            $rules['road_burden'] = 'integer';
        }
        if(isset($this->road_burden_area)) {
            $rules['road_burden_area'] = 'numeric|max:99999.99';
        }
        if(isset($this->road_numerator)) {
            $rules['road_numerator'] = 'numeric|max:99999.99';
        }
        if(isset($this->road_denominator)) {
            $rules['road_denominator'] = 'numeric|max:99999.99';
        }
        if(isset($this->easement)) {
            $rules['easement'] = 'integer';
        }
        if(isset($this->easement_area)) {
            $rules['easement_area'] = 'numeric|max:99999.99';
        }
        if(isset($this->land_kind1)) {
            $rules['land_kind1'] = 'integer';
        }
        if(isset($this->land_direction1)) {
            $rules['land_direction1'] = 'integer';
        }
        if(isset($this->road_width1)) {
            $rules['road_width1'] = 'numeric|max:99999.99';
        }
        if(isset($this->frontage1)) {
            $rules['frontage1'] = 'numeric|max:99999.99';
        }
        if(isset($this->land_kind2)) {
            $rules['land_kind2'] = 'integer';
        }
        if(isset($this->land_direction2)) {
            $rules['land_direction2'] = 'integer';
        }
        if(isset($this->road_width2)) {
            $rules['road_width2'] = 'numeric|max:99999.99';
        }
        if(isset($this->frontage2)) {
            $rules['frontage2'] = 'numeric|max:99999.99';
        }
        if(isset($this->land_kind3)) {
            $rules['land_kind3'] = 'integer';
        }
        if(isset($this->land_direction3)) {
            $rules['land_direction3'] = 'integer';
        }
        if(isset($this->road_width3)) {
            $rules['road_width3'] = 'numeric|max:99999.99';
        }
        if(isset($this->frontage3)) {
            $rules['frontage3'] = 'numeric|max:99999.99';
        }
        if(isset($this->water_supply)) {
            $rules['water_supply'] = 'integer';
        }
        if(isset($this->sewerage)) {
            $rules['sewerage'] = 'integer';
        }
        if(isset($this->gas)) {
            $rules['gas'] = 'integer';
        }
        if(isset($this->garage)) {
            $rules['garage'] = 'integer';
        }
        if(isset($this->set)) {
            $rules['set'] = 'integer';
        }
        if(isset($this->set_area)) {
            $rules['set_area'] = 'numeric|max:99999.99';
        }
        if(isset($this->use_area)) {
            $rules['use_area'] = 'integer';
        }
        if(isset($this->land_use)) {
            $rules['land_use'] = 'integer';
        }
        if(isset($this->land_use2)) {
            $rules['land_use2'] = 'integer';
        }
        if(isset($this->city_plan)) {
            $rules['city_plan'] = 'integer';
        }
        if(isset($this->city_plan_reason)) {
            $rules['city_plan_reason'] = 'integer';
        }
        if(isset($this->develop_num)) {
            $rules['develop_num'] = 'integer';
        }
        if(isset($this->section)) {
            $rules['section'] = 'integer';
        }
        if(isset($this->other_reason)) {
            $rules['other_reason'] = 'integer';
        }
        if(isset($this->rebuilding)) {
            $rules['rebuilding'] = 'integer';
        }
        if(isset($this->total_area)) {
            $rules['total_area'] = 'integer';
        }
        if(isset($this->total_area_val)) {
            $rules['total_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->underground_area)) {
            $rules['underground_area'] = 'integer';
        }
        if(isset($this->underground_area_val)) {
            $rules['underground_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->garage_area)) {
            $rules['garage_area'] = 'integer';
        }
        if(isset($this->garage_area_val)) {
            $rules['garage_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->underground_garage_area)) {
            $rules['underground_garage_area'] = 'integer';
        }
        if(isset($this->underground_garage_area_val)) {
            $rules['underground_garage_area_val'] = 'numeric|max:99999.99';
        }
        if(isset($this->residence_area)) {
            $rules['residence_area'] = 'integer';
        }
        if(isset($this->residence_area_val)) {
            $rules['residence_area_val'] = 'integer';
        }
        if(isset($this->floor_plan)) {
            $rules['floor_plan'] = 'integer';
        }
        if(isset($this->floor_plan_type)) {
            $rules['floor_plan_type'] = 'integer';
        }
        if(isset($this->completed_year)) {
            $rules['completed_year'] = 'integer';
        }
        if(isset($this->completed_month)) {
            $rules['completed_month'] = 'integer';
        }
        if(isset($this->completed_contract_month)) {
            $rules['completed_contract_month'] = 'integer';
        }
        if(isset($this->move_in)) {
            $rules['move_in'] = 'integer';
        }
        if(isset($this->move_in_year)) {
            $rules['move_in_year'] = 'integer';
        }
        if(isset($this->move_in_month)) {
            $rules['move_in_month'] = 'integer';
        }
        if(isset($this->move_in_contract_month)) {
            $rules['move_in_contract_month'] = 'integer';
        }
        if(isset($this->current_status)) {
            $rules['current_status'] = 'integer';
        }
        if(isset($this->current_status_year)) {
            $rules['current_status_year'] = 'integer';
        }
        if(isset($this->current_status_month)) {
            $rules['current_status_month'] = 'integer';
        }
        if(isset($this->building_construction)) {
            $rules['building_construction'] = 'integer';
        }
        if(isset($this->building_construction_sub)) {
            $rules['building_construction_sub'] = 'integer';
        }
        if(isset($this->ground_unit)) {
            $rules['ground_unit'] = 'integer';
        }
        if(isset($this->underground_unit)) {
            $rules['underground_unit'] = 'integer';
        }
        if(isset($this->parking)) {
            $rules['parking'] = 'integer';
        }
        if(isset($this->parking_num)) {
            $rules['parking_num'] = 'integer';
        }
        if(isset($this->exterior)) {
            $rules['exterior'] = 'integer';
        }
        if(isset($this->exterior_year)) {
            $rules['exterior_year'] = 'integer';
        }
        if(isset($this->exterior_month)) {
            $rules['exterior_month'] = 'integer';
        }
        if(isset($this->exterior_wall)) {
            $rules['exterior_wall'] = 'integer';
        }
        if(isset($this->exterior_roof)) {
            $rules['exterior_roof'] = 'integer';
        }
        if(isset($this->exterior_other)) {
            $rules['exterior_other'] = 'integer';
        }
        if(isset($this->exterior_text)) {
            $rules['exterior_text'] = 'integer';
        }
        if(isset($this->interior)) {
            $rules['interior'] = 'integer';
        }
        if(isset($this->interior_year)) {
            $rules['interior_year'] = 'integer';
        }
        if(isset($this->interior_month)) {
            $rules['interior_month'] = 'integer';
        }
        if(isset($this->interior_kitchen)) {
            $rules['interior_kitchen'] = 'integer';
        }
        if(isset($this->interior_bathroom)) {
            $rules['interior_bathroom'] = 'integer';
        }
        if(isset($this->interior_toilet)) {
            $rules['interior_toilet'] = 'integer';
        }
        if(isset($this->interior_wall)) {
            $rules['interior_wall'] = 'integer';
        }
        if(isset($this->interior_floor)) {
            $rules['interior_floor'] = 'integer';
        }
        if(isset($this->interior_all)) {
            $rules['interior_all'] = 'integer';
        }
        if(isset($this->interior_other)) {
            $rules['interior_other'] = 'integer';
        }
        if(isset($this->interior_text)) {
            $rules['interior_text'] = 'integer';
        }
        if(isset($this->classfication)) {
            $rules['classfication'] = 'integer';
        }
        if(isset($this->use_method)) {
            $rules['use_method'] = 'integer';
        }
        if(isset($this->trading_classfication)) {
            $rules['trading_classfication'] = 'integer';
        }
        if(isset($this->business_status)) {
            $rules['business_status'] = 'integer';
        }
        if(isset($this->investment_status)) {
            $rules['investment_status'] = 'integer';
        }
        if(isset($this->investment_performance)) {
            $rules['investment_performance'] = 'integer';
        }
        if(isset($this->investment_performance_unit)) {
            $rules['investment_performance_unit'] = 'integer';
        }
        if(isset($this->investment_interest)) {
            $rules['investment_interest'] = 'numeric|max:99999.99';
        }
        if(isset($this->own_company)) {
            $rules['own_company'] = 'integer';
        }
        if(isset($this->suumo)) {
            $rules['suumo'] = 'integer';
        }
        if(isset($this->homes)) {
            $rules['homes'] = 'integer';
        }
        if(isset($this->athome)) {
            $rules['athome'] = 'integer';
        }
        if(isset($this->hp_charge)) {
            $rules['hp_charge'] = 'integer';
        }
        if(isset($this->floor_file_disp)) {
            $rules['floor_file_disp'] = 'integer';
        }
        if(isset($this->sheet_file_type)) {
            $rules['sheet_file_type'] = 'integer';
        }
        if(isset($this->event_category)) {
            $rules['event_category'] = 'integer';
        }
        if(isset($this->event_schedule)) {
            $rules['event_schedule'] = 'integer';
        }
        if(isset($this->from_hour)) {
            $rules['from_hour'] = 'integer';
        }
        if(isset($this->from_minute)) {
            $rules['from_minute'] = 'integer';
        }
        if(isset($this->to_hour)) {
            $rules['to_hour'] = 'integer';
        }
        if(isset($this->to_minute)) {
            $rules['to_minute'] = 'integer';
        }
        if(isset($this->reservation)) {
            $rules['reservation'] = 'integer';
        }
        if(isset($this->disp)) {
            $rules['disp'] = 'integer';
        }
        if(isset($this->provisional)) {
            $rules['provisional'] = 'integer';
        }
        if(isset($this->recommend)) {
            $rules['recommend'] = 'integer';
        }
        if(isset($this->recommend_num)) {
            $rules['recommend_num'] = 'integer';
        }
        if(isset($this->repair)) {
            $rules['repair'] = 'integer';
        }
        if(isset($this->repair_cost)) {
            $rules['repair_cost'] = 'integer';
        }
        if(isset($this->repair_cost_unit)) {
            $rules['repair_cost_unit'] = 'integer';
        }
        if(isset($this->management)) {
            $rules['management'] = 'integer';
        }
        if(isset($this->management_cost)) {
            $rules['management_cost'] = 'integer';
        }
        if(isset($this->management_cost_unit)) {
            $rules['management_cost_unit'] = 'integer';
        }
        if(isset($this->original1)) {
            $rules['original1'] = 'integer';
        }
        if(isset($this->original2)) {
            $rules['original2'] = 'integer';
        }
        if(isset($this->original4)) {
            $rules['original4'] = 'integer';
        }
        if(isset($this->room_num)) {
            $rules['room_num'] = 'integer';
        }
        if(isset($this->room_num_disp)) {
            $rules['room_num_disp'] = 'integer';
        }
        if(isset($this->parking_yes)) {
            $rules['parking_yes'] = 'integer';
        }
        if(isset($this->parking_yes_cost_from)) {
            $rules['parking_yes_cost_from'] = 'integer';
        }
        if(isset($this->parking_yes_cost_to)) {
            $rules['parking_yes_cost_to'] = 'integer';
        }
        if(isset($this->parking_yes_cost_range)) {
            $rules['parking_yes_cost_range'] = 'integer';
        }
        if(isset($this->parking_yes_cost_unit)) {
            $rules['parking_yes_cost_unit'] = 'integer';
        }
        if(isset($this->parking_require_cost)) {
            $rules['parking_require_cost'] = 'integer';
        }
        if(isset($this->parking_require_management)) {
            $rules['parking_require_management'] = 'integer';
        }
        if(isset($this->parking_require_management_cost)) {
            $rules['parking_require_management_cost'] = 'integer';
        }
        if(isset($this->parking_require_management_unit)) {
            $rules['parking_require_management_unit'] = 'integer';
        }
        if(isset($this->parking_require_repair)) {
            $rules['parking_require_repair'] = 'integer';
        }
        if(isset($this->parking_require_repair_cost)) {
            $rules['parking_require_repair_cost'] = 'integer';
        }
        if(isset($this->parking_require_repair_unit)) {
            $rules['parking_require_repair_unit'] = 'integer';
        }
        if(isset($this->parking_any)) {
            $rules['parking_any'] = 'integer';
        }
        if(isset($this->parking_any_cost_from)) {
            $rules['parking_any_cost_from'] = 'integer';
        }
        if(isset($this->parking_any_cost_to)) {
            $rules['parking_any_cost_to'] = 'integer';
        }
        if(isset($this->parking_any_cost_range)) {
            $rules['parking_any_cost_range'] = 'integer';
        }
        if(isset($this->parking_any_management)) {
            $rules['parking_any_management'] = 'integer';
        }
        if(isset($this->parking_any_management_cost)) {
            $rules['parking_any_management_cost'] = 'integer';
        }
        if(isset($this->parking_any_management_unit)) {
            $rules['parking_any_management_unit'] = 'integer';
        }
        if(isset($this->parking_any_repair)) {
            $rules['parking_any_repair'] = 'integer';
        }
        if(isset($this->parking_any_repair_cost)) {
            $rules['parking_any_repair_cost'] = 'integer';
        }
        if(isset($this->parking_any_repair_unit)) {
            $rules['parking_any_repair_unit'] = 'integer';
        }
        if(isset($this->parking_designated)) {
            $rules['parking_designated'] = 'integer';
        }
        if(isset($this->parking_designated_cost)) {
            $rules['parking_designated_cost'] = 'integer';
        }
        if(isset($this->parking_designated_unit)) {
            $rules['parking_designated_unit'] = 'integer';
        }
        if(isset($this->parking_out)) {
            $rules['parking_out'] = 'integer';
        }
        if(isset($this->parking_out_cost_from)) {
            $rules['parking_out_cost_from'] = 'integer';
        }
        if(isset($this->parking_out_cost_range)) {
            $rules['parking_out_cost_range'] = 'integer';
        }
        if(isset($this->parking_out_cost_to)) {
            $rules['parking_out_cost_to'] = 'integer';
        }
        if(isset($this->parking_out_cost_unit)) {
            $rules['parking_out_cost_unit'] = 'integer';
        }
        if(isset($this->regular_leased_registration)) {
            $rules['regular_leased_registration'] = 'integer';
        }
        if(isset($this->regular_leased_season)) {
            $rules['regular_leased_season'] = 'integer';
        }
        if(isset($this->regular_leased_season_nen)) {
            $rules['regular_leased_season_nen'] = 'integer';
        }
        if(isset($this->regular_leased_cost)) {
            $rules['regular_leased_cost'] = 'integer';
        }
        if(isset($this->regular_leased_transfer)) {
            $rules['regular_leased_transfer'] = 'integer';
        }
        if(isset($this->regular_leased_transfer_method)) {
            $rules['regular_leased_transfer_method'] = 'integer';
        }
        if(isset($this->regular_leased_transfer_necessity)) {
            $rules['regular_leased_transfer_necessity'] = 'integer';
        }
        if(isset($this->regular_leased_transfer_consent)) {
            $rules['regular_leased_transfer_consent'] = 'integer';
        }
        return array_merge($rules_base, $rules);
    }
}
