<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Validator;

class UserPost extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];

        $rules_base = [
            //
            'last_name' => 'required',

        ];

        if(!isset($this->id)) {
            $rules_base['email'] = 'required|email|unique:users';
            $rules_base['password'] = 'required|confirmed';
            $rules_base['password_confirmation'] = 'required';
        } else {
            if(isset($this->password)) {
                $rules_base['password'] = 'required|confirmed';
                $rules_base['password_confirmation'] = 'required';
            }
        }

        // return array_merge($rules_price);
        return array_merge($rules_base);
    }
}
