<?php
namespace app\Library;

use App\Models\MstCity;
use App\Models\Article;


class Common
{
    public static function getRecommendArticle($num = 6) {
        $articles = Article::getDataByRandom($num);
        return $articles;
    }

    public static function getCountCommonArticle() {
        $result = [];
        $pid = 14;
        $target_area = [111, 105, 107, 108, 115];

        foreach($target_area as $city_id) {
            $count = Article::getCountByCityId($pid, $city_id);
            $name = MstCity::getName($pid, $city_id);
            $count_mansion = Article::getCountByAreaProperty($pid, $city_id, 3);
            $count_house_new = Article::getCountByAreaProperty($pid, $city_id, 2, 1);
            $count_house_old = Article::getCountByAreaProperty($pid, $city_id, 2, 2);
            $count_land = Article::getCountByAreaProperty($pid, $city_id, 1);

            $result[] = [
                'pref' => $pid,
                'city' => $city_id,
                'area_id' => $pid.$city_id,
                'count' => $count,
                'name' => $name->name,
                'sub_list' => [
                    ['name' => '中古マンション', 'count' => $count_mansion],
                    ['name' => '新築一戸建て', 'count' => $count_house_new],
                    ['name' => '中古一戸建て', 'count' => $count_house_old],
                    ['name' => '土地', 'count' => $count_land]
                ]
            ];
        }
        return $result;
    }
}