<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstCity extends Model
{
    public static function getName($prefCode=null, $cityCode=null) 
    {
        $city_name = "";
        if($prefCode != null && $cityCode != null){
            $city_name = MstCity::select('name')->where('pref_code', '=', $prefCode)->where('code', '=', $cityCode)->first();
        }
        return $city_name;
    }

    public static function getData($prefCode=null, $cityCode=null, $companyId = null) 
    {
		$cityQuery = MstCity::query();

		if(!is_null($companyId)) {
			$cityQuery->where('company_id', $companyId);
		}

        if($prefCode != null && $cityCode != null){
            $cities = $cityQuery->where('pref_code', '=', $prefCode)->where('code', '=', $cityCode)->get();
			           
            $arrResult = array();
            foreach($cities as $city){
                 $arrResult[] = ['code' => $city->code, 'name' => $city->name];
            }
            return $arrResult;         
        } elseif($prefCode != null) {
            $cities = $cityQuery->where('pref_code', '=', $prefCode)->get();

            $arrResult = array();
            foreach($cities as $city){
                 $arrResult[] = ['code' => $city->code, 'name' => $city->name];
            }
            return $arrResult;
        } else {
            $cities = $cityQuery->get();

            $arrResult = array();
            foreach($cities as $city){
                 $arrResult[] = ['code' => $city->code, 'name' => $city->name];
            }
            return $arrResult; 
        }
    }
}
