<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstGenkyou extends Model
{
    //
    public static function getData($code='') 
    {
        if($code==''){
            $types = MstGenkyou::get();

            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;         
        } else {
            $types = MstGenkyou::where('code', '=', $code)->get();
            
            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;
        }
    }

    public static function getDataByCode($code) 
    {
        $result = MstGenkyou::where('code', '=', $code)->first();
        return $result;
    }

    public static function getDataByProperty($property) 
    {
        $result = MstGenkyou::where('property', '=', $property)->get();
        $arrResult = array();
        foreach($result as $type){
                $arrResult[] = ['code' => $type->code, 'name' => $type->name];
        }
        return $arrResult;
    }
}
