<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstLine extends Model
{
    protected $fillable = ['count'];

    const CREATED_AT = null;
    const UPDATED_AT = null;
    
    //
    public static function getDataAll() 
    {
        $res = MstLine::get()->toArray();
        return $res; 
    }
    public static function getData() 
    {
        $res = MstLine::ownCompany()->get();
        $arrResult = array();
            foreach($res as $row){
                 $arrResult[] = ['code' => $row->id, 'name' => $row->name];
            }
        return $arrResult; 
    }

    public static function getDataById($id) 
    {
        $res = MstLine::where('id', '=', $name)->first();
        return $res; 
    }

    public static function getDataByName($name) 
    {
        $res = MstLine::where('name', 'LIKE', '%'.$name.'%')->first();
        return $res; 
    }

    public function scopeOwnCompany($query)
    {
        return $query->where("company_id", auth()->user()->company_id);
    }
}
