<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstParking extends Model
{
    //
    public static function getData($code='') 
    {
        if($code==''){
            $types = MstParking::get();

            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;         
        } else {
            $types = MstParking::where('code', '=', $code)->get();
            
            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;
        }
    }

    public static function getDataByType($type) 
    {
        $types = MstParking::whereNull('type')->orWhere('type', '=', $type)->get();

        $arrResult = array();
        foreach($types as $type){
                $arrResult[] = ['code' => $type->code, 'name' => $type->name];
        }
        return $arrResult;
    }
}
