<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstPropertyType extends Model
{
    //
    public static function getData($code='') 
    {
        if($code == ''){
            $types = MstPropertyType::get();

            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;         
        } else {
            $types = MstPropertyType::where('code', '=', $code)->get();
            
            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;
        }
    }

    public static function getDataByParentId($parentCode='') 
    {
        if($parentCode != ''){
            $types = MstPropertyType::where('parent_code', '=', $parentCode)->get();

            $arrResult = array();
            foreach($types as $type){
                 $arrResult[] = ['code' => $type->code, 'name' => $type->name];
            }
            return $arrResult;         
        }
    }
}
