<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstStation extends Model
{
    protected $fillable = ['count'];

    const CREATED_AT = null;
    const UPDATED_AT = null;

    public static function getAllId() {
        $res = MstStation::select('id')->get();
        return $res; 
    }

    public static function getDataByCode($code) 
    {
        $res = MstStation::where('area_id', 'LIKE', $code.'%')->get();
        return $res; 
    }

    public static function getDataByLine($lid) 
    {
        $res = MstStation::where('line_id', '=', $lid)->get()->toArray();
        return $res; 
    }

    public static function getMaxCount($id) {
        $result = MstStation::where('id', $id)->max('count');

        return $result;
    }

    public static function getDataDistinctByCode($code, $key) 
    {
        $res = [];
        if(empty($key)) {
            $res = MstStation::where('area_id', 'LIKE', '%'.$code.'%')->distinct()->select('line_id', 'line')->get();
        } else {
            $res = MstStation::where('area_id', 'LIKE', '%'.$code.'%')->where('line', 'LIKE', '%'.$key.'%')->distinct()->select('line_id', 'line')->get();
        }
        
        return $res; 
    }

    public static function getDataStation($line, $key='') 
    {
        $res = [];
        if(empty($key)) {
            $res = MstStation::where('line', '=', $line)->distinct()->select('id', 'name')->get();
        } else {
            $res = MstStation::where('line', '=', $line)->where('name', 'LIKE', '%'.$key.'%')->distinct()->select('id', 'name')->get();
        }
        
        return $res; 
    }

    public static function getDataStationByLine($line) 
    {
        $res = MstStation::where('line_id', '=', $line)->get();
        return $res; 
    }

    public static function getDataByName($name_line, $name_station) 
    {
        $res = MstStation::where('line', 'like', '%'.$name_line.'%')->where('name', 'like', '%'.$name_station.'%')->first();
        return $res; 
    }

    public static function getDataStationById($id) 
    {
        $res = MstStation::where('id', '=', $id)->first();
        return $res; 
    }


}
