<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MstStatus extends Model
{
    //
    public static function getData($code='') 
    {
        if($code==''){
            $statuses = MstStatus::get();

            $arrResult = array();
            foreach($statuses as $status){
                 $arrResult[] = ['code' => $status->code, 'name' => $status->name];
            }
            return $arrResult;         
        } else {
            $statuses = MstStatus::where('code', '=', $code)->get();
            
            $arrResult = array();
            foreach($statuses as $status){
                 $arrResult[] = ['code' => $status->code, 'name' => $status->name];
            }
            return $arrResult;
        }
    }

    public static function getDataToArray() 
    {
        $statuses = MstStatus::select('name')->get()->toArray();
        return $statuses; 
    }
}
