<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class News extends Model
{
    protected $fillable = ['company_id', 'news_id', 'news_date','news_category', 'news_category_text','news_title','news_link','news_link_target','news_link_target_url','news_link_target_text','shop','order','disp'];
    //

    public static function getMaxNo($cid) {
        $result = News::where('company_id', $cid)->max('news_id');

        return $result;
    }

    public static function getDataByCompany($cid) {
        $result = News::where('company_id', $cid)->orderby('news_date', 'desc')->get();

        return $result;
    }

    public static function getData($cid) {
        $news = News::query();
        $news->leftjoin('mst_news_categories', 'news.news_category', '=', 'mst_news_categories.code');
        $result = $news->where('company_id', $cid)->where('disp', '=', 1)->orderby('news_date', 'desc')->get();

        return $result;
    }

    public static function getTopicsDispData($cid) {
        $news = News::query();
        $news->leftjoin('mst_news_categories', 'news.news_category', '=', 'mst_news_categories.code');
        $news->where('company_id', $cid)->where('disp', '=', 1)->orderby('news_date', 'desc')->where('news_link_target', '=', 2);
        $result = $news->get();

        return $result;
    }
}
