<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Reform extends Model
{
    protected $fillable = ['code', 'company_id',  'regist_date',  'category',  'title',  'area',  'from_year',  'from_month',  'cost',  'target',  'plan',  'point',  'disp', 'reform_num', 'before_file_path', 'after_file_path'];

    const CREATED_AT = null;
    const UPDATED_AT = null;
    //

    public static function getDataAll($cid) 
    {
        $res = Reform::where('company_id', '=', $cid)->get();
        return $res;
    }

    public static function getDispDataAll($cid) 
    {
        $res = Reform::where('company_id', '=', $cid)->where('disp', '=', 1)->orderby('reform_num')->get();
        return $res;
    }

    public static function getMaxNo($cid) {
        $result = Reform::where('company_id', $cid)->max('code');

        return $result;
    }

    public static function getDataById($cid, $id) 
    {
        $res = Reform::where('id', '=', $id)->where('company_id', '=', $cid)->where('disp', '=', 1)->first();
        return $res;
    }

    public static function getDataByCode($cid, $id) 
    {
        $res = Reform::where('code', '=', $id)->where('company_id', '=', $cid)->where('disp', '=', 1)->first();
        return $res;
    }

    public static function getReformDataByCode($cid, $id) 
    {
        $res = Reform::where('code', '=', $id)->where('company_id', '=', $cid)->first();
        return $res;
    }
}
