<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelationArticleFacility extends Model
{
    protected $fillable = [
        'article_id', 'facility_id', 'distance', 'time'
    ];

    const CREATED_AT = null;
    const UPDATED_AT = null;

    //
    public static function getData($id) 
    {
        $res = RelationArticleFacility::where('article_id', '=', $id)->orderby('distance')->get();
        return $res;
    }

    public static function getArticleRelation($article_id, $facility_id) {

        $res = RelationArticleFacility::where('article_id', '=', $article_id)->where('facility_id', '=', $facility_id)->first();
        return $res;
    }

    public static function getFacilityDataByRainsNo($code='') 
    {
        $res = RelationArticleFacility::select(['relation_article_facilities.*', 'facilities.name', 'facilities.kind', 'facilities.file_path'])
        ->leftjoin("facilities", "facilities.id", "=", "relation_article_facilities.facility_id")
        ->where('relation_article_facilities.article_id', '=', $code)->get();
        return $res;
    }
}
