<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelationArticlePhoto extends Model
{
    protected $fillable = [
        'article_id', 'file_type', 'file_path', 'file_disp', 'property', 'property_sub', 'memo', 'order'
    ];

    const CREATED_AT = null;
    const UPDATED_AT = null;

    //
    public static function getTopImagePath($id) 
    {

        $res = RelationArticlePhoto::where('article_id', '=', $id)
        ->where('file_disp', '=', 1)
        ->first();
        return $res;
    }

    public static function getImgByArticleId($id) 
    {

        $res = RelationArticlePhoto::where('article_id', '=', $id)
	->where("company_id", auth()->user()->company_id)
        ->orderBy('order')
        ->get();
        return $res;
    }

    public static function getCountImgByArticleId($id) 
    {

        $res = RelationArticlePhoto::where('article_id', '=', $id)
        ->count();
        return $res;
    }

    public static function getDispImgByArticleId($id) 
    {

        $res = RelationArticlePhoto::where('article_id', '=', $id)
        ->get();
        return $res;
    }
}
