<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelationCitySchool extends Model
{
    //
    public static function getCityList() 
    {
        $cityCodeList = RelationCitySchool::select('name')->get();
        return $cityCodeList;
    }

    public static function getCityListByCityId($cid) 
    {
        $cityCodeList = RelationCitySchool::where('city_id', 'like', '%'.$cid.'%')->get();
        $count = RelationCitySchool::where('city_id', '=', $cid)->count();
        if($count == 0) {
            $cityCodeList = RelationCitySchool::get();
        }
        return $cityCodeList;
    }

    public static function getDataElementarySchool($town) 
    {
        $cityCodeList = RelationCitySchool::where('name', '=', $town)->select(['e_school1', 'e_school2', 'e_school3', 'e_school4', 'e_school5', 'e_school6', 'e_school7', 'e_school8'])->first();
        return $cityCodeList;
    }

    public static function getDataJuniorSchool($town) 
    {
        $cityCodeList = RelationCitySchool::where('name', '=', $town)->select('j_school1', 'j_school2', 'j_school3', 'j_school4', 'j_school5', 'j_school6', 'j_school7')->first();
        return $cityCodeList;
    }
}
