<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelationDuplicateVendorArticle extends Model
{
    const CREATED_AT = null;
    const UPDATED_AT = null;

    protected $fillable = [
        'article_id', 'vendor_id',
    ];

    public static function getVendorDataByRainsNo($code='') 
    {
        $res = RelationDuplicateVendorArticle::select('vendors.*')
        ->leftjoin("vendors", "vendors.id", "=", "relation_duplicate_vendor_articles.vendor_id")
	->where("vendors.company_id", auth()->user()->company_id)
        ->where('relation_duplicate_vendor_articles.article_id', '=', $code)->first();
        return $res;
    }

    public static function getRelationVendorInfo($code='') 
    {
        $res = RelationDuplicateVendorArticle::select('relation_duplicate_vendor_articles.charge as vendor_charge', 'vendors.id', 'vendors.name', 'vendors.vendor_tel1', 'vendors.manner', 'vendors.vendor_fax')
        ->leftjoin("vendors", "vendors.id", "=", "relation_duplicate_vendor_articles.vendor_id")
	->where("vendors.company_id", auth()->user()->company_id)
        ->where('relation_duplicate_vendor_articles.article_id', '=', $code)->first();
        return $res;
    }
}
