<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelationReformPhoto extends Model
{
    protected $fillable = [
        'company_id', 'reform_id', 'file_type', 'file_path', 'file_disp', 'property', 'property_sub', 'memo', 'order'
    ];

    const CREATED_AT = null;
    const UPDATED_AT = null;
    //

    public static function getData($id) 
    {
        $res = RelationReformPhoto::where('reform_id', '=', $id)->orderby('order')->get();
        return $res;
    }

    public static function getDataByCode($id, $cid) 
    {
        $res = RelationReformPhoto::where('company_id', $cid)->where('reform_id', '=', $id)->orderby('order')->get();
        return $res;
    }

    public static function getImageByReformId($id) 
    {
        $res = RelationReformPhoto::where('reform_id', '=', $id)->get();
        return $res;
    }

    public static function getListImageByReformId($id) 
    {
        $res = RelationReformPhoto::where('reform_id', '=', $id)->where('list', '=', '1')->first();
        return $res;
    }
        
}
