<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelationStorePhoto extends Model
{
    protected $fillable = [
        'company_id', 'store_id', 'file_type', 'file_path', 'file_disp', 'property', 'memo', 'order', 'list'
    ];

    const CREATED_AT = null;
    const UPDATED_AT = null;

    //
    public static function getTopImagePath($id) 
    {

        $res = RelationStorePhoto::where('store_id', '=', $id)
        ->first();
        return $res;
    }

    public static function getData($id) 
    {
        $res = RelationStorePhoto::where('store_id', '=', $id)->orderby('order')->get();
        return $res;
    }

    public static function getPhotoDataFront($cid, $id) 
    {
        $res = RelationStorePhoto::where('company_id', '=', $cid)->where('store_id', '=', $id)->orderByRaw('list desc, relation_store_photos.order')->get();
        return $res;
    }

    public static function getListPhoto($cid, $id) {
        $res = RelationStorePhoto::where('company_id', '=', $cid)->where('store_id', '=', $id)->where('list', '=', 1)->first();
        return $res;
    }
}
