<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'role', 'company_id', 'store_id', 'order', 'name', 'email', 'password',
    ];
    
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public static function getDataStaffById($uid) 
    {
        $res = User::where('id', '=', $uid)->get()->toArray();
        return $res; 
    }

    public static function getDataStaff($cid, $sid) 
    {
        $res = User::where('company_id', '=', $cid)
        ->where('store_id', '=', $sid)
        ->where(function($query) {
            $query->orWhere('role', '=', 2)
                  ->orWhere('role', '=', 3);
        })
        ->orderBy('order')->get()->toArray();
        return $res; 
    }

    public static function getDataByCompanyId($cid, $role = 3) 
    {
        $res = User::where('company_id', '=', $cid)->where('role', '=', $role)->get();

        $arrResult = array();
        foreach($res as $row){
                $arrResult[] = ['code' => $row->id, 'name' => $row->name];
        }

        return $arrResult;
    }

    public function isOwnerOfSaiKyoto()
    {
        return $this->attributes["company_id"] == config("const.SAI_KYOTO_ID");
    }
}
