<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserInfo extends Model
{
    const CREATED_AT = null;
    const UPDATED_AT = null;

    protected $fillable = [
        'id', 'company_id', 'employee_number', 'last_name', 'first_name', 'last_name_kana', 'first_name_kana', 
        'store', 'department', 'position', 'birth_month', 'birth_day', 'blood_type', 'disp', 'order', 'file_path'
    ];
    //
    public static function getDataById($id) 
    {
        $res = UserInfo::where('id', '=', $id)->first();
        return $res;
    }

    public static function getDataByNumber($id) 
    {
        $res = UserInfo::where('employee_number', '=', $id)->first();
        return $res;
    }

    public static function getCharge($cid, $sid) 
    {
        $res = [];
        $results = UserInfo::select('user_infos.*')
        -> where('user_infos.company_id', '=', $cid)
        -> leftJoin('users', 'users.id', '=', 'user_infos.id')
        -> where('user_infos.store', '=', $sid)
        // -> where('users.role', '=', 3)
        -> get();

        foreach($results as $row) {
            $res[] = ['code' => $row->id, 'name' => $row->last_name.' '.$row->first_name];
        }
        return $res;
    }

    public static function getDataByStore($cid, $id) 
    {
        $res = UserInfo::where('company_id', '=', $cid)
        ->where('store', '=', $id)->where('disp', '=', 1)->get();
        return $res;
    }
}
