<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateArticlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->increments('id');

            // 1.基本情報
            $table->bigInteger('building_id')->nullable();          // 企業コード
            $table->bigInteger('company_id')->nullable();          // 企業コード
            $table->bigInteger('rains_no')->nullable();          // レインズ番号
            $table->integer('sale_no')->nullable();
            $table->integer('property')->nullable();          // 物件種別
            $table->integer('property_sub')->nullable();      // 新築・中古種別
            $table->string('name')->required();               // 物件名称
            $table->string('name_gouchi')->nullable();               // 物件名称
            $table->string('name_portal')->nullable();          // 物件名称（ポータル用）
            $table->string('occupied')->nullable();             // 未入居
            $table->string('revenue')->nullable();              // 収益物件
            $table->integer('status')->nullable();              // ステータス
            $table->integer('company_manner')->nullable();              // 取引様態
            $table->integer('shop')->nullable();                // 物件取り扱い店舗
            $table->string('zip')->required();                // 郵便番号
            $table->integer('address1')->required();          // 都道府県
            $table->integer('address2')->required();          // 市区郡
            $table->integer('address3')->required();          // 町村
            $table->string('address4')->nullable();                         // その他住所
            $table->string('name_apartment')->nullable();                   // マンション名
            $table->double('lat', 9, 6)->nullable();                        // 緯度
            $table->double('lng', 9, 6)->nullable();                        // 経度
            
            $table->integer('main_traffic')->nullable();                    // 主要交通
            $table->string('main_traffic_line')->nullable();                // 路線
            $table->integer('main_traffic_line_id')->nullable();                // 路線_id
            $table->string('main_traffic_station')->nullable();             // 駅名
            $table->integer('main_traffic_station_id')->nullable();                // 駅名_id
            $table->integer('main_traffic_time')->nullable();               // 徒歩時間
            $table->integer('main_traffic_bus_time')->nullable();           // バス乗車時間
            $table->string('main_traffic_bus')->nullable();                 // バス停
            $table->integer('main_traffic_bus_walk')->nullable();           // 徒歩時間
            
            $table->integer('sub_traffic1')->nullable();                    // 補助交通１
            $table->string('sub_traffic1_line')->nullable();                // 路線
            $table->integer('sub_traffic1_line_id')->nullable();                // 路線_id
            $table->string('sub_traffic1_station')->nullable();             // 駅名
            $table->integer('sub_traffic1_station_id')->nullable();                // 駅名_id
            $table->integer('sub_traffic1_time')->nullable();               // 徒歩時間
            $table->integer('sub_traffic1_bus_time')->nullable();           // バス乗車時間
            $table->string('sub_traffic1_bus')->nullable();                 // バス停
            $table->integer('sub_traffic1_bus_walk')->nullable();           // 徒歩時間
            
            $table->integer('sub_traffic2')->nullable();                    // 補助交通２
            $table->string('sub_traffic2_line')->nullable();                // 路線
            $table->integer('sub_traffic2_line_id')->nullable();                // 路線_id
            $table->string('sub_traffic2_station')->nullable();             // 駅名
            $table->integer('sub_traffic2_station_id')->nullable();                // 駅名_id
            $table->integer('sub_traffic2_time')->nullable();               // 徒歩時間
            $table->integer('sub_traffic2_bus_time')->nullable();           // バス乗車時間
            $table->string('sub_traffic2_bus')->nullable();                 // バス停
            $table->integer('sub_traffic2_bus_walk')->nullable();           // 徒歩時間

            $table->integer('primary_school_city')->nullable();             // 最寄り小学校学区
            $table->integer('primary_school_school')->nullable();           // 学校名
            $table->integer('primary_school_distance')->nullable();         // 距離
            $table->integer('secondary_school_city')->nullable();           // 最寄り中学校学区
            $table->integer('secondary_school_school')->nullable();         // 学校名
            $table->integer('secondary_school_distance')->nullable();       // 距離

            $table->text('memo1')->nullable();                               // 備考
            $table->text('memo2')->nullable();                               // 備考

            // ２.価格
            $table->double('price', 10, 1)->nullable();                     // 価格
            $table->integer('price_closing')->nullable();                       // 成約価格
            $table->date('close_date')->nullable();                       // 成約価格
            
            $table->integer('tax')->nullable();                             // 税込・税抜き

            $table->integer('council')->nullable();                         // 町会費種類
            $table->integer('council_presence')->nullable();                // 有無
            $table->integer('council_cost')->nullable();                    // 費用
            $table->integer('council_cost_unit')->nullable();               // 費用種類

            $table->integer('spring')->nullable();                          // 温泉
            $table->integer('spring_presence')->nullable();
            $table->integer('spring_cost')->nullable();
            $table->integer('spring_cost_unit')->nullable();
            $table->string('spring_kind')->nullable();

            $table->string('another_cost_name1')->nullable();               // その他諸経費
            $table->integer('another_cost1')->nullable();
            $table->integer('another_cost_unit1')->nullable();

            $table->string('another_cost_name2')->nullable();
            $table->integer('another_cost2')->nullable();
            $table->integer('another_cost_unit2')->nullable();

            //// 戸建
            $table->integer('broadcasting')->nullable();                    // 有線放送
            $table->integer('broadcasting_presence')->nullable();
            $table->integer('broadcasting_cost')->nullable();                    
            $table->integer('broadcasting_fixed_presence')->nullable();                
            $table->integer('broadcasting_fixed_cost')->nullable();                    
            $table->integer('broadcasting_fixed_cost_unit')->nullable();    
            
            $table->integer('internet')->nullable();                        // インターネット
            $table->integer('internet_presence')->nullable();
            $table->integer('internet_cost')->nullable();                    
            $table->integer('internet_fixed_presence')->nullable();                
            $table->integer('internet_fixed_cost')->nullable();                    
            $table->integer('internet_fixed_cost_unit')->nullable();   

            $table->integer('catv')->nullable();                            // ケーブルテレビ
            $table->integer('catv_presence')->nullable();
            $table->integer('catv_cost')->nullable();                    
            $table->integer('catv_fixed_presence')->nullable();                
            $table->integer('catv_fixed_cost')->nullable();                    
            $table->integer('catv_fixed_cost_unit')->nullable();  

            //// マンション
            $table->integer('total_unit')->nullable();
            $table->integer('age_year')->nullable();
            $table->integer('age_month')->nullable();
            $table->integer('construction')->nullable();
            $table->integer('construction_sub')->nullable();
            $table->integer('floor')->nullable();
            $table->integer('whereabouts')->nullable();
            $table->integer('underground')->nullable();

            $table->integer('maisonette')->nullable();
            $table->integer('maisonette_from')->nullable();
            $table->integer('maisonette_to')->nullable();
            


            $table->double('site_area', 7, 2)->nullable();
            $table->string('sales_company')->nullable();
            $table->string('construction_company')->nullable();
            $table->string('management_company')->nullable();
            $table->integer('management_form')->nullable();
            $table->integer('pet')->nullable();                            // ペット可不可
            $table->integer('pet_count')->nullable();                      // ペット最大数
            $table->text('overview_comment')->nullable(); 


            // 3.物件概要
            $table->integer('land_right')->nullable();                           // 土地面積
            $table->integer('leasehold_kind')->nullable();
            $table->integer('leasehold_rate')->nullable();
            $table->integer('land_rent')->nullable();
            $table->integer('land_rent_val')->nullable();
            $table->integer('land_rent_unit')->nullable();
            $table->integer('leasehold_period')->nullable();
            $table->integer('leasehold_period_year')->nullable();
            $table->integer('leasehold_period_month')->nullable();
            $table->integer('right_cost')->nullable();
            $table->integer('right_cost_val')->nullable();
            $table->integer('deposit_cost')->nullable();
            $table->integer('deposit_cost_val')->nullable();
            $table->integer('security_deposit_cost')->nullable();
            $table->integer('security_deposit_cost_val')->nullable();
            $table->string('other_leasehold')->nullable();



            $table->integer('exclusive_area')->nullable();
            $table->double('exclusive_area_val', 7, 2)->nullable();   

            $table->integer('balcony_area')->nullable();
            $table->double('balcony_area_val', 7, 2)->nullable();   

            $table->integer('loof_balcony_area')->nullable();
            $table->double('loof_balcony_area_val', 7, 2)->nullable();   
            $table->integer('loof_balcony_area_cost')->nullable();
            $table->integer('loof_balcony_area_unit')->nullable();

            $table->integer('garden_area')->nullable();
            $table->double('garden_area_val', 7, 2)->nullable();   
            $table->integer('garden_area_cost')->nullable();
            $table->integer('garden_area_unit')->nullable();

            $table->integer('terrace_area')->nullable();
            $table->double('terrace_area_val', 7, 2)->nullable();   
            $table->integer('terrace_area_cost')->nullable();
            $table->integer('terrace_area_unit')->nullable();

            




            $table->integer('land_area')->nullable();                           // 土地面積
            $table->double('land_area_val', 7, 2)->nullable();                  // 土地面積値

            $table->double('total_area_val', 7, 2)->nullable();                 // 延べ面積値
            
            
            $table->integer('land_condition1')->nullable();                     // 土地条件
            $table->double('land_condition_area1', 7, 2)->nullable();
            $table->integer('land_condition_unit1')->nullable();
            $table->integer('land_condition2')->nullable();
            $table->double('land_condition_area2', 7, 2)->nullable();
            $table->integer('land_condition_unit2')->nullable();
            $table->integer('land_condition3')->nullable();
            $table->double('land_condition_area3', 7, 2)->nullable();
            $table->integer('building_condition1')->nullable();
            $table->double('building_condition_area1', 7, 2)->nullable();
            $table->integer('building_condition2')->nullable();
            $table->double('building_condition_area2', 7, 2)->nullable();
            $table->integer('building_condition3')->nullable();
            $table->double('building_condition_area3', 7, 2)->nullable();
            $table->integer('building_condition4')->nullable();
            $table->integer('building_condition_select')->nullable();

            $table->integer('land_not')->nullable();                            // 建築不可

            $table->integer('land_status')->nullable();
            $table->integer('comp_year')->nullable();
            $table->integer('comp_month')->nullable();

            $table->integer('land_delivery')->nullable();
            $table->integer('delivery_year')->nullable();
            $table->integer('delivery_month')->nullable();
            $table->integer('land_delivery_time')->nullable();

            $table->integer('land_condition')->nullable();
            $table->integer('land_condition_not')->nullable();
            $table->integer('building_plan_place')->nullable();
            $table->double('building_plan_area', 7, 2)->nullable();

            $table->integer('ground')->nullable();
            $table->string('ground_text')->nullable();

            $table->double('building_rate', 7, 2)->nullable();
            $table->double('volume_rate', 7, 2)->nullable();

            $table->integer('road_burden')->nullable();
            $table->double('road_burden_area', 7, 2)->nullable();
            $table->double('road_numerator', 7, 2)->nullable();
            $table->double('road_denominator', 7, 2)->nullable();

            $table->integer('easement')->nullable();
            $table->double('easement_area', 7, 2)->nullable();

            $table->integer('land_kind1')->nullable();
            $table->integer('land_direction1')->nullable();
            $table->double('road_width1', 7, 2)->nullable();
            $table->double('frontage1', 7, 2)->nullable();

            $table->integer('land_kind2')->nullable();
            $table->integer('land_direction2')->nullable();
            $table->double('road_width2', 7, 2)->nullable();
            $table->double('frontage2', 7, 2)->nullable();

            $table->integer('land_kind3')->nullable();
            $table->integer('land_direction3')->nullable();
            $table->double('road_width3', 7, 2)->nullable();
            $table->double('frontage3', 7, 2)->nullable();

            $table->integer('water_supply')->nullable();
            $table->integer('sewerage')->nullable();
            $table->integer('gas')->nullable();
            $table->integer('garage')->nullable();

            $table->integer('set')->nullable();
            $table->double('set_area', 7, 2)->nullable();

            $table->integer('use_area')->nullable();
            $table->integer('land_use')->nullable();

            $table->integer('city_plan')->nullable();
            $table->integer('city_plan_reason')->nullable();
            $table->integer('develop_num')->nullable();
            $table->integer('section')->nullable();

            $table->integer('other_reason')->nullable();
            $table->text('other_comment')->nullable();

            //// 戸建
            $table->integer('rebuilding')->nullable();                              // 再建築不可

            $table->integer('building_area')->nullable();                           // 建物面積
            $table->double('building_area_val', 7, 2)->nullable();                  // 建物面積値
            $table->integer('underground_area')->nullable();                        // 建物条件_地下室
            $table->double('underground_area_val', 7, 2)->nullable();               // 建物条件_地下室値
            $table->integer('garage_area')->nullable();                             // 建物条件_車庫
            $table->double('garage_area_val', 7, 2)->nullable();                    // 建物条件_車庫値
            $table->integer('underground_garage_area')->nullable();                 // 建物条件_地下車庫
            $table->double('underground_garage_area_val', 7, 2)->nullable();        // 建物条件_地下車庫値
            $table->integer('residence_area')->nullable();                          // 建物条件_居住用途以外
            $table->integer('residence_area_val')->nullable();                      // 建物条件_居住用途以外値
            $table->integer('floor_plan')->nullable();                              // 間取り
            $table->integer('floor_plan_type')->nullable();                         // 間取り_タイプ

            

            $table->integer('completed_year')->nullable();
            $table->integer('completed_month')->nullable();
            $table->integer('completed_contract_month')->nullable();

            
            $table->integer('move_in')->nullable();
            $table->integer('move_in_year')->nullable();
            $table->integer('move_in_month')->nullable();
            $table->integer('move_in_contract_month')->nullable();

            $table->integer('current_status')->nullable();
            $table->integer('current_status_year')->nullable();
            $table->integer('current_status_month')->nullable();
            $table->integer('building_construction')->nullable();
            $table->integer('building_construction_sub')->nullable();
            $table->integer('ground_unit')->nullable();
            $table->integer('underground_unit')->nullable();
            $table->integer('parking')->nullable();
            $table->integer('parking_num')->nullable();
            $table->string('architecture_no')->nullable();

            $table->integer('exterior')->nullable();
            $table->integer('exterior_year')->nullable();
            $table->integer('exterior_month')->nullable();
            $table->integer('exterior_wall')->nullable();
            $table->integer('exterior_roof')->nullable();
            $table->integer('exterior_other')->nullable();
            $table->integer('exterior_text')->nullable();

            $table->integer('interior')->nullable();
            $table->integer('interior_year')->nullable();
            $table->integer('interior_month')->nullable();
            $table->integer('interior_kitchen')->nullable();
            $table->integer('interior_bathroom')->nullable();
            $table->integer('interior_toilet')->nullable();
            $table->integer('interior_wall')->nullable();
            $table->integer('interior_floor')->nullable();
            $table->integer('interior_all')->nullable();
            $table->integer('interior_other')->nullable();
            $table->integer('interior_text')->nullable();

            //// マンション



            // 4.投資・事業用
            $table->integer('classfication')->nullable();
            $table->integer('use_method')->nullable();
            $table->string('use_method_text')->nullable();

            $table->integer('trading_classfication')->nullable();
            $table->integer('business_status')->nullable();
            $table->integer('investment_status')->nullable();
            $table->integer('investment_performance')->nullable();
            $table->integer('investment_performance_unit')->nullable();
            $table->double('investment_interest', 7, 2)->nullable();

            // 5.取引情報
            $table->integer('own_company')->nullable();
            $table->integer('suumo')->nullable();
            $table->integer('homes')->nullable();
            $table->integer('athome')->nullable();
            $table->text('catchcopy')->nullable();
            $table->text('point')->nullable();
            $table->text('comment')->nullable();
            $table->integer('hp_charge')->nullable();

            // 6.画像
            $table->string('floor_file_type')->nullable();
            $table->string('floor_file_path')->nullable();
            $table->integer('floor_file_disp')->nullable();

            $table->string('sheet_file_path2')->nullable();
            $table->string('sheet_file_path3')->nullable();
            $table->integer('sheet_file_type')->nullable();


            // 7.イベント
            $table->integer('event_category')->nullable();
            $table->integer('event_schedule')->nullable();
            $table->string('event_day')->nullable();
            $table->date('from_event')->nullable();
            $table->date('to_event')->nullable();
            $table->integer('from_hour')->nullable();
            $table->integer('from_minute')->nullable();
            $table->integer('to_hour')->nullable();
            $table->integer('to_minute')->nullable();
            $table->integer('reservation')->nullable();
            $table->text('event_comment')->nullable();
            

            $table->integer('disp')->nullable();
            $table->integer('provisional')->nullable();
            $table->integer('recommend')->nullable();
            $table->integer('recommend_num')->nullable();


            // 修繕費・管理費
            $table->integer('repair')->nullable();
            $table->integer('repair_cost')->nullable();
            $table->integer('repair_cost_unit')->nullable();
            
            $table->integer('management')->nullable();
            $table->integer('management_cost')->nullable();
            $table->integer('management_cost_unit')->nullable();

            // オリジナル項目
            $table->integer('original1')->nullable();
            $table->integer('original2')->nullable();
            $table->integer('original3')->nullable();
            $table->integer('original4')->nullable();

            // 部屋番号
            $table->integer('room_num')->nullable();
            $table->integer('room_num_disp')->nullable();
            
            $table->date('close_date')->nullable();
            $table->integer('parking_yes')->nullable();
            $table->integer('parking_yes_cost_from')->nullable();
            $table->integer('parking_yes_cost_to')->nullable();
            $table->integer('parking_yes_cost_range')->nullable();
            $table->integer('parking_yes_cost_unit')->nullable();
            $table->date('parking_yes_cost_date')->nullable();
            $table->integer('parking_require_cost')->nullable();
            $table->integer('parking_require_management')->nullable();
            $table->integer('parking_require_management_cost')->nullable();
            $table->integer('parking_require_management_unit')->nullable();
            $table->integer('parking_require_repair')->nullable();
            $table->integer('parking_require_repair_cost')->nullable();
            $table->integer('parking_require_repair_unit')->nullable();
            $table->integer('parking_any')->nullable();
            $table->integer('parking_any_cost_from')->nullable();
            $table->integer('parking_any_cost_to')->nullable();
            $table->integer('parking_any_cost_range')->nullable();
            $table->integer('parking_any_management')->nullable();
            $table->integer('parking_any_management_cost')->nullable();
            $table->integer('parking_any_management_unit')->nullable();
            $table->integer('parking_any_repair')->nullable();
            $table->integer('parking_any_repair_cost')->nullable();
            $table->integer('parking_any_repair_unit')->nullable();
            $table->integer('parking_designated')->nullable();
            $table->integer('parking_designated_cost')->nullable();
            $table->integer('parking_designated_unit')->nullable();
            $table->integer('parking_out')->nullable();
            $table->integer('parking_out_cost_from')->nullable();
            $table->integer('parking_out_cost_range')->nullable();
            $table->integer('parking_out_cost_to')->nullable();
            $table->integer('parking_out_cost_unit')->nullable();
            $table->date('parking_out_cost_date')->nullable();
            $table->integer('regular_leased_registration')->nullable();
            $table->integer('regular_leased_season')->nullable();
            $table->integer('regular_leased_season_nen')->nullable();
            $table->integer('regular_leased_cost')->nullable();
            $table->integer('regular_leased_transfer')->nullable();
            $table->integer('regular_leased_transfer_method')->nullable();
            $table->integer('regular_leased_transfer_necessity')->nullable();
            $table->integer('regular_leased_transfer_consent')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('articles');
    }
}
