<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstRights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_rights', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 権利コード(value)
            $table->text('name'); // 権利名(name)
        });
        DB::statement("ALTER TABLE mst_rights COMMENT 'マスタ：権利'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_rights');
    }
}
