<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstPlans extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_plans', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 計画コード(value)
            $table->text('name'); // 計画名(name)
        });
        DB::statement("ALTER TABLE mst_plans COMMENT 'マスタ：計画'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_plans');
    }
}
