<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstRoadTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_road_types', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 接面タイプコード(value)
            $table->text('name'); // 接面タイプ名(name)
        });
        DB::statement("ALTER TABLE mst_road_types COMMENT 'マスタ：接面タイプ'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_road_types');
    }
}
