<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstLandSpaceTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_land_space_types', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 土地面積コード(value)
            $table->text('name'); // 土地面積タイプ名(name)
        });
        DB::statement("ALTER TABLE mst_land_space_types COMMENT 'マスタ：土地面積'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_land_space_types');
    }
}
