<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstLandCategories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_land_categories', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 地目コード(value)
            $table->text('name'); // 地目名(name)
        });
        DB::statement("ALTER TABLE mst_land_categories COMMENT 'マスタ：地目'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_land_categories');
    }
}
