<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstPossessions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_possessions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 物件所有者コード(value)
            $table->text('name'); // 物件所有者名(name)
        });
        DB::statement("ALTER TABLE mst_possessions COMMENT 'マスタ：物件所有者'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_possessions');
    }
}
