<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstTradeTransactionTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_trade_transaction_types', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('code')->default(0); // 取引態様タイプコード(value)
            $table->text('name'); // 取引態様タイプ名(name)
        });

        DB::statement("ALTER TABLE mst_trade_transaction_types COMMENT 'マスタ：取引態様タイプ'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_trade_transaction_types');
    }
}
