<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstCities extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_cities', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('pref_code')->default(0); // 都道府県コード(value)
            $table->integer('code')->default(0); // 市区町村コード(value)
            $table->text('name'); // 市区町村名(name)
        });

        DB::statement("ALTER TABLE mst_cities COMMENT 'マスタ：市区町村'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_cities');
    }
}
