<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMstTowns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mst_towns', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('pref_code')->default(0); // 都道府県コード(value)
            $table->integer('city_code')->default(0); // 市区郡コード(value)
            $table->integer('code')->default(0); // 町村コード(value)
            $table->text('name'); // 町村名(name)
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mst_towns');
    }
}
