<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateImageFloorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('image_floors', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('parent_id');
            $table->integer('kind');
            $table->integer('disp');
            $table->string('mime',50)->nullable();
            $table->binary('data')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('image_floors');
    }
}
